/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.Collection;
import java.util.Objects;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.Predicate;

public final class Predicates {
    private Predicates() {
    }

    public static <T> Predicate<T> alwaysTrue() {
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T t) {
                return true;
            }
        };
    }

    public static <T> Predicate<T> alwaysFalse() {
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T t) {
                return false;
            }
        };
    }

    public static <T> Predicate<T> not(final Predicate<T> predicate) {
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T t) {
                return !predicate.evaluate(t);
            }
        };
    }

    public static <T> Predicate<T> equalTo(final T t) {
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T t2) {
                return Objects.equals(t2, t);
            }
        };
    }

    public static <T> Predicate<T> isOfClass(final Class<? extends T> clazz) {
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T t) {
                return t != null && t.getClass() == clazz;
            }
        };
    }

    public static Predicate<String> stringMatchesPattern(final Pattern pattern) {
        return new Predicate<String>(){

            @Override
            public boolean evaluate(String string) {
                return pattern.matcher(string).matches();
            }
        };
    }

    public static Predicate<String> stringContainsPattern(final Pattern pattern) {
        return new Predicate<String>(){

            @Override
            public boolean evaluate(String string) {
                return pattern.matcher(string).find();
            }
        };
    }

    public static Predicate<String> stringContains(final String string) {
        return new Predicate<String>(){

            @Override
            public boolean evaluate(String string2) {
                return string2.contains(string);
            }
        };
    }

    public static Predicate<OsmPrimitive> hasTag(final String string, final String ... stringArray) {
        return new Predicate<OsmPrimitive>(){

            @Override
            public boolean evaluate(OsmPrimitive osmPrimitive) {
                return osmPrimitive.hasTag(string, stringArray);
            }
        };
    }

    public static Predicate<OsmPrimitive> hasKey(final String string) {
        return new Predicate<OsmPrimitive>(){

            @Override
            public boolean evaluate(OsmPrimitive osmPrimitive) {
                return osmPrimitive.hasKey(string);
            }
        };
    }

    public static <T> Predicate<T> inCollection(final Collection<? extends T> collection) {
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T t) {
                return collection.contains(t);
            }
        };
    }

    public static <T> Predicate<T> isNull() {
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T t) {
                return t == null;
            }
        };
    }
}

