// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _MgtTopoDS_HeaderFile
#define _MgtTopoDS_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Handle_PTopoDS_HShape.hxx>
#include <Handle_MgtTopoDS_TranslateTool.hxx>
#include <Handle_MgtTopoDS_TranslateTool1.hxx>
class PTopoDS_HShape;
class TopoDS_Shape;
class MgtTopoDS_TranslateTool;
class PTColStd_TransientPersistentMap;
class PTColStd_PersistentTransientMap;
class MgtTopoDS_TranslateTool1;
class PTopoDS_Shape1;
class MgtTopoDS_TranslateTool;
class MgtTopoDS_TranslateTool1;


//! The  package  MgtTopoDS  provides methods to store
//! and  retrieve Topological  Data  Structure objects
//! from the Database.
//!
//! The  objects are  translated  between  a transient
//! topology and a persitent topology.
//!
//! *   The TopoDS  package   describes  the transient
//! topology.
//!
//! *  The  PTopoDS  package describes  the persistent
//! topology.
//!
//! As the topological data structure may be completed
//! by  inheritance  the  MgtTopoDS package provides a
//! mechanism to support  the translation of inherited
//! data structure. This mechanism is supported by the
//! TranslateTool class.
//!
//! An error is  raised if  the TranslateTool does not
//! match with  the DataStructure  to  translate. This
//! check is done with the type of the Model.
//!
//! This   package   does   not  provides  methods  to
//! translate directly Shapes from TopoDS  and PTopoDS
//! because the   data structures  are  deferred.   It
//! provides methods to support  the implementation of
//! Translate methods in the inherited DataStructures.
//!
//! In  an   inherited data  structure  the  Translate
//! method must :
//!
//! * Create a TranslateTool of the correct type.
//!
//! * Call the Translate method of MgtTopoDS with this
//! Tool.
class MgtTopoDS 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Translates a Transient Shape onto a Persistent Shape
  Standard_EXPORT static   Handle(PTopoDS_HShape) Translate (const TopoDS_Shape& S, const Handle(MgtTopoDS_TranslateTool)& T, PTColStd_TransientPersistentMap& M) ;
  
  //! Translates a Persistent Shape onto a Transient Shape
  Standard_EXPORT static   void Translate (const Handle(PTopoDS_HShape)& S, const Handle(MgtTopoDS_TranslateTool)& T, PTColStd_PersistentTransientMap& M, TopoDS_Shape& Sh) ;
  
  //! Translates a Transient Shape onto a Persistent Shape
  Standard_EXPORT static   void Translate1 (const TopoDS_Shape& aShape, const Handle(MgtTopoDS_TranslateTool1)& T, PTColStd_TransientPersistentMap& M, PTopoDS_Shape1& aPShape) ;
  
  //! Translates a Persistent Shape onto a Transient Shape
  Standard_EXPORT static   void Translate1 (const PTopoDS_Shape1& aPShape, const Handle(MgtTopoDS_TranslateTool1)& T, PTColStd_PersistentTransientMap& M, TopoDS_Shape& aShape) ;




protected:





private:




friend class MgtTopoDS_TranslateTool;
friend class MgtTopoDS_TranslateTool1;

};







#endif // _MgtTopoDS_HeaderFile
