/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.DoorOrWindow;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.Sash;
import java.io.IOException;
import java.io.ObjectInputStream;

public class HomeDoorOrWindow
extends HomePieceOfFurniture
implements DoorOrWindow {
    private static final long serialVersionUID = 1L;
    private final float wallThickness;
    private final float wallDistance;
    private final Sash[] sashes;
    private String cutOutShape;
    private boolean boundToWall;

    public HomeDoorOrWindow(DoorOrWindow doorOrWindow) {
        super(doorOrWindow);
        this.wallThickness = doorOrWindow.getWallThickness();
        this.wallDistance = doorOrWindow.getWallDistance();
        this.sashes = doorOrWindow.getSashes();
        this.cutOutShape = doorOrWindow.getCutOutShape();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.cutOutShape = "M0,0 v1 h1 v-1 z";
        objectInputStream.defaultReadObject();
    }

    public float getWallThickness() {
        return this.wallThickness;
    }

    public float getWallDistance() {
        return this.wallDistance;
    }

    public Sash[] getSashes() {
        if (this.sashes.length == 0) {
            return this.sashes;
        }
        return (Sash[])this.sashes.clone();
    }

    public String getCutOutShape() {
        return this.cutOutShape;
    }

    public boolean isBoundToWall() {
        return this.boundToWall;
    }

    public void setBoundToWall(boolean bl) {
        this.boundToWall = bl;
    }

    public void setX(float f) {
        if (this.getX() != f) {
            this.boundToWall = false;
        }
        super.setX(f);
    }

    public void setY(float f) {
        if (this.getY() != f) {
            this.boundToWall = false;
        }
        super.setY(f);
    }

    public void setAngle(float f) {
        if (this.getAngle() != f) {
            this.boundToWall = false;
        }
        super.setAngle(f);
    }

    public void setDepth(float f) {
        if (this.getDepth() != f) {
            this.boundToWall = false;
        }
        super.setDepth(f);
    }

    public boolean isDoorOrWindow() {
        return true;
    }

    public HomeDoorOrWindow clone() {
        HomeDoorOrWindow homeDoorOrWindow = (HomeDoorOrWindow)super.clone();
        homeDoorOrWindow.boundToWall = false;
        return homeDoorOrWindow;
    }
}

