/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractCommand;
import CH.ifa.draw.util.Undoable;
import CH.ifa.draw.util.UndoableAdapter;

public class SelectAllCommand
extends AbstractCommand {
    public SelectAllCommand(String name, DrawingEditor newDrawingEditor) {
        super(name, newDrawingEditor);
    }

    public void execute() {
        super.execute();
        this.setUndoActivity(this.createUndoActivity());
        this.getUndoActivity().setAffectedFigures(this.view().selectionElements());
        this.view().addToSelectionAll(this.view().drawing().figures());
        this.view().checkDamage();
    }

    public boolean isExecutableWithView() {
        FigureEnumeration e = this.view().drawing().figures();
        return e.hasMoreElements() && e.nextFigure() != null;
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view());
    }

    public static class UndoActivity
    extends UndoableAdapter {
        public UndoActivity(DrawingView newDrawingView) {
            super(newDrawingView);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            this.getDrawingView().clearSelection();
            this.getDrawingView().addToSelectionAll(this.getAffectedFigures());
            return true;
        }

        public boolean redo() {
            if (this.isRedoable()) {
                this.getDrawingView().addToSelectionAll(this.getDrawingView().drawing().figures());
                return true;
            }
            return false;
        }
    }
}

