/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.ui.actions;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.core.ui.components.Spacer;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

class RenameConfigurator
extends JPanel {
    private static RenameConfigurator defaultInstance;
    private JLabel nameLabel;
    private JTextField nameField;
    private JButton okButton;

    public static RenameConfigurator defineName(DataSource dataSource) {
        RenameConfigurator hc = RenameConfigurator.getDefault();
        hc.setupDefineName(dataSource);
        DialogDescriptor dd = new DialogDescriptor((Object)hc, NbBundle.getMessage(RenameConfigurator.class, (String)"LBL_Rename"), true, new Object[]{hc.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)hc.okButton, 0, null, null);
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        d.pack();
        d.setVisible(true);
        if (dd.getValue() == hc.okButton) {
            return hc;
        }
        return null;
    }

    public String getDisplayName() {
        return this.nameField.getText().trim();
    }

    private RenameConfigurator() {
        this.initComponents();
        this.update();
    }

    private static RenameConfigurator getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new RenameConfigurator();
        }
        return defaultInstance;
    }

    private void setupDefineName(DataSource dataSource) {
        this.nameField.setText(DataSourceDescriptorFactory.getDescriptor(dataSource).getName());
        this.nameField.selectAll();
    }

    private void update() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RenameConfigurator.this.okButton.setEnabled(RenameConfigurator.this.getDisplayName().length() > 0);
            }
        });
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.nameLabel = new JLabel(NbBundle.getMessage(RenameConfigurator.class, (String)"LBL_New_Name"));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 13;
        constraints.insets = new Insets(15, 10, 0, 0);
        this.add((Component)this.nameLabel, constraints);
        this.nameField = new JTextField();
        this.nameField.setPreferredSize(new Dimension(220, this.nameField.getPreferredSize().height));
        this.nameField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                RenameConfigurator.this.update();
            }

            public void removeUpdate(DocumentEvent e) {
                RenameConfigurator.this.update();
            }

            public void changedUpdate(DocumentEvent e) {
                RenameConfigurator.this.update();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.gridwidth = 1;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(15, 5, 0, 10);
        this.add((Component)this.nameField, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 0, 15, 0);
        this.add((Component)Spacer.create(), constraints);
        this.okButton = new JButton(NbBundle.getMessage(RenameConfigurator.class, (String)"LBL_OK"));
    }
}

