/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.impl;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.LoopCountReceiver;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.impl.FindContextNode;
import com.oracle.truffle.api.impl.TVMCI;
import com.oracle.truffle.api.instrument.WrapperNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;

public abstract class Accessor {
    private static LanguageSupport API;
    private static EngineSupport SPI;
    private static Nodes NODES;
    private static OldInstrumentSupport INSTRUMENT;
    private static InstrumentSupport INSTRUMENTHANDLER;
    private static DebugSupport DEBUG;
    private static final TVMCI SUPPORT;

    protected Accessor() {
        if (!this.getClass().getName().startsWith("com.oracle.truffle.api")) {
            throw new IllegalStateException();
        }
        if (this.getClass().getSimpleName().endsWith("API")) {
            if (API != null) {
                throw new IllegalStateException();
            }
            API = this.languageSupport();
        } else if (this.getClass().getSimpleName().endsWith("Nodes")) {
            if (NODES != null) {
                throw new IllegalStateException();
            }
            NODES = this.nodes();
        } else if (this.getClass().getSimpleName().endsWith("Instrument")) {
            if (INSTRUMENT != null) {
                throw new IllegalStateException();
            }
            INSTRUMENT = this.oldInstrumentSupport();
        } else if (this.getClass().getSimpleName().endsWith("InstrumentHandler")) {
            if (INSTRUMENTHANDLER != null) {
                throw new IllegalStateException();
            }
            INSTRUMENTHANDLER = this.instrumentSupport();
        } else if (this.getClass().getSimpleName().endsWith("Debug")) {
            if (DEBUG != null) {
                throw new IllegalStateException();
            }
            DEBUG = this.debugSupport();
        } else {
            if (SPI != null) {
                throw new IllegalStateException();
            }
            SPI = this.engineSupport();
        }
    }

    protected Nodes nodes() {
        return NODES;
    }

    protected OldInstrumentSupport oldInstrumentSupport() {
        return INSTRUMENT;
    }

    protected LanguageSupport languageSupport() {
        return API;
    }

    protected DebugSupport debugSupport() {
        return DEBUG;
    }

    protected EngineSupport engineSupport() {
        return SPI;
    }

    protected InstrumentSupport instrumentSupport() {
        return INSTRUMENTHANDLER;
    }

    static InstrumentSupport instrumentAccess() {
        return INSTRUMENTHANDLER;
    }

    static LanguageSupport languageAccess() {
        return API;
    }

    static EngineSupport engineAccess() {
        return SPI;
    }

    static DebugSupport debugAccess() {
        return DEBUG;
    }

    static Nodes nodesAccess() {
        return NODES;
    }

    public static void main(String ... args) {
        throw new IllegalStateException();
    }

    protected void onLoopCount(Node source, int iterations) {
        if (SUPPORT != null) {
            SUPPORT.onLoopCount(source, iterations);
        } else {
            RootCallTarget target;
            RootNode root = source.getRootNode();
            if (root != null && (target = root.getCallTarget()) instanceof LoopCountReceiver) {
                ((LoopCountReceiver)((Object)target)).reportLoopCount(iterations);
            }
        }
    }

    static <T extends TruffleLanguage<?>> T findLanguageByClass(Object vm, Class<T> languageClass) {
        TruffleLanguage.Env env = SPI.findEnv(vm, languageClass);
        TruffleLanguage<?> language = API.findLanguage(env);
        return (T)((TruffleLanguage)languageClass.cast(language));
    }

    static {
        TruffleLanguage<Object> lng = new TruffleLanguage<Object>(){

            @Override
            protected Object findExportedSymbol(Object context, String globalName, boolean onlyExplicit) {
                return null;
            }

            @Override
            protected Object getLanguageGlobal(Object context) {
                return null;
            }

            @Override
            protected boolean isObjectOfLanguage(Object object) {
                return false;
            }

            @Override
            protected CallTarget parse(Source code, Node context, String ... argumentNames) throws IOException {
                throw new IOException();
            }

            @Override
            protected Object createContext(TruffleLanguage.Env env) {
                return null;
            }

            @Override
            protected boolean isInstrumentable(Node node) {
                return false;
            }

            @Override
            protected WrapperNode createWrapperNode(Node node) {
                return null;
            }

            @Override
            protected Object evalInContext(Source source, Node node, MaterializedFrame mFrame) throws IOException {
                return null;
            }
        };
        lng.hashCode();
        new Node(){}.getRootNode();
        try {
            Class.forName("com.oracle.truffle.api.instrument.Instrumenter", true, Accessor.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
        try {
            Class.forName("com.oracle.truffle.api.debug.Debugger", true, Accessor.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
        SUPPORT = Truffle.getRuntime().getCapability(TVMCI.class);
    }

    public static abstract class OldInstrumentSupport {
        public abstract void probeAST(RootNode var1);
    }

    public static abstract class InstrumentSupport {
        public abstract void addInstrument(Object var1, Object var2, Class<?> var3);

        public abstract void disposeInstrument(Object var1, Object var2, boolean var3);

        public abstract <T> T getInstrumentationHandlerService(Object var1, Object var2, Class<T> var3);

        public abstract Object createInstrumentationHandler(Object var1, OutputStream var2, OutputStream var3, InputStream var4);

        public abstract void collectEnvServices(Set<Object> var1, Object var2, TruffleLanguage<?> var3, TruffleLanguage.Env var4);

        public abstract void detachLanguageFromInstrumentation(Object var1, TruffleLanguage.Env var2);

        public abstract void onFirstExecution(RootNode var1);
    }

    public static abstract class LanguageSupport {
        public abstract TruffleLanguage.Env attachEnv(Object var1, TruffleLanguage<?> var2, OutputStream var3, OutputStream var4, InputStream var5, Object var6, Map<String, Object> var7);

        public abstract Object eval(TruffleLanguage<?> var1, Source var2, Map<Source, CallTarget> var3) throws IOException;

        public abstract Object evalInContext(Object var1, Object var2, String var3, Node var4, MaterializedFrame var5) throws IOException;

        public abstract Object findExportedSymbol(TruffleLanguage.Env var1, String var2, boolean var3);

        public abstract Object languageGlobal(TruffleLanguage.Env var1);

        public abstract boolean isInstrumentable(Node var1, TruffleLanguage<?> var2);

        public abstract Object createWrapperNode(Node var1, TruffleLanguage<?> var2);

        public abstract void dispose(TruffleLanguage<?> var1, TruffleLanguage.Env var2);

        public abstract TruffleLanguage<?> findLanguage(TruffleLanguage.Env var1);

        public abstract CallTarget parse(TruffleLanguage<?> var1, Source var2, Node var3, String ... var4) throws IOException;

        public abstract String toString(TruffleLanguage<?> var1, TruffleLanguage.Env var2, Object var3);

        public abstract Object findContext(TruffleLanguage.Env var1);
    }

    public static abstract class EngineSupport {
        public static final int EXECUTION_EVENT = 1;
        public static final int SUSPENDED_EVENT = 2;

        public abstract <C> FindContextNode<C> createFindContextNode(TruffleLanguage<C> var1);

        public abstract TruffleLanguage.Env findEnv(Object var1, Class<? extends TruffleLanguage> var2);

        public abstract TruffleLanguage<?> findLanguageImpl(Object var1, Class<? extends TruffleLanguage> var2, String var3);

        public abstract Object getInstrumentationHandler(Object var1);

        public abstract Object getInstrumenter(Object var1);

        public abstract Object importSymbol(Object var1, TruffleLanguage<?> var2, String var3);

        public abstract void dispatchEvent(Object var1, Object var2, int var3);

        public abstract boolean isMimeTypeSupported(Object var1, String var2);
    }

    public static abstract class DebugSupport {
        public abstract Assumption assumeNoDebugger();

        public abstract void executionStarted(Object var1, int var2, Object[] var3, Source var4);

        public abstract void executionEnded(Object var1, Object[] var2);
    }

    public static abstract class Nodes {
        public abstract Class<? extends TruffleLanguage> findLanguage(RootNode var1);

        public abstract boolean isInstrumentable(RootNode var1);

        public abstract boolean isTaggedWith(Node var1, Class<?> var2);
    }
}

