/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.range;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.CoreClass;
import org.jruby.truffle.core.CoreLibrary;
import org.jruby.truffle.core.CoreMethod;
import org.jruby.truffle.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.CoreMethodNode;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.UnaryCoreMethodNode;
import org.jruby.truffle.core.YieldingCoreMethodNode;
import org.jruby.truffle.core.array.ArrayBuilderNode;
import org.jruby.truffle.core.cast.BooleanCastNodeGen;
import org.jruby.truffle.core.cast.BooleanCastWithDefaultNodeGen;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.objects.AllocateObjectNode;
import org.jruby.truffle.language.objects.AllocateObjectNodeGen;

@CoreClass(name="Range")
public abstract class RangeNodes {

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends UnaryCoreMethodNode {
        @Node.Child
        private AllocateObjectNode allocateNode;

        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return this.allocateNode.allocate(rubyClass, false, this.nil(), this.nil());
        }
    }

    @CoreMethod(names={"new"}, constructor=true, required=2, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="rubyClass"), @NodeChild(type=RubyNode.class, value="begin"), @NodeChild(type=RubyNode.class, value="end"), @NodeChild(type=RubyNode.class, value="excludeEnd")})
    public static abstract class NewNode
    extends CoreMethodNode {
        protected final DynamicObject rangeClass;
        @Node.Child
        private CallDispatchHeadNode cmpNode;
        @Node.Child
        private AllocateObjectNode allocateNode;

        public NewNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.rangeClass = context.getCoreLibrary().getRangeClass();
        }

        @CreateCast(value={"excludeEnd"})
        public RubyNode coerceToBoolean(RubyNode excludeEnd) {
            return BooleanCastWithDefaultNodeGen.create(null, null, false, excludeEnd);
        }

        @Specialization(guards={"rubyClass == rangeClass"})
        public DynamicObject intRange(DynamicObject rubyClass, int begin, int end, boolean excludeEnd) {
            return Layouts.INTEGER_FIXNUM_RANGE.createIntegerFixnumRange(this.coreLibrary().getIntegerFixnumRangeFactory(), excludeEnd, begin, end);
        }

        @Specialization(guards={"rubyClass == rangeClass", "fitsIntoInteger(begin)", "fitsIntoInteger(end)"})
        public DynamicObject longFittingIntRange(DynamicObject rubyClass, long begin, long end, boolean excludeEnd) {
            return Layouts.INTEGER_FIXNUM_RANGE.createIntegerFixnumRange(this.coreLibrary().getIntegerFixnumRangeFactory(), excludeEnd, (int)begin, (int)end);
        }

        @Specialization(guards={"rubyClass == rangeClass", "!fitsIntoInteger(begin) || !fitsIntoInteger(end)"})
        public DynamicObject longRange(DynamicObject rubyClass, long begin, long end, boolean excludeEnd) {
            return Layouts.LONG_FIXNUM_RANGE.createLongFixnumRange(this.coreLibrary().getLongFixnumRangeFactory(), excludeEnd, begin, end);
        }

        @Specialization(guards={"rubyClass != rangeClass || (!isIntOrLong(begin) || !isIntOrLong(end))"})
        public Object objectRange(VirtualFrame frame, DynamicObject rubyClass, Object begin, Object end, boolean excludeEnd) {
            Object cmpResult;
            if (this.cmpNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.cmpNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            if (this.allocateNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.allocateNode = this.insert(AllocateObjectNodeGen.create(this.getContext(), this.getSourceSection(), null, null));
            }
            try {
                cmpResult = this.cmpNode.call(frame, begin, "<=>", null, end);
            }
            catch (RaiseException e) {
                throw new RaiseException(this.coreExceptions().argumentError("bad value for range", this));
            }
            if (cmpResult == this.nil()) {
                throw new RaiseException(this.coreExceptions().argumentError("bad value for range", this));
            }
            return this.allocateNode.allocate(rubyClass, excludeEnd, begin, end);
        }

        protected boolean fitsIntoInteger(long value) {
            return CoreLibrary.fitsIntoInteger(value);
        }

        protected boolean isIntOrLong(Object value) {
            return RubyGuards.isInteger(value) || RubyGuards.isLong(value);
        }
    }

    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="self"), @NodeChild(type=RubyNode.class, value="excludeEnd")})
    public static abstract class InternalSetExcludeEndNode
    extends RubyNode {
        @CreateCast(value={"excludeEnd"})
        public RubyNode castToBoolean(RubyNode excludeEnd) {
            return BooleanCastNodeGen.create(null, null, excludeEnd);
        }

        @Specialization(guards={"isObjectRange(range)"})
        public boolean setExcludeEnd(DynamicObject range, boolean excludeEnd) {
            Layouts.OBJECT_RANGE.setExcludedEnd(range, excludeEnd);
            return excludeEnd;
        }
    }

    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="self"), @NodeChild(type=RubyNode.class, value="end")})
    public static abstract class InternalSetEndNode
    extends RubyNode {
        @Specialization(guards={"isObjectRange(range)"})
        public Object setEnd(DynamicObject range, Object end) {
            Layouts.OBJECT_RANGE.setEnd(range, end);
            return end;
        }
    }

    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="self"), @NodeChild(type=RubyNode.class, value="begin")})
    public static abstract class InternalSetBeginNode
    extends RubyNode {
        @Specialization(guards={"isObjectRange(range)"})
        public Object setBegin(DynamicObject range, Object begin) {
            Layouts.OBJECT_RANGE.setBegin(range, begin);
            return begin;
        }
    }

    @CoreMethod(names={"to_a"}, lowerFixnumSelf=true)
    public static abstract class ToANode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode toAInternalCall;

        @Specialization(guards={"isIntegerFixnumRange(range)"})
        public DynamicObject toA(DynamicObject range) {
            int begin = Layouts.INTEGER_FIXNUM_RANGE.getBegin(range);
            int result = Layouts.INTEGER_FIXNUM_RANGE.getExcludedEnd(range) ? Layouts.INTEGER_FIXNUM_RANGE.getEnd(range) : Layouts.INTEGER_FIXNUM_RANGE.getEnd(range) + 1;
            int length = result - begin;
            if (length < 0) {
                return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), null, 0);
            }
            int[] values = new int[length];
            for (int n = 0; n < length; ++n) {
                values[n] = begin + n;
            }
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), values, length);
        }

        @Specialization(guards={"isObjectRange(range)"})
        public Object toA(VirtualFrame frame, DynamicObject range) {
            if (this.toAInternalCall == null) {
                CompilerDirectives.transferToInterpreter();
                this.toAInternalCall = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            return this.toAInternalCall.call(frame, range, "to_a_internal", null, new Object[0]);
        }
    }

    @CoreMethod(names={"step"}, needsBlock=true, optional=1, returnsEnumeratorIfNoBlock=true)
    public static abstract class StepNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode stepInternalCall;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isIntegerFixnumRange(range)", "step > 0"})
        public Object stepInt(VirtualFrame frame, DynamicObject range, int step, DynamicObject block) {
            int count = 0;
            try {
                int result = Layouts.INTEGER_FIXNUM_RANGE.getExcludedEnd(range) ? Layouts.INTEGER_FIXNUM_RANGE.getEnd(range) : Layouts.INTEGER_FIXNUM_RANGE.getEnd(range) + 1;
                for (int n = Layouts.INTEGER_FIXNUM_RANGE.getBegin(range); n < result; n += step) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    this.yield(frame, block, n);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    LoopNode.reportLoopCount(this, count);
                }
            }
            return range;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isLongFixnumRange(range)", "step > 0"})
        public Object stepLong(VirtualFrame frame, DynamicObject range, int step, DynamicObject block) {
            int count = 0;
            try {
                long result = Layouts.LONG_FIXNUM_RANGE.getExcludedEnd(range) ? Layouts.LONG_FIXNUM_RANGE.getEnd(range) : Layouts.LONG_FIXNUM_RANGE.getEnd(range) + 1L;
                for (long n = Layouts.LONG_FIXNUM_RANGE.getBegin(range); n < result; n += (long)step) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    this.yield(frame, block, n);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    LoopNode.reportLoopCount(this, count);
                }
            }
            return range;
        }

        private Object stepInternal(VirtualFrame frame, DynamicObject range, DynamicObject block) {
            return this.stepInternal(frame, range, 1, block);
        }

        private Object stepInternal(VirtualFrame frame, DynamicObject range, Object step, DynamicObject block) {
            if (this.stepInternalCall == null) {
                CompilerDirectives.transferToInterpreter();
                this.stepInternalCall = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            return this.stepInternalCall.call(frame, range, "step_internal", block, step);
        }

        @Specialization(guards={"isIntegerFixnumRange(range)", "wasProvided(step)"})
        public Object stepFallbackInt(VirtualFrame frame, DynamicObject range, Object step, DynamicObject block) {
            return this.stepInternal(frame, range, step, block);
        }

        @Specialization(guards={"isLongFixnumRange(range)", "wasProvided(step)"})
        public Object stepFallbackLong(VirtualFrame frame, DynamicObject range, Object step, DynamicObject block) {
            return this.stepInternal(frame, range, step, block);
        }

        @Specialization(guards={"isIntegerFixnumRange(range)"})
        public Object stepInt(VirtualFrame frame, DynamicObject range, NotProvided step, NotProvided block) {
            return this.stepInternal(frame, range, null);
        }

        @Specialization(guards={"isIntegerFixnumRange(range)"})
        public Object stepInt(VirtualFrame frame, DynamicObject range, NotProvided step, DynamicObject block) {
            return this.stepInternal(frame, range, block);
        }

        @Specialization(guards={"isIntegerFixnumRange(range)", "!isInteger(step)", "!isLong(step)", "wasProvided(step)"})
        public Object stepInt(VirtualFrame frame, DynamicObject range, Object step, NotProvided block) {
            return this.stepInternal(frame, range, step, null);
        }

        @Specialization(guards={"isLongFixnumRange(range)"})
        public Object stepLong(VirtualFrame frame, DynamicObject range, NotProvided step, NotProvided block) {
            return this.stepInternal(frame, range, null);
        }

        @Specialization(guards={"isLongFixnumRange(range)"})
        public Object stepLong(VirtualFrame frame, DynamicObject range, NotProvided step, DynamicObject block) {
            return this.stepInternal(frame, range, block);
        }

        @Specialization(guards={"isLongFixnumRange(range)", "wasProvided(step)"})
        public Object stepLong(VirtualFrame frame, DynamicObject range, Object step, NotProvided block) {
            return this.stepInternal(frame, range, step, null);
        }

        @Specialization(guards={"isObjectRange(range)", "wasProvided(step)"})
        public Object stepObject(VirtualFrame frame, DynamicObject range, Object step, DynamicObject block) {
            return this.stepInternal(frame, range, step, block);
        }

        @Specialization(guards={"isObjectRange(range)"})
        public Object stepObject(VirtualFrame frame, DynamicObject range, NotProvided step, NotProvided block) {
            return this.stepInternal(frame, range, null);
        }

        @Specialization(guards={"isObjectRange(range)"})
        public Object stepObject(VirtualFrame frame, DynamicObject range, NotProvided step, DynamicObject block) {
            return this.stepInternal(frame, range, block);
        }

        @Specialization(guards={"isObjectRange(range)", "wasProvided(step)"})
        public Object step(VirtualFrame frame, DynamicObject range, Object step, NotProvided block) {
            return this.stepInternal(frame, range, step, null);
        }
    }

    @CoreMethod(names={"end"})
    public static abstract class EndNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isIntegerFixnumRange(range)"})
        public int lastInt(DynamicObject range) {
            return Layouts.INTEGER_FIXNUM_RANGE.getEnd(range);
        }

        @Specialization(guards={"isLongFixnumRange(range)"})
        public long lastLong(DynamicObject range) {
            return Layouts.LONG_FIXNUM_RANGE.getEnd(range);
        }

        @Specialization(guards={"isObjectRange(range)"})
        public Object lastObject(DynamicObject range) {
            return Layouts.OBJECT_RANGE.getEnd(range);
        }
    }

    @CoreMethod(names={"dup", "clone"})
    public static abstract class DupNode
    extends UnaryCoreMethodNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode;

        public DupNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization(guards={"isIntegerFixnumRange(range)"})
        public DynamicObject dupIntRange(DynamicObject range) {
            return Layouts.INTEGER_FIXNUM_RANGE.createIntegerFixnumRange(this.coreLibrary().getIntegerFixnumRangeFactory(), Layouts.INTEGER_FIXNUM_RANGE.getExcludedEnd(range), Layouts.INTEGER_FIXNUM_RANGE.getBegin(range), Layouts.INTEGER_FIXNUM_RANGE.getEnd(range));
        }

        @Specialization(guards={"isLongFixnumRange(range)"})
        public DynamicObject dupLongRange(DynamicObject range) {
            return Layouts.LONG_FIXNUM_RANGE.createLongFixnumRange(this.coreLibrary().getIntegerFixnumRangeFactory(), Layouts.LONG_FIXNUM_RANGE.getExcludedEnd(range), Layouts.LONG_FIXNUM_RANGE.getBegin(range), Layouts.LONG_FIXNUM_RANGE.getEnd(range));
        }

        @Specialization(guards={"isObjectRange(range)"})
        public DynamicObject dup(DynamicObject range) {
            DynamicObject copy = this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(range), Layouts.OBJECT_RANGE.getExcludedEnd(range), Layouts.OBJECT_RANGE.getBegin(range), Layouts.OBJECT_RANGE.getEnd(range));
            return copy;
        }
    }

    @CoreMethod(names={"begin"})
    public static abstract class BeginNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isIntegerFixnumRange(range)"})
        public int eachInt(DynamicObject range) {
            return Layouts.INTEGER_FIXNUM_RANGE.getBegin(range);
        }

        @Specialization(guards={"isLongFixnumRange(range)"})
        public long eachLong(DynamicObject range) {
            return Layouts.LONG_FIXNUM_RANGE.getBegin(range);
        }

        @Specialization(guards={"isObjectRange(range)"})
        public Object eachObject(DynamicObject range) {
            return Layouts.OBJECT_RANGE.getBegin(range);
        }
    }

    @CoreMethod(names={"exclude_end?"})
    public static abstract class ExcludeEndNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isIntegerFixnumRange(range)"})
        public boolean excludeEndInt(DynamicObject range) {
            return Layouts.INTEGER_FIXNUM_RANGE.getExcludedEnd(range);
        }

        @Specialization(guards={"isLongFixnumRange(range)"})
        public boolean excludeEndLong(DynamicObject range) {
            return Layouts.LONG_FIXNUM_RANGE.getExcludedEnd(range);
        }

        @Specialization(guards={"isObjectRange(range)"})
        public boolean excludeEndObject(DynamicObject range) {
            return Layouts.OBJECT_RANGE.getExcludedEnd(range);
        }
    }

    @CoreMethod(names={"each"}, needsBlock=true, lowerFixnumSelf=true, returnsEnumeratorIfNoBlock=true)
    public static abstract class EachNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode eachInternalCall;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isIntegerFixnumRange(range)"})
        public Object eachInt(VirtualFrame frame, DynamicObject range, DynamicObject block) {
            int result = Layouts.INTEGER_FIXNUM_RANGE.getExcludedEnd(range) ? Layouts.INTEGER_FIXNUM_RANGE.getEnd(range) : Layouts.INTEGER_FIXNUM_RANGE.getEnd(range) + 1;
            int exclusiveEnd = result;
            int count = 0;
            try {
                for (int n = Layouts.INTEGER_FIXNUM_RANGE.getBegin(range); n < exclusiveEnd; ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    this.yield(frame, block, n);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    LoopNode.reportLoopCount(this, count);
                }
            }
            return range;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isLongFixnumRange(range)"})
        public Object eachLong(VirtualFrame frame, DynamicObject range, DynamicObject block) {
            long result = Layouts.LONG_FIXNUM_RANGE.getExcludedEnd(range) ? Layouts.LONG_FIXNUM_RANGE.getEnd(range) : Layouts.LONG_FIXNUM_RANGE.getEnd(range) + 1L;
            long exclusiveEnd = result;
            int count = 0;
            try {
                for (long n = Layouts.LONG_FIXNUM_RANGE.getBegin(range); n < exclusiveEnd; ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    this.yield(frame, block, n);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    LoopNode.reportLoopCount(this, count);
                }
            }
            return range;
        }

        private Object eachInternal(VirtualFrame frame, DynamicObject range, DynamicObject block) {
            if (this.eachInternalCall == null) {
                CompilerDirectives.transferToInterpreter();
                this.eachInternalCall = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            return this.eachInternalCall.call(frame, range, "each_internal", block, new Object[0]);
        }

        @Specialization(guards={"isLongFixnumRange(range)"})
        public Object eachObject(VirtualFrame frame, DynamicObject range, NotProvided block) {
            return this.eachInternal(frame, range, null);
        }

        @Specialization(guards={"isObjectRange(range)"})
        public Object each(VirtualFrame frame, DynamicObject range, NotProvided block) {
            return this.eachInternal(frame, range, null);
        }

        @Specialization(guards={"isObjectRange(range)"})
        public Object each(VirtualFrame frame, DynamicObject range, DynamicObject block) {
            return this.eachInternal(frame, range, block);
        }
    }

    @CoreMethod(names={"map", "collect"}, needsBlock=true, lowerFixnumSelf=true)
    public static abstract class MapNode
    extends YieldingCoreMethodNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isIntegerFixnumRange(range)"})
        public DynamicObject map(VirtualFrame frame, DynamicObject range, DynamicObject block, @Cached(value="create(getContext())") ArrayBuilderNode arrayBuilder) {
            int begin = Layouts.INTEGER_FIXNUM_RANGE.getBegin(range);
            int end = Layouts.INTEGER_FIXNUM_RANGE.getEnd(range);
            boolean excludedEnd = Layouts.INTEGER_FIXNUM_RANGE.getExcludedEnd(range);
            int length = (excludedEnd ? end : end + 1) - begin;
            Object store = arrayBuilder.start(length);
            int count = 0;
            try {
                for (int n = 0; n < length; ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    store = arrayBuilder.appendValue(store, n, this.yield(frame, block, begin + n));
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    LoopNode.reportLoopCount(this, count);
                }
            }
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), arrayBuilder.finish(store, length), length);
        }
    }
}

