/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.dsl.internal.SuppressFBWarnings;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.rubinius.PointerPrimitiveNodes;
import org.jruby.truffle.core.rubinius.RubiniusPrimitiveArrayArgumentsNode;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypes;
import org.jruby.truffle.language.RubyTypesGen;

@GeneratedBy(value=PointerPrimitiveNodes.class)
public final class PointerPrimitiveNodesFactory {
    public static List<NodeFactory<? extends RubiniusPrimitiveArrayArgumentsNode>> getFactories() {
        return Arrays.asList(PointerAllocatePrimitiveNodeFactory.getInstance(), PointerMallocPrimitiveNodeFactory.getInstance(), PointerFreePrimitiveNodeFactory.getInstance(), PointerSetAddressPrimitiveNodeFactory.getInstance(), PointerAddPrimitiveNodeFactory.getInstance(), PointerReadIntPrimitiveNodeFactory.getInstance(), PointerReadStringPrimitiveNodeFactory.getInstance(), PointerSetAutoreleasePrimitiveNodeFactory.getInstance(), PointerSetAtOffsetPrimitiveNodeFactory.getInstance(), PointerReadPointerPrimitiveNodeFactory.getInstance(), PointerAddressPrimitiveNodeFactory.getInstance(), PointerGetAtOffsetPrimitiveNodeFactory.getInstance(), PointerWriteStringPrimitiveNodeFactory.getInstance(), PointerReadStringToNullPrimitiveNodeFactory.getInstance(), PointerWriteIntPrimitiveNodeFactory.getInstance());
    }

    @GeneratedBy(value=PointerPrimitiveNodes.PointerWriteIntPrimitiveNode.class)
    public static final class PointerWriteIntPrimitiveNodeFactory
    extends NodeFactoryBase<PointerPrimitiveNodes.PointerWriteIntPrimitiveNode> {
        private static PointerWriteIntPrimitiveNodeFactory pointerWriteIntPrimitiveNodeFactoryInstance;

        private PointerWriteIntPrimitiveNodeFactory() {
            super(PointerPrimitiveNodes.PointerWriteIntPrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public PointerPrimitiveNodes.PointerWriteIntPrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return PointerWriteIntPrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<PointerPrimitiveNodes.PointerWriteIntPrimitiveNode> getInstance() {
            if (pointerWriteIntPrimitiveNodeFactoryInstance == null) {
                pointerWriteIntPrimitiveNodeFactoryInstance = new PointerWriteIntPrimitiveNodeFactory();
            }
            return pointerWriteIntPrimitiveNodeFactoryInstance;
        }

        public static PointerPrimitiveNodes.PointerWriteIntPrimitiveNode create(RubyNode[] arguments) {
            return new PointerWriteIntPrimitiveNodeGen(arguments);
        }

        @GeneratedBy(value=PointerPrimitiveNodes.PointerWriteIntPrimitiveNode.class)
        public static final class PointerWriteIntPrimitiveNodeGen
        extends PointerPrimitiveNodes.PointerWriteIntPrimitiveNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private PointerWriteIntPrimitiveNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                return this.specialization_.executeDynamicObject(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="address(DynamicObject, int)", value=PointerPrimitiveNodes.PointerWriteIntPrimitiveNode.class)
            private static final class AddressNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                AddressNode_(PointerWriteIntPrimitiveNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((AddressNode_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDynamicObject(frameValue);
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeDynamicObject_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.address(arguments0Value_, arguments1Value_);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        return this.root.address(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PointerWriteIntPrimitiveNodeGen root, Object arguments1Value) {
                    return new AddressNode_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=PointerPrimitiveNodes.PointerWriteIntPrimitiveNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(PointerWriteIntPrimitiveNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PointerWriteIntPrimitiveNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=PointerPrimitiveNodes.PointerWriteIntPrimitiveNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(PointerWriteIntPrimitiveNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PointerWriteIntPrimitiveNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=PointerPrimitiveNodes.PointerWriteIntPrimitiveNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected PointerWriteIntPrimitiveNodeGen root;

                BaseNode_(PointerWriteIntPrimitiveNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (PointerWriteIntPrimitiveNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    return (DynamicObject)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value)) {
                        return AddressNode_.create(this.root, arguments1Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=PointerPrimitiveNodes.PointerReadStringToNullPrimitiveNode.class)
    public static final class PointerReadStringToNullPrimitiveNodeFactory
    extends NodeFactoryBase<PointerPrimitiveNodes.PointerReadStringToNullPrimitiveNode> {
        private static PointerReadStringToNullPrimitiveNodeFactory pointerReadStringToNullPrimitiveNodeFactoryInstance;

        private PointerReadStringToNullPrimitiveNodeFactory() {
            super(PointerPrimitiveNodes.PointerReadStringToNullPrimitiveNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public PointerPrimitiveNodes.PointerReadStringToNullPrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return PointerReadStringToNullPrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<PointerPrimitiveNodes.PointerReadStringToNullPrimitiveNode> getInstance() {
            if (pointerReadStringToNullPrimitiveNodeFactoryInstance == null) {
                pointerReadStringToNullPrimitiveNodeFactoryInstance = new PointerReadStringToNullPrimitiveNodeFactory();
            }
            return pointerReadStringToNullPrimitiveNodeFactoryInstance;
        }

        public static PointerPrimitiveNodes.PointerReadStringToNullPrimitiveNode create(RubyNode[] arguments) {
            return new PointerReadStringToNullPrimitiveNodeGen(arguments);
        }

        @GeneratedBy(value=PointerPrimitiveNodes.PointerReadStringToNullPrimitiveNode.class)
        public static final class PointerReadStringToNullPrimitiveNodeGen
        extends PointerPrimitiveNodes.PointerReadStringToNullPrimitiveNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private PointerReadStringToNullPrimitiveNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="readStringToNull(DynamicObject)", value=PointerPrimitiveNodes.PointerReadStringToNullPrimitiveNode.class)
            private static final class ReadStringToNullNode_
            extends BaseNode_ {
                ReadStringToNullNode_(PointerReadStringToNullPrimitiveNodeGen root) {
                    super(root, 2);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && !RubyGuards.isNullPointer(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.readStringToNull(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(PointerReadStringToNullPrimitiveNodeGen root) {
                    return new ReadStringToNullNode_(root);
                }
            }

            @GeneratedBy(methodName="readNullPointer(DynamicObject)", value=PointerPrimitiveNodes.PointerReadStringToNullPrimitiveNode.class)
            private static final class ReadNullPointerNode_
            extends BaseNode_ {
                ReadNullPointerNode_(PointerReadStringToNullPrimitiveNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isNullPointer(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.readNullPointer(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(PointerReadStringToNullPrimitiveNodeGen root) {
                    return new ReadNullPointerNode_(root);
                }
            }

            @GeneratedBy(value=PointerPrimitiveNodes.PointerReadStringToNullPrimitiveNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(PointerReadStringToNullPrimitiveNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(PointerReadStringToNullPrimitiveNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=PointerPrimitiveNodes.PointerReadStringToNullPrimitiveNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(PointerReadStringToNullPrimitiveNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(PointerReadStringToNullPrimitiveNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=PointerPrimitiveNodes.PointerReadStringToNullPrimitiveNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected PointerReadStringToNullPrimitiveNodeGen root;

                BaseNode_(PointerReadStringToNullPrimitiveNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (PointerReadStringToNullPrimitiveNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (RubyGuards.isNullPointer(arguments0Value_)) {
                            return ReadNullPointerNode_.create(this.root);
                        }
                        return ReadStringToNullNode_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=PointerPrimitiveNodes.PointerWriteStringPrimitiveNode.class)
    public static final class PointerWriteStringPrimitiveNodeFactory
    extends NodeFactoryBase<PointerPrimitiveNodes.PointerWriteStringPrimitiveNode> {
        private static PointerWriteStringPrimitiveNodeFactory pointerWriteStringPrimitiveNodeFactoryInstance;

        private PointerWriteStringPrimitiveNodeFactory() {
            super(PointerPrimitiveNodes.PointerWriteStringPrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public PointerPrimitiveNodes.PointerWriteStringPrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return PointerWriteStringPrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<PointerPrimitiveNodes.PointerWriteStringPrimitiveNode> getInstance() {
            if (pointerWriteStringPrimitiveNodeFactoryInstance == null) {
                pointerWriteStringPrimitiveNodeFactoryInstance = new PointerWriteStringPrimitiveNodeFactory();
            }
            return pointerWriteStringPrimitiveNodeFactoryInstance;
        }

        public static PointerPrimitiveNodes.PointerWriteStringPrimitiveNode create(RubyNode[] arguments) {
            return new PointerWriteStringPrimitiveNodeGen(arguments);
        }

        @GeneratedBy(value=PointerPrimitiveNodes.PointerWriteStringPrimitiveNode.class)
        public static final class PointerWriteStringPrimitiveNodeGen
        extends PointerPrimitiveNodes.PointerWriteStringPrimitiveNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private PointerWriteStringPrimitiveNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                return this.specialization_.executeDynamicObject(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="address(DynamicObject, DynamicObject, int)", value=PointerPrimitiveNodes.PointerWriteStringPrimitiveNode.class)
            private static final class AddressNode_
            extends BaseNode_ {
                private final Class<?> arguments2ImplicitType;

                AddressNode_(PointerWriteStringPrimitiveNodeGen root, Object arguments2Value) {
                    super(root, 1);
                    this.arguments2ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments2Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments2ImplicitType == ((AddressNode_)other).arguments2ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDynamicObject(frameValue);
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    int arguments2Value_;
                    DynamicObject arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return this.getNext().executeDynamicObject_(frameValue, ex.getResult(), arguments1Value, arguments2Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    try {
                        if (this.arguments2ImplicitType == Integer.TYPE) {
                            arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                        } else {
                            Object arguments2Value__ = this.executeArguments2_(frameValue);
                            arguments2Value_ = RubyTypesGen.expectImplicitInteger(arguments2Value__, this.arguments2ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyString(arguments1Value_)) {
                        return this.root.address(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments2Value, this.arguments2ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        int arguments2Value_ = RubyTypesGen.asImplicitInteger(arguments2Value, this.arguments2ImplicitType);
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.address(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(PointerWriteStringPrimitiveNodeGen root, Object arguments2Value) {
                    return new AddressNode_(root, arguments2Value);
                }
            }

            @GeneratedBy(value=PointerPrimitiveNodes.PointerWriteStringPrimitiveNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(PointerWriteStringPrimitiveNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(PointerWriteStringPrimitiveNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=PointerPrimitiveNodes.PointerWriteStringPrimitiveNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(PointerWriteStringPrimitiveNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(PointerWriteStringPrimitiveNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=PointerPrimitiveNodes.PointerWriteStringPrimitiveNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected PointerWriteStringPrimitiveNodeGen root;

                BaseNode_(PointerWriteStringPrimitiveNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (PointerWriteStringPrimitiveNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.executeArguments2_(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    return (DynamicObject)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    DynamicObject arguments1Value_;
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments2Value) && RubyGuards.isRubyString(arguments1Value_ = (DynamicObject)arguments1Value)) {
                        return AddressNode_.create(this.root, arguments2Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments2_(Frame frameValue) {
                    Object object;
                    Class arguments2Type_ = this.root.arguments2Type_;
                    if (arguments2Type_ == Integer.TYPE) {
                        return this.root.arguments2_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments2Type_ != null) return this.root.arguments2_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments2_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments2Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments2Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments2Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=PointerPrimitiveNodes.PointerGetAtOffsetPrimitiveNode.class)
    public static final class PointerGetAtOffsetPrimitiveNodeFactory
    extends NodeFactoryBase<PointerPrimitiveNodes.PointerGetAtOffsetPrimitiveNode> {
        private static PointerGetAtOffsetPrimitiveNodeFactory pointerGetAtOffsetPrimitiveNodeFactoryInstance;

        private PointerGetAtOffsetPrimitiveNodeFactory() {
            super(PointerPrimitiveNodes.PointerGetAtOffsetPrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public PointerPrimitiveNodes.PointerGetAtOffsetPrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return PointerGetAtOffsetPrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<PointerPrimitiveNodes.PointerGetAtOffsetPrimitiveNode> getInstance() {
            if (pointerGetAtOffsetPrimitiveNodeFactoryInstance == null) {
                pointerGetAtOffsetPrimitiveNodeFactoryInstance = new PointerGetAtOffsetPrimitiveNodeFactory();
            }
            return pointerGetAtOffsetPrimitiveNodeFactoryInstance;
        }

        public static PointerPrimitiveNodes.PointerGetAtOffsetPrimitiveNode create(RubyNode[] arguments) {
            return new PointerGetAtOffsetPrimitiveNodeGen(arguments);
        }

        @GeneratedBy(value=PointerPrimitiveNodes.PointerGetAtOffsetPrimitiveNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class PointerGetAtOffsetPrimitiveNodeGen
        extends PointerPrimitiveNodes.PointerGetAtOffsetPrimitiveNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private PointerGetAtOffsetPrimitiveNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeDynamicObject(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static DynamicObject expectDynamicObject(Object value) throws UnexpectedResultException {
                if (value instanceof DynamicObject) {
                    return (DynamicObject)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="getAtOffsetPointer(DynamicObject, int, int)", value=PointerPrimitiveNodes.PointerGetAtOffsetPrimitiveNode.class)
            private static final class GetAtOffsetPointerNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;
                private final Class<?> arguments2ImplicitType;

                GetAtOffsetPointerNode_(PointerGetAtOffsetPrimitiveNodeGen root, Object arguments1Value, Object arguments2Value) {
                    super(root, 10);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                    this.arguments2ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments2Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((GetAtOffsetPointerNode_)other).arguments1ImplicitType && this.arguments2ImplicitType == ((GetAtOffsetPointerNode_)other).arguments2ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return PointerGetAtOffsetPrimitiveNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value));
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return PointerGetAtOffsetPrimitiveNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value));
                    }
                    try {
                        if (this.arguments2ImplicitType == Integer.TYPE) {
                            arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                        } else {
                            Object arguments2Value__ = this.executeArguments2_(frameValue);
                            arguments2Value_ = RubyTypesGen.expectImplicitInteger(arguments2Value__, this.arguments2ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return PointerGetAtOffsetPrimitiveNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult()));
                    }
                    if (arguments2Value_ == 13) {
                        return this.root.getAtOffsetPointer(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return PointerGetAtOffsetPrimitiveNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && RubyTypesGen.isImplicitInteger(arguments2Value, this.arguments2ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        int arguments2Value_ = RubyTypesGen.asImplicitInteger(arguments2Value, this.arguments2ImplicitType);
                        if (arguments2Value_ == 13) {
                            return this.root.getAtOffsetPointer(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(PointerGetAtOffsetPrimitiveNodeGen root, Object arguments1Value, Object arguments2Value) {
                    return new GetAtOffsetPointerNode_(root, arguments1Value, arguments2Value);
                }
            }

            @GeneratedBy(methodName="getAtOffsetString(DynamicObject, int, int)", value=PointerPrimitiveNodes.PointerGetAtOffsetPrimitiveNode.class)
            private static final class GetAtOffsetStringNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;
                private final Class<?> arguments2ImplicitType;

                GetAtOffsetStringNode_(PointerGetAtOffsetPrimitiveNodeGen root, Object arguments1Value, Object arguments2Value) {
                    super(root, 9);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                    this.arguments2ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments2Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((GetAtOffsetStringNode_)other).arguments1ImplicitType && this.arguments2ImplicitType == ((GetAtOffsetStringNode_)other).arguments2ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return PointerGetAtOffsetPrimitiveNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value));
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return PointerGetAtOffsetPrimitiveNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value));
                    }
                    try {
                        if (this.arguments2ImplicitType == Integer.TYPE) {
                            arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                        } else {
                            Object arguments2Value__ = this.executeArguments2_(frameValue);
                            arguments2Value_ = RubyTypesGen.expectImplicitInteger(arguments2Value__, this.arguments2ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return PointerGetAtOffsetPrimitiveNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult()));
                    }
                    if (arguments2Value_ == 15) {
                        return this.root.getAtOffsetString(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return PointerGetAtOffsetPrimitiveNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && RubyTypesGen.isImplicitInteger(arguments2Value, this.arguments2ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        int arguments2Value_ = RubyTypesGen.asImplicitInteger(arguments2Value, this.arguments2ImplicitType);
                        if (arguments2Value_ == 15) {
                            return this.root.getAtOffsetString(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(PointerGetAtOffsetPrimitiveNodeGen root, Object arguments1Value, Object arguments2Value) {
                    return new GetAtOffsetStringNode_(root, arguments1Value, arguments2Value);
                }
            }

            @GeneratedBy(methodName="getAtOffsetULL(DynamicObject, int, int)", value=PointerPrimitiveNodes.PointerGetAtOffsetPrimitiveNode.class)
            private static final class GetAtOffsetULLNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;
                private final Class<?> arguments2ImplicitType;

                GetAtOffsetULLNode_(PointerGetAtOffsetPrimitiveNodeGen root, Object arguments1Value, Object arguments2Value) {
                    super(root, 8);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                    this.arguments2ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments2Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((GetAtOffsetULLNode_)other).arguments1ImplicitType && this.arguments2ImplicitType == ((GetAtOffsetULLNode_)other).arguments2ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return PointerGetAtOffsetPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value));
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return PointerGetAtOffsetPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value));
                    }
                    try {
                        if (this.arguments2ImplicitType == Integer.TYPE) {
                            arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                        } else {
                            Object arguments2Value__ = this.executeArguments2_(frameValue);
                            arguments2Value_ = RubyTypesGen.expectImplicitInteger(arguments2Value__, this.arguments2ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return PointerGetAtOffsetPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult()));
                    }
                    if (arguments2Value_ == 10) {
                        return this.root.getAtOffsetULL(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return PointerGetAtOffsetPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && RubyTypesGen.isImplicitInteger(arguments2Value, this.arguments2ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        int arguments2Value_ = RubyTypesGen.asImplicitInteger(arguments2Value, this.arguments2ImplicitType);
                        if (arguments2Value_ == 10) {
                            return this.root.getAtOffsetULL(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(PointerGetAtOffsetPrimitiveNodeGen root, Object arguments1Value, Object arguments2Value) {
                    return new GetAtOffsetULLNode_(root, arguments1Value, arguments2Value);
                }
            }

            @GeneratedBy(methodName="getAtOffsetULong(DynamicObject, int, int)", value=PointerPrimitiveNodes.PointerGetAtOffsetPrimitiveNode.class)
            private static final class GetAtOffsetULongNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;
                private final Class<?> arguments2ImplicitType;

                GetAtOffsetULongNode_(PointerGetAtOffsetPrimitiveNodeGen root, Object arguments1Value, Object arguments2Value) {
                    super(root, 7);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                    this.arguments2ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments2Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((GetAtOffsetULongNode_)other).arguments1ImplicitType && this.arguments2ImplicitType == ((GetAtOffsetULongNode_)other).arguments2ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return PointerGetAtOffsetPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value));
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return PointerGetAtOffsetPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value));
                    }
                    try {
                        if (this.arguments2ImplicitType == Integer.TYPE) {
                            arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                        } else {
                            Object arguments2Value__ = this.executeArguments2_(frameValue);
                            arguments2Value_ = RubyTypesGen.expectImplicitInteger(arguments2Value__, this.arguments2ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return PointerGetAtOffsetPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult()));
                    }
                    if (arguments2Value_ == 8) {
                        return this.root.getAtOffsetULong(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return PointerGetAtOffsetPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && RubyTypesGen.isImplicitInteger(arguments2Value, this.arguments2ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        int arguments2Value_ = RubyTypesGen.asImplicitInteger(arguments2Value, this.arguments2ImplicitType);
                        if (arguments2Value_ == 8) {
                            return this.root.getAtOffsetULong(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(PointerGetAtOffsetPrimitiveNodeGen root, Object arguments1Value, Object arguments2Value) {
                    return new GetAtOffsetULongNode_(root, arguments1Value, arguments2Value);
                }
            }

            @GeneratedBy(methodName="getAtOffsetLong(DynamicObject, int, int)", value=PointerPrimitiveNodes.PointerGetAtOffsetPrimitiveNode.class)
            private static final class GetAtOffsetLongNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;
                private final Class<?> arguments2ImplicitType;

                GetAtOffsetLongNode_(PointerGetAtOffsetPrimitiveNodeGen root, Object arguments1Value, Object arguments2Value) {
                    super(root, 6);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                    this.arguments2ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments2Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((GetAtOffsetLongNode_)other).arguments1ImplicitType && this.arguments2ImplicitType == ((GetAtOffsetLongNode_)other).arguments2ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return PointerGetAtOffsetPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value));
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return PointerGetAtOffsetPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value));
                    }
                    try {
                        if (this.arguments2ImplicitType == Integer.TYPE) {
                            arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                        } else {
                            Object arguments2Value__ = this.executeArguments2_(frameValue);
                            arguments2Value_ = RubyTypesGen.expectImplicitInteger(arguments2Value__, this.arguments2ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return PointerGetAtOffsetPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult()));
                    }
                    if (arguments2Value_ == 7) {
                        return this.root.getAtOffsetLong(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return PointerGetAtOffsetPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && RubyTypesGen.isImplicitInteger(arguments2Value, this.arguments2ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        int arguments2Value_ = RubyTypesGen.asImplicitInteger(arguments2Value, this.arguments2ImplicitType);
                        if (arguments2Value_ == 7) {
                            return this.root.getAtOffsetLong(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(PointerGetAtOffsetPrimitiveNodeGen root, Object arguments1Value, Object arguments2Value) {
                    return new GetAtOffsetLongNode_(root, arguments1Value, arguments2Value);
                }
            }

            @GeneratedBy(methodName="getAtOffsetUShort(DynamicObject, int, int)", value=PointerPrimitiveNodes.PointerGetAtOffsetPrimitiveNode.class)
            private static final class GetAtOffsetUShortNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;
                private final Class<?> arguments2ImplicitType;

                GetAtOffsetUShortNode_(PointerGetAtOffsetPrimitiveNodeGen root, Object arguments1Value, Object arguments2Value) {
                    super(root, 5);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                    this.arguments2ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments2Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((GetAtOffsetUShortNode_)other).arguments1ImplicitType && this.arguments2ImplicitType == ((GetAtOffsetUShortNode_)other).arguments2ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return PointerGetAtOffsetPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value));
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return PointerGetAtOffsetPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value));
                    }
                    try {
                        if (this.arguments2ImplicitType == Integer.TYPE) {
                            arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                        } else {
                            Object arguments2Value__ = this.executeArguments2_(frameValue);
                            arguments2Value_ = RubyTypesGen.expectImplicitInteger(arguments2Value__, this.arguments2ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return PointerGetAtOffsetPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult()));
                    }
                    if (arguments2Value_ == 4) {
                        return this.root.getAtOffsetUShort(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return PointerGetAtOffsetPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && RubyTypesGen.isImplicitInteger(arguments2Value, this.arguments2ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        int arguments2Value_ = RubyTypesGen.asImplicitInteger(arguments2Value, this.arguments2ImplicitType);
                        if (arguments2Value_ == 4) {
                            return this.root.getAtOffsetUShort(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(PointerGetAtOffsetPrimitiveNodeGen root, Object arguments1Value, Object arguments2Value) {
                    return new GetAtOffsetUShortNode_(root, arguments1Value, arguments2Value);
                }
            }

            @GeneratedBy(methodName="getAtOffsetShort(DynamicObject, int, int)", value=PointerPrimitiveNodes.PointerGetAtOffsetPrimitiveNode.class)
            private static final class GetAtOffsetShortNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;
                private final Class<?> arguments2ImplicitType;

                GetAtOffsetShortNode_(PointerGetAtOffsetPrimitiveNodeGen root, Object arguments1Value, Object arguments2Value) {
                    super(root, 4);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                    this.arguments2ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments2Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((GetAtOffsetShortNode_)other).arguments1ImplicitType && this.arguments2ImplicitType == ((GetAtOffsetShortNode_)other).arguments2ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return PointerGetAtOffsetPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value));
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return PointerGetAtOffsetPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value));
                    }
                    try {
                        if (this.arguments2ImplicitType == Integer.TYPE) {
                            arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                        } else {
                            Object arguments2Value__ = this.executeArguments2_(frameValue);
                            arguments2Value_ = RubyTypesGen.expectImplicitInteger(arguments2Value__, this.arguments2ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return PointerGetAtOffsetPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult()));
                    }
                    if (arguments2Value_ == 3) {
                        return this.root.getAtOffsetShort(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return PointerGetAtOffsetPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && RubyTypesGen.isImplicitInteger(arguments2Value, this.arguments2ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        int arguments2Value_ = RubyTypesGen.asImplicitInteger(arguments2Value, this.arguments2ImplicitType);
                        if (arguments2Value_ == 3) {
                            return this.root.getAtOffsetShort(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(PointerGetAtOffsetPrimitiveNodeGen root, Object arguments1Value, Object arguments2Value) {
                    return new GetAtOffsetShortNode_(root, arguments1Value, arguments2Value);
                }
            }

            @GeneratedBy(methodName="getAtOffsetInt(DynamicObject, int, int)", value=PointerPrimitiveNodes.PointerGetAtOffsetPrimitiveNode.class)
            private static final class GetAtOffsetIntNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;
                private final Class<?> arguments2ImplicitType;

                GetAtOffsetIntNode_(PointerGetAtOffsetPrimitiveNodeGen root, Object arguments1Value, Object arguments2Value) {
                    super(root, 3);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                    this.arguments2ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments2Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((GetAtOffsetIntNode_)other).arguments1ImplicitType && this.arguments2ImplicitType == ((GetAtOffsetIntNode_)other).arguments2ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return PointerGetAtOffsetPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value));
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return PointerGetAtOffsetPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value));
                    }
                    try {
                        if (this.arguments2ImplicitType == Integer.TYPE) {
                            arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                        } else {
                            Object arguments2Value__ = this.executeArguments2_(frameValue);
                            arguments2Value_ = RubyTypesGen.expectImplicitInteger(arguments2Value__, this.arguments2ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return PointerGetAtOffsetPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult()));
                    }
                    if (arguments2Value_ == 5) {
                        return this.root.getAtOffsetInt(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return PointerGetAtOffsetPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && RubyTypesGen.isImplicitInteger(arguments2Value, this.arguments2ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        int arguments2Value_ = RubyTypesGen.asImplicitInteger(arguments2Value, this.arguments2ImplicitType);
                        if (arguments2Value_ == 5) {
                            return this.root.getAtOffsetInt(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(PointerGetAtOffsetPrimitiveNodeGen root, Object arguments1Value, Object arguments2Value) {
                    return new GetAtOffsetIntNode_(root, arguments1Value, arguments2Value);
                }
            }

            @GeneratedBy(methodName="getAtOffsetUChar(DynamicObject, int, int)", value=PointerPrimitiveNodes.PointerGetAtOffsetPrimitiveNode.class)
            private static final class GetAtOffsetUCharNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;
                private final Class<?> arguments2ImplicitType;

                GetAtOffsetUCharNode_(PointerGetAtOffsetPrimitiveNodeGen root, Object arguments1Value, Object arguments2Value) {
                    super(root, 2);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                    this.arguments2ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments2Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((GetAtOffsetUCharNode_)other).arguments1ImplicitType && this.arguments2ImplicitType == ((GetAtOffsetUCharNode_)other).arguments2ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return PointerGetAtOffsetPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value));
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return PointerGetAtOffsetPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value));
                    }
                    try {
                        if (this.arguments2ImplicitType == Integer.TYPE) {
                            arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                        } else {
                            Object arguments2Value__ = this.executeArguments2_(frameValue);
                            arguments2Value_ = RubyTypesGen.expectImplicitInteger(arguments2Value__, this.arguments2ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return PointerGetAtOffsetPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult()));
                    }
                    if (arguments2Value_ == 1) {
                        return this.root.getAtOffsetUChar(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return PointerGetAtOffsetPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && RubyTypesGen.isImplicitInteger(arguments2Value, this.arguments2ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        int arguments2Value_ = RubyTypesGen.asImplicitInteger(arguments2Value, this.arguments2ImplicitType);
                        if (arguments2Value_ == 1) {
                            return this.root.getAtOffsetUChar(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(PointerGetAtOffsetPrimitiveNodeGen root, Object arguments1Value, Object arguments2Value) {
                    return new GetAtOffsetUCharNode_(root, arguments1Value, arguments2Value);
                }
            }

            @GeneratedBy(methodName="getAtOffsetChar(DynamicObject, int, int)", value=PointerPrimitiveNodes.PointerGetAtOffsetPrimitiveNode.class)
            private static final class GetAtOffsetCharNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;
                private final Class<?> arguments2ImplicitType;

                GetAtOffsetCharNode_(PointerGetAtOffsetPrimitiveNodeGen root, Object arguments1Value, Object arguments2Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                    this.arguments2ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments2Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((GetAtOffsetCharNode_)other).arguments1ImplicitType && this.arguments2ImplicitType == ((GetAtOffsetCharNode_)other).arguments2ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return PointerGetAtOffsetPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value));
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return PointerGetAtOffsetPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value));
                    }
                    try {
                        if (this.arguments2ImplicitType == Integer.TYPE) {
                            arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                        } else {
                            Object arguments2Value__ = this.executeArguments2_(frameValue);
                            arguments2Value_ = RubyTypesGen.expectImplicitInteger(arguments2Value__, this.arguments2ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return PointerGetAtOffsetPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult()));
                    }
                    if (arguments2Value_ == 0) {
                        return this.root.getAtOffsetChar(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return PointerGetAtOffsetPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && RubyTypesGen.isImplicitInteger(arguments2Value, this.arguments2ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        int arguments2Value_ = RubyTypesGen.asImplicitInteger(arguments2Value, this.arguments2ImplicitType);
                        if (arguments2Value_ == 0) {
                            return this.root.getAtOffsetChar(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(PointerGetAtOffsetPrimitiveNodeGen root, Object arguments1Value, Object arguments2Value) {
                    return new GetAtOffsetCharNode_(root, arguments1Value, arguments2Value);
                }
            }

            @GeneratedBy(value=PointerPrimitiveNodes.PointerGetAtOffsetPrimitiveNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(PointerGetAtOffsetPrimitiveNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(PointerGetAtOffsetPrimitiveNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=PointerPrimitiveNodes.PointerGetAtOffsetPrimitiveNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(PointerGetAtOffsetPrimitiveNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(PointerGetAtOffsetPrimitiveNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=PointerPrimitiveNodes.PointerGetAtOffsetPrimitiveNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected PointerGetAtOffsetPrimitiveNodeGen root;

                BaseNode_(PointerGetAtOffsetPrimitiveNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (PointerGetAtOffsetPrimitiveNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    Object arguments2Value_ = this.executeArguments2_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    return PointerGetAtOffsetPrimitiveNodeGen.expectDynamicObject(this.execute(frameValue));
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return PointerGetAtOffsetPrimitiveNodeGen.expectInteger(this.execute(frameValue));
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return PointerGetAtOffsetPrimitiveNodeGen.expectLong(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value) && RubyTypesGen.isImplicitInteger(arguments2Value)) {
                        int arguments2Value_ = RubyTypesGen.asImplicitInteger(arguments2Value);
                        if (arguments2Value_ == 0) {
                            return GetAtOffsetCharNode_.create(this.root, arguments1Value, arguments2Value);
                        }
                        if (arguments2Value_ == 1) {
                            return GetAtOffsetUCharNode_.create(this.root, arguments1Value, arguments2Value);
                        }
                        if (arguments2Value_ == 5) {
                            return GetAtOffsetIntNode_.create(this.root, arguments1Value, arguments2Value);
                        }
                        if (arguments2Value_ == 3) {
                            return GetAtOffsetShortNode_.create(this.root, arguments1Value, arguments2Value);
                        }
                        if (arguments2Value_ == 4) {
                            return GetAtOffsetUShortNode_.create(this.root, arguments1Value, arguments2Value);
                        }
                        if (arguments2Value_ == 7) {
                            return GetAtOffsetLongNode_.create(this.root, arguments1Value, arguments2Value);
                        }
                        if (arguments2Value_ == 8) {
                            return GetAtOffsetULongNode_.create(this.root, arguments1Value, arguments2Value);
                        }
                        if (arguments2Value_ == 10) {
                            return GetAtOffsetULLNode_.create(this.root, arguments1Value, arguments2Value);
                        }
                        if (arguments2Value_ == 15) {
                            return GetAtOffsetStringNode_.create(this.root, arguments1Value, arguments2Value);
                        }
                        if (arguments2Value_ == 13) {
                            return GetAtOffsetPointerNode_.create(this.root, arguments1Value, arguments2Value);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments2_(Frame frameValue) {
                    Object object;
                    Class arguments2Type_ = this.root.arguments2Type_;
                    if (arguments2Type_ == Integer.TYPE) {
                        return this.root.arguments2_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments2Type_ != null) return this.root.arguments2_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments2_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments2Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments2Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments2Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=PointerPrimitiveNodes.PointerAddressPrimitiveNode.class)
    public static final class PointerAddressPrimitiveNodeFactory
    extends NodeFactoryBase<PointerPrimitiveNodes.PointerAddressPrimitiveNode> {
        private static PointerAddressPrimitiveNodeFactory pointerAddressPrimitiveNodeFactoryInstance;

        private PointerAddressPrimitiveNodeFactory() {
            super(PointerPrimitiveNodes.PointerAddressPrimitiveNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public PointerPrimitiveNodes.PointerAddressPrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return PointerAddressPrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<PointerPrimitiveNodes.PointerAddressPrimitiveNode> getInstance() {
            if (pointerAddressPrimitiveNodeFactoryInstance == null) {
                pointerAddressPrimitiveNodeFactoryInstance = new PointerAddressPrimitiveNodeFactory();
            }
            return pointerAddressPrimitiveNodeFactoryInstance;
        }

        public static PointerPrimitiveNodes.PointerAddressPrimitiveNode create(RubyNode[] arguments) {
            return new PointerAddressPrimitiveNodeGen(arguments);
        }

        @GeneratedBy(value=PointerPrimitiveNodes.PointerAddressPrimitiveNode.class)
        public static final class PointerAddressPrimitiveNodeGen
        extends PointerPrimitiveNodes.PointerAddressPrimitiveNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private PointerAddressPrimitiveNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeLong(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeLong(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.address(arguments0Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=PointerPrimitiveNodes.PointerReadPointerPrimitiveNode.class)
    public static final class PointerReadPointerPrimitiveNodeFactory
    extends NodeFactoryBase<PointerPrimitiveNodes.PointerReadPointerPrimitiveNode> {
        private static PointerReadPointerPrimitiveNodeFactory pointerReadPointerPrimitiveNodeFactoryInstance;

        private PointerReadPointerPrimitiveNodeFactory() {
            super(PointerPrimitiveNodes.PointerReadPointerPrimitiveNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public PointerPrimitiveNodes.PointerReadPointerPrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PointerReadPointerPrimitiveNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<PointerPrimitiveNodes.PointerReadPointerPrimitiveNode> getInstance() {
            if (pointerReadPointerPrimitiveNodeFactoryInstance == null) {
                pointerReadPointerPrimitiveNodeFactoryInstance = new PointerReadPointerPrimitiveNodeFactory();
            }
            return pointerReadPointerPrimitiveNodeFactoryInstance;
        }

        public static PointerPrimitiveNodes.PointerReadPointerPrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new PointerReadPointerPrimitiveNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=PointerPrimitiveNodes.PointerReadPointerPrimitiveNode.class)
        public static final class PointerReadPointerPrimitiveNodeGen
        extends PointerPrimitiveNodes.PointerReadPointerPrimitiveNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private PointerReadPointerPrimitiveNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.readPointer(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=PointerPrimitiveNodes.PointerSetAtOffsetPrimitiveNode.class)
    public static final class PointerSetAtOffsetPrimitiveNodeFactory
    extends NodeFactoryBase<PointerPrimitiveNodes.PointerSetAtOffsetPrimitiveNode> {
        private static PointerSetAtOffsetPrimitiveNodeFactory pointerSetAtOffsetPrimitiveNodeFactoryInstance;

        private PointerSetAtOffsetPrimitiveNodeFactory() {
            super(PointerPrimitiveNodes.PointerSetAtOffsetPrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public PointerPrimitiveNodes.PointerSetAtOffsetPrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return PointerSetAtOffsetPrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<PointerPrimitiveNodes.PointerSetAtOffsetPrimitiveNode> getInstance() {
            if (pointerSetAtOffsetPrimitiveNodeFactoryInstance == null) {
                pointerSetAtOffsetPrimitiveNodeFactoryInstance = new PointerSetAtOffsetPrimitiveNodeFactory();
            }
            return pointerSetAtOffsetPrimitiveNodeFactoryInstance;
        }

        public static PointerPrimitiveNodes.PointerSetAtOffsetPrimitiveNode create(RubyNode[] arguments) {
            return new PointerSetAtOffsetPrimitiveNodeGen(arguments);
        }

        @GeneratedBy(value=PointerPrimitiveNodes.PointerSetAtOffsetPrimitiveNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class PointerSetAtOffsetPrimitiveNodeGen
        extends PointerPrimitiveNodes.PointerSetAtOffsetPrimitiveNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private RubyNode arguments3_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments3Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private PointerSetAtOffsetPrimitiveNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.arguments3_ = arguments != null && 3 < arguments.length ? arguments[3] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="setAtOffsetULL(DynamicObject, int, int, long)", value=PointerPrimitiveNodes.PointerSetAtOffsetPrimitiveNode.class)
            private static final class SetAtOffsetULLNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;
                private final Class<?> arguments2ImplicitType;
                private final Class<?> arguments3ImplicitType;

                SetAtOffsetULLNode_(PointerSetAtOffsetPrimitiveNodeGen root, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    super(root, 4);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                    this.arguments2ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments2Value);
                    this.arguments3ImplicitType = RubyTypesGen.getImplicitLongClass(arguments3Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((SetAtOffsetULLNode_)other).arguments1ImplicitType && this.arguments2ImplicitType == ((SetAtOffsetULLNode_)other).arguments2ImplicitType && this.arguments3ImplicitType == ((SetAtOffsetULLNode_)other).arguments3ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments3Value_;
                    int arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        Object arguments3Value = this.executeArguments3_(frameValue);
                        return PointerSetAtOffsetPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value));
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        Object arguments3Value = this.executeArguments3_(frameValue);
                        return PointerSetAtOffsetPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value));
                    }
                    try {
                        if (this.arguments2ImplicitType == Integer.TYPE) {
                            arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                        } else {
                            Object arguments2Value__ = this.executeArguments2_(frameValue);
                            arguments2Value_ = RubyTypesGen.expectImplicitInteger(arguments2Value__, this.arguments2ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments3Value = this.executeArguments3_(frameValue);
                        return PointerSetAtOffsetPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value));
                    }
                    try {
                        arguments3Value_ = this.executeArguments3Long_(frameValue, this.arguments3ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return PointerSetAtOffsetPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult()));
                    }
                    if (arguments2Value_ == 10) {
                        return this.root.setAtOffsetULL(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return PointerSetAtOffsetPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && RubyTypesGen.isImplicitInteger(arguments2Value, this.arguments2ImplicitType) && RubyTypesGen.isImplicitLong(arguments3Value, this.arguments3ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        int arguments2Value_ = RubyTypesGen.asImplicitInteger(arguments2Value, this.arguments2ImplicitType);
                        long arguments3Value_ = RubyTypesGen.asImplicitLong(arguments3Value, this.arguments3ImplicitType);
                        if (arguments2Value_ == 10) {
                            return this.root.setAtOffsetULL(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(PointerSetAtOffsetPrimitiveNodeGen root, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return new SetAtOffsetULLNode_(root, arguments1Value, arguments2Value, arguments3Value);
                }
            }

            @GeneratedBy(methodName="setAtOffsetULong(DynamicObject, int, int, long)", value=PointerPrimitiveNodes.PointerSetAtOffsetPrimitiveNode.class)
            private static final class SetAtOffsetULongNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;
                private final Class<?> arguments2ImplicitType;
                private final Class<?> arguments3ImplicitType;

                SetAtOffsetULongNode_(PointerSetAtOffsetPrimitiveNodeGen root, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    super(root, 3);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                    this.arguments2ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments2Value);
                    this.arguments3ImplicitType = RubyTypesGen.getImplicitLongClass(arguments3Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((SetAtOffsetULongNode_)other).arguments1ImplicitType && this.arguments2ImplicitType == ((SetAtOffsetULongNode_)other).arguments2ImplicitType && this.arguments3ImplicitType == ((SetAtOffsetULongNode_)other).arguments3ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments3Value_;
                    int arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        Object arguments3Value = this.executeArguments3_(frameValue);
                        return PointerSetAtOffsetPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value));
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        Object arguments3Value = this.executeArguments3_(frameValue);
                        return PointerSetAtOffsetPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value));
                    }
                    try {
                        if (this.arguments2ImplicitType == Integer.TYPE) {
                            arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                        } else {
                            Object arguments2Value__ = this.executeArguments2_(frameValue);
                            arguments2Value_ = RubyTypesGen.expectImplicitInteger(arguments2Value__, this.arguments2ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments3Value = this.executeArguments3_(frameValue);
                        return PointerSetAtOffsetPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value));
                    }
                    try {
                        arguments3Value_ = this.executeArguments3Long_(frameValue, this.arguments3ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return PointerSetAtOffsetPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult()));
                    }
                    if (arguments2Value_ == 8) {
                        return this.root.setAtOffsetULong(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return PointerSetAtOffsetPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && RubyTypesGen.isImplicitInteger(arguments2Value, this.arguments2ImplicitType) && RubyTypesGen.isImplicitLong(arguments3Value, this.arguments3ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        int arguments2Value_ = RubyTypesGen.asImplicitInteger(arguments2Value, this.arguments2ImplicitType);
                        long arguments3Value_ = RubyTypesGen.asImplicitLong(arguments3Value, this.arguments3ImplicitType);
                        if (arguments2Value_ == 8) {
                            return this.root.setAtOffsetULong(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(PointerSetAtOffsetPrimitiveNodeGen root, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return new SetAtOffsetULongNode_(root, arguments1Value, arguments2Value, arguments3Value);
                }
            }

            @GeneratedBy(methodName="setAtOffsetLong(DynamicObject, int, int, long)", value=PointerPrimitiveNodes.PointerSetAtOffsetPrimitiveNode.class)
            private static final class SetAtOffsetLongNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;
                private final Class<?> arguments2ImplicitType;
                private final Class<?> arguments3ImplicitType;

                SetAtOffsetLongNode_(PointerSetAtOffsetPrimitiveNodeGen root, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    super(root, 2);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                    this.arguments2ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments2Value);
                    this.arguments3ImplicitType = RubyTypesGen.getImplicitLongClass(arguments3Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((SetAtOffsetLongNode_)other).arguments1ImplicitType && this.arguments2ImplicitType == ((SetAtOffsetLongNode_)other).arguments2ImplicitType && this.arguments3ImplicitType == ((SetAtOffsetLongNode_)other).arguments3ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments3Value_;
                    int arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        Object arguments3Value = this.executeArguments3_(frameValue);
                        return PointerSetAtOffsetPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value));
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        Object arguments3Value = this.executeArguments3_(frameValue);
                        return PointerSetAtOffsetPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value));
                    }
                    try {
                        if (this.arguments2ImplicitType == Integer.TYPE) {
                            arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                        } else {
                            Object arguments2Value__ = this.executeArguments2_(frameValue);
                            arguments2Value_ = RubyTypesGen.expectImplicitInteger(arguments2Value__, this.arguments2ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments3Value = this.executeArguments3_(frameValue);
                        return PointerSetAtOffsetPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value));
                    }
                    try {
                        arguments3Value_ = this.executeArguments3Long_(frameValue, this.arguments3ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return PointerSetAtOffsetPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult()));
                    }
                    if (arguments2Value_ == 7) {
                        return this.root.setAtOffsetLong(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return PointerSetAtOffsetPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && RubyTypesGen.isImplicitInteger(arguments2Value, this.arguments2ImplicitType) && RubyTypesGen.isImplicitLong(arguments3Value, this.arguments3ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        int arguments2Value_ = RubyTypesGen.asImplicitInteger(arguments2Value, this.arguments2ImplicitType);
                        long arguments3Value_ = RubyTypesGen.asImplicitLong(arguments3Value, this.arguments3ImplicitType);
                        if (arguments2Value_ == 7) {
                            return this.root.setAtOffsetLong(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(PointerSetAtOffsetPrimitiveNodeGen root, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return new SetAtOffsetLongNode_(root, arguments1Value, arguments2Value, arguments3Value);
                }
            }

            @GeneratedBy(methodName="setAtOffsetInt(DynamicObject, int, int, int)", value=PointerPrimitiveNodes.PointerSetAtOffsetPrimitiveNode.class)
            private static final class SetAtOffsetIntNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;
                private final Class<?> arguments2ImplicitType;
                private final Class<?> arguments3ImplicitType;

                SetAtOffsetIntNode_(PointerSetAtOffsetPrimitiveNodeGen root, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                    this.arguments2ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments2Value);
                    this.arguments3ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments3Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((SetAtOffsetIntNode_)other).arguments1ImplicitType && this.arguments2ImplicitType == ((SetAtOffsetIntNode_)other).arguments2ImplicitType && this.arguments3ImplicitType == ((SetAtOffsetIntNode_)other).arguments3ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments3Value_;
                    int arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        Object arguments3Value = this.executeArguments3_(frameValue);
                        return PointerSetAtOffsetPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value));
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        Object arguments3Value = this.executeArguments3_(frameValue);
                        return PointerSetAtOffsetPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value));
                    }
                    try {
                        if (this.arguments2ImplicitType == Integer.TYPE) {
                            arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                        } else {
                            Object arguments2Value__ = this.executeArguments2_(frameValue);
                            arguments2Value_ = RubyTypesGen.expectImplicitInteger(arguments2Value__, this.arguments2ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments3Value = this.executeArguments3_(frameValue);
                        return PointerSetAtOffsetPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value));
                    }
                    try {
                        if (this.arguments3ImplicitType == Integer.TYPE) {
                            arguments3Value_ = this.root.arguments3_.executeInteger(frameValue);
                        } else {
                            Object arguments3Value__ = this.executeArguments3_(frameValue);
                            arguments3Value_ = RubyTypesGen.expectImplicitInteger(arguments3Value__, this.arguments3ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return PointerSetAtOffsetPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult()));
                    }
                    if (arguments2Value_ == 5) {
                        return this.root.setAtOffsetInt(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return PointerSetAtOffsetPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && RubyTypesGen.isImplicitInteger(arguments2Value, this.arguments2ImplicitType) && RubyTypesGen.isImplicitInteger(arguments3Value, this.arguments3ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        int arguments2Value_ = RubyTypesGen.asImplicitInteger(arguments2Value, this.arguments2ImplicitType);
                        int arguments3Value_ = RubyTypesGen.asImplicitInteger(arguments3Value, this.arguments3ImplicitType);
                        if (arguments2Value_ == 5) {
                            return this.root.setAtOffsetInt(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(PointerSetAtOffsetPrimitiveNodeGen root, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return new SetAtOffsetIntNode_(root, arguments1Value, arguments2Value, arguments3Value);
                }
            }

            @GeneratedBy(value=PointerPrimitiveNodes.PointerSetAtOffsetPrimitiveNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(PointerSetAtOffsetPrimitiveNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(PointerSetAtOffsetPrimitiveNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=PointerPrimitiveNodes.PointerSetAtOffsetPrimitiveNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(PointerSetAtOffsetPrimitiveNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(PointerSetAtOffsetPrimitiveNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=PointerPrimitiveNodes.PointerSetAtOffsetPrimitiveNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected PointerSetAtOffsetPrimitiveNodeGen root;

                BaseNode_(PointerSetAtOffsetPrimitiveNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (PointerSetAtOffsetPrimitiveNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_, this.root.arguments3_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    Object arguments2Value_ = this.executeArguments2_(frameValue);
                    Object arguments3Value_ = this.executeArguments3_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return PointerSetAtOffsetPrimitiveNodeGen.expectInteger(this.execute(frameValue));
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return PointerSetAtOffsetPrimitiveNodeGen.expectLong(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value) && RubyTypesGen.isImplicitInteger(arguments2Value)) {
                        int arguments2Value_ = RubyTypesGen.asImplicitInteger(arguments2Value);
                        if (RubyTypesGen.isImplicitInteger(arguments3Value) && arguments2Value_ == 5) {
                            return SetAtOffsetIntNode_.create(this.root, arguments1Value, arguments2Value, arguments3Value);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments3Value)) {
                            if (arguments2Value_ == 7) {
                                return SetAtOffsetLongNode_.create(this.root, arguments1Value, arguments2Value, arguments3Value);
                            }
                            if (arguments2Value_ == 8) {
                                return SetAtOffsetULongNode_.create(this.root, arguments1Value, arguments2Value, arguments3Value);
                            }
                            if (arguments2Value_ == 10) {
                                return SetAtOffsetULLNode_.create(this.root, arguments1Value, arguments2Value, arguments3Value);
                            }
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments2_(Frame frameValue) {
                    Object object;
                    Class arguments2Type_ = this.root.arguments2Type_;
                    if (arguments2Type_ == Integer.TYPE) {
                        return this.root.arguments2_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments2Type_ != null) return this.root.arguments2_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments2_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments2Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments2Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments2Type_ = _type;
                    return object;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments3_(Frame frameValue) {
                    Object object;
                    Class arguments3Type_ = this.root.arguments3Type_;
                    if (arguments3Type_ == Integer.TYPE) {
                        return this.root.arguments3_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments3Type_ == Long.TYPE) {
                        return this.root.arguments3_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments3Type_ != null) return this.root.arguments3_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments3_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments3Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments3Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments3Type_ = _type;
                    return object;
                }

                protected final long executeArguments3Long_(Frame frameValue, Class<?> arguments3ImplicitType) throws UnexpectedResultException {
                    if (arguments3ImplicitType == Long.TYPE) {
                        return this.root.arguments3_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments3ImplicitType == Integer.TYPE) {
                        return RubyTypes.promoteToLong(this.root.arguments3_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments3Value_ = this.executeArguments3_(frameValue);
                    return RubyTypesGen.expectImplicitLong(arguments3Value_, arguments3ImplicitType);
                }
            }
        }
    }

    @GeneratedBy(value=PointerPrimitiveNodes.PointerSetAutoreleasePrimitiveNode.class)
    public static final class PointerSetAutoreleasePrimitiveNodeFactory
    extends NodeFactoryBase<PointerPrimitiveNodes.PointerSetAutoreleasePrimitiveNode> {
        private static PointerSetAutoreleasePrimitiveNodeFactory pointerSetAutoreleasePrimitiveNodeFactoryInstance;

        private PointerSetAutoreleasePrimitiveNodeFactory() {
            super(PointerPrimitiveNodes.PointerSetAutoreleasePrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public PointerPrimitiveNodes.PointerSetAutoreleasePrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return PointerSetAutoreleasePrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<PointerPrimitiveNodes.PointerSetAutoreleasePrimitiveNode> getInstance() {
            if (pointerSetAutoreleasePrimitiveNodeFactoryInstance == null) {
                pointerSetAutoreleasePrimitiveNodeFactoryInstance = new PointerSetAutoreleasePrimitiveNodeFactory();
            }
            return pointerSetAutoreleasePrimitiveNodeFactoryInstance;
        }

        public static PointerPrimitiveNodes.PointerSetAutoreleasePrimitiveNode create(RubyNode[] arguments) {
            return new PointerSetAutoreleasePrimitiveNodeGen(arguments);
        }

        @GeneratedBy(value=PointerPrimitiveNodes.PointerSetAutoreleasePrimitiveNode.class)
        public static final class PointerSetAutoreleasePrimitiveNodeGen
        extends PointerPrimitiveNodes.PointerSetAutoreleasePrimitiveNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private PointerSetAutoreleasePrimitiveNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                boolean arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.setAutorelease(arguments0Value_, arguments1Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }

    @GeneratedBy(value=PointerPrimitiveNodes.PointerReadStringPrimitiveNode.class)
    public static final class PointerReadStringPrimitiveNodeFactory
    extends NodeFactoryBase<PointerPrimitiveNodes.PointerReadStringPrimitiveNode> {
        private static PointerReadStringPrimitiveNodeFactory pointerReadStringPrimitiveNodeFactoryInstance;

        private PointerReadStringPrimitiveNodeFactory() {
            super(PointerPrimitiveNodes.PointerReadStringPrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public PointerPrimitiveNodes.PointerReadStringPrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return PointerReadStringPrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<PointerPrimitiveNodes.PointerReadStringPrimitiveNode> getInstance() {
            if (pointerReadStringPrimitiveNodeFactoryInstance == null) {
                pointerReadStringPrimitiveNodeFactoryInstance = new PointerReadStringPrimitiveNodeFactory();
            }
            return pointerReadStringPrimitiveNodeFactoryInstance;
        }

        public static PointerPrimitiveNodes.PointerReadStringPrimitiveNode create(RubyNode[] arguments) {
            return new PointerReadStringPrimitiveNodeGen(arguments);
        }

        @GeneratedBy(value=PointerPrimitiveNodes.PointerReadStringPrimitiveNode.class)
        public static final class PointerReadStringPrimitiveNodeGen
        extends PointerPrimitiveNodes.PointerReadStringPrimitiveNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private PointerReadStringPrimitiveNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                return this.specialization_.executeDynamicObject(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="readString(DynamicObject, int)", value=PointerPrimitiveNodes.PointerReadStringPrimitiveNode.class)
            private static final class ReadStringNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                ReadStringNode_(PointerReadStringPrimitiveNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((ReadStringNode_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDynamicObject(frameValue);
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeDynamicObject_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.readString(arguments0Value_, arguments1Value_);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        return this.root.readString(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PointerReadStringPrimitiveNodeGen root, Object arguments1Value) {
                    return new ReadStringNode_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=PointerPrimitiveNodes.PointerReadStringPrimitiveNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(PointerReadStringPrimitiveNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PointerReadStringPrimitiveNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=PointerPrimitiveNodes.PointerReadStringPrimitiveNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(PointerReadStringPrimitiveNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PointerReadStringPrimitiveNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=PointerPrimitiveNodes.PointerReadStringPrimitiveNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected PointerReadStringPrimitiveNodeGen root;

                BaseNode_(PointerReadStringPrimitiveNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (PointerReadStringPrimitiveNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    return (DynamicObject)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value)) {
                        return ReadStringNode_.create(this.root, arguments1Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=PointerPrimitiveNodes.PointerReadIntPrimitiveNode.class)
    public static final class PointerReadIntPrimitiveNodeFactory
    extends NodeFactoryBase<PointerPrimitiveNodes.PointerReadIntPrimitiveNode> {
        private static PointerReadIntPrimitiveNodeFactory pointerReadIntPrimitiveNodeFactoryInstance;

        private PointerReadIntPrimitiveNodeFactory() {
            super(PointerPrimitiveNodes.PointerReadIntPrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public PointerPrimitiveNodes.PointerReadIntPrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return PointerReadIntPrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<PointerPrimitiveNodes.PointerReadIntPrimitiveNode> getInstance() {
            if (pointerReadIntPrimitiveNodeFactoryInstance == null) {
                pointerReadIntPrimitiveNodeFactoryInstance = new PointerReadIntPrimitiveNodeFactory();
            }
            return pointerReadIntPrimitiveNodeFactoryInstance;
        }

        public static PointerPrimitiveNodes.PointerReadIntPrimitiveNode create(RubyNode[] arguments) {
            return new PointerReadIntPrimitiveNodeGen(arguments);
        }

        @GeneratedBy(value=PointerPrimitiveNodes.PointerReadIntPrimitiveNode.class)
        public static final class PointerReadIntPrimitiveNodeGen
        extends PointerPrimitiveNodes.PointerReadIntPrimitiveNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private PointerReadIntPrimitiveNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                boolean arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                if (this.isSigned(arguments1Value_)) {
                    return this.readInt(arguments0Value_, arguments1Value_);
                }
                throw this.unsupported(arguments0Value_, arguments1Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }

    @GeneratedBy(value=PointerPrimitiveNodes.PointerAddPrimitiveNode.class)
    public static final class PointerAddPrimitiveNodeFactory
    extends NodeFactoryBase<PointerPrimitiveNodes.PointerAddPrimitiveNode> {
        private static PointerAddPrimitiveNodeFactory pointerAddPrimitiveNodeFactoryInstance;

        private PointerAddPrimitiveNodeFactory() {
            super(PointerPrimitiveNodes.PointerAddPrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public PointerPrimitiveNodes.PointerAddPrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PointerAddPrimitiveNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<PointerPrimitiveNodes.PointerAddPrimitiveNode> getInstance() {
            if (pointerAddPrimitiveNodeFactoryInstance == null) {
                pointerAddPrimitiveNodeFactoryInstance = new PointerAddPrimitiveNodeFactory();
            }
            return pointerAddPrimitiveNodeFactoryInstance;
        }

        public static PointerPrimitiveNodes.PointerAddPrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new PointerAddPrimitiveNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=PointerPrimitiveNodes.PointerAddPrimitiveNode.class)
        public static final class PointerAddPrimitiveNodeGen
        extends PointerPrimitiveNodes.PointerAddPrimitiveNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private PointerAddPrimitiveNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                return this.specialization_.executeDynamicObject(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="add(DynamicObject, long)", value=PointerPrimitiveNodes.PointerAddPrimitiveNode.class)
            private static final class Add1Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Add1Node_(PointerAddPrimitiveNodeGen root, Object arguments1Value) {
                    super(root, 2);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Add1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDynamicObject(frameValue);
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    long arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeDynamicObject_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Long.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                        } else if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = RubyTypes.promoteToLong(this.root.arguments1_.executeInteger(frameValue));
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitLong(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.add(arguments0Value_, arguments1Value_);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.add(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PointerAddPrimitiveNodeGen root, Object arguments1Value) {
                    return new Add1Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="add(DynamicObject, int)", value=PointerPrimitiveNodes.PointerAddPrimitiveNode.class)
            private static final class Add0Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Add0Node_(PointerAddPrimitiveNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Add0Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDynamicObject(frameValue);
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeDynamicObject_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.add(arguments0Value_, arguments1Value_);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        return this.root.add(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PointerAddPrimitiveNodeGen root, Object arguments1Value) {
                    return new Add0Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=PointerPrimitiveNodes.PointerAddPrimitiveNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(PointerAddPrimitiveNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PointerAddPrimitiveNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=PointerPrimitiveNodes.PointerAddPrimitiveNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(PointerAddPrimitiveNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PointerAddPrimitiveNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=PointerPrimitiveNodes.PointerAddPrimitiveNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected PointerAddPrimitiveNodeGen root;

                BaseNode_(PointerAddPrimitiveNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (PointerAddPrimitiveNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    return (DynamicObject)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        if (RubyTypesGen.isImplicitInteger(arguments1Value)) {
                            return Add0Node_.create(this.root, arguments1Value);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Add1Node_.create(this.root, arguments1Value);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=PointerPrimitiveNodes.PointerSetAddressPrimitiveNode.class)
    public static final class PointerSetAddressPrimitiveNodeFactory
    extends NodeFactoryBase<PointerPrimitiveNodes.PointerSetAddressPrimitiveNode> {
        private static PointerSetAddressPrimitiveNodeFactory pointerSetAddressPrimitiveNodeFactoryInstance;

        private PointerSetAddressPrimitiveNodeFactory() {
            super(PointerPrimitiveNodes.PointerSetAddressPrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public PointerPrimitiveNodes.PointerSetAddressPrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return PointerSetAddressPrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<PointerPrimitiveNodes.PointerSetAddressPrimitiveNode> getInstance() {
            if (pointerSetAddressPrimitiveNodeFactoryInstance == null) {
                pointerSetAddressPrimitiveNodeFactoryInstance = new PointerSetAddressPrimitiveNodeFactory();
            }
            return pointerSetAddressPrimitiveNodeFactoryInstance;
        }

        public static PointerPrimitiveNodes.PointerSetAddressPrimitiveNode create(RubyNode[] arguments) {
            return new PointerSetAddressPrimitiveNodeGen(arguments);
        }

        @GeneratedBy(value=PointerPrimitiveNodes.PointerSetAddressPrimitiveNode.class)
        public static final class PointerSetAddressPrimitiveNodeGen
        extends PointerPrimitiveNodes.PointerSetAddressPrimitiveNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private PointerSetAddressPrimitiveNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) {
                return this.specialization_.executeLong(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="setAddress(DynamicObject, long)", value=PointerPrimitiveNodes.PointerSetAddressPrimitiveNode.class)
            private static final class SetAddress1Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                SetAddress1Node_(PointerSetAddressPrimitiveNodeGen root, Object arguments1Value) {
                    super(root, 2);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((SetAddress1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeLong(frameValue);
                }

                @Override
                public long executeLong(VirtualFrame frameValue) {
                    long arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeLong_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Long.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                        } else if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = RubyTypes.promoteToLong(this.root.arguments1_.executeInteger(frameValue));
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitLong(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeLong_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.setAddress(arguments0Value_, arguments1Value_);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.setAddress(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeLong_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PointerSetAddressPrimitiveNodeGen root, Object arguments1Value) {
                    return new SetAddress1Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="setAddress(DynamicObject, int)", value=PointerPrimitiveNodes.PointerSetAddressPrimitiveNode.class)
            private static final class SetAddress0Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                SetAddress0Node_(PointerSetAddressPrimitiveNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((SetAddress0Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeLong(frameValue);
                }

                @Override
                public long executeLong(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeLong_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeLong_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.setAddress(arguments0Value_, arguments1Value_);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        return this.root.setAddress(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeLong_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PointerSetAddressPrimitiveNodeGen root, Object arguments1Value) {
                    return new SetAddress0Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=PointerPrimitiveNodes.PointerSetAddressPrimitiveNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(PointerSetAddressPrimitiveNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public long executeLong(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.getNext().executeLong_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeLong_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PointerSetAddressPrimitiveNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=PointerPrimitiveNodes.PointerSetAddressPrimitiveNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(PointerSetAddressPrimitiveNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (Long)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PointerSetAddressPrimitiveNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=PointerPrimitiveNodes.PointerSetAddressPrimitiveNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected PointerSetAddressPrimitiveNodeGen root;

                BaseNode_(PointerSetAddressPrimitiveNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (PointerSetAddressPrimitiveNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeLong_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract long executeLong_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.executeLong_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public long executeLong(VirtualFrame frameValue) {
                    return (Long)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        if (RubyTypesGen.isImplicitInteger(arguments1Value)) {
                            return SetAddress0Node_.create(this.root, arguments1Value);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return SetAddress1Node_.create(this.root, arguments1Value);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=PointerPrimitiveNodes.PointerFreePrimitiveNode.class)
    public static final class PointerFreePrimitiveNodeFactory
    extends NodeFactoryBase<PointerPrimitiveNodes.PointerFreePrimitiveNode> {
        private static PointerFreePrimitiveNodeFactory pointerFreePrimitiveNodeFactoryInstance;

        private PointerFreePrimitiveNodeFactory() {
            super(PointerPrimitiveNodes.PointerFreePrimitiveNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public PointerPrimitiveNodes.PointerFreePrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return PointerFreePrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<PointerPrimitiveNodes.PointerFreePrimitiveNode> getInstance() {
            if (pointerFreePrimitiveNodeFactoryInstance == null) {
                pointerFreePrimitiveNodeFactoryInstance = new PointerFreePrimitiveNodeFactory();
            }
            return pointerFreePrimitiveNodeFactoryInstance;
        }

        public static PointerPrimitiveNodes.PointerFreePrimitiveNode create(RubyNode[] arguments) {
            return new PointerFreePrimitiveNodeGen(arguments);
        }

        @GeneratedBy(value=PointerPrimitiveNodes.PointerFreePrimitiveNode.class)
        public static final class PointerFreePrimitiveNodeGen
        extends PointerPrimitiveNodes.PointerFreePrimitiveNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private PointerFreePrimitiveNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.free(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=PointerPrimitiveNodes.PointerMallocPrimitiveNode.class)
    public static final class PointerMallocPrimitiveNodeFactory
    extends NodeFactoryBase<PointerPrimitiveNodes.PointerMallocPrimitiveNode> {
        private static PointerMallocPrimitiveNodeFactory pointerMallocPrimitiveNodeFactoryInstance;

        private PointerMallocPrimitiveNodeFactory() {
            super(PointerPrimitiveNodes.PointerMallocPrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public PointerPrimitiveNodes.PointerMallocPrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PointerMallocPrimitiveNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<PointerPrimitiveNodes.PointerMallocPrimitiveNode> getInstance() {
            if (pointerMallocPrimitiveNodeFactoryInstance == null) {
                pointerMallocPrimitiveNodeFactoryInstance = new PointerMallocPrimitiveNodeFactory();
            }
            return pointerMallocPrimitiveNodeFactoryInstance;
        }

        public static PointerPrimitiveNodes.PointerMallocPrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new PointerMallocPrimitiveNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=PointerPrimitiveNodes.PointerMallocPrimitiveNode.class)
        public static final class PointerMallocPrimitiveNodeGen
        extends PointerPrimitiveNodes.PointerMallocPrimitiveNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private PointerMallocPrimitiveNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                return this.specialization_.executeDynamicObject(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="malloc(DynamicObject, long)", value=PointerPrimitiveNodes.PointerMallocPrimitiveNode.class)
            private static final class Malloc1Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Malloc1Node_(PointerMallocPrimitiveNodeGen root, Object arguments1Value) {
                    super(root, 2);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Malloc1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDynamicObject(frameValue);
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    long arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeDynamicObject_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Long.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                        } else if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = RubyTypes.promoteToLong(this.root.arguments1_.executeInteger(frameValue));
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitLong(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.malloc(arguments0Value_, arguments1Value_);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.malloc(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PointerMallocPrimitiveNodeGen root, Object arguments1Value) {
                    return new Malloc1Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="malloc(DynamicObject, int)", value=PointerPrimitiveNodes.PointerMallocPrimitiveNode.class)
            private static final class Malloc0Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Malloc0Node_(PointerMallocPrimitiveNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Malloc0Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDynamicObject(frameValue);
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeDynamicObject_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.malloc(arguments0Value_, arguments1Value_);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        return this.root.malloc(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PointerMallocPrimitiveNodeGen root, Object arguments1Value) {
                    return new Malloc0Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=PointerPrimitiveNodes.PointerMallocPrimitiveNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(PointerMallocPrimitiveNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PointerMallocPrimitiveNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=PointerPrimitiveNodes.PointerMallocPrimitiveNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(PointerMallocPrimitiveNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PointerMallocPrimitiveNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=PointerPrimitiveNodes.PointerMallocPrimitiveNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected PointerMallocPrimitiveNodeGen root;

                BaseNode_(PointerMallocPrimitiveNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (PointerMallocPrimitiveNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    return (DynamicObject)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        if (RubyTypesGen.isImplicitInteger(arguments1Value)) {
                            return Malloc0Node_.create(this.root, arguments1Value);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Malloc1Node_.create(this.root, arguments1Value);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=PointerPrimitiveNodes.PointerAllocatePrimitiveNode.class)
    public static final class PointerAllocatePrimitiveNodeFactory
    extends NodeFactoryBase<PointerPrimitiveNodes.PointerAllocatePrimitiveNode> {
        private static PointerAllocatePrimitiveNodeFactory pointerAllocatePrimitiveNodeFactoryInstance;

        private PointerAllocatePrimitiveNodeFactory() {
            super(PointerPrimitiveNodes.PointerAllocatePrimitiveNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public PointerPrimitiveNodes.PointerAllocatePrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PointerAllocatePrimitiveNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<PointerPrimitiveNodes.PointerAllocatePrimitiveNode> getInstance() {
            if (pointerAllocatePrimitiveNodeFactoryInstance == null) {
                pointerAllocatePrimitiveNodeFactoryInstance = new PointerAllocatePrimitiveNodeFactory();
            }
            return pointerAllocatePrimitiveNodeFactoryInstance;
        }

        public static PointerPrimitiveNodes.PointerAllocatePrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new PointerAllocatePrimitiveNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=PointerPrimitiveNodes.PointerAllocatePrimitiveNode.class)
        public static final class PointerAllocatePrimitiveNodeGen
        extends PointerPrimitiveNodes.PointerAllocatePrimitiveNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private PointerAllocatePrimitiveNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.allocate(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }
}

