/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.yield;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.language.methods.DeclarationContext;
import org.jruby.truffle.language.yield.CallBlockNode;
import org.jruby.truffle.language.yield.CallBlockNodeGen;

public class YieldNode
extends Node {
    private final RubyContext context;
    private final DeclarationContext declarationContext;
    @Node.Child
    private CallBlockNode callBlockNode;

    public YieldNode(RubyContext context) {
        this(context, DeclarationContext.BLOCK);
    }

    public YieldNode(RubyContext context, DeclarationContext declarationContext) {
        this.context = context;
        this.declarationContext = declarationContext;
    }

    public Object dispatch(VirtualFrame frame, DynamicObject block, Object ... argumentsObjects) {
        return this.getCallBlockNode().executeCallBlock(frame, block, Layouts.PROC.getSelf(block), Layouts.PROC.getBlock(block), argumentsObjects);
    }

    public Object dispatchWithModifiedBlock(VirtualFrame frame, DynamicObject block, DynamicObject modifiedBlock, Object ... argumentsObjects) {
        return this.getCallBlockNode().executeCallBlock(frame, block, Layouts.PROC.getSelf(block), modifiedBlock, argumentsObjects);
    }

    public Object dispatchWithModifiedSelf(VirtualFrame currentFrame, DynamicObject block, Object self, Object ... argumentsObjects) {
        return this.getCallBlockNode().executeCallBlock(currentFrame, block, self, Layouts.PROC.getBlock(block), argumentsObjects);
    }

    private CallBlockNode getCallBlockNode() {
        if (this.callBlockNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.callBlockNode = this.insert(CallBlockNodeGen.create(this.context, null, this.declarationContext, null, null, null, null));
        }
        return this.callBlockNode;
    }
}

