/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.stdlib;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.math.BigDecimal;
import java.util.EnumSet;
import org.jruby.truffle.core.basicobject.BasicObjectLayoutImpl;
import org.jruby.truffle.stdlib.BigDecimalLayout;
import org.jruby.truffle.stdlib.BigDecimalNodes;

@GeneratedBy(value=BigDecimalLayout.class)
public class BigDecimalLayoutImpl
extends BasicObjectLayoutImpl
implements BigDecimalLayout {
    public static final BigDecimalLayout INSTANCE = new BigDecimalLayoutImpl();
    protected static final Shape.Allocator BIG_DECIMAL_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey VALUE_IDENTIFIER = new HiddenKey("value");
    protected static final Property VALUE_PROPERTY = Property.create(VALUE_IDENTIFIER, BIG_DECIMAL_ALLOCATOR.locationForType(BigDecimal.class, EnumSet.of(LocationModifier.NonNull)), 0);
    protected static final HiddenKey TYPE_IDENTIFIER = new HiddenKey("type");
    protected static final Property TYPE_PROPERTY = Property.create(TYPE_IDENTIFIER, BIG_DECIMAL_ALLOCATOR.locationForType(BigDecimalNodes.Type.class, EnumSet.of(LocationModifier.NonNull)), 0);

    protected BigDecimalLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createBigDecimalShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new BigDecimalType(logicalClass, metaClass)).addProperty(VALUE_PROPERTY).addProperty(TYPE_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createBigDecimal(DynamicObjectFactory factory, BigDecimal value, BigDecimalNodes.Type type) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (BigDecimalLayoutImpl.createsBigDecimal(factory));
        assert (factory.getShape().hasProperty(VALUE_IDENTIFIER));
        assert (factory.getShape().hasProperty(TYPE_IDENTIFIER));
        assert (value != null);
        assert (type != null);
        return factory.newInstance(new Object[]{value, type});
    }

    @Override
    public boolean isBigDecimal(DynamicObject object) {
        return BigDecimalLayoutImpl.isBigDecimal(object.getShape().getObjectType());
    }

    private static boolean isBigDecimal(ObjectType objectType) {
        return objectType instanceof BigDecimalType;
    }

    private static boolean createsBigDecimal(DynamicObjectFactory factory) {
        return BigDecimalLayoutImpl.isBigDecimal(factory.getShape().getObjectType());
    }

    @Override
    public BigDecimal getValue(DynamicObject object) {
        assert (this.isBigDecimal(object));
        assert (object.getShape().hasProperty(VALUE_IDENTIFIER));
        return (BigDecimal)VALUE_PROPERTY.get(object, this.isBigDecimal(object));
    }

    @Override
    public void setValue(DynamicObject object, BigDecimal value) {
        assert (this.isBigDecimal(object));
        assert (object.getShape().hasProperty(VALUE_IDENTIFIER));
        assert (value != null);
        try {
            VALUE_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public BigDecimalNodes.Type getType(DynamicObject object) {
        assert (this.isBigDecimal(object));
        assert (object.getShape().hasProperty(TYPE_IDENTIFIER));
        return (BigDecimalNodes.Type)((Object)TYPE_PROPERTY.get(object, this.isBigDecimal(object)));
    }

    @Override
    public void setType(DynamicObject object, BigDecimalNodes.Type value) {
        assert (this.isBigDecimal(object));
        assert (object.getShape().hasProperty(TYPE_IDENTIFIER));
        assert (value != null);
        try {
            TYPE_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static class BigDecimalType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public BigDecimalType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public BigDecimalType setLogicalClass(DynamicObject logicalClass) {
            return new BigDecimalType(logicalClass, this.metaClass);
        }

        @Override
        public BigDecimalType setMetaClass(DynamicObject metaClass) {
            return new BigDecimalType(this.logicalClass, metaClass);
        }
    }
}

