/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.scope;

import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.OneVarDynamicScope;

public class TwoVarDynamicScope
extends OneVarDynamicScope {
    private static final int SIZE = 2;
    private static final String SIZE_ERROR = "TwoVarDynamicScope only supports scopes with two variables";
    private static final String GROW_ERROR = "TwoVarDynamicScope cannot be grown; use ManyVarsDynamicScope";
    protected IRubyObject variableValueOne;

    public TwoVarDynamicScope(StaticScope staticScope, DynamicScope parent) {
        super(staticScope, parent);
    }

    public TwoVarDynamicScope(StaticScope staticScope) {
        super(staticScope);
    }

    @Override
    public void growIfNeeded() {
        this.growIfNeeded(2, GROW_ERROR);
    }

    @Override
    public DynamicScope cloneScope() {
        return new TwoVarDynamicScope(this.staticScope, this.parent);
    }

    @Override
    public IRubyObject[] getValues() {
        return new IRubyObject[]{this.variableValueZero, this.variableValueOne};
    }

    @Override
    public IRubyObject getValue(int offset2, int depth) {
        if (depth > 0) {
            return this.parent.getValue(offset2, depth - 1);
        }
        assert (offset2 < 2) : "TwoVarDynamicScope only supports scopes with two variables";
        switch (offset2) {
            case 0: {
                return this.variableValueZero;
            }
            case 1: {
                return this.variableValueOne;
            }
        }
        throw new RuntimeException(SIZE_ERROR);
    }

    @Override
    public IRubyObject getValueDepthZeroOrNil(int offset2, IRubyObject nil) {
        assert (offset2 < 2) : "TwoVarDynamicScope only supports scopes with two variables";
        switch (offset2) {
            case 0: {
                if (this.variableValueZero == null) {
                    this.variableValueZero = nil;
                    return this.variableValueZero;
                }
                return this.variableValueZero;
            }
            case 1: {
                if (this.variableValueOne == null) {
                    this.variableValueOne = nil;
                    return this.variableValueOne;
                }
                return this.variableValueOne;
            }
        }
        throw new RuntimeException(SIZE_ERROR);
    }

    @Override
    public IRubyObject getValueOneDepthZeroOrNil(IRubyObject nil) {
        if (this.variableValueOne == null) {
            this.variableValueOne = nil;
            return this.variableValueOne;
        }
        return this.variableValueOne;
    }

    @Override
    public IRubyObject setValue(int offset2, IRubyObject value2, int depth) {
        if (depth > 0) {
            assert (this.parent != null) : "If depth > 0, then parent should not ever be null";
            return this.parent.setValue(offset2, value2, depth - 1);
        }
        assert (offset2 < 2) : "TwoVarDynamicScope only supports scopes with two variables";
        switch (offset2) {
            case 0: {
                this.variableValueZero = value2;
                return this.variableValueZero;
            }
            case 1: {
                this.variableValueOne = value2;
                return this.variableValueOne;
            }
        }
        throw new RuntimeException(SIZE_ERROR);
    }

    @Override
    public IRubyObject setValueDepthZero(IRubyObject value2, int offset2) {
        assert (offset2 < 2) : "TwoVarDynamicScope only supports scopes with two variables";
        switch (offset2) {
            case 0: {
                this.variableValueZero = value2;
                return this.variableValueZero;
            }
            case 1: {
                this.variableValueOne = value2;
                return this.variableValueOne;
            }
        }
        throw new RuntimeException(SIZE_ERROR);
    }

    @Override
    public IRubyObject setValueOneDepthZero(IRubyObject value2) {
        this.variableValueOne = value2;
        return this.variableValueOne;
    }
}

