/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.io;

import java.util.Arrays;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.ComboBox;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.ModuleOwned;
import org.pdfsam.support.RequireUtils;
import org.pdfsam.ui.io.AddPdfVersionConstraintEvent;
import org.pdfsam.ui.io.ChangedSelectedPdfVersionEvent;
import org.pdfsam.ui.io.PdfVersionFilter;
import org.pdfsam.ui.io.RemovePdfVersionConstraintEvent;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;
import org.sejda.eventstudio.annotation.EventStation;
import org.sejda.model.pdf.PdfVersion;

class PdfVersionCombo
extends ComboBox<PdfVersionComboItem>
implements ModuleOwned {
    private String ownerModule = "";
    private ObservableList<PdfVersionComboItem> unfilteredItems = FXCollections.observableArrayList();
    private PdfVersionFilter versionsFilter = new PdfVersionFilter();
    private SameAsSourceComboItem sameAsSource = new SameAsSourceComboItem();

    public PdfVersionCombo(String ownerModule) {
        this.ownerModule = ownerModule;
        Arrays.stream(PdfVersion.values()).filter(v -> v.getVersion() > PdfVersion.VERSION_1_2.getVersion()).map(DefaultPdfVersionComboItem::new).forEach(arg_0 -> this.unfilteredItems.add(arg_0));
        this.versionsFilter.requiredProperty().addListener((observable, oldVal, newVal) -> {
            PdfVersionComboItem selected = (PdfVersionComboItem)this.getSelectionModel().getSelectedItem();
            this.setItems((ObservableList)this.unfilteredItems.filtered(t -> t.isHigherOrEqual((PdfVersion)newVal)));
            int selecedIndex = this.getItems().indexOf((Object)selected);
            if (selecedIndex != -1) {
                this.getSelectionModel().select(selecedIndex);
            } else {
                this.getSelectionModel().selectFirst();
            }
        });
        this.initializeState();
        StaticStudio.eventStudio().addAnnotatedListeners(this);
    }

    @EventListener
    public void onAddPdfVersionConstraint(AddPdfVersionConstraintEvent event) {
        this.versionsFilter.addFilter(event.getPdfVersion());
    }

    @EventListener
    public void onRemovePdfVersionConstraint(RemovePdfVersionConstraintEvent event) {
        this.versionsFilter.removeFilter(event.getPdfVersion());
    }

    @EventListener
    public void onChangedSelectedPdfVersion(ChangedSelectedPdfVersionEvent event) {
        this.sameAsSource.setVersion(event.getPdfVersion());
    }

    @Override
    @EventStation
    public String getOwnerModule() {
        return this.ownerModule;
    }

    void initializeState() {
        this.versionsFilter.reset();
        this.versionsFilter.addFilter(PdfVersion.VERSION_1_2);
    }

    public void enableSameAsSourceItem() {
        this.unfilteredItems.add(0, (Object)this.sameAsSource);
        this.getSelectionModel().selectFirst();
    }

    private static class SameAsSourceComboItem
    implements PdfVersionComboItem {
        private PdfVersion version = PdfVersion.VERSION_1_5;

        private SameAsSourceComboItem() {
        }

        void setVersion(PdfVersion version) {
            this.version = version;
        }

        @Override
        public PdfVersion getVersion() {
            return this.version;
        }

        @Override
        public boolean isHigherOrEqual(PdfVersion other) {
            return this.version.getVersion() >= other.getVersion();
        }

        public String toString() {
            return DefaultI18nContext.getInstance().i18n("Same as the input document");
        }
    }

    static class DefaultPdfVersionComboItem
    implements PdfVersionComboItem {
        private PdfVersion version;

        public DefaultPdfVersionComboItem(PdfVersion version) {
            RequireUtils.requireNotNull(version, "PDF version cannot be null");
            this.version = version;
        }

        @Override
        public PdfVersion getVersion() {
            return this.version;
        }

        @Override
        public boolean isHigherOrEqual(PdfVersion version) {
            return this.version.getVersion() >= version.getVersion();
        }

        public String toString() {
            return DefaultI18nContext.getInstance().i18n("Version {0}", this.version.getVersionString());
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.version).toHashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DefaultPdfVersionComboItem)) {
                return false;
            }
            DefaultPdfVersionComboItem otherItem = (DefaultPdfVersionComboItem)other;
            return new EqualsBuilder().append(this.version, otherItem.version).isEquals();
        }
    }

    public static interface PdfVersionComboItem {
        public PdfVersion getVersion();

        public boolean isHigherOrEqual(PdfVersion var1);
    }
}

