/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.Closeable;
import java.io.File;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Queue;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.sejda.common.ComponentsUtility;
import org.sejda.common.LookupTable;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.SingleOutputWriter;
import org.sejda.core.support.io.model.FileOutput;
import org.sejda.impl.sambox.component.AcroFormsMerger;
import org.sejda.impl.sambox.component.Annotations;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.FilenameFooterWriter;
import org.sejda.impl.sambox.component.OutlineMerger;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.SignatureClipper;
import org.sejda.impl.sambox.component.TableOfContentsCreator;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfMergeInput;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.parameter.MergeParameters;
import org.sejda.model.task.BaseTask;
import org.sejda.model.toc.ToCPolicy;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSInteger;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotation;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.PDPageFitWidthDestination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeTask
extends BaseTask<MergeParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(MergeTask.class);
    private SingleOutputWriter outputWriter;
    private PdfSourceOpener<PDDocumentHandler> sourceOpener;
    private int totalSteps;
    private PDDocumentHandler destinationDocument;
    private Queue<Closeable> toClose = new LinkedList<Closeable>();
    private OutlineMerger outlineMerger;
    private AcroFormsMerger acroFormsMerger;
    private TableOfContentsCreator tocCreator;
    private FilenameFooterWriter footerWriter;
    private PDRectangle currentPageSize = PDRectangle.A4;
    private long pagesCounter = 0L;

    @Override
    public void before(MergeParameters parameters) {
        this.totalSteps = parameters.getInputList().size();
        this.sourceOpener = new DefaultPdfSourceOpener();
        this.outputWriter = OutputWriters.newSingleOutputWriter(parameters.getExistingOutputPolicy());
        this.outlineMerger = new OutlineMerger(parameters.getOutlinePolicy());
    }

    @Override
    public void execute(MergeParameters parameters) throws TaskException {
        int currentStep = 0;
        File tmpFile = IOUtils.createTemporaryPdfBuffer();
        LOG.debug("Created output temporary buffer {} ", (Object)tmpFile);
        this.destinationDocument = new PDDocumentHandler();
        this.destinationDocument.setCreatorOnPDDocument();
        this.destinationDocument.setVersionOnPDDocument(parameters.getVersion());
        this.destinationDocument.setCompress(parameters.isCompress());
        this.acroFormsMerger = new AcroFormsMerger(parameters.getAcroFormPolicy(), this.destinationDocument.getUnderlyingPDDocument());
        this.tocCreator = new TableOfContentsCreator(parameters.getTableOfContentsPolicy(), this.destinationDocument.getUnderlyingPDDocument());
        this.footerWriter = new FilenameFooterWriter(parameters.isFilenameFooter(), this.destinationDocument.getUnderlyingPDDocument());
        for (PdfMergeInput input : parameters.getInputList()) {
            LOG.debug("Opening {}", (Object)input.getSource());
            PDDocumentHandler sourceDocumentHandler = input.getSource().open(this.sourceOpener);
            this.toClose.add(sourceDocumentHandler);
            LOG.debug("Adding pages");
            LookupTable<PDPage> pagesLookup = new LookupTable<PDPage>();
            long relativeCounter = 0L;
            for (Integer currentPage : input.getPages(sourceDocumentHandler.getNumberOfPages())) {
                this.stopTaskIfCancelled();
                ++this.pagesCounter;
                ++relativeCounter;
                PDPage page = sourceDocumentHandler.getPage(currentPage);
                this.currentPageSize = page.getMediaBox().rotate(page.getRotation());
                PDPage importedPage = this.destinationDocument.importPage(page);
                pagesLookup.addLookupEntry(page, importedPage);
                String sourceBaseName = FilenameUtils.getBaseName(input.getSource().getName());
                if (this.tocCreator.shouldGenerateToC() && relativeCounter == 1L) {
                    this.tocCreator.pageSizeIfNotSet(this.currentPageSize);
                    if (ToCPolicy.DOC_TITLES == parameters.getTableOfContentsPolicy()) {
                        sourceBaseName = Optional.ofNullable(sourceDocumentHandler.getUnderlyingPDDocument().getDocumentInformation()).map(i -> i.getTitle()).filter(StringUtils::isNotBlank).orElse(sourceBaseName);
                    }
                    this.tocCreator.appendItem(sourceBaseName, this.pagesCounter, this.linkAnnotationFor(importedPage));
                }
                this.footerWriter.addFooter(importedPage, sourceBaseName, this.pagesCounter);
                LOG.trace("Added imported page");
            }
            relativeCounter = 0L;
            this.outlineMerger.updateOutline(sourceDocumentHandler.getUnderlyingPDDocument(), input.getSource().getName(), pagesLookup);
            LookupTable<PDAnnotation> annotationsLookup = Annotations.processAnnotations(pagesLookup, sourceDocumentHandler.getUnderlyingPDDocument());
            SignatureClipper.clipSignatures(annotationsLookup.values());
            this.acroFormsMerger.mergeForm(sourceDocumentHandler.getUnderlyingPDDocument().getDocumentCatalog().getAcroForm(), annotationsLookup);
            if (parameters.isBlankPageIfOdd()) {
                this.destinationDocument.addBlankPageIfOdd(this.currentPageSize);
            }
            ApplicationEventsNotifier.notifyEvent(this.getNotifiableTaskMetadata()).stepsCompleted(++currentStep).outOf(this.totalSteps);
        }
        if (this.outlineMerger.hasOutline()) {
            LOG.debug("Adding generated outline");
            this.destinationDocument.setDocumentOutline(this.outlineMerger.getOutline());
        }
        if (this.acroFormsMerger.hasForm()) {
            LOG.debug("Adding generated AcroForm");
            this.destinationDocument.setDocumentAcroForm(this.acroFormsMerger.getForm());
        }
        if (this.tocCreator.hasToc()) {
            LOG.debug("Adding generated ToC");
            this.tocCreator.addToC();
        }
        this.destinationDocument.savePDDocument(tmpFile);
        this.closeResources();
        this.outputWriter.setOutput(FileOutput.file(tmpFile).name(parameters.getOutputName()));
        parameters.getOutput().accept(this.outputWriter);
        LOG.debug("Input documents merged correctly and written to {}", (Object)parameters.getOutput());
    }

    private PDAnnotationLink linkAnnotationFor(PDPage importedPage) {
        PDPageFitWidthDestination pageDest = new PDPageFitWidthDestination();
        pageDest.setPage(importedPage);
        PDAnnotationLink link = new PDAnnotationLink();
        link.setDestination(pageDest);
        link.setBorder(new COSArray(COSInteger.ZERO, COSInteger.ZERO, COSInteger.ZERO));
        return link;
    }

    private void closeResources() {
        Closeable current;
        while ((current = this.toClose.poll()) != null) {
            ComponentsUtility.nullSafeCloseQuietly(current);
        }
        ComponentsUtility.nullSafeCloseQuietly(this.destinationDocument);
    }

    @Override
    public void after() {
        this.closeResources();
        this.outputWriter = null;
    }
}

