/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.ldap;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.ldap.Rdn;
import javax.naming.ldap.Rfc2253Parser;

public class LdapName
implements Name {
    private transient ArrayList rdns;
    private transient String unparsed;
    private static final long serialVersionUID = -1595520034788997356L;

    public LdapName(String name) throws InvalidNameException {
        this.unparsed = name;
        this.parse();
    }

    public LdapName(List<Rdn> rdns) {
        this.rdns = new ArrayList(rdns.size());
        for (int i = 0; i < rdns.size(); ++i) {
            Rdn obj = rdns.get(i);
            if (!(obj instanceof Rdn)) {
                throw new IllegalArgumentException("Entry:" + obj + "  not a valid type;list entries must be of type Rdn");
            }
            this.rdns.add(obj);
        }
    }

    private LdapName(String name, ArrayList rdns, int beg, int end) {
        this.unparsed = name;
        List sList = rdns.subList(beg, end);
        this.rdns = new ArrayList(sList);
    }

    @Override
    public int size() {
        return this.rdns.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rdns.isEmpty();
    }

    @Override
    public Enumeration<String> getAll() {
        final Iterator iter = this.rdns.iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return iter.hasNext();
            }

            @Override
            public String nextElement() {
                return iter.next().toString();
            }
        };
    }

    @Override
    public String get(int posn) {
        return this.rdns.get(posn).toString();
    }

    public Rdn getRdn(int posn) {
        return (Rdn)this.rdns.get(posn);
    }

    @Override
    public Name getPrefix(int posn) {
        try {
            return new LdapName(null, this.rdns, 0, posn);
        }
        catch (IllegalArgumentException e) {
            throw new IndexOutOfBoundsException("Posn: " + posn + ", Size: " + this.rdns.size());
        }
    }

    @Override
    public Name getSuffix(int posn) {
        try {
            return new LdapName(null, this.rdns, posn, this.rdns.size());
        }
        catch (IllegalArgumentException e) {
            throw new IndexOutOfBoundsException("Posn: " + posn + ", Size: " + this.rdns.size());
        }
    }

    @Override
    public boolean startsWith(Name n) {
        int len2;
        if (n == null) {
            return false;
        }
        int len1 = this.rdns.size();
        return len1 >= (len2 = n.size()) && this.matches(0, len2, n);
    }

    public boolean startsWith(List<Rdn> rdns) {
        int len2;
        if (rdns == null) {
            return false;
        }
        int len1 = this.rdns.size();
        return len1 >= (len2 = rdns.size()) && this.doesListMatch(0, len2, rdns);
    }

    @Override
    public boolean endsWith(Name n) {
        int len2;
        if (n == null) {
            return false;
        }
        int len1 = this.rdns.size();
        return len1 >= (len2 = n.size()) && this.matches(len1 - len2, len1, n);
    }

    public boolean endsWith(List<Rdn> rdns) {
        int len2;
        if (rdns == null) {
            return false;
        }
        int len1 = this.rdns.size();
        return len1 >= (len2 = rdns.size()) && this.doesListMatch(len1 - len2, len1, rdns);
    }

    private boolean doesListMatch(int beg, int end, List rdns) {
        for (int i = beg; i < end; ++i) {
            if (this.rdns.get(i).equals(rdns.get(i - beg))) continue;
            return false;
        }
        return true;
    }

    private boolean matches(int beg, int end, Name n) {
        if (n instanceof LdapName) {
            LdapName ln = (LdapName)n;
            return this.doesListMatch(beg, end, ln.rdns);
        }
        for (int i = beg; i < end; ++i) {
            Rdn rdn;
            String rdnString = n.get(i - beg);
            try {
                rdn = new Rfc2253Parser(rdnString).parseRdn();
            }
            catch (InvalidNameException e) {
                return false;
            }
            if (rdn.equals(this.rdns.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Name addAll(Name suffix) throws InvalidNameException {
        return this.addAll(this.size(), suffix);
    }

    public Name addAll(List<Rdn> suffixRdns) {
        return this.addAll(this.size(), suffixRdns);
    }

    @Override
    public Name addAll(int posn, Name suffix) throws InvalidNameException {
        this.unparsed = null;
        if (suffix instanceof LdapName) {
            LdapName s = (LdapName)suffix;
            this.rdns.addAll(posn, s.rdns);
        } else {
            Enumeration<String> comps = suffix.getAll();
            while (comps.hasMoreElements()) {
                this.rdns.add(posn++, new Rfc2253Parser(comps.nextElement()).parseRdn());
            }
        }
        return this;
    }

    public Name addAll(int posn, List<Rdn> suffixRdns) {
        this.unparsed = null;
        for (int i = 0; i < suffixRdns.size(); ++i) {
            Rdn obj = suffixRdns.get(i);
            if (!(obj instanceof Rdn)) {
                throw new IllegalArgumentException("Entry:" + obj + "  not a valid type;suffix list entries must be of type Rdn");
            }
            this.rdns.add(i + posn, obj);
        }
        return this;
    }

    @Override
    public Name add(String comp) throws InvalidNameException {
        return this.add(this.size(), comp);
    }

    public Name add(Rdn comp) {
        return this.add(this.size(), comp);
    }

    @Override
    public Name add(int posn, String comp) throws InvalidNameException {
        Rdn rdn = new Rfc2253Parser(comp).parseRdn();
        this.rdns.add(posn, rdn);
        this.unparsed = null;
        return this;
    }

    public Name add(int posn, Rdn comp) {
        if (comp == null) {
            throw new NullPointerException("Cannot set comp to null");
        }
        this.rdns.add(posn, comp);
        this.unparsed = null;
        return this;
    }

    @Override
    public Object remove(int posn) throws InvalidNameException {
        this.unparsed = null;
        return this.rdns.remove(posn).toString();
    }

    public List<Rdn> getRdns() {
        return Collections.unmodifiableList(this.rdns);
    }

    @Override
    public Object clone() {
        return new LdapName(this.unparsed, this.rdns, 0, this.rdns.size());
    }

    public String toString() {
        if (this.unparsed != null) {
            return this.unparsed;
        }
        StringBuilder builder = new StringBuilder();
        int size = this.rdns.size();
        if (size - 1 >= 0) {
            builder.append((Rdn)this.rdns.get(size - 1));
        }
        for (int next = size - 2; next >= 0; --next) {
            builder.append(',');
            builder.append((Rdn)this.rdns.get(next));
        }
        this.unparsed = builder.toString();
        return this.unparsed;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LdapName)) {
            return false;
        }
        LdapName that = (LdapName)obj;
        if (this.rdns.size() != that.rdns.size()) {
            return false;
        }
        if (this.unparsed != null && this.unparsed.equalsIgnoreCase(that.unparsed)) {
            return true;
        }
        for (int i = 0; i < this.rdns.size(); ++i) {
            Rdn rdn2;
            Rdn rdn1 = (Rdn)this.rdns.get(i);
            if (rdn1.equals(rdn2 = (Rdn)that.rdns.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(Object obj) {
        if (!(obj instanceof LdapName)) {
            throw new ClassCastException("The obj is not a LdapName");
        }
        if (obj == this) {
            return 0;
        }
        LdapName that = (LdapName)obj;
        if (this.unparsed != null && this.unparsed.equalsIgnoreCase(that.unparsed)) {
            return 0;
        }
        int minSize = Math.min(this.rdns.size(), that.rdns.size());
        for (int i = 0; i < minSize; ++i) {
            Rdn rdn2;
            Rdn rdn1 = (Rdn)this.rdns.get(i);
            int diff = rdn1.compareTo(rdn2 = (Rdn)that.rdns.get(i));
            if (diff == 0) continue;
            return diff;
        }
        return this.rdns.size() - that.rdns.size();
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.rdns.size(); ++i) {
            Rdn rdn = (Rdn)this.rdns.get(i);
            hash += rdn.hashCode();
        }
        return hash;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.toString());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.unparsed = (String)s.readObject();
        try {
            this.parse();
        }
        catch (InvalidNameException e) {
            throw new StreamCorruptedException("Invalid name: " + this.unparsed);
        }
    }

    private void parse() throws InvalidNameException {
        this.rdns = (ArrayList)new Rfc2253Parser(this.unparsed).parseDn();
    }
}

