/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Player;

public class FreeColXMLWriter
implements Closeable,
XMLStreamWriter {
    private static final Logger logger = Logger.getLogger(FreeColXMLWriter.class.getName());
    private static final String[] indentProps = new String[]{"indent", "yes", "{http://xml.apache.org/xslt}indent-amount", "2"};
    private final XMLStreamWriter xmlStreamWriter;
    private StringWriter stringWriter = null;
    private Writer outputWriter = null;
    private WriteScope writeScope;

    public FreeColXMLWriter(OutputStream outputStream, WriteScope scope, boolean indent) throws IOException {
        this(new OutputStreamWriter(outputStream, "UTF-8"), scope, indent);
    }

    public FreeColXMLWriter(Writer writer, WriteScope scope) throws IOException {
        this(writer, scope, false);
    }

    private FreeColXMLWriter(Writer writer, WriteScope scope, boolean indent) throws IOException {
        try {
            if (indent) {
                this.outputWriter = writer;
                this.stringWriter = new StringWriter(1024);
                this.xmlStreamWriter = this.getFactory().createXMLStreamWriter(this.stringWriter);
            } else {
                this.xmlStreamWriter = this.getFactory().createXMLStreamWriter(writer);
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        this.writeScope = scope;
    }

    private XMLOutputFactory getFactory() {
        return XMLOutputFactory.newInstance();
    }

    public WriteScope getWriteScope() {
        return this.writeScope;
    }

    public void setWriteScope(WriteScope writeScope) {
        this.writeScope = writeScope;
    }

    @Override
    public void close() {
        if (this.xmlStreamWriter != null) {
            try {
                this.xmlStreamWriter.close();
            }
            catch (XMLStreamException xse) {
                logger.log(Level.WARNING, "Error closing stream.", xse);
            }
        }
        if (this.outputWriter != null) {
            try {
                StreamSource source = new StreamSource(new StringReader(this.stringWriter.toString()));
                StreamResult result = new StreamResult(this.outputWriter);
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer transformer = factory.newTransformer();
                for (int i = 0; i < indentProps.length; i += 2) {
                    transformer.setOutputProperty(indentProps[i], indentProps[i + 1]);
                }
                transformer.transform(source, result);
            }
            catch (TransformerException te) {
                logger.log(Level.WARNING, "Transformer fail", te);
            }
            try {
                this.outputWriter.flush();
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "Flush fail", ioe);
            }
        }
    }

    public void writeAttribute(String attributeName, boolean value) throws XMLStreamException {
        this.xmlStreamWriter.writeAttribute(attributeName, String.valueOf(value));
    }

    public void writeAttribute(String attributeName, float value) throws XMLStreamException {
        this.xmlStreamWriter.writeAttribute(attributeName, String.valueOf(value));
    }

    public void writeAttribute(String attributeName, int value) throws XMLStreamException {
        this.xmlStreamWriter.writeAttribute(attributeName, String.valueOf(value));
    }

    public void writeAttribute(String attributeName, long value) throws XMLStreamException {
        this.xmlStreamWriter.writeAttribute(attributeName, String.valueOf(value));
    }

    public void writeAttribute(String attributeName, Enum<?> value) throws XMLStreamException {
        this.xmlStreamWriter.writeAttribute(attributeName, value.toString().toLowerCase(Locale.US));
    }

    public void writeAttribute(String attributeName, Object value) throws XMLStreamException {
        this.xmlStreamWriter.writeAttribute(attributeName, String.valueOf(value));
    }

    public void writeAttribute(String attributeName, FreeColObject value) throws XMLStreamException {
        if (value != null) {
            this.xmlStreamWriter.writeAttribute(attributeName, value.getId());
        }
    }

    public void writeLocationAttribute(String attributeName, Location value) throws XMLStreamException {
        this.writeAttribute(attributeName, (FreeColObject)((Object)value));
    }

    public <T extends FreeColObject> void writeToListElement(String tag, Collection<T> members) throws XMLStreamException {
        this.writeStartElement(tag);
        this.writeAttribute("xLength", members.size());
        int i = 0;
        for (FreeColObject t : members) {
            this.writeAttribute("x" + i, t);
            ++i;
        }
        this.writeEndElement();
    }

    public Player getClientPlayer() {
        return this.writeScope.getClient();
    }

    public boolean validForSave() {
        return this.writeScope.validForSave();
    }

    public boolean validFor(Player player) {
        return this.writeScope.validFor(player);
    }

    @Override
    public void flush() throws XMLStreamException {
        this.xmlStreamWriter.flush();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.xmlStreamWriter.getNamespaceContext();
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.xmlStreamWriter.getPrefix(uri);
    }

    @Override
    public Object getProperty(String name) {
        return this.xmlStreamWriter.getProperty(name);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.xmlStreamWriter.setDefaultNamespace(uri);
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.xmlStreamWriter.setNamespaceContext(context);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.xmlStreamWriter.setPrefix(prefix, uri);
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.xmlStreamWriter.writeAttribute(localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.xmlStreamWriter.writeAttribute(namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.xmlStreamWriter.writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.xmlStreamWriter.writeCData(data);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(text, start, len);
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(text);
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.xmlStreamWriter.writeComment(data);
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.xmlStreamWriter.writeDefaultNamespace(namespaceURI);
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.xmlStreamWriter.writeDTD(dtd);
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.xmlStreamWriter.writeEmptyElement(localName);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.xmlStreamWriter.writeEmptyElement(namespaceURI, localName);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.xmlStreamWriter.writeEmptyElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.xmlStreamWriter.writeEndDocument();
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.xmlStreamWriter.writeEndElement();
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.xmlStreamWriter.writeEntityRef(name);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.xmlStreamWriter.writeNamespace(prefix, namespaceURI);
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.xmlStreamWriter.writeProcessingInstruction(target);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.xmlStreamWriter.writeProcessingInstruction(target, data);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.xmlStreamWriter.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.xmlStreamWriter.writeStartDocument(version);
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.xmlStreamWriter.writeStartDocument(encoding, version);
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.xmlStreamWriter.writeStartElement(localName);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.xmlStreamWriter.writeStartElement(namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.xmlStreamWriter.writeStartElement(prefix, localName, namespaceURI);
    }

    public static enum WriteScope {
        CLIENT,
        SERVER,
        SAVE;

        private Player player = null;

        public static WriteScope toClient(Player player) {
            if (player == null) {
                throw new IllegalArgumentException("Null player.");
            }
            WriteScope ret = CLIENT;
            ret.player = player;
            return ret;
        }

        public static WriteScope toServer() {
            return SERVER;
        }

        public static WriteScope toSave() {
            return SAVE;
        }

        public boolean isValid() {
            return this == CLIENT == (this.player != null);
        }

        public boolean validForSave() {
            return this == SAVE;
        }

        public boolean validFor(Player player) {
            return this != CLIENT || this.player == player;
        }

        public Player getClient() {
            return this.player;
        }
    }
}

