/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.kernel.KernelNodes;
import org.jruby.truffle.core.kernel.KernelNodesFactory;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;

@NodeChild(type=RubyNode.class)
public abstract class ToSNode
extends RubyNode {
    @Node.Child
    private CallDispatchHeadNode callToSNode;
    @Node.Child
    private KernelNodes.ToSNode kernelToSNode;

    public ToSNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.callToSNode = DispatchHeadNodeFactory.createMethodCall(context, true);
    }

    protected DynamicObject kernelToS(VirtualFrame frame, Object object) {
        if (this.kernelToSNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.kernelToSNode = this.insert(KernelNodesFactory.ToSNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null}));
        }
        return this.kernelToSNode.executeToS(frame, object);
    }

    @Specialization(guards={"isRubyString(string)"})
    public DynamicObject toS(DynamicObject string) {
        return string;
    }

    @Specialization(guards={"!isRubyString(object)"}, rewriteOn={UnexpectedResultException.class})
    public DynamicObject toS(VirtualFrame frame, Object object) throws UnexpectedResultException {
        Object value = this.callToSNode.call(frame, object, "to_s", null, new Object[0]);
        if (RubyGuards.isRubyString(value)) {
            return (DynamicObject)value;
        }
        throw new UnexpectedResultException(value);
    }

    @Specialization(guards={"!isRubyString(object)"})
    public DynamicObject toSFallback(VirtualFrame frame, Object object) {
        Object value = this.callToSNode.call(frame, object, "to_s", null, new Object[0]);
        if (RubyGuards.isRubyString(value)) {
            return (DynamicObject)value;
        }
        return this.kernelToS(frame, object);
    }
}

