/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.regexp;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.Ruby;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.regexp.RegexpNodes;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.parser.jruby.BodyTranslator;
import org.jruby.util.ByteList;
import org.jruby.util.RegexpOptions;

public class InterpolatedRegexpNode
extends RubyNode {
    @Node.Children
    private final RubyNode[] children;
    private final RegexpOptions options;
    @Node.Child
    private CallDispatchHeadNode toS;

    public InterpolatedRegexpNode(RubyContext context, SourceSection sourceSection, RubyNode[] children, RegexpOptions options) {
        super(context, sourceSection);
        this.children = children;
        this.options = options;
        this.toS = DispatchHeadNodeFactory.createMethodCall(context);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        CompilerDirectives.transferToInterpreter();
        RubyString[] strings = new RubyString[this.children.length];
        for (int n = 0; n < this.children.length; ++n) {
            Object child = this.children[n].execute(frame);
            strings[n] = RubyString.newString((Ruby)this.getContext().getJRubyRuntime(), (ByteList)StringOperations.getByteListReadOnly((DynamicObject)this.toS.call(frame, child, "to_s", null, new Object[0])));
        }
        RubyString preprocessed = RubyRegexp.preprocessDRegexp((Ruby)this.getContext().getJRubyRuntime(), (IRubyObject[])strings, (RegexpOptions)this.options);
        DynamicObject regexp = RegexpNodes.createRubyRegexp(this.getContext(), this, this.coreLibrary().getRegexpClass(), StringOperations.ropeFromByteList(preprocessed.getByteList()), this.options);
        if (this.options.isEncodingNone()) {
            Rope source = Layouts.REGEXP.getSource(regexp);
            if (!BodyTranslator.all7Bit(preprocessed.getByteList().bytes())) {
                Layouts.REGEXP.setSource(regexp, RopeOperations.withEncodingVerySlow(source, this.getContext().getJRubyRuntime().getEncodingService().getAscii8bitEncoding()));
            } else {
                Layouts.REGEXP.setSource(regexp, RopeOperations.withEncodingVerySlow(source, this.getContext().getJRubyRuntime().getEncodingService().getUSAsciiEncoding()));
            }
        }
        return regexp;
    }
}

