/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.RubyThread;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.rubinius.RubiniusPrimitive;
import org.jruby.truffle.core.rubinius.RubiniusPrimitiveArrayArgumentsNode;
import org.jruby.truffle.language.SafepointAction;
import org.jruby.truffle.language.backtrace.Backtrace;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.platform.UnsafeGroup;

public class ThreadPrimitiveNodes {

    @RubiniusPrimitive(name="thread_set_priority", unsafe={UnsafeGroup.THREADS})
    public static abstract class ThreadSetPriorityPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        public ThreadSetPriorityPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyThread(thread)"})
        public int getPriority(DynamicObject thread, int rubyPriority) {
            if (rubyPriority < -3) {
                rubyPriority = -3;
            } else if (rubyPriority > 3) {
                rubyPriority = 3;
            }
            int javaPriority = RubyThread.rubyPriorityToJavaPriority((int)rubyPriority);
            Thread javaThread = Layouts.THREAD.getThread(thread);
            if (javaThread != null) {
                javaThread.setPriority(javaPriority);
            }
            Layouts.THREAD.setPriority(thread, rubyPriority);
            return rubyPriority;
        }
    }

    @RubiniusPrimitive(name="thread_get_priority", unsafe={UnsafeGroup.THREADS})
    public static abstract class ThreadGetPriorityPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        public ThreadGetPriorityPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyThread(thread)"})
        public int getPriority(DynamicObject thread) {
            Thread javaThread = Layouts.THREAD.getThread(thread);
            if (javaThread != null) {
                int javaPriority = javaThread.getPriority();
                return RubyThread.javaPriorityToRubyPriority((int)javaPriority);
            }
            return Layouts.THREAD.getPriority(thread);
        }
    }

    @RubiniusPrimitive(name="thread_raise", unsafe={UnsafeGroup.THREADS})
    public static abstract class ThreadRaisePrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization(guards={"isRubyThread(thread)", "isRubyException(exception)"})
        public DynamicObject raise(DynamicObject thread, DynamicObject exception) {
            ThreadRaisePrimitiveNode.raiseInThread(this.getContext(), thread, exception, this);
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        public static void raiseInThread(final RubyContext context, DynamicObject rubyThread, final DynamicObject exception, Node currentNode) {
            Thread javaThread = Layouts.FIBER.getThread(Layouts.THREAD.getFiberManager(rubyThread).getCurrentFiber());
            context.getSafepointManager().pauseThreadAndExecuteLater(javaThread, currentNode, new SafepointAction(){

                @Override
                public void run(DynamicObject currentThread, Node currentNode) {
                    if (Layouts.EXCEPTION.getBacktrace(exception) == null) {
                        Backtrace backtrace = context.getCallStack().getBacktrace(currentNode);
                        Layouts.EXCEPTION.setBacktrace(exception, backtrace);
                    }
                    throw new RaiseException(exception);
                }
            });
        }
    }
}

