/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.old.element;

import com.baselet.control.HandlerElementMap;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.util.Utils;
import com.baselet.element.old.OldGridElement;
import com.baselet.element.sticking.StickingPolygon;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.util.Vector;

public class Taxonomy_of_Actors
extends OldGridElement {
    @Override
    public void paintEntity(Graphics g) {
        float zoom = HandlerElementMap.getHandlerForElement(this).getZoomFactor();
        Graphics2D g2 = (Graphics2D)g;
        g2.setFont(HandlerElementMap.getHandlerForElement(this).getFontHandler().getFont());
        Composite[] composites = this.colorize(g2);
        g2.setColor(this.fgColor);
        g2.setComposite(composites[1]);
        g2.setColor(this.bgColor);
        g2.fillRect(0, 0, this.getRectangle().width - 1, this.getRectangle().height - 1);
        g2.setComposite(composites[0]);
        if (HandlerElementMap.getHandlerForElement(this).getDrawPanel().getSelector().isSelected(this)) {
            g2.setColor(this.fgColor);
        } else {
            g2.setColor(this.fgColorBase);
        }
        g2.drawRect(0, 0, this.getRectangle().width - 1, this.getRectangle().height - 1);
        Vector<String> tmp = Utils.decomposeStrings(this.getPanelAttributes());
        int level = 0;
        float yPos = 10.0f * zoom;
        float xPos = 10.0f * zoom;
        float actorHeight = 60.0f * zoom;
        float actorWidth = 14.0f * zoom;
        Vector<Point> dock = new Vector<Point>();
        Point nextDock = new Point((int)((double)(xPos + actorWidth / 2.0f) + 0.5), (int)((double)(actorHeight + yPos) + 0.5));
        dock.add(nextDock);
        for (int i = 0; i < tmp.size(); ++i) {
            String s = tmp.elementAt(i);
            int currentLineLevel = this.calculateLevel(s);
            s = s.replaceAll("\t", "");
            if (currentLineLevel > level && i > 0) {
                nextDock = new Point((int)((double)(xPos + actorWidth / 2.0f) + 0.5), (int)((double)(actorHeight + yPos) + 0.5));
                dock.add(nextDock);
                nextDock = (Point)dock.elementAt(++level - 1);
                this.drawDockAnchor(g2, nextDock);
            }
            if (currentLineLevel < level) {
                level = currentLineLevel;
            }
            xPos = 10.0f * zoom + 4.0f * actorWidth * (float)level;
            this.drawActor(g2, xPos, yPos, s);
            if (level > 0) {
                Color color = g2.getColor();
                if (currentLineLevel > level) {
                    g2.setColor(Color.red);
                }
                nextDock = (Point)dock.elementAt(level - 1);
                this.drawDock(g2, nextDock, xPos, yPos);
                g2.setColor(color);
            }
            nextDock = new Point((int)((double)(xPos + actorWidth / 2.0f) + 0.5), (int)((double)(actorHeight + yPos) + 0.5));
            dock.set(level, nextDock);
            yPos += actorHeight;
        }
    }

    @Override
    public StickingPolygon generateStickingBorder() {
        StickingPolygon p = new StickingPolygon(0, 0);
        return p;
    }

    private void drawDock(Graphics2D g2, Point nextDock, float xPos, float yPos) {
        float zoom = HandlerElementMap.getHandlerForElement(this).getZoomFactor();
        float dockHeight = 50.0f * zoom;
        g2.drawLine(nextDock.x, nextDock.y, nextDock.x, (int)((double)(dockHeight / 2.0f + yPos) + 0.5));
        g2.drawLine(nextDock.x, (int)((double)(dockHeight / 2.0f + yPos) + 0.5), (int)((double)(xPos - 4.0f * zoom) + 0.5), (int)((double)(dockHeight / 2.0f + yPos) + 0.5));
    }

    private void drawActor(Graphics2D g2, float xPos, float yPos, String name) {
        float zoom = HandlerElementMap.getHandlerForElement(this).getZoomFactor();
        float head = 14.0f * zoom;
        float distance = 10.0f * zoom;
        g2.drawOval((int)((double)xPos + 0.5), (int)((double)yPos + 0.5), (int)((double)head + 0.5), (int)((double)head + 0.5));
        g2.drawLine((int)((double)(head / 2.0f + xPos) + 0.5), (int)((double)(head + yPos) + 0.5), (int)((double)(head / 2.0f + xPos) + 0.5), (int)((double)(yPos + head * 3.0f - distance) + 0.5));
        g2.drawLine((int)((double)(xPos - 4.0f * zoom) + 0.5), (int)((double)(yPos + head + head / 3.0f) + 0.5), (int)((double)(xPos + head + 4.0f * zoom) + 0.5), (int)((double)(yPos + head + head / 3.0f) + 0.5));
        g2.drawLine((int)((double)(head / 2.0f + xPos) + 0.5), (int)((double)(yPos + head * 3.0f - distance) + 0.5), (int)((double)(head + xPos) + 0.5), (int)((double)(yPos + head * 4.0f - distance) + 0.5));
        g2.drawLine((int)(head / 2.0f + xPos), (int)((double)(yPos + head * 3.0f - distance) + 0.5), (int)((double)xPos + 0.5), (int)((double)(yPos + head * 4.0f - distance) + 0.5));
        HandlerElementMap.getHandlerForElement(this).getFontHandler().writeText(g2, name, (double)((int)((double)xPos + (double)head * 1.5 + HandlerElementMap.getHandlerForElement(this).getFontHandler().getDistanceBetweenTexts() + 0.5)), (double)((int)((double)(2.0f * head + yPos) + 0.5)), AlignHorizontal.LEFT);
    }

    private void drawDockAnchor(Graphics2D g2, Point nextDock) {
        float zoom = HandlerElementMap.getHandlerForElement(this).getZoomFactor();
        int[] xkanten = new int[]{nextDock.x, nextDock.x + (int)(6.0f * zoom), nextDock.x - (int)(6.0f * zoom)};
        int[] ykanten = new int[]{nextDock.y - (int)(9.0f * zoom), nextDock.y, nextDock.y};
        int kanten_zahl = 3;
        g2.drawPolygon(new Polygon(xkanten, ykanten, kanten_zahl));
    }

    protected int calculateLevel(String s) {
        int level = 0;
        while (s.length() > 0 && s.charAt(0) == '\t') {
            ++level;
            s = s.substring(1);
        }
        return level;
    }
}

