/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan;

import java.awt.Dialog;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.extension.pscan.scanner.RegexAutoTagScanner;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.AbstractFormDialog;

class DialogAddAutoTagScanner
extends AbstractFormDialog {
    private static final long serialVersionUID = -5209887319253495735L;
    private static final String DIALOG_TITLE = Constant.messages.getString("pscan.options.dialog.scanner.add.title");
    private static final String CONFIRM_BUTTON_LABEL = Constant.messages.getString("pscan.options.dialog.scanner.add.button.confirm");
    private static final String NAME_FIELD_LABEL = Constant.messages.getString("pscan.options.dialog.scanner.field.label.name");
    private static final String TYPE_FIELD_LABEL = Constant.messages.getString("pscan.options.dialog.scanner.field.label.type");
    private static final String CONFIGURATION_FIELD_LABEL = Constant.messages.getString("pscan.options.dialog.scanner.field.label.config");
    private static final String REQUEST_URL_REGEX_FIELD_LABEL = Constant.messages.getString("pscan.options.dialog.scanner.field.label.editRequestUrlRegex");
    private static final String REQUEST_HEADER_REGEX_FIELD_LABEL = Constant.messages.getString("pscan.options.dialog.scanner.field.label.editRequestHeaderRegex");
    private static final String RESPONSE_HEADER_REGEX_FIELD_LABEL = Constant.messages.getString("pscan.options.dialog.scanner.field.label.editResponseHeaderRegex");
    private static final String RESPONSE_BODY_REGEX_FIELD_LABEL = Constant.messages.getString("pscan.options.dialog.scanner.field.label.editResponseBodyRegex");
    private static final String ENABLED_FIELD_LABEL = Constant.messages.getString("pscan.options.dialog.scanner.field.label.enabled");
    private static final String TITLE_DISPLAY_NAME_REPEATED_DIALOG = Constant.messages.getString("pscan.options.dialog.scanner.warning.name.repeated.title");
    private static final String TEXT_DISPLAY_NAME_REPEATED_DIALOG = Constant.messages.getString("pscan.options.dialog.scanner.warning.name.repeated.text");
    private static final String TITLE_WARNING_INVALID_REGEX = Constant.messages.getString("pscan.options.dialog.scanner.warning.invalid.regex.title");
    private static final String MESSAGE_INVALID_REQUEST_HEADER_REGEX = Constant.messages.getString("pscan.options.dialog.scanner.warning.invalid.requestHeaderRegex");
    private static final String MESSAGE_INVALID_REQUEST_URL_REGEX = Constant.messages.getString("pscan.options.dialog.scanner.warning.invalid.requestUrlRegex");
    private static final String MESSAGE_INVALID_RESPONSE_BODY_REGEX = Constant.messages.getString("pscan.options.dialog.scanner.warning.invalid.responseBodyRegex");
    private static final String MESSAGE_INVALID_RESPONSE_HEADER_REGEX = Constant.messages.getString("pscan.options.dialog.scanner.warning.invalid.responseHeaderRegex");
    private ZapTextField nameTextField;
    private ZapTextField typeTextField;
    private ZapTextField configurationTextField;
    private ZapTextField requestUrlRegexTextField;
    private ZapTextField requestHeaderRegexTextField;
    private ZapTextField responseHeaderRegexTextField;
    private ZapTextField responseBodyRegexTextField;
    private JCheckBox enabledCheckBox;
    protected RegexAutoTagScanner scanner;
    private List<RegexAutoTagScanner> scanners;
    private ConfirmButtonValidatorDocListener confirmButtonValidatorDocListener;

    public DialogAddAutoTagScanner(Dialog dialog) {
        super(dialog, DIALOG_TITLE);
    }

    protected DialogAddAutoTagScanner(Dialog dialog, String string) {
        super(dialog, string);
    }

    @Override
    protected JPanel getFieldsPanel() {
        JPanel jPanel = new JPanel();
        GroupLayout groupLayout = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout);
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setAutoCreateContainerGaps(true);
        JLabel jLabel = new JLabel(NAME_FIELD_LABEL);
        JLabel jLabel2 = new JLabel(TYPE_FIELD_LABEL);
        JLabel jLabel3 = new JLabel(CONFIGURATION_FIELD_LABEL);
        JLabel jLabel4 = new JLabel(REQUEST_URL_REGEX_FIELD_LABEL);
        JLabel jLabel5 = new JLabel(REQUEST_HEADER_REGEX_FIELD_LABEL);
        JLabel jLabel6 = new JLabel(RESPONSE_HEADER_REGEX_FIELD_LABEL);
        JLabel jLabel7 = new JLabel(RESPONSE_BODY_REGEX_FIELD_LABEL);
        JLabel jLabel8 = new JLabel(ENABLED_FIELD_LABEL);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel).addComponent(jLabel2).addComponent(jLabel3).addComponent(jLabel4).addComponent(jLabel5).addComponent(jLabel6).addComponent(jLabel7).addComponent(jLabel8)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getNameTextField()).addComponent(this.getTypeTextField()).addComponent(this.getConfigurationTextField()).addComponent(this.getRequestUrlRegexTextField()).addComponent(this.getRequestHeaderRegexTextField()).addComponent(this.getResponseHeaderRegexTextField()).addComponent(this.getResponseBodyRegexTextField()).addComponent(this.getEnabledCheckBox())));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel).addComponent(this.getNameTextField())).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel2).addComponent(this.getTypeTextField())).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel3).addComponent(this.getConfigurationTextField())).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel4).addComponent(this.getRequestUrlRegexTextField())).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel5).addComponent(this.getRequestHeaderRegexTextField())).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel6).addComponent(this.getResponseHeaderRegexTextField())).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel7).addComponent(this.getResponseBodyRegexTextField())).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel8).addComponent(this.getEnabledCheckBox())));
        return jPanel;
    }

    @Override
    protected String getConfirmButtonLabel() {
        return CONFIRM_BUTTON_LABEL;
    }

    @Override
    protected void init() {
        this.getNameTextField().setText("");
        this.getConfigurationTextField().setText("");
        this.getRequestUrlRegexTextField().setText("");
        this.getRequestHeaderRegexTextField().setText("");
        this.getResponseHeaderRegexTextField().setText("");
        this.getResponseBodyRegexTextField().setText("");
        this.getEnabledCheckBox().setSelected(true);
        this.scanner = null;
    }

    @Override
    protected boolean validateFields() {
        if (!this.validateName(this.getNameTextField().getText())) {
            return false;
        }
        if (!this.validateRegex(this.getRequestHeaderRegexTextField(), MESSAGE_INVALID_REQUEST_HEADER_REGEX)) {
            return false;
        }
        if (!this.validateRegex(this.getRequestUrlRegexTextField(), MESSAGE_INVALID_REQUEST_URL_REGEX)) {
            return false;
        }
        if (!this.validateRegex(this.getResponseHeaderRegexTextField(), MESSAGE_INVALID_RESPONSE_HEADER_REGEX)) {
            return false;
        }
        return this.validateRegex(this.getResponseBodyRegexTextField(), MESSAGE_INVALID_RESPONSE_BODY_REGEX);
    }

    protected boolean validateName(String string) {
        for (RegexAutoTagScanner regexAutoTagScanner : this.scanners) {
            if (!string.equals(regexAutoTagScanner.getName())) continue;
            JOptionPane.showMessageDialog(this, TEXT_DISPLAY_NAME_REPEATED_DIALOG, TITLE_DISPLAY_NAME_REPEATED_DIALOG, 1);
            this.getNameTextField().requestFocusInWindow();
            return false;
        }
        return true;
    }

    private boolean validateRegex(ZapTextField zapTextField, String string) {
        try {
            Pattern.compile(zapTextField.getText(), 2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(this, string, TITLE_WARNING_INVALID_REGEX, 2);
            zapTextField.requestFocusInWindow();
            return false;
        }
        return true;
    }

    @Override
    protected void performAction() {
        this.scanner = new RegexAutoTagScanner(this.getNameTextField().getText(), RegexAutoTagScanner.TYPE.TAG, this.getConfigurationTextField().getText());
        this.scanner.setRequestHeaderRegex(this.getRequestHeaderRegexTextField().getText());
        this.scanner.setRequestUrlRegex(this.getRequestUrlRegexTextField().getText());
        this.scanner.setResponseHeaderRegex(this.getResponseHeaderRegexTextField().getText());
        this.scanner.setResponseBodyRegex(this.getResponseBodyRegexTextField().getText());
        this.scanner.setEnabled(this.getEnabledCheckBox().isSelected());
    }

    @Override
    protected void clearFields() {
        this.getNameTextField().setText("");
        this.getNameTextField().discardAllEdits();
        this.getConfigurationTextField().setText("");
        this.getConfigurationTextField().discardAllEdits();
        this.getRequestUrlRegexTextField().setText("");
        this.getRequestUrlRegexTextField().discardAllEdits();
        this.getRequestHeaderRegexTextField().setText("");
        this.getRequestHeaderRegexTextField().discardAllEdits();
        this.getResponseHeaderRegexTextField().setText("");
        this.getResponseHeaderRegexTextField().discardAllEdits();
        this.getResponseBodyRegexTextField().setText("");
        this.getResponseBodyRegexTextField().discardAllEdits();
    }

    public RegexAutoTagScanner getScanner() {
        return this.scanner;
    }

    protected ZapTextField getNameTextField() {
        if (this.nameTextField == null) {
            this.nameTextField = new ZapTextField(25);
            this.nameTextField.getDocument().addDocumentListener(this.getConfirmButtonValidatorDocListener());
        }
        return this.nameTextField;
    }

    protected ZapTextField getTypeTextField() {
        if (this.typeTextField == null) {
            this.typeTextField = new ZapTextField();
            this.typeTextField.setEditable(false);
            this.typeTextField.setText(RegexAutoTagScanner.TYPE.TAG.name());
        }
        return this.typeTextField;
    }

    protected ZapTextField getConfigurationTextField() {
        if (this.configurationTextField == null) {
            this.configurationTextField = new ZapTextField();
            this.configurationTextField.getDocument().addDocumentListener(this.getConfirmButtonValidatorDocListener());
        }
        return this.configurationTextField;
    }

    protected ZapTextField getRequestUrlRegexTextField() {
        if (this.requestUrlRegexTextField == null) {
            this.requestUrlRegexTextField = new ZapTextField();
            this.requestUrlRegexTextField.getDocument().addDocumentListener(this.getConfirmButtonValidatorDocListener());
        }
        return this.requestUrlRegexTextField;
    }

    protected ZapTextField getRequestHeaderRegexTextField() {
        if (this.requestHeaderRegexTextField == null) {
            this.requestHeaderRegexTextField = new ZapTextField();
            this.requestHeaderRegexTextField.getDocument().addDocumentListener(this.getConfirmButtonValidatorDocListener());
        }
        return this.requestHeaderRegexTextField;
    }

    protected ZapTextField getResponseHeaderRegexTextField() {
        if (this.responseHeaderRegexTextField == null) {
            this.responseHeaderRegexTextField = new ZapTextField();
            this.responseHeaderRegexTextField.getDocument().addDocumentListener(this.getConfirmButtonValidatorDocListener());
        }
        return this.responseHeaderRegexTextField;
    }

    protected ZapTextField getResponseBodyRegexTextField() {
        if (this.responseBodyRegexTextField == null) {
            this.responseBodyRegexTextField = new ZapTextField();
            this.responseBodyRegexTextField.getDocument().addDocumentListener(this.getConfirmButtonValidatorDocListener());
        }
        return this.responseBodyRegexTextField;
    }

    protected JCheckBox getEnabledCheckBox() {
        if (this.enabledCheckBox == null) {
            this.enabledCheckBox = new JCheckBox();
        }
        return this.enabledCheckBox;
    }

    public void setScanners(List<RegexAutoTagScanner> list) {
        this.scanners = list;
    }

    public void clear() {
        this.scanners = null;
        this.scanner = null;
    }

    private ConfirmButtonValidatorDocListener getConfirmButtonValidatorDocListener() {
        if (this.confirmButtonValidatorDocListener == null) {
            this.confirmButtonValidatorDocListener = new ConfirmButtonValidatorDocListener();
        }
        return this.confirmButtonValidatorDocListener;
    }

    private class ConfirmButtonValidatorDocListener
    implements DocumentListener {
        private ConfirmButtonValidatorDocListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.checkAndEnableConfirmButton();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.checkAndEnableConfirmButton();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.checkAndEnableConfirmButton();
        }

        private void checkAndEnableConfirmButton() {
            boolean bl = DialogAddAutoTagScanner.this.getNameTextField().getDocument().getLength() > 0 && DialogAddAutoTagScanner.this.getConfigurationTextField().getDocument().getLength() > 0 && (DialogAddAutoTagScanner.this.getRequestUrlRegexTextField().getDocument().getLength() > 0 || DialogAddAutoTagScanner.this.getRequestUrlRegexTextField().getDocument().getLength() > 0 || DialogAddAutoTagScanner.this.getRequestHeaderRegexTextField().getDocument().getLength() > 0 || DialogAddAutoTagScanner.this.getResponseHeaderRegexTextField().getDocument().getLength() > 0 || DialogAddAutoTagScanner.this.getResponseBodyRegexTextField().getDocument().getLength() > 0);
            DialogAddAutoTagScanner.this.setConfirmButtonEnabled(bl);
        }
    }
}

