/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.sessions;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.zaproxy.zap.control.ExtensionFactory;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.sessions.ContextSessionManagementPanel;
import org.zaproxy.zap.extension.sessions.SessionManagementAPI;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.ContextDataFactory;
import org.zaproxy.zap.session.SessionManagementMethod;
import org.zaproxy.zap.session.SessionManagementMethodType;
import org.zaproxy.zap.view.AbstractContextPropertiesPanel;
import org.zaproxy.zap.view.ContextPanelFactory;

public class ExtensionSessionManagement
extends ExtensionAdaptor
implements ContextPanelFactory,
ContextDataFactory {
    public static final String NAME = "ExtensionSessionManagement";
    public static final String CONTEXT_CONFIG_SESSION = "context.session";
    public static final String CONTEXT_CONFIG_SESSION_TYPE = "context.session.type";
    private static final Logger log = Logger.getLogger(ExtensionSessionManagement.class);
    List<SessionManagementMethodType> sessionManagementMethodTypes;
    private Map<Integer, ContextSessionManagementPanel> contextPanelsMap = new HashMap<Integer, ContextSessionManagementPanel>();
    private SessionManagementAPI api;

    public ExtensionSessionManagement() {
        this.initialize();
    }

    private void initialize() {
        this.setName(NAME);
        this.setOrder(103);
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        Model.getSingleton().addContextDataFactory(this);
        if (this.getView() != null) {
            this.getView().addContextPanelFactory(this);
        }
        this.loadSesssionManagementMethodTypes(extensionHook);
        this.api = new SessionManagementAPI(this);
        API.getInstance().registerApiImplementor(this.api);
    }

    @Override
    public AbstractContextPropertiesPanel getContextPanel(Context context) {
        ContextSessionManagementPanel contextSessionManagementPanel = this.contextPanelsMap.get(context.getIndex());
        if (contextSessionManagementPanel == null) {
            contextSessionManagementPanel = new ContextSessionManagementPanel(this, context);
            this.contextPanelsMap.put(context.getIndex(), contextSessionManagementPanel);
        }
        return contextSessionManagementPanel;
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    public List<SessionManagementMethodType> getSessionManagementMethodTypes() {
        return this.sessionManagementMethodTypes;
    }

    private void loadSesssionManagementMethodTypes(ExtensionHook extensionHook) {
        this.sessionManagementMethodTypes = ExtensionFactory.getAddOnLoader().getImplementors("org.zaproxy.zap", SessionManagementMethodType.class);
        for (SessionManagementMethodType sessionManagementMethodType : this.sessionManagementMethodTypes) {
            sessionManagementMethodType.hook(extensionHook);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Loaded session management method types: " + this.sessionManagementMethodTypes));
        }
    }

    @Override
    public void discardContexts() {
        this.contextPanelsMap.clear();
    }

    @Override
    public void discardContext(Context context) {
        this.contextPanelsMap.remove(context.getIndex());
    }

    public SessionManagementMethodType getSessionManagementMethodTypeForIdentifier(int n) {
        for (SessionManagementMethodType sessionManagementMethodType : this.getSessionManagementMethodTypes()) {
            if (sessionManagementMethodType.getUniqueIdentifier() != n) continue;
            return sessionManagementMethodType;
        }
        return null;
    }

    @Override
    public void loadContextData(Session session, Context context) {
        try {
            SessionManagementMethodType sessionManagementMethodType;
            List<String> list = session.getContextDataStrings(context.getIndex(), 220);
            if (list != null && list.size() > 0 && (sessionManagementMethodType = this.getSessionManagementMethodTypeForIdentifier(Integer.parseInt(list.get(0)))) != null) {
                context.setSessionManagementMethod(sessionManagementMethodType.loadMethodFromSession(session, context.getIndex()));
            }
        }
        catch (DatabaseException databaseException) {
            log.error((Object)"Unable to load Session Management method.", (Throwable)databaseException);
        }
    }

    @Override
    public void persistContextData(Session session, Context context) {
        try {
            SessionManagementMethodType sessionManagementMethodType = context.getSessionManagementMethod().getType();
            session.setContextData(context.getIndex(), 220, Integer.toString(sessionManagementMethodType.getUniqueIdentifier()));
            sessionManagementMethodType.persistMethodToSession(session, context.getIndex(), context.getSessionManagementMethod());
        }
        catch (DatabaseException databaseException) {
            log.error((Object)"Unable to persist Session Management method.", (Throwable)databaseException);
        }
    }

    @Override
    public void exportContextData(Context context, Configuration configuration) {
        configuration.setProperty(CONTEXT_CONFIG_SESSION_TYPE, (Object)context.getSessionManagementMethod().getType().getUniqueIdentifier());
    }

    @Override
    public void importContextData(Context context, Configuration configuration) throws ConfigurationException {
        SessionManagementMethodType sessionManagementMethodType = this.getSessionManagementMethodTypeForIdentifier(configuration.getInt(CONTEXT_CONFIG_SESSION_TYPE));
        if (sessionManagementMethodType != null) {
            SessionManagementMethod sessionManagementMethod = sessionManagementMethodType.createSessionManagementMethod(context.getIndex());
            sessionManagementMethodType.importData(configuration, sessionManagementMethod);
            context.setSessionManagementMethod(sessionManagementMethod);
        }
    }
}

