/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Box;

public final class VerticalLayout
implements LayoutManager {
    private final boolean proportionalWidth;
    private final int vGap;

    public VerticalLayout(boolean bl) {
        this(bl, 0);
    }

    public VerticalLayout(boolean bl, int n) {
        this.proportionalWidth = bl;
        this.vGap = n;
    }

    @Override
    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = insets.left;
        int n2 = insets.top;
        int n3 = container.getWidth() - insets.left - insets.right;
        for (Component component : container.getComponents()) {
            if (!component.isVisible()) continue;
            Dimension dimension = component.getPreferredSize();
            if (this.proportionalWidth) {
                int n4 = Math.min(dimension.width, n3);
                int n5 = (n3 - n4) / 2;
                component.setBounds(n, n2 + n5, n4, dimension.height);
            } else {
                component.setBounds(n, n2, n3, dimension.height);
            }
            dimension.height += this.vGap;
            n2 += dimension.height;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        int n = 0;
        int n2 = 0;
        for (Component component : container.getComponents()) {
            if (!component.isVisible() || component instanceof Box.Filler) continue;
            Dimension dimension2 = component.getPreferredSize();
            n = Math.max(n, dimension2.width);
            dimension.height += dimension2.height;
            ++n2;
        }
        dimension.height += (n2 - 1) * this.vGap;
        dimension.width += n;
        return dimension;
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        int n = 0;
        int n2 = 0;
        for (Component component : container.getComponents()) {
            if (!component.isVisible()) continue;
            Dimension dimension2 = component.getPreferredSize();
            n = Math.max(n, dimension2.width);
            dimension.height += dimension2.height;
            ++n2;
        }
        dimension.height += (n2 - 1) * this.vGap;
        dimension.width += n;
        return dimension;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }
}

