/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import org.gradle.testkit.jarjar.org.gradle.api.Action;
import org.gradle.tooling.internal.adapter.SourceObjectMapping;
import org.gradle.tooling.internal.connection.DefaultProjectIdentifier;
import org.gradle.tooling.internal.consumer.converters.CompositeMappingAction;
import org.gradle.tooling.internal.consumer.converters.FixedBuildIdentifierProvider;
import org.gradle.tooling.internal.consumer.converters.GradleProjectIdentifierMapping;
import org.gradle.tooling.internal.consumer.converters.IdeaProjectCompatibilityMapper;
import org.gradle.tooling.internal.consumer.converters.TaskPropertyHandlerFactory;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.model.ProjectIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HasCompatibilityMapperAction {
    private final Action<SourceObjectMapping> taskPropertyHandlerMapper;
    private final Action<SourceObjectMapping> ideaProjectCompatibilityMapper;
    private final Action<SourceObjectMapping> gradleProjectIdentifierMapper;

    public HasCompatibilityMapperAction(VersionDetails versionDetails) {
        this.taskPropertyHandlerMapper = new TaskPropertyHandlerFactory().forVersion(versionDetails);
        this.ideaProjectCompatibilityMapper = new IdeaProjectCompatibilityMapper(versionDetails);
        this.gradleProjectIdentifierMapper = new GradleProjectIdentifierMapping();
    }

    public Action<SourceObjectMapping> getCompatibilityMapperAction(ConsumerOperationParameters parameters) {
        DefaultProjectIdentifier projectIdentifier = new DefaultProjectIdentifier(parameters.getBuildIdentifier(), ":");
        return this.getCompatibilityMapperAction(projectIdentifier);
    }

    public Action<SourceObjectMapping> getCompatibilityMapperAction(ProjectIdentifier projectIdentifier) {
        FixedBuildIdentifierProvider identifierProvider = new FixedBuildIdentifierProvider(projectIdentifier);
        return this.getCompatibilityMapperAction(identifierProvider);
    }

    private Action<SourceObjectMapping> getCompatibilityMapperAction(Action<SourceObjectMapping> requestScopedMapping) {
        return CompositeMappingAction.builder().add(this.taskPropertyHandlerMapper).add(this.ideaProjectCompatibilityMapper).add(this.gradleProjectIdentifierMapper).add(requestScopedMapping).build();
    }
}

