/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.data;

public class MavenDependencyKey {
    private static final String KEY_SEPARATOR = ":";
    private final String groupId;
    private final String artifactId;
    private final String type;
    private final String classifier;

    public MavenDependencyKey(String groupId, String artifactId, String type, String classifier) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.type = type;
        this.classifier = classifier;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getType() {
        return this.type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenDependencyKey that = (MavenDependencyKey)o;
        if (!this.artifactId.equals(that.artifactId)) {
            return false;
        }
        if (this.classifier != null ? !this.classifier.equals(that.classifier) : that.classifier != null) {
            return false;
        }
        if (!this.groupId.equals(that.groupId)) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public int hashCode() {
        int result = this.groupId.hashCode();
        result = 31 * result + this.artifactId.hashCode();
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.classifier != null ? this.classifier.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder key = new StringBuilder();
        key.append(this.groupId).append(KEY_SEPARATOR).append(this.artifactId).append(KEY_SEPARATOR).append(this.type);
        if (this.classifier != null) {
            key.append(KEY_SEPARATOR).append(this.classifier);
        }
        return key.toString();
    }
}

