/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.array.ArrayBuilderNode;
import org.jruby.truffle.core.array.ArrayHelpers;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;

public final class ArrayConcatNode
extends RubyNode {
    @Node.Children
    private final RubyNode[] children;
    @Node.Child
    private ArrayBuilderNode arrayBuilderNode;
    private final ConditionProfile isArrayProfile = ConditionProfile.createBinaryProfile();

    public ArrayConcatNode(RubyContext context, SourceSection sourceSection, RubyNode[] children) {
        super(context, sourceSection);
        assert (children.length > 1);
        this.children = children;
        this.arrayBuilderNode = ArrayBuilderNode.create(context);
    }

    @Override
    public DynamicObject execute(VirtualFrame frame) {
        if (this.children.length == 1) {
            return this.executeSingle(frame);
        }
        return this.executeMultiple(frame);
    }

    private DynamicObject executeSingle(VirtualFrame frame) {
        int size;
        Object store = this.arrayBuilderNode.start();
        Object childObject = this.children[0].execute(frame);
        if (this.isArrayProfile.profile(RubyGuards.isRubyArray(childObject))) {
            DynamicObject childArray = (DynamicObject)childObject;
            size = Layouts.ARRAY.getSize(childArray);
            store = this.arrayBuilderNode.ensure(store, size);
            store = this.arrayBuilderNode.appendArray(store, 0, childArray);
        } else {
            size = 1;
            store = this.arrayBuilderNode.ensure(store, 1);
            store = this.arrayBuilderNode.appendValue(store, 0, childObject);
        }
        return ArrayHelpers.createArray(this.getContext(), this.arrayBuilderNode.finish(store, size), size);
    }

    @ExplodeLoop
    private DynamicObject executeMultiple(VirtualFrame frame) {
        Object store = this.arrayBuilderNode.start();
        int length = 0;
        for (int n = 0; n < this.children.length; ++n) {
            Object childObject = this.children[n].execute(frame);
            if (this.isArrayProfile.profile(RubyGuards.isRubyArray(childObject))) {
                DynamicObject childArray = (DynamicObject)childObject;
                int size = Layouts.ARRAY.getSize(childArray);
                store = this.arrayBuilderNode.ensure(store, length + size);
                store = this.arrayBuilderNode.appendArray(store, length, childArray);
                length += size;
                continue;
            }
            store = this.arrayBuilderNode.ensure(store, length + 1);
            store = this.arrayBuilderNode.appendValue(store, length, childObject);
            ++length;
        }
        return ArrayHelpers.createArray(this.getContext(), this.arrayBuilderNode.finish(store, length), length);
    }

    @Override
    @ExplodeLoop
    public void executeVoid(VirtualFrame frame) {
        for (int n = 0; n < this.children.length; ++n) {
            this.children[n].executeVoid(frame);
        }
    }
}

