/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.mutex;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.CoreClass;
import org.jruby.truffle.core.CoreMethod;
import org.jruby.truffle.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.UnaryCoreMethodNode;
import org.jruby.truffle.core.kernel.KernelNodes;
import org.jruby.truffle.core.mutex.MutexOperations;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.objects.AllocateObjectNode;
import org.jruby.truffle.language.objects.AllocateObjectNodeGen;

@CoreClass(name="Mutex")
public abstract class MutexNodes {

    @CoreMethod(names={"sleep"}, optional=1)
    public static abstract class SleepNode
    extends CoreMethodArrayArgumentsNode {
        private final ConditionProfile durationLessThanZeroProfile = ConditionProfile.createBinaryProfile();

        @Specialization
        public long sleep(DynamicObject mutex, NotProvided duration) {
            return this.doSleepMillis(mutex, Long.MAX_VALUE);
        }

        @Specialization(guards={"isNil(duration)"})
        public long sleep(DynamicObject mutex, DynamicObject duration) {
            return this.sleep(mutex, NotProvided.INSTANCE);
        }

        @Specialization
        public long sleep(DynamicObject mutex, long duration) {
            return this.doSleepMillis(mutex, duration * 1000L);
        }

        @Specialization
        public long sleep(DynamicObject mutex, double duration) {
            return this.doSleepMillis(mutex, (long)(duration * 1000.0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long doSleepMillis(DynamicObject mutex, long durationInMillis) {
            if (this.durationLessThanZeroProfile.profile(durationInMillis < 0L)) {
                throw new RaiseException(this.coreExceptions().argumentErrorTimeItervalPositive(this));
            }
            ReentrantLock lock = Layouts.MUTEX.getLock(mutex);
            DynamicObject thread = this.getContext().getThreadManager().getCurrentThread();
            Layouts.THREAD.getWakeUp(thread).set(false);
            MutexOperations.unlock(lock, thread, this);
            try {
                long l = KernelNodes.SleepNode.sleepFor(this, this.getContext(), durationInMillis);
                return l;
            }
            finally {
                MutexOperations.lock(lock, thread, this);
            }
        }
    }

    @CoreMethod(names={"unlock"})
    public static abstract class UnlockNode
    extends UnaryCoreMethodNode {
        @Specialization
        public DynamicObject unlock(DynamicObject mutex) {
            ReentrantLock lock = Layouts.MUTEX.getLock(mutex);
            DynamicObject thread = this.getContext().getThreadManager().getCurrentThread();
            MutexOperations.unlock(lock, thread, this);
            return mutex;
        }
    }

    @CoreMethod(names={"try_lock"})
    public static abstract class TryLockNode
    extends UnaryCoreMethodNode {
        @Specialization
        public boolean tryLock(DynamicObject mutex, @Cached(value="createBinaryProfile()") ConditionProfile heldByCurrentThreadProfile) {
            ReentrantLock lock = Layouts.MUTEX.getLock(mutex);
            if (heldByCurrentThreadProfile.profile(lock.isHeldByCurrentThread())) {
                return false;
            }
            return this.doTryLock(lock);
        }

        @CompilerDirectives.TruffleBoundary
        private boolean doTryLock(ReentrantLock lock) {
            if (lock.tryLock()) {
                DynamicObject thread = this.getContext().getThreadManager().getCurrentThread();
                Layouts.THREAD.getOwnedLocks(thread).add(lock);
                return true;
            }
            return false;
        }
    }

    @CoreMethod(names={"owned?"})
    public static abstract class IsOwnedNode
    extends UnaryCoreMethodNode {
        @Specialization
        public boolean isOwned(DynamicObject mutex) {
            return Layouts.MUTEX.getLock(mutex).isHeldByCurrentThread();
        }
    }

    @CoreMethod(names={"locked?"})
    public static abstract class IsLockedNode
    extends UnaryCoreMethodNode {
        @Specialization
        public boolean isLocked(DynamicObject mutex) {
            return Layouts.MUTEX.getLock(mutex).isLocked();
        }
    }

    @CoreMethod(names={"lock"})
    public static abstract class LockNode
    extends UnaryCoreMethodNode {
        @Specialization
        public DynamicObject lock(DynamicObject mutex) {
            ReentrantLock lock = Layouts.MUTEX.getLock(mutex);
            DynamicObject thread = this.getContext().getThreadManager().getCurrentThread();
            MutexOperations.lock(lock, thread, this);
            return mutex;
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateNode;

        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return this.allocateNode.allocate(rubyClass, new ReentrantLock());
        }
    }
}

