/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.numeric;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ExactMath;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import java.math.BigInteger;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.CoreClass;
import org.jruby.truffle.core.CoreLibrary;
import org.jruby.truffle.core.CoreMethod;
import org.jruby.truffle.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.numeric.BignumNodes;
import org.jruby.truffle.core.numeric.FixnumNodesFactory;
import org.jruby.truffle.core.numeric.FixnumOrBignumNode;
import org.jruby.truffle.core.numeric.GeneralDivModNode;
import org.jruby.truffle.core.rope.LazyIntRope;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.SnippetNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.methods.UnsupportedOperationBehavior;

@CoreClass(name="Fixnum")
public abstract class FixnumNodes {

    @CoreMethod(names={"zero?"})
    public static abstract class ZeroNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public boolean zero(int n) {
            return n == 0;
        }

        @Specialization
        public boolean zero(long n) {
            return n == 0L;
        }
    }

    @CoreMethod(names={"to_s"}, optional=1)
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject toS(int n, NotProvided base) {
            return this.createString(new LazyIntRope(n));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject toS(long n, NotProvided base) {
            if (CoreLibrary.fitsIntoInteger(n)) {
                return this.toS((int)n, base);
            }
            return this.create7BitString(Long.toString(n), (Encoding)USASCIIEncoding.INSTANCE);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject toS(long n, int base) {
            if (base == 10) {
                return this.toS(n, NotProvided.INSTANCE);
            }
            if (base < 2 || base > 36) {
                throw new RaiseException(this.coreExceptions().argumentErrorInvalidRadix(base, this));
            }
            return this.create7BitString(Long.toString(n, base), (Encoding)USASCIIEncoding.INSTANCE);
        }
    }

    @CoreMethod(names={"to_f"})
    public static abstract class ToFNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public double toF(int n) {
            return n;
        }

        @Specialization
        public double toF(long n) {
            return n;
        }
    }

    @CoreMethod(names={"size"}, needsSelf=false)
    public static abstract class SizeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int size() {
            return 8;
        }
    }

    @CoreMethod(names={"inspect"})
    public static abstract class InspectNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject inspect(int n) {
            return this.createString(new LazyIntRope(n));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject inspect(long n) {
            if (CoreLibrary.fitsIntoInteger(n)) {
                return this.inspect((int)n);
            }
            return this.create7BitString(Long.toString(n), (Encoding)USASCIIEncoding.INSTANCE);
        }
    }

    @CoreMethod(names={"floor"})
    public static abstract class FloorNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int floor(int n) {
            return n;
        }

        @Specialization
        public long floor(long n) {
            return n;
        }
    }

    @CoreMethod(names={"bit_length"})
    public static abstract class BitLengthNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int bitLength(int n) {
            if (n < 0) {
                n ^= 0xFFFFFFFF;
            }
            return 32 - Integer.numberOfLeadingZeros(n);
        }

        @Specialization
        public int bitLength(long n) {
            if (n < 0L) {
                n ^= 0xFFFFFFFFFFFFFFFFL;
            }
            return 64 - Long.numberOfLeadingZeros(n);
        }
    }

    @CoreMethod(names={"abs", "magnitude"})
    public static abstract class AbsNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(rewriteOn={ArithmeticException.class})
        public int absIntInBounds(int n) {
            return n < 0 ? ExactMath.subtractExact(0, n) : n;
        }

        @Specialization(contains={"absIntInBounds"})
        public Object abs(int n) {
            if (n == Integer.MIN_VALUE) {
                return -((long)n);
            }
            return n < 0 ? -n : n;
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public long absInBounds(long n) {
            return n < 0L ? ExactMath.subtractExact(0L, n) : n;
        }

        @Specialization(contains={"absInBounds"})
        public Object abs(long n) {
            if (n == Long.MIN_VALUE) {
                return this.createBignum(BigInteger.valueOf(n).abs());
            }
            return n < 0L ? -n : n;
        }
    }

    @CoreMethod(names={">>"}, required=1, lowerFixnumParameters={0})
    public static abstract class RightShiftNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode fallbackCallNode;
        @Node.Child
        private LeftShiftNode leftShiftNode;

        public abstract Object executeRightShift(VirtualFrame var1, Object var2, Object var3);

        @Specialization(guards={"b >= 0"})
        public int rightShift(VirtualFrame frame, int a, int b, @Cached(value="createBinaryProfile()") ConditionProfile profile) {
            if (profile.profile(b >= 31)) {
                return a < 0 ? -1 : 0;
            }
            return a >> b;
        }

        @Specialization(guards={"b >= 0"})
        public Object rightShift(VirtualFrame frame, long a, int b, @Cached(value="createBinaryProfile()") ConditionProfile profile) {
            if (profile.profile(b >= 63)) {
                return a < 0L ? -1 : 0;
            }
            return a >> b;
        }

        @Specialization(guards={"b < 0"})
        public Object rightShiftNeg(VirtualFrame frame, long a, int b) {
            if (this.leftShiftNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.leftShiftNode = this.insert(FixnumNodesFactory.LeftShiftNodeFactory.create(new RubyNode[]{null, null}));
            }
            return this.leftShiftNode.executeLeftShift(frame, a, -b);
        }

        @Specialization(guards={"b >= 0"})
        public int rightShift(long a, long b) {
            assert (!CoreLibrary.fitsIntoInteger(b));
            return 0;
        }

        @Specialization(guards={"isRubyBignum(b)", "isPositive(b)"})
        public int rightShift(long a, DynamicObject b) {
            return 0;
        }

        @Specialization(guards={"isRubyBignum(b)", "!isPositive(b)"})
        public Object rightShiftNeg(VirtualFrame frame, long a, DynamicObject b) {
            if (this.leftShiftNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.leftShiftNode = this.insert(FixnumNodesFactory.LeftShiftNodeFactory.create(new RubyNode[]{null, null}));
            }
            return this.leftShiftNode.executeLeftShift(frame, a, Layouts.BIGNUM.getValue(b).negate());
        }

        @Specialization(guards={"!isInteger(b)", "!isLong(b)"})
        public Object rightShiftFallback(VirtualFrame frame, Object a, Object b) {
            if (this.fallbackCallNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.fallbackCallNode = this.insert(DispatchHeadNodeFactory.createMethodCallOnSelf(this.getContext()));
            }
            return this.fallbackCallNode.call(frame, a, "right_shift_fallback", null, b);
        }

        protected static boolean isPositive(DynamicObject b) {
            return Layouts.BIGNUM.getValue(b).signum() >= 0;
        }
    }

    @CoreMethod(names={"<<"}, required=1, lowerFixnumParameters={0})
    public static abstract class LeftShiftNode
    extends BignumNodes.BignumCoreMethodNode {
        @Node.Child
        private RightShiftNode rightShiftNode;
        @Node.Child
        private CallDispatchHeadNode fallbackCallNode;

        public abstract Object executeLeftShift(VirtualFrame var1, Object var2, Object var3);

        @Specialization(guards={"b >= 0", "canShiftIntoInt(a, b)"})
        public int leftShift(int a, int b) {
            return a << b;
        }

        @Specialization(guards={"b >= 0", "canShiftLongIntoInt(a, b)"})
        public int leftShift(long a, int b) {
            return (int)(a << b);
        }

        @Specialization(guards={"b >= 0", "canShiftIntoLong(a, b)"})
        public long leftShiftToLong(long a, int b) {
            return a << b;
        }

        @Specialization(guards={"b >= 0"})
        public Object leftShiftWithOverflow(long a, int b) {
            if (LeftShiftNode.canShiftIntoLong(a, b)) {
                return this.leftShiftToLong(a, b);
            }
            return this.fixnumOrBignum(BigInteger.valueOf(a).shiftLeft(b));
        }

        @Specialization(guards={"b < 0"})
        public Object leftShiftNeg(VirtualFrame frame, long a, int b) {
            if (this.rightShiftNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.rightShiftNode = this.insert(FixnumNodesFactory.RightShiftNodeFactory.create(new RubyNode[]{null, null}));
            }
            return this.rightShiftNode.executeRightShift(frame, a, -b);
        }

        @Specialization(guards={"!isInteger(b)", "!isLong(b)"})
        public Object leftShiftFallback(VirtualFrame frame, Object a, Object b) {
            if (this.fallbackCallNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.fallbackCallNode = this.insert(DispatchHeadNodeFactory.createMethodCallOnSelf(this.getContext()));
            }
            return this.fallbackCallNode.call(frame, a, "left_shift_fallback", null, b);
        }

        static boolean canShiftIntoInt(int a, int b) {
            return Integer.numberOfLeadingZeros(a) - b > 0;
        }

        static boolean canShiftLongIntoInt(long a, int b) {
            return Long.numberOfLeadingZeros(a) - 32 - b > 0;
        }

        static boolean canShiftIntoLong(long a, int b) {
            return Long.numberOfLeadingZeros(a) - b > 0;
        }
    }

    @CoreMethod(names={"^"}, required=1)
    public static abstract class BitXOrNode
    extends BignumNodes.BignumCoreMethodNode {
        @Specialization
        public int bitXOr(int a, int b) {
            return a ^ b;
        }

        @Specialization
        public long bitXOr(long a, long b) {
            return a ^ b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Object bitXOr(long a, DynamicObject b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).xor(Layouts.BIGNUM.getValue(b)));
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object bitXOr(VirtualFrame frame, Object a, DynamicObject b, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "a ^ Rubinius::Type.coerce_to_bitwise_operand(b)", "a", a, "b", b);
        }
    }

    @CoreMethod(names={"|"}, required=1)
    public static abstract class BitOrNode
    extends BignumNodes.BignumCoreMethodNode {
        @Specialization
        public int bitOr(int a, int b) {
            return a | b;
        }

        @Specialization
        public long bitOr(long a, long b) {
            return a | b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Object bitOr(long a, DynamicObject b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).or(Layouts.BIGNUM.getValue(b)));
        }
    }

    @CoreMethod(names={"&"}, required=1)
    public static abstract class BitAndNode
    extends BignumNodes.BignumCoreMethodNode {
        @Specialization
        public int bitAndIntInt(int a, int b) {
            return a & b;
        }

        @Specialization
        public int bitAndIntLong(int a, long b) {
            return a & (int)b;
        }

        @Specialization
        public int bitAndLongInt(long a, int b) {
            return (int)a & b;
        }

        @Specialization
        public long bitAndLongLong(long a, long b) {
            return a & b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Object bitAndBignum(long a, DynamicObject b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).and(Layouts.BIGNUM.getValue(b)));
        }
    }

    @CoreMethod(names={"~"})
    public static abstract class ComplementNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int complement(int n) {
            return ~n;
        }

        @Specialization
        public long complement(long n) {
            return n ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    @CoreMethod(names={">"}, required=1, unsupportedOperationBehavior=UnsupportedOperationBehavior.ARGUMENT_ERROR)
    public static abstract class GreaterNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public boolean greater(int a, int b) {
            return a > b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean greater(int a, DynamicObject b) {
            return BigInteger.valueOf(a).compareTo(Layouts.BIGNUM.getValue(b)) > 0;
        }

        @Specialization
        public boolean greater(long a, long b) {
            return a > b;
        }

        @Specialization
        public boolean greater(long a, double b) {
            return (double)a > b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean greater(long a, DynamicObject b) {
            return BigInteger.valueOf(a).compareTo(Layouts.BIGNUM.getValue(b)) > 0;
        }

        @Specialization(guards={"!isRubyBignum(b)", "!isInteger(b)", "!isLong(b)", "!isDouble(b)"})
        public Object greaterCoerced(VirtualFrame frame, long a, Object b, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "b, a = math_coerce(other, :compare_error); a > b", "other", b);
        }
    }

    @CoreMethod(names={">="}, required=1, unsupportedOperationBehavior=UnsupportedOperationBehavior.ARGUMENT_ERROR)
    public static abstract class GreaterEqualNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public boolean greaterEqual(int a, int b) {
            return a >= b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean greaterEqual(int a, DynamicObject b) {
            return BigInteger.valueOf(a).compareTo(Layouts.BIGNUM.getValue(b)) >= 0;
        }

        @Specialization
        public boolean greaterEqual(long a, long b) {
            return a >= b;
        }

        @Specialization
        public boolean greaterEqual(long a, double b) {
            return (double)a >= b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean greaterEqual(long a, DynamicObject b) {
            return BigInteger.valueOf(a).compareTo(Layouts.BIGNUM.getValue(b)) >= 0;
        }

        @Specialization(guards={"!isRubyBignum(b)", "!isInteger(b)", "!isLong(b)", "!isDouble(b)"})
        public Object greaterEqualCoerced(VirtualFrame frame, long a, Object b, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "b, a = math_coerce other, :compare_error; a >= b", "other", b);
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int compare(int a, int b) {
            return Integer.compare(a, b);
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public int compare(int a, DynamicObject b) {
            return BigInteger.valueOf(a).compareTo(Layouts.BIGNUM.getValue(b));
        }

        @Specialization
        public int compare(long a, long b) {
            return Long.compare(a, b);
        }

        @Specialization
        public int compare(long a, double b) {
            return Double.compare(a, b);
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public int compare(long a, DynamicObject b) {
            return BigInteger.valueOf(a).compareTo(Layouts.BIGNUM.getValue(b));
        }

        @Specialization(guards={"!isInteger(b)", "!isLong(b)", "!isDouble(b)", "!isRubyBignum(b)"})
        public Object compare(VirtualFrame frame, Object a, Object b, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "begin; b, a = math_coerce(other, :compare_error); a <=> b; rescue ArgumentError; nil; end", "other", b);
        }
    }

    @CoreMethod(names={"==", "==="}, required=1)
    public static abstract class EqualNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode reverseCallNode;

        public EqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.reverseCallNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public boolean equal(int a, int b) {
            return a == b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean equal(int a, DynamicObject b) {
            return false;
        }

        @Specialization
        public boolean equal(long a, long b) {
            return a == b;
        }

        @Specialization
        public boolean equal(long a, double b) {
            return (double)a == b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean equal(long a, DynamicObject b) {
            return false;
        }

        @Specialization(guards={"!isInteger(b)", "!isLong(b)", "!isRubyBignum(b)"})
        public Object equal(VirtualFrame frame, Object a, Object b) {
            return this.reverseCallNode.call(frame, b, "==", null, a);
        }
    }

    @CoreMethod(names={"<="}, required=1, unsupportedOperationBehavior=UnsupportedOperationBehavior.ARGUMENT_ERROR)
    public static abstract class LessEqualNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public boolean lessEqual(int a, int b) {
            return a <= b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean lessEqual(int a, DynamicObject b) {
            return BigInteger.valueOf(a).compareTo(Layouts.BIGNUM.getValue(b)) <= 0;
        }

        @Specialization
        public boolean lessEqual(long a, long b) {
            return a <= b;
        }

        @Specialization
        public boolean lessEqual(long a, double b) {
            return (double)a <= b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean lessEqual(long a, DynamicObject b) {
            return BigInteger.valueOf(a).compareTo(Layouts.BIGNUM.getValue(b)) <= 0;
        }

        @Specialization(guards={"!isRubyBignum(b)", "!isInteger(b)", "!isLong(b)", "!isDouble(b)"})
        public Object lessEqualCoerced(VirtualFrame frame, long a, Object b, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "b, a = math_coerce other, :compare_error; a <= b", "other", b);
        }
    }

    @CoreMethod(names={"<"}, required=1, unsupportedOperationBehavior=UnsupportedOperationBehavior.ARGUMENT_ERROR)
    public static abstract class LessNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public boolean less(int a, int b) {
            return a < b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean less(int a, DynamicObject b) {
            return BigInteger.valueOf(a).compareTo(Layouts.BIGNUM.getValue(b)) < 0;
        }

        @Specialization
        public boolean less(long a, long b) {
            return a < b;
        }

        @Specialization
        public boolean less(long a, double b) {
            return (double)a < b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean less(long a, DynamicObject b) {
            return BigInteger.valueOf(a).compareTo(Layouts.BIGNUM.getValue(b)) < 0;
        }

        @Specialization(guards={"!isRubyBignum(b)", "!isInteger(b)", "!isLong(b)", "!isDouble(b)"})
        public Object lessCoerced(VirtualFrame frame, long a, Object b, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "b, a = math_coerce other, :compare_error; a < b", "other", b);
        }
    }

    @CoreMethod(names={"divmod"}, required=1)
    public static abstract class DivModNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private GeneralDivModNode divModNode;

        public DivModNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.divModNode = new GeneralDivModNode(context, sourceSection);
        }

        @Specialization
        public DynamicObject divMod(long a, long b) {
            return this.divModNode.execute(a, b);
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public DynamicObject divMod(long a, DynamicObject b) {
            return this.divModNode.execute(a, Layouts.BIGNUM.getValue(b));
        }

        @Specialization
        public DynamicObject divMod(long a, double b) {
            return this.divModNode.execute(a, b);
        }
    }

    @CoreMethod(names={"%"}, required=1)
    public static abstract class ModNode
    extends BignumNodes.BignumCoreMethodNode {
        private final BranchProfile adjustProfile = BranchProfile.create();

        @Specialization
        public int mod(int a, int b) {
            int mod = a % b;
            if (mod < 0 && b > 0 || mod > 0 && b < 0) {
                this.adjustProfile.enter();
                mod += b;
            }
            return mod;
        }

        @Specialization
        public double mod(long a, double b) {
            if (b == 0.0) {
                throw new ArithmeticException("divide by zero");
            }
            double mod = (double)a % b;
            if (mod < 0.0 && b > 0.0 || mod > 0.0 && b < 0.0) {
                this.adjustProfile.enter();
                mod += b;
            }
            return mod;
        }

        @Specialization
        public long mod(long a, long b) {
            long mod = a % b;
            if (mod < 0L && b > 0L || mod > 0L && b < 0L) {
                this.adjustProfile.enter();
                mod += b;
            }
            return mod;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Object mod(long a, DynamicObject b) {
            CompilerDirectives.transferToInterpreter();
            long mod = BigInteger.valueOf(a).mod(Layouts.BIGNUM.getValue(b)).longValue();
            if (mod < 0L && Layouts.BIGNUM.getValue(b).compareTo(BigInteger.ZERO) > 0 || mod > 0L && Layouts.BIGNUM.getValue(b).compareTo(BigInteger.ZERO) < 0) {
                this.adjustProfile.enter();
                return this.createBignum(BigInteger.valueOf(mod).add(Layouts.BIGNUM.getValue(b)));
            }
            return mod;
        }
    }

    @CoreMethod(names={"/", "__slash__"}, required=1)
    public static abstract class DivNode
    extends CoreMethodArrayArgumentsNode {
        private final BranchProfile bGreaterZero = BranchProfile.create();
        private final BranchProfile bGreaterZeroAGreaterEqualZero = BranchProfile.create();
        private final BranchProfile bGreaterZeroALessZero = BranchProfile.create();
        private final BranchProfile aGreaterZero = BranchProfile.create();
        private final BranchProfile bMinusOne = BranchProfile.create();
        private final BranchProfile bMinusOneAMinimum = BranchProfile.create();
        private final BranchProfile bMinusOneANotMinimum = BranchProfile.create();
        private final BranchProfile finalCase = BranchProfile.create();

        @Specialization(rewriteOn={UnexpectedResultException.class})
        public int div(int a, int b) throws UnexpectedResultException {
            if (b > 0) {
                this.bGreaterZero.enter();
                if (a >= 0) {
                    this.bGreaterZeroAGreaterEqualZero.enter();
                    return a / b;
                }
                this.bGreaterZeroALessZero.enter();
                return (a + 1) / b - 1;
            }
            if (a > 0) {
                this.aGreaterZero.enter();
                return (a - 1) / b - 1;
            }
            if (b == -1) {
                this.bMinusOne.enter();
                if (a == Integer.MIN_VALUE) {
                    this.bMinusOneAMinimum.enter();
                    throw new UnexpectedResultException(BigInteger.valueOf(a).negate());
                }
                this.bMinusOneANotMinimum.enter();
                return -a;
            }
            this.finalCase.enter();
            return a / b;
        }

        @Specialization
        public Object divEdgeCase(int a, int b) {
            if (b > 0) {
                this.bGreaterZero.enter();
                if (a >= 0) {
                    this.bGreaterZeroAGreaterEqualZero.enter();
                    return a / b;
                }
                this.bGreaterZeroALessZero.enter();
                return (a + 1) / b - 1;
            }
            if (a > 0) {
                this.aGreaterZero.enter();
                return (a - 1) / b - 1;
            }
            if (b == -1) {
                this.bMinusOne.enter();
                if (a == Integer.MIN_VALUE) {
                    this.bMinusOneAMinimum.enter();
                    return BigInteger.valueOf(a).negate();
                }
                this.bMinusOneANotMinimum.enter();
                return -a;
            }
            this.finalCase.enter();
            return a / b;
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object divCoerced(VirtualFrame frame, int a, DynamicObject b, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "redo_coerced :/, b", "b", b);
        }

        @Specialization(rewriteOn={UnexpectedResultException.class})
        public long div(long a, long b) throws UnexpectedResultException {
            if (b > 0L) {
                this.bGreaterZero.enter();
                if (a >= 0L) {
                    this.bGreaterZeroAGreaterEqualZero.enter();
                    return a / b;
                }
                this.bGreaterZeroALessZero.enter();
                return (a + 1L) / b - 1L;
            }
            if (a > 0L) {
                this.aGreaterZero.enter();
                return (a - 1L) / b - 1L;
            }
            if (b == -1L) {
                this.bMinusOne.enter();
                if (a == Long.MIN_VALUE) {
                    this.bMinusOneAMinimum.enter();
                    throw new UnexpectedResultException(BigInteger.valueOf(a).negate());
                }
                this.bMinusOneANotMinimum.enter();
                return -a;
            }
            this.finalCase.enter();
            return a / b;
        }

        @Specialization
        public Object divEdgeCase(long a, long b) {
            if (b > 0L) {
                this.bGreaterZero.enter();
                if (a >= 0L) {
                    this.bGreaterZeroAGreaterEqualZero.enter();
                    return a / b;
                }
                this.bGreaterZeroALessZero.enter();
                return (a + 1L) / b - 1L;
            }
            if (a > 0L) {
                this.aGreaterZero.enter();
                return (a - 1L) / b - 1L;
            }
            if (b == -1L) {
                this.bMinusOne.enter();
                if (a == Long.MIN_VALUE) {
                    this.bMinusOneAMinimum.enter();
                    return BigInteger.valueOf(a).negate();
                }
                this.bMinusOneANotMinimum.enter();
                return -a;
            }
            this.finalCase.enter();
            return a / b;
        }

        @Specialization
        public double div(long a, double b) {
            return (double)a / b;
        }

        @Specialization(guards={"!isLongMinValue(a)", "isRubyBignum(b)"})
        public int div(long a, DynamicObject b) {
            return 0;
        }

        @Specialization(guards={"isLongMinValue(a)", "isRubyBignum(b)"})
        public int divEdgeCase(long a, DynamicObject b) {
            return -Layouts.BIGNUM.getValue(b).signum();
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object divCoerced(VirtualFrame frame, long a, DynamicObject b, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "redo_coerced :/, b", "b", b);
        }

        public static boolean isLongMinValue(long a) {
            return a == Long.MIN_VALUE;
        }
    }

    @CoreMethod(names={"*"}, required=1)
    public static abstract class MulNode
    extends BignumNodes.BignumCoreMethodNode {
        @Specialization(rewriteOn={ArithmeticException.class})
        public int mul(int a, int b) {
            return ExactMath.multiplyExact(a, b);
        }

        @Specialization
        public long mulWithOverflow(int a, int b) {
            return (long)a * (long)b;
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object mulCoerced(VirtualFrame frame, int a, DynamicObject b, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "redo_coerced :*, b", "b", b);
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public long mul(long a, long b) {
            return ExactMath.multiplyExact(a, b);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object mulWithOverflow(long a, long b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).multiply(BigInteger.valueOf(b)));
        }

        @Specialization
        public double mul(long a, double b) {
            return (double)a * b;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyBignum(b)"})
        public Object mul(long a, DynamicObject b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).multiply(Layouts.BIGNUM.getValue(b)));
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object mulCoerced(VirtualFrame frame, long a, DynamicObject b, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "redo_coerced :*, b", "b", b);
        }
    }

    @CoreMethod(names={"-"}, required=1)
    public static abstract class SubNode
    extends BignumNodes.BignumCoreMethodNode {
        @Specialization(rewriteOn={ArithmeticException.class})
        public int sub(int a, int b) {
            return ExactMath.subtractExact(a, b);
        }

        @Specialization
        public long subWithOverflow(int a, int b) {
            return (long)a - (long)b;
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object subCoerced(VirtualFrame frame, int a, DynamicObject b, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "redo_coerced :-, b", "b", b);
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public long sub(long a, long b) {
            return ExactMath.subtractExact(a, b);
        }

        @Specialization
        public Object subWithOverflow(long a, long b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).subtract(BigInteger.valueOf(b)));
        }

        @Specialization
        public double sub(long a, double b) {
            return (double)a - b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Object sub(long a, DynamicObject b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).subtract(Layouts.BIGNUM.getValue(b)));
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object subCoerced(VirtualFrame frame, long a, DynamicObject b, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "redo_coerced :-, b", "b", b);
        }
    }

    @CoreMethod(names={"+"}, required=1)
    public static abstract class AddNode
    extends BignumNodes.BignumCoreMethodNode {
        @Specialization(rewriteOn={ArithmeticException.class})
        public int add(int a, int b) {
            return ExactMath.addExact(a, b);
        }

        @Specialization
        public long addWithOverflow(int a, int b) {
            return (long)a + (long)b;
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object addCoerced(VirtualFrame frame, int a, DynamicObject b, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "redo_coerced :+, b", "b", b);
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public long add(long a, long b) {
            return ExactMath.addExact(a, b);
        }

        @Specialization
        public Object addWithOverflow(long a, long b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).add(BigInteger.valueOf(b)));
        }

        @Specialization
        public double add(long a, double b) {
            return (double)a + b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Object add(long a, DynamicObject b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).add(Layouts.BIGNUM.getValue(b)));
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object addCoerced(VirtualFrame frame, long a, DynamicObject b, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "redo_coerced :+, b", "b", b);
        }
    }

    @CoreMethod(names={"-@"})
    public static abstract class NegNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private FixnumOrBignumNode fixnumOrBignumNode;

        @Specialization(rewriteOn={ArithmeticException.class})
        public int neg(int value) {
            return ExactMath.subtractExact(0, value);
        }

        @Specialization(contains={"neg"})
        public Object negWithOverflow(int value) {
            if (value == Integer.MIN_VALUE) {
                return -((long)value);
            }
            return -value;
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public long neg(long value) {
            return ExactMath.subtractExact(0L, value);
        }

        @Specialization
        public Object negWithOverflow(long value) {
            if (this.fixnumOrBignumNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.fixnumOrBignumNode = this.insert(new FixnumOrBignumNode(this.getContext(), this.getSourceSection()));
            }
            return this.fixnumOrBignumNode.fixnumOrBignum(BigInteger.valueOf(value).negate());
        }
    }
}

