/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.math.BigInteger;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.rubinius.RubiniusPrimitive;
import org.jruby.truffle.core.rubinius.RubiniusPrimitiveArrayArgumentsNode;

public abstract class BignumPrimitiveNodes {

    @RubiniusPrimitive(name="bignum_pow")
    public static abstract class BignumPowPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        private final ConditionProfile negativeProfile = ConditionProfile.createBinaryProfile();

        @Specialization
        public DynamicObject pow(DynamicObject a, int b) {
            return this.pow(a, (long)b);
        }

        @Specialization
        public DynamicObject pow(DynamicObject a, long b) {
            if (this.negativeProfile.profile(b < 0L)) {
                return null;
            }
            return this.createBignum(Layouts.BIGNUM.getValue(a).pow((int)b));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public double pow(DynamicObject a, double b) {
            return Math.pow(Layouts.BIGNUM.getValue(a).doubleValue(), b);
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Void pow(DynamicObject a, DynamicObject b) {
            throw new UnsupportedOperationException();
        }
    }

    @RubiniusPrimitive(name="bignum_compare")
    public static abstract class BignumCompareNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization
        public int compare(DynamicObject a, long b) {
            return Layouts.BIGNUM.getValue(a).compareTo(BigInteger.valueOf(b));
        }

        @Specialization(guards={"!isInfinity(b)"})
        public int compare(DynamicObject a, double b) {
            return Double.compare(Layouts.BIGNUM.getValue(a).doubleValue(), b);
        }

        @Specialization(guards={"isInfinity(b)"})
        public int compareInfinity(DynamicObject a, double b) {
            if (b < 0.0) {
                return 1;
            }
            return -1;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public int compare(DynamicObject a, DynamicObject b) {
            return Layouts.BIGNUM.getValue(a).compareTo(Layouts.BIGNUM.getValue(b));
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object compareFallback(DynamicObject a, DynamicObject b) {
            return null;
        }
    }
}

