/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.symbol;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.rope.LeafRope;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.util.ByteList;
import org.jruby.util.IdUtil;

public class SymbolTable {
    private final RubyContext context;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final WeakHashMap<Rope, WeakReference<DynamicObject>> symbolsTable = new WeakHashMap();
    private final WeakHashMap<String, WeakReference<DynamicObject>> symbolsTableByString = new WeakHashMap();

    public SymbolTable(RubyContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public DynamicObject getSymbol(String string) {
        DynamicObject symbol;
        this.lock.readLock().lock();
        try {
            WeakReference<DynamicObject> symbolReference = this.symbolsTableByString.get(string);
            if (symbolReference != null && (symbol = (DynamicObject)symbolReference.get()) != null) {
                DynamicObject dynamicObject = symbol;
                return dynamicObject;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        Rope rope = StringOperations.createRope(string, (Encoding)USASCIIEncoding.INSTANCE);
        symbol = this.getSymbol(rope);
        this.lock.writeLock().lock();
        try {
            this.symbolsTableByString.put(string, new WeakReference<DynamicObject>(symbol));
            DynamicObject dynamicObject = symbol;
            return dynamicObject;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public DynamicObject getSymbol(Rope rope) {
        DynamicObject symbol;
        WeakReference<DynamicObject> symbolReference;
        this.lock.readLock().lock();
        try {
            symbolReference = this.symbolsTable.get(rope);
            if (symbolReference != null && (symbol = (DynamicObject)symbolReference.get()) != null) {
                DynamicObject dynamicObject = symbol;
                return dynamicObject;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            symbolReference = this.symbolsTable.get(rope);
            if (symbolReference != null && (symbol = (DynamicObject)symbolReference.get()) != null) {
                DynamicObject dynamicObject = symbol;
                return dynamicObject;
            }
            DynamicObject symbolClass = this.context.getCoreLibrary().getSymbolClass();
            LeafRope flattenedRope = RopeOperations.flatten(rope);
            String string = ByteList.decode((byte[])flattenedRope.getBytes(), (int)0, (int)flattenedRope.byteLength(), (String)"ISO-8859-1");
            DynamicObject newSymbol = Layouts.SYMBOL.createSymbol(Layouts.CLASS.getInstanceFactory(symbolClass), string, flattenedRope, string.hashCode());
            this.symbolsTable.put(flattenedRope, new WeakReference<DynamicObject>(newSymbol));
            DynamicObject dynamicObject = newSymbol;
            return dynamicObject;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public Collection<DynamicObject> allSymbols() {
        Collection<WeakReference<DynamicObject>> symbolReferences;
        this.lock.readLock().lock();
        try {
            symbolReferences = this.symbolsTable.values();
        }
        finally {
            this.lock.readLock().unlock();
        }
        ArrayList<DynamicObject> symbols = new ArrayList<DynamicObject>(symbolReferences.size());
        for (WeakReference<DynamicObject> reference : symbolReferences) {
            DynamicObject symbol = (DynamicObject)reference.get();
            if (symbol == null) continue;
            symbols.add(symbol);
        }
        return symbols;
    }

    public static String checkInstanceVariableName(RubyContext context, String name, Node currentNode) {
        if (!name.startsWith("@") || name.length() <= 1 || !IdUtil.isInitialCharacter((int)name.charAt(1))) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(context.getCoreExceptions().nameErrorInstanceNameNotAllowable(name, currentNode));
        }
        return name;
    }

    public static String checkClassVariableName(RubyContext context, String name, Node currentNode) {
        if (!IdUtil.isValidClassVariableName((String)name)) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(context.getCoreExceptions().nameErrorInstanceNameNotAllowable(name, currentNode));
        }
        return name;
    }
}

