/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.CallBlock19;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaInternalBlockBody;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.InternalVariables;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.util.TypeConverter;

@JRubyModule(name={"Enumerable"})
public class RubyEnumerable {
    private static final int SORT_MAX = 1;
    private static final int SORT_MIN = -1;

    public static RubyModule createEnumerableModule(Ruby runtime) {
        RubyModule enumModule = runtime.defineModule("Enumerable");
        runtime.setEnumerable(enumModule);
        enumModule.defineAnnotatedMethods(RubyEnumerable.class);
        return enumModule;
    }

    public static IRubyObject callEach(Ruby runtime, ThreadContext context, IRubyObject self2, BlockCallback callback) {
        return Helpers.invoke(context, self2, "each", CallBlock.newCallClosure(self2, runtime.getEnumerable(), Signature.OPTIONAL, callback, context));
    }

    public static IRubyObject callEach19(Ruby runtime, ThreadContext context, IRubyObject self2, BlockCallback callback) {
        return Helpers.invoke(context, self2, "each", CallBlock19.newCallClosure(self2, runtime.getEnumerable(), Signature.OPTIONAL, callback, context));
    }

    @Deprecated
    public static IRubyObject callEach(Ruby runtime, ThreadContext context, IRubyObject self2, IRubyObject[] args2, BlockCallback callback) {
        return Helpers.invoke(context, self2, "each", args2, CallBlock.newCallClosure(self2, runtime.getEnumerable(), Signature.OPTIONAL, callback, context));
    }

    public static IRubyObject callEach(Ruby runtime, ThreadContext context, IRubyObject self2, Signature signature, BlockCallback callback) {
        return Helpers.invoke(context, self2, "each", CallBlock.newCallClosure(self2, runtime.getEnumerable(), signature, callback, context));
    }

    @Deprecated
    public static IRubyObject callEach(Ruby runtime, ThreadContext context, IRubyObject self2, Arity arity2, BlockCallback callback) {
        return Helpers.invoke(context, self2, "each", CallBlock.newCallClosure(self2, runtime.getEnumerable(), arity2, callback, context));
    }

    public static IRubyObject callEach19(Ruby runtime, ThreadContext context, IRubyObject self2, Signature signature, BlockCallback callback) {
        return Helpers.invoke(context, self2, "each", CallBlock19.newCallClosure(self2, runtime.getEnumerable(), signature, callback, context));
    }

    @Deprecated
    public static IRubyObject callEach19(Ruby runtime, ThreadContext context, IRubyObject self2, Arity arity2, BlockCallback callback) {
        return Helpers.invoke(context, self2, "each", CallBlock19.newCallClosure(self2, runtime.getEnumerable(), arity2, callback, context));
    }

    public static IRubyObject each(ThreadContext context, IRubyObject self2, BlockBody body) {
        Block block = new Block(body, context.currentBinding(self2, Visibility.PUBLIC));
        return Helpers.invoke(context, self2, "each", block);
    }

    @Deprecated
    public static IRubyObject callEach(Ruby runtime, ThreadContext context, IRubyObject self2, IRubyObject[] args2, Arity arity2, BlockCallback callback) {
        return Helpers.invoke(context, self2, "each", args2, CallBlock.newCallClosure(self2, runtime.getEnumerable(), arity2, callback, context));
    }

    public static IRubyObject callEach(Ruby runtime, ThreadContext context, IRubyObject self2, IRubyObject[] args2, Signature signature, BlockCallback callback) {
        return Helpers.invoke(context, self2, "each", args2, CallBlock.newCallClosure(self2, runtime.getEnumerable(), signature, callback, context));
    }

    private static void checkContext(ThreadContext firstContext, ThreadContext secondContext, String name2) {
        if (firstContext != secondContext) {
            throw secondContext.runtime.newThreadError("Enumerable#" + name2 + " cannot be parallelized");
        }
    }

    public static IRubyObject count18(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.count(context, self2, block);
    }

    @JRubyMethod(name={"count"})
    public static IRubyObject count(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.countCommon(context, self2, block);
    }

    private static IRubyObject countCommon(ThreadContext context, IRubyObject self2, final Block block) {
        Ruby runtime = context.runtime;
        final int[] result2 = new int[]{0};
        if (block.isGiven()) {
            RubyEnumerable.each(context, self2, new JavaInternalBlockBody(runtime, context, "Enumerable#count", block.getSignature()){

                @Override
                public IRubyObject yield(ThreadContext context, IRubyObject[] args2) {
                    IRubyObject packedArg = RubyEnumerable.packEnumValues(context.runtime, args2);
                    if (block.yield(context, packedArg).isTrue()) {
                        result2[0] = result2[0] + 1;
                    }
                    return context.nil;
                }
            });
        } else {
            RubyEnumerable.each(context, self2, new JavaInternalBlockBody(runtime, context, "Enumerable#count", Signature.NO_ARGUMENTS){

                @Override
                public IRubyObject yield(ThreadContext context, IRubyObject[] unusedValue) {
                    result2[0] = result2[0] + 1;
                    return context.nil;
                }
            });
        }
        return RubyFixnum.newFixnum(runtime, result2[0]);
    }

    public static IRubyObject count18(ThreadContext context, IRubyObject self2, IRubyObject methodArg, Block block) {
        return RubyEnumerable.count(context, self2, methodArg, block);
    }

    @JRubyMethod(name={"count"})
    public static IRubyObject count(ThreadContext context, IRubyObject self2, final IRubyObject methodArg, Block block) {
        final Ruby runtime = context.runtime;
        final int[] result2 = new int[]{0};
        if (block.isGiven()) {
            runtime.getWarnings().warn(IRubyWarnings.ID.BLOCK_UNUSED, "given block not used");
        }
        RubyEnumerable.each(context, self2, new JavaInternalBlockBody(runtime, context, "Enumerable#count", Signature.ONE_REQUIRED){

            @Override
            public IRubyObject yield(ThreadContext context, IRubyObject[] args2) {
                IRubyObject packedArg = RubyEnumerable.packEnumValues(context.runtime, args2);
                if (packedArg.equals(methodArg)) {
                    result2[0] = result2[0] + 1;
                }
                return runtime.getNil();
            }
        });
        return RubyFixnum.newFixnum(runtime, result2[0]);
    }

    @JRubyMethod
    public static IRubyObject cycle(ThreadContext context, IRubyObject self2, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, self2, "cycle", RubyEnumerable.cycleSizeFn(context, self2));
        }
        return RubyEnumerable.cycleCommon(context, self2, -1L, block);
    }

    @JRubyMethod
    public static IRubyObject cycle(ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        if (arg2.isNil()) {
            return RubyEnumerable.cycle(context, self2, block);
        }
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, self2, "cycle", new IRubyObject[]{arg2}, RubyEnumerable.cycleSizeFn(context, self2));
        }
        long times2 = RubyNumeric.num2long(arg2);
        if (times2 <= 0L) {
            return context.nil;
        }
        return RubyEnumerable.cycleCommon(context, self2, times2, block);
    }

    private static IRubyObject cycleCommon(ThreadContext context, IRubyObject self2, long nv, final Block block) {
        Ruby runtime = context.runtime;
        final RubyArray result2 = runtime.newArray();
        RubyEnumerable.each(context, self2, new JavaInternalBlockBody(runtime, Signature.OPTIONAL){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IRubyObject yield(ThreadContext context, IRubyObject[] args2) {
                IRubyObject packedArg = RubyEnumerable.packEnumValues(context.runtime, args2);
                RubyArray rubyArray = result2;
                synchronized (rubyArray) {
                    result2.append(packedArg);
                }
                block.yield(context, packedArg);
                return context.nil;
            }
        });
        int length2 = result2.size();
        if (length2 == 0) {
            return context.nil;
        }
        while (nv < 0L || 0L < --nv) {
            for (int i2 = 0; i2 < length2; ++i2) {
                block.yield(context, result2.eltInternal(i2));
            }
        }
        return context.nil;
    }

    private static RubyEnumerator.SizeFn cycleSizeFn(final ThreadContext context, final IRubyObject self2) {
        return new RubyEnumerator.SizeFn(){

            @Override
            public IRubyObject size(IRubyObject[] args2) {
                Ruby runtime = context.runtime;
                IRubyObject n = runtime.getNil();
                IRubyObject size2 = RubyEnumerable.enumSizeFn(context, self2).size(args2);
                if (size2 == null || size2.isNil()) {
                    return runtime.getNil();
                }
                if (args2 != null && args2.length > 0) {
                    n = args2[0];
                }
                if (n == null || n.isNil()) {
                    return RubyFloat.newFloat(runtime, Double.POSITIVE_INFINITY);
                }
                long multiple = RubyNumeric.num2long(n);
                if (multiple <= 0L) {
                    return RubyFixnum.zero(runtime);
                }
                return size2.callMethod(context, "*", RubyFixnum.newFixnum(runtime, multiple));
            }
        };
    }

    @JRubyMethod(name={"take"})
    public static IRubyObject take(ThreadContext context, IRubyObject self2, IRubyObject n, Block block) {
        Ruby runtime = context.runtime;
        final long len = RubyNumeric.num2long(n);
        if (len < 0L) {
            throw runtime.newArgumentError("attempt to take negative size");
        }
        if (len == 0L) {
            return runtime.newEmptyArray();
        }
        final RubyArray result2 = runtime.newArray();
        try {
            RubyEnumerable.each(context, self2, new JavaInternalBlockBody(runtime, Signature.ONE_REQUIRED){
                long i;
                {
                    super(x0, x1);
                    this.i = len;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject yield(ThreadContext context, IRubyObject[] args2) {
                    RubyArray rubyArray = result2;
                    synchronized (rubyArray) {
                        IRubyObject packedArg = RubyEnumerable.packEnumValues(context, args2);
                        result2.append(packedArg);
                        if (--this.i == 0L) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                    }
                    return context.nil;
                }
            });
        }
        catch (JumpException.SpecialJump e) {
            // empty catch block
        }
        return result2;
    }

    @JRubyMethod(name={"take_while"})
    public static IRubyObject take_while19(ThreadContext context, IRubyObject self2, final Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, self2, "take_while");
        }
        Ruby runtime = context.runtime;
        final RubyArray result2 = runtime.newArray();
        try {
            RubyEnumerable.callEach(runtime, context, self2, Signature.OPTIONAL, new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject val;
                    IRubyObject larg;
                    boolean ary = false;
                    switch (largs.length) {
                        case 0: {
                            larg = ctx.nil;
                            break;
                        }
                        case 1: {
                            larg = largs[0];
                            break;
                        }
                        default: {
                            larg = RubyArray.newArrayNoCopy(ctx.runtime, largs);
                            ary = true;
                        }
                    }
                    IRubyObject iRubyObject = val = ary ? block.yieldArray(ctx, larg, null) : block.yield(ctx, larg);
                    if (!val.isTrue()) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    RubyArray rubyArray = result2;
                    synchronized (rubyArray) {
                        result2.append(larg);
                    }
                    return ctx.nil;
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            // empty catch block
        }
        return result2;
    }

    @JRubyMethod(name={"drop"})
    public static IRubyObject drop(ThreadContext context, IRubyObject self2, IRubyObject n, Block block) {
        Ruby runtime = context.runtime;
        final long len = RubyNumeric.num2long(n);
        if (len < 0L) {
            throw runtime.newArgumentError("attempt to drop negative size");
        }
        final RubyArray result2 = runtime.newArray();
        try {
            RubyEnumerable.each(context, self2, new JavaInternalBlockBody(runtime, Signature.NO_ARGUMENTS){
                long i;
                {
                    super(x0, x1);
                    this.i = len;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject yield(ThreadContext context, IRubyObject[] args2) {
                    IRubyObject packedArg = RubyEnumerable.packEnumValues(context.runtime, args2);
                    RubyArray rubyArray = result2;
                    synchronized (rubyArray) {
                        if (this.i == 0L) {
                            result2.append(packedArg.isImmediate() ? packedArg : packedArg.dup());
                        } else {
                            --this.i;
                        }
                    }
                    return context.nil;
                }
            });
        }
        catch (JumpException.SpecialJump e) {
            // empty catch block
        }
        return result2;
    }

    @JRubyMethod
    public static IRubyObject drop_while(ThreadContext context, IRubyObject self2, final Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, self2, "drop_while");
        }
        final Ruby runtime = context.runtime;
        final RubyArray result2 = runtime.newArray();
        try {
            RubyEnumerable.each(context, self2, new JavaInternalBlockBody(runtime, context, "Enumerable#drop_while", Signature.OPTIONAL){
                boolean memo;
                {
                    super(x0, x1, x2, x3);
                    this.memo = false;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject yield(ThreadContext context, IRubyObject[] args2) {
                    IRubyObject packedArg = RubyEnumerable.packEnumValues(context.runtime, args2);
                    if (!this.memo && !block.yield(context, packedArg).isTrue()) {
                        this.memo = true;
                    }
                    if (this.memo) {
                        RubyArray rubyArray = result2;
                        synchronized (rubyArray) {
                            result2.append(packedArg);
                        }
                    }
                    return runtime.getNil();
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            // empty catch block
        }
        return result2;
    }

    @JRubyMethod(name={"first"})
    public static IRubyObject first(ThreadContext context, IRubyObject self2) {
        final IRubyObject[] holder = new IRubyObject[]{context.nil};
        try {
            RubyEnumerable.each(context, self2, new JavaInternalBlockBody(context.runtime, context, null, Signature.ONE_REQUIRED){

                @Override
                public IRubyObject yield(ThreadContext context, IRubyObject[] args2) {
                    IRubyObject packedArg;
                    holder[0] = packedArg = RubyEnumerable.packEnumValues(context.runtime, args2);
                    throw JumpException.SPECIAL_JUMP;
                }
            });
        }
        catch (JumpException.SpecialJump specialJump) {
            // empty catch block
        }
        return holder[0];
    }

    @JRubyMethod(name={"first"})
    public static IRubyObject first(ThreadContext context, IRubyObject self2, final IRubyObject num) {
        int firstCount = RubyNumeric.fix2int(num);
        Ruby runtime = context.runtime;
        final RubyArray result2 = runtime.newArray();
        if (firstCount < 0) {
            throw runtime.newArgumentError("negative index");
        }
        if (firstCount == 0) {
            return result2;
        }
        try {
            RubyEnumerable.each(context, self2, new JavaInternalBlockBody(runtime, context, null, Signature.ONE_REQUIRED){
                private int iter;
                {
                    super(x0, x1, x2, x3);
                    this.iter = RubyNumeric.fix2int(num);
                }

                @Override
                public IRubyObject yield(ThreadContext context, IRubyObject[] args2) {
                    IRubyObject packedArg = RubyEnumerable.packEnumValues(context.runtime, args2);
                    result2.append(packedArg);
                    if (this.iter-- == 1) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    return context.nil;
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            // empty catch block
        }
        return result2;
    }

    public static IRubyObject to_a(ThreadContext context, IRubyObject self2) {
        return RubyEnumerable.to_a19(context, self2);
    }

    public static IRubyObject to_a(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        return RubyEnumerable.to_a19(context, self2, args2);
    }

    @JRubyMethod(name={"to_a", "entries"})
    public static IRubyObject to_a19(ThreadContext context, IRubyObject self2) {
        Ruby runtime = context.runtime;
        RubyArray result2 = runtime.newArray();
        RubyEnumerable.callEach(runtime, context, self2, Signature.OPTIONAL, (BlockCallback)new AppendBlockCallback(runtime, result2));
        result2.infectBy(self2);
        return result2;
    }

    @JRubyMethod(name={"to_a", "entries"}, rest=true)
    public static IRubyObject to_a19(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        RubyArray result2 = runtime.newArray();
        Helpers.invoke(context, self2, "each", args2, CallBlock.newCallClosure(self2, runtime.getEnumerable(), Signature.OPTIONAL, (BlockCallback)new AppendBlockCallback(runtime, result2), context));
        result2.infectBy(self2);
        return result2;
    }

    @JRubyMethod(name={"to_h"}, rest=true)
    public static IRubyObject to_h(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        RubyHash result2 = RubyHash.newHash(runtime);
        Helpers.invoke(context, self2, "each", args2, CallBlock.newCallClosure(self2, runtime.getEnumerable(), Signature.OPTIONAL, (BlockCallback)new PutKeyValueCallback(runtime, result2), context));
        result2.infectBy(self2);
        return result2;
    }

    @JRubyMethod
    public static IRubyObject sort(ThreadContext context, IRubyObject self2, Block block) {
        Ruby runtime = context.runtime;
        RubyArray result2 = runtime.newArray();
        RubyEnumerable.callEach(runtime, context, self2, Signature.OPTIONAL, (BlockCallback)new AppendBlockCallback(runtime, result2));
        result2.sort_bang(context, block);
        return result2;
    }

    @JRubyMethod
    public static IRubyObject sort_by(final ThreadContext context, IRubyObject self2, final Block block) {
        IRubyObject[][] valuesAndCriteria;
        Ruby runtime = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, self2, "sort_by", RubyEnumerable.enumSizeFn(context, self2));
        }
        if (self2 instanceof RubyArray) {
            RubyArray selfArray = (RubyArray)self2;
            final IRubyObject[][] valuesAndCriteriaArray = new IRubyObject[selfArray.size()][2];
            RubyEnumerable.each(context, self2, new JavaInternalBlockBody(runtime, Signature.OPTIONAL){
                AtomicInteger i;
                {
                    super(x0, x1);
                    this.i = new AtomicInteger(0);
                }

                @Override
                public IRubyObject yield(ThreadContext context, IRubyObject[] args2) {
                    IRubyObject packedArg = RubyEnumerable.packEnumValues(context.runtime, args2);
                    IRubyObject[] myVandC = valuesAndCriteriaArray[this.i.getAndIncrement()];
                    myVandC[0] = packedArg;
                    myVandC[1] = block.yield(context, packedArg);
                    return context.nil;
                }
            });
            valuesAndCriteria = valuesAndCriteriaArray;
        } else {
            final ArrayList valuesAndCriteriaList = new ArrayList();
            RubyEnumerable.callEach(runtime, context, self2, Signature.OPTIONAL, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                    IRubyObject[] myVandC = new IRubyObject[]{larg, block.yield(ctx, larg)};
                    valuesAndCriteriaList.add(myVandC);
                    return ctx.nil;
                }
            });
            valuesAndCriteria = (IRubyObject[][])valuesAndCriteriaList.toArray((T[])new IRubyObject[valuesAndCriteriaList.size()][]);
        }
        Arrays.sort(valuesAndCriteria, new Comparator<IRubyObject[]>(){

            @Override
            public int compare(IRubyObject[] o1, IRubyObject[] o2) {
                return RubyComparable.cmpint(context, Helpers.invokedynamic(context, o1[1], MethodNames.OP_CMP, o2[1]), o1[1], o2[1]);
            }
        });
        IRubyObject[] dstArray = new IRubyObject[valuesAndCriteria.length];
        for (int i2 = 0; i2 < dstArray.length; ++i2) {
            dstArray[i2] = valuesAndCriteria[i2][0];
        }
        return runtime.newArrayNoCopy(dstArray);
    }

    @JRubyMethod
    public static IRubyObject grep(ThreadContext context, IRubyObject self2, IRubyObject pattern, Block block) {
        return RubyEnumerable.grep(context, self2, pattern, block, true);
    }

    @JRubyMethod(name={"grep_v"})
    public static IRubyObject inverseGrep(ThreadContext context, IRubyObject self2, IRubyObject pattern, Block block) {
        return RubyEnumerable.grep(context, self2, pattern, block, false);
    }

    private static IRubyObject grep(ThreadContext context, IRubyObject self2, final IRubyObject pattern, final Block block, final boolean isPresent) {
        Ruby runtime = context.runtime;
        final RubyArray result2 = runtime.newArray();
        if (block.isGiven()) {
            RubyEnumerable.callEach(runtime, context, self2, Signature.ONE_REQUIRED, new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                    if (pattern.callMethod(ctx, "===", larg).isTrue() == isPresent) {
                        IRubyObject value2 = block.yield(ctx, larg);
                        RubyArray rubyArray = result2;
                        synchronized (rubyArray) {
                            result2.append(value2);
                        }
                    }
                    return ctx.nil;
                }
            });
        } else {
            RubyEnumerable.callEach(runtime, context, self2, Signature.ONE_REQUIRED, new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                    if (pattern.callMethod(ctx, "===", larg).isTrue() == isPresent) {
                        RubyArray rubyArray = result2;
                        synchronized (rubyArray) {
                            result2.append(larg);
                        }
                    }
                    return ctx.nil;
                }
            });
        }
        return result2;
    }

    public static IRubyObject detectCommon(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.detectCommon(context, self2, null, block);
    }

    public static IRubyObject detectCommon(final ThreadContext context, IRubyObject self2, IRubyObject ifnone, final Block block) {
        Ruby runtime = context.runtime;
        final IRubyObject[] result2 = new IRubyObject[]{null};
        try {
            RubyEnumerable.callEach(runtime, context, self2, Signature.OPTIONAL, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                    RubyEnumerable.checkContext(context, ctx, "detect/find");
                    if (block.yield(ctx, larg).isTrue()) {
                        result2[0] = larg;
                        throw JumpException.SPECIAL_JUMP;
                    }
                    return ctx.nil;
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            return result2[0];
        }
        return ifnone != null ? ifnone.callMethod(context, "call") : runtime.getNil();
    }

    @JRubyMethod
    public static IRubyObject detect(ThreadContext context, IRubyObject self2, Block block) {
        boolean blockGiven = block.isGiven();
        if (self2 instanceof RubyArray && blockGiven) {
            return ((RubyArray)self2).find(context, null, block);
        }
        return block.isGiven() ? RubyEnumerable.detectCommon(context, self2, block) : RubyEnumerator.enumeratorize(context.runtime, self2, "detect");
    }

    @JRubyMethod
    public static IRubyObject detect(ThreadContext context, IRubyObject self2, IRubyObject ifnone, Block block) {
        boolean blockGiven = block.isGiven();
        if (self2 instanceof RubyArray && blockGiven) {
            return ((RubyArray)self2).find(context, ifnone, block);
        }
        return block.isGiven() ? RubyEnumerable.detectCommon(context, self2, ifnone, block) : RubyEnumerator.enumeratorize(context.runtime, self2, "detect", ifnone);
    }

    @JRubyMethod
    public static IRubyObject find(ThreadContext context, IRubyObject self2, Block block) {
        boolean blockGiven = block.isGiven();
        if (self2 instanceof RubyArray && blockGiven) {
            return ((RubyArray)self2).find(context, null, block);
        }
        return blockGiven ? RubyEnumerable.detectCommon(context, self2, block) : RubyEnumerator.enumeratorize(context.runtime, self2, "find");
    }

    @JRubyMethod
    public static IRubyObject find(ThreadContext context, IRubyObject self2, IRubyObject ifnone, Block block) {
        boolean blockGiven = block.isGiven();
        if (self2 instanceof RubyArray && blockGiven) {
            return ((RubyArray)self2).find(context, ifnone, block);
        }
        return blockGiven ? RubyEnumerable.detectCommon(context, self2, ifnone, block) : RubyEnumerator.enumeratorize(context.runtime, self2, "find", ifnone);
    }

    @JRubyMethod(name={"find_index"})
    public static IRubyObject find_index19(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.find_index(context, self2, block);
    }

    public static IRubyObject find_index(ThreadContext context, IRubyObject self2, Block block) {
        boolean blockGiven = block.isGiven();
        if (self2 instanceof RubyArray && blockGiven) {
            return ((RubyArray)self2).find_index(context, block);
        }
        return blockGiven ? RubyEnumerable.find_indexCommon(context, self2, block, block.getSignature()) : RubyEnumerator.enumeratorize(context.runtime, self2, "find_index");
    }

    @Deprecated
    public static IRubyObject find_index(ThreadContext context, IRubyObject self2, Block block, Arity callbackArity) {
        boolean blockGiven = block.isGiven();
        if (self2 instanceof RubyArray && blockGiven) {
            return ((RubyArray)self2).find_index(context, block);
        }
        return blockGiven ? RubyEnumerable.find_indexCommon(context, self2, block, callbackArity) : RubyEnumerator.enumeratorize(context.runtime, self2, "find_index");
    }

    @JRubyMethod(name={"find_index"})
    public static IRubyObject find_index19(ThreadContext context, IRubyObject self2, IRubyObject cond, Block block) {
        return RubyEnumerable.find_index(context, self2, cond, block);
    }

    public static IRubyObject find_index(ThreadContext context, IRubyObject self2, IRubyObject cond, Block block) {
        Ruby runtime = context.runtime;
        if (block.isGiven()) {
            runtime.getWarnings().warn(IRubyWarnings.ID.BLOCK_UNUSED, "given block not used");
        }
        if (self2 instanceof RubyArray) {
            return ((RubyArray)self2).find_index(context, cond);
        }
        return RubyEnumerable.find_indexCommon(context, self2, cond);
    }

    public static IRubyObject find_indexCommon(ThreadContext context, IRubyObject self2, final Block block, Signature callbackArity) {
        final Ruby runtime = context.runtime;
        final long[] result2 = new long[]{0L};
        try {
            RubyEnumerable.callEach(runtime, context, self2, callbackArity, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.packEnumValues(runtime, largs);
                    if (block.yield(ctx, larg).isTrue()) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    result2[0] = result2[0] + 1L;
                    return runtime.getNil();
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            return RubyFixnum.newFixnum(runtime, result2[0]);
        }
        return runtime.getNil();
    }

    @Deprecated
    public static IRubyObject find_indexCommon(ThreadContext context, IRubyObject self2, final Block block, Arity callbackArity) {
        Ruby runtime = context.runtime;
        final long[] result2 = new long[]{0L};
        try {
            RubyEnumerable.callEach(runtime, context, self2, callbackArity, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                    if (block.yield(ctx, larg).isTrue()) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    result2[0] = result2[0] + 1L;
                    return ctx.nil;
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            return RubyFixnum.newFixnum(runtime, result2[0]);
        }
        return context.nil;
    }

    public static IRubyObject find_indexCommon(ThreadContext context, IRubyObject self2, final IRubyObject cond) {
        Ruby runtime = context.runtime;
        final long[] result2 = new long[]{0L};
        try {
            RubyEnumerable.callEach(runtime, context, self2, Signature.ONE_ARGUMENT, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                    if (RubyObject.equalInternal(ctx, larg, cond)) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    result2[0] = result2[0] + 1L;
                    return ctx.nil;
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            return RubyFixnum.newFixnum(runtime, result2[0]);
        }
        return context.nil;
    }

    public static IRubyObject selectCommon(ThreadContext context, IRubyObject self2, final Block block, String methodName) {
        Ruby runtime = context.runtime;
        final RubyArray result2 = runtime.newArray();
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, self2, methodName, RubyEnumerable.enumSizeFn(context, self2));
        }
        RubyEnumerable.callEach(runtime, context, self2, Signature.OPTIONAL, new BlockCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                if (block.yield(ctx, larg).isTrue()) {
                    RubyArray rubyArray = result2;
                    synchronized (rubyArray) {
                        result2.append(larg);
                    }
                }
                return ctx.nil;
            }
        });
        return result2;
    }

    @JRubyMethod
    public static IRubyObject select(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.selectCommon(context, self2, block, "select");
    }

    @JRubyMethod
    public static IRubyObject find_all(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.selectCommon(context, self2, block, "find_all");
    }

    @JRubyMethod
    public static IRubyObject reject(ThreadContext context, IRubyObject self2, final Block block) {
        Ruby runtime = context.runtime;
        final RubyArray result2 = runtime.newArray();
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, self2, "reject", RubyEnumerable.enumSizeFn(context, self2));
        }
        RubyEnumerable.callEach(runtime, context, self2, Signature.OPTIONAL, new BlockCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                if (!block.yield(ctx, larg).isTrue()) {
                    RubyArray rubyArray = result2;
                    synchronized (rubyArray) {
                        result2.append(larg);
                    }
                }
                return ctx.nil;
            }
        });
        return result2;
    }

    @JRubyMethod(name={"collect"})
    public static IRubyObject collect19(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.collectCommon19(context, self2, block, "collect");
    }

    @JRubyMethod(name={"map"})
    public static IRubyObject map19(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.collectCommon19(context, self2, block, "map");
    }

    private static IRubyObject collectCommon19(ThreadContext context, IRubyObject self2, final Block block, String methodName) {
        Ruby runtime = context.runtime;
        if (block.isGiven()) {
            final RubyArray result2 = runtime.newArray();
            RubyEnumerable.callEach19(runtime, context, self2, block.getSignature(), new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg;
                    boolean ary = false;
                    switch (largs.length) {
                        case 0: {
                            larg = ctx.nil;
                            break;
                        }
                        case 1: {
                            larg = largs[0];
                            break;
                        }
                        default: {
                            larg = RubyArray.newArrayNoCopy(ctx.runtime, largs);
                            ary = true;
                        }
                    }
                    IRubyObject val = ary ? block.yieldArray(ctx, larg, null) : block.yield(ctx, larg);
                    RubyArray rubyArray = result2;
                    synchronized (rubyArray) {
                        result2.append(val);
                    }
                    return ctx.nil;
                }
            });
            return result2;
        }
        return RubyEnumerator.enumeratorizeWithSize(context, self2, methodName, RubyEnumerable.enumSizeFn(context, self2));
    }

    public static IRubyObject collectCommon(ThreadContext context, Ruby runtime, IRubyObject self2, RubyArray result2, Block block, BlockCallback blockCallback) {
        RubyEnumerable.callEach(runtime, context, self2, Signature.ONE_ARGUMENT, blockCallback);
        return result2;
    }

    @JRubyMethod(name={"flat_map"})
    public static IRubyObject flat_map19(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.flatMapCommon19(context, self2, block, "flat_map");
    }

    @JRubyMethod(name={"collect_concat"})
    public static IRubyObject collect_concat19(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.flatMapCommon19(context, self2, block, "collect_concat");
    }

    private static IRubyObject flatMapCommon19(ThreadContext context, IRubyObject self2, final Block block, String methodName) {
        Ruby runtime = context.runtime;
        if (block.isGiven()) {
            final RubyArray ary = runtime.newArray();
            RubyEnumerable.callEach(runtime, context, self2, block.getSignature(), new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                    IRubyObject i2 = block.yield(ctx, larg);
                    IRubyObject tmp = i2.checkArrayType();
                    RubyArray rubyArray = ary;
                    synchronized (rubyArray) {
                        if (tmp.isNil()) {
                            ary.append(i2);
                        } else {
                            ary.concat(tmp);
                        }
                    }
                    return ctx.nil;
                }
            });
            return ary;
        }
        return RubyEnumerator.enumeratorizeWithSize(context, self2, methodName, RubyEnumerable.enumSizeFn(context, self2));
    }

    public static IRubyObject injectCommon(final ThreadContext context, IRubyObject self2, IRubyObject init, final Block block) {
        final Ruby runtime = context.runtime;
        final IRubyObject[] result2 = new IRubyObject[]{init};
        RubyEnumerable.callEach(runtime, context, self2, Signature.OPTIONAL, new BlockCallback(){

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                RubyEnumerable.checkContext(context, ctx, "inject");
                result2[0] = result2[0] == null ? larg : block.yieldArray(ctx, runtime.newArray(result2[0], larg), null);
                return ctx.nil;
            }
        });
        return result2[0] == null ? runtime.getNil() : result2[0];
    }

    @JRubyMethod(name={"inject", "reduce"})
    public static IRubyObject inject(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.injectCommon(context, self2, null, block);
    }

    @JRubyMethod(name={"inject", "reduce"})
    public static IRubyObject inject(ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        return block.isGiven() ? RubyEnumerable.injectCommon(context, self2, arg2, block) : RubyEnumerable.inject(context, self2, null, arg2, block);
    }

    @JRubyMethod(name={"inject", "reduce"})
    public static IRubyObject inject(ThreadContext context, IRubyObject self2, IRubyObject init, IRubyObject method, Block block) {
        Ruby runtime = context.runtime;
        if (block.isGiven()) {
            runtime.getWarnings().warn(IRubyWarnings.ID.BLOCK_UNUSED, "given block not used");
        }
        final String methodId = method.asJavaString();
        final IRubyObject[] result2 = new IRubyObject[]{init};
        RubyEnumerable.callEach(runtime, context, self2, Signature.OPTIONAL, new BlockCallback(){

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                result2[0] = result2[0] == null ? larg : result2[0].callMethod(ctx, methodId, larg);
                return ctx.nil;
            }
        });
        return result2[0] == null ? runtime.getNil() : result2[0];
    }

    @JRubyMethod
    public static IRubyObject partition(ThreadContext context, IRubyObject self2, final Block block) {
        Ruby runtime = context.runtime;
        final RubyArray arr_true = runtime.newArray();
        final RubyArray arr_false = runtime.newArray();
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, self2, "partition", RubyEnumerable.enumSizeFn(context, self2));
        }
        RubyEnumerable.callEach(runtime, context, self2, Signature.OPTIONAL, new BlockCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                if (block.yield(ctx, larg).isTrue()) {
                    RubyArray rubyArray = arr_true;
                    synchronized (rubyArray) {
                        arr_true.append(larg);
                    }
                }
                RubyArray rubyArray = arr_false;
                synchronized (rubyArray) {
                    arr_false.append(larg);
                }
                return ctx.nil;
            }
        });
        return runtime.newArray((IRubyObject)arr_true, (IRubyObject)arr_false);
    }

    private static IRubyObject packEnumValues(Ruby runtime, IRubyObject[] args2) {
        if (args2.length < 2) {
            return args2.length == 0 ? runtime.getNil() : args2[0];
        }
        return runtime.newArrayNoCopy(args2);
    }

    static IRubyObject packEnumValues(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return context.nil;
            }
            case 1: {
                return args2[0];
            }
        }
        return RubyArray.newArrayNoCopy(context.runtime, args2);
    }

    public static IRubyObject each_with_indexCommon(ThreadContext context, IRubyObject self2, Block block) {
        RubyEnumerable.callEach(context.runtime, context, self2, Signature.OPTIONAL, (BlockCallback)new EachWithIndex(block));
        return self2;
    }

    public static IRubyObject each_with_indexCommon19(ThreadContext context, IRubyObject self2, Block block, IRubyObject[] args2) {
        RubyEnumerable.callEach(context.runtime, context, self2, args2, Signature.OPTIONAL, (BlockCallback)new EachWithIndex(block));
        return self2;
    }

    public static IRubyObject each_with_objectCommon19(ThreadContext context, IRubyObject self2, final Block block, final IRubyObject arg2) {
        Ruby runtime = context.runtime;
        RubyEnumerable.callEach(runtime, context, self2, Signature.OPTIONAL, new BlockCallback(){

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                return block.call(ctx, RubyEnumerable.packEnumValues(ctx, largs), arg2);
            }
        });
        return arg2;
    }

    public static IRubyObject each_with_index(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.each_with_index19(context, self2, IRubyObject.NULL_ARRAY, block);
    }

    @JRubyMethod(name={"each_with_index"}, rest=true)
    public static IRubyObject each_with_index19(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_with_indexCommon19(context, self2, block, args2) : RubyEnumerator.enumeratorizeWithSize(context, self2, "each_with_index", args2, RubyEnumerable.enumSizeFn(context, self2));
    }

    @JRubyMethod(required=1)
    public static IRubyObject each_with_object(ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_with_objectCommon19(context, self2, block, arg2) : RubyEnumerator.enumeratorizeWithSize(context, self2, "each_with_object", new IRubyObject[]{arg2}, RubyEnumerable.enumSizeFn(context, self2));
    }

    @JRubyMethod(rest=true)
    public static IRubyObject each_entry(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_entryCommon(context, self2, args2, block) : RubyEnumerator.enumeratorizeWithSize(context, self2, "each_entry", args2, RubyEnumerable.enumSizeFn(context, self2));
    }

    public static IRubyObject each_entryCommon(ThreadContext context, IRubyObject self2, IRubyObject[] args2, final Block block) {
        RubyEnumerable.callEach(context.runtime, context, self2, args2, Signature.OPTIONAL, new BlockCallback(){

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                return block.yieldSpecific(ctx, RubyEnumerable.packEnumValues(ctx, largs));
            }
        });
        return self2;
    }

    public static IRubyObject each_slice(ThreadContext context, IRubyObject self2, IRubyObject arg2, final Block block) {
        final int size2 = RubyNumeric.num2int(arg2);
        final Ruby runtime = context.runtime;
        if (size2 <= 0) {
            throw runtime.newArgumentError("invalid slice size");
        }
        final RubyArray[] result2 = new RubyArray[]{runtime.newArray(size2)};
        RubyEnumerable.callEach(runtime, context, self2, Signature.OPTIONAL, new BlockCallback(){

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                result2[0].append(RubyEnumerable.packEnumValues(ctx, largs));
                if (result2[0].size() == size2) {
                    block.yield(ctx, result2[0]);
                    result2[0] = runtime.newArray(size2);
                }
                return ctx.nil;
            }
        });
        if (result2[0].size() > 0) {
            block.yield(context, result2[0]);
        }
        return context.nil;
    }

    @JRubyMethod(name={"each_slice"})
    public static IRubyObject each_slice19(ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_slice(context, self2, arg2, block) : RubyEnumerator.enumeratorizeWithSize(context, self2, "each_slice", new IRubyObject[]{arg2}, RubyEnumerable.eachSliceSizeFn(context, self2));
    }

    private static RubyEnumerator.SizeFn eachSliceSizeFn(final ThreadContext context, final IRubyObject self2) {
        return new RubyEnumerator.SizeFn(){

            @Override
            public IRubyObject size(IRubyObject[] args2) {
                Ruby runtime = context.runtime;
                assert (args2 != null && args2.length > 0 && args2[0] instanceof RubyNumeric);
                long sliceSize = ((RubyNumeric)args2[0]).getLongValue();
                if (sliceSize <= 0L) {
                    throw runtime.newArgumentError("invalid slice size");
                }
                IRubyObject size2 = RubyEnumerable.enumSizeFn(context, self2).size(args2);
                if (size2 == null || size2.isNil()) {
                    return runtime.getNil();
                }
                IRubyObject n = size2.callMethod(context, "+", RubyFixnum.newFixnum(runtime, sliceSize - 1L));
                return n.callMethod(context, "/", RubyFixnum.newFixnum(runtime, sliceSize));
            }
        };
    }

    public static IRubyObject each_cons(ThreadContext context, IRubyObject self2, IRubyObject arg2, final Block block) {
        final int size2 = (int)RubyNumeric.num2long(arg2);
        Ruby runtime = context.runtime;
        if (size2 <= 0) {
            throw runtime.newArgumentError("invalid size");
        }
        final RubyArray result2 = runtime.newArray(size2);
        RubyEnumerable.callEach(runtime, context, self2, Signature.OPTIONAL, new BlockCallback(){

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                if (result2.size() == size2) {
                    result2.shift(ctx);
                }
                result2.append(RubyEnumerable.packEnumValues(ctx, largs));
                if (result2.size() == size2) {
                    block.yield(ctx, result2.aryDup());
                }
                return ctx.nil;
            }
        });
        return context.nil;
    }

    @JRubyMethod(name={"each_cons"})
    public static IRubyObject each_cons19(ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_cons(context, self2, arg2, block) : RubyEnumerator.enumeratorizeWithSize(context, self2, "each_cons", new IRubyObject[]{arg2}, RubyEnumerable.eachConsSizeFn(context, self2));
    }

    private static RubyEnumerator.SizeFn eachConsSizeFn(final ThreadContext context, final IRubyObject self2) {
        return new RubyEnumerator.SizeFn(){

            @Override
            public IRubyObject size(IRubyObject[] args2) {
                RubyFixnum zero;
                Ruby runtime = context.runtime;
                assert (args2 != null && args2.length > 0 && args2[0] instanceof RubyNumeric);
                long consSize = ((RubyNumeric)args2[0]).getLongValue();
                if (consSize <= 0L) {
                    throw runtime.newArgumentError("invalid size");
                }
                IRubyObject size2 = RubyEnumerable.enumSizeFn(context, self2).size(args2);
                if (size2 == null || size2.isNil()) {
                    return runtime.getNil();
                }
                IRubyObject n = size2.callMethod(context, "+", RubyFixnum.newFixnum(runtime, 1L - consSize));
                return RubyComparable.cmpint(context, n.callMethod(context, "<=>", zero = RubyFixnum.zero(runtime)), n, zero) == -1 ? zero : n;
            }
        };
    }

    @JRubyMethod
    public static IRubyObject reverse_each(ThreadContext context, IRubyObject self2, Block block) {
        return block.isGiven() ? RubyEnumerable.reverse_eachInternal(context, self2, RubyEnumerable.to_a(context, self2), block) : RubyEnumerator.enumeratorizeWithSize(context, self2, "reverse_each", RubyEnumerable.enumSizeFn(context, self2));
    }

    @JRubyMethod(rest=true)
    public static IRubyObject reverse_each(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyEnumerable.reverse_eachInternal(context, self2, RubyEnumerable.to_a(context, self2, args2), block) : RubyEnumerator.enumeratorizeWithSize(context, self2, "reverse_each", args2, RubyEnumerable.enumSizeFn(context, self2));
    }

    private static IRubyObject reverse_eachInternal(ThreadContext context, IRubyObject self2, IRubyObject obj, Block block) {
        ((RubyArray)obj).reverse_each(context, block);
        return self2;
    }

    @JRubyMethod(name={"include?", "member?"}, required=1)
    public static IRubyObject include_p(final ThreadContext context, IRubyObject self2, final IRubyObject arg2) {
        Ruby runtime = context.runtime;
        try {
            RubyEnumerable.callEach(runtime, context, self2, Signature.OPTIONAL, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                    RubyEnumerable.checkContext(context, ctx, "include?/member?");
                    if (RubyObject.equalInternal(ctx, larg, arg2)) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    return ctx.nil;
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            return runtime.getTrue();
        }
        return runtime.getFalse();
    }

    @JRubyMethod
    public static IRubyObject max(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.singleExtent(context, self2, "max", 1, block);
    }

    @JRubyMethod
    public static IRubyObject max(ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        RubyArray sorted = (RubyArray)RubyEnumerable.sort(context, self2, block);
        return ((RubyArray)sorted.last(arg2)).reverse();
    }

    @JRubyMethod
    public static IRubyObject min(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.singleExtent(context, self2, "min", -1, block);
    }

    @JRubyMethod
    public static IRubyObject min(ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        RubyArray sorted = (RubyArray)RubyEnumerable.sort(context, self2, block);
        return sorted.first(arg2);
    }

    @JRubyMethod
    public static IRubyObject max_by(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.singleExtentBy(context, self2, "max", 1, block);
    }

    @JRubyMethod
    public static IRubyObject max_by(ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        if (arg2 == context.nil) {
            return RubyEnumerable.singleExtentBy(context, self2, "max", 1, block);
        }
        RubyArray sorted = (RubyArray)RubyEnumerable.sort_by(context, self2, block);
        return ((RubyArray)sorted.last(arg2)).reverse();
    }

    @JRubyMethod
    public static IRubyObject min_by(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.singleExtentBy(context, self2, "min", -1, block);
    }

    @JRubyMethod
    public static IRubyObject min_by(ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        if (arg2 == context.nil) {
            return RubyEnumerable.singleExtentBy(context, self2, "min", -1, block);
        }
        RubyArray sorted = (RubyArray)RubyEnumerable.sort_by(context, self2, block);
        return sorted.first(arg2);
    }

    private static IRubyObject singleExtent(final ThreadContext context, IRubyObject self2, final String op, final int sortDirection, final Block block) {
        final Ruby runtime = context.runtime;
        final IRubyObject[] result2 = new IRubyObject[]{null};
        RubyEnumerable.callEach(runtime, context, self2, block.isGiven() ? block.getSignature() : Signature.ONE_REQUIRED, new BlockCallback(){

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                RubyEnumerable.checkContext(context, ctx, op + "{}");
                if (result2[0] == null || block.isGiven() && RubyComparable.cmpint(ctx, block.yieldArray(ctx, runtime.newArray(larg, result2[0]), null), larg, result2[0]) * sortDirection > 0 || !block.isGiven() && RubyComparable.cmpint(ctx, Helpers.invokedynamic(ctx, larg, MethodNames.OP_CMP, result2[0]), larg, result2[0]) * sortDirection > 0) {
                    result2[0] = larg;
                }
                return ctx.nil;
            }
        });
        return result2[0] == null ? runtime.getNil() : result2[0];
    }

    private static IRubyObject singleExtentBy(final ThreadContext context, IRubyObject self2, final String op, final int sortDirection, final Block block) {
        Ruby runtime = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, self2, op, RubyEnumerable.enumSizeFn(context, self2));
        }
        final IRubyObject[] result2 = new IRubyObject[]{runtime.getNil()};
        RubyEnumerable.callEach(runtime, context, self2, Signature.OPTIONAL, new BlockCallback(){
            IRubyObject memo = null;

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                RubyEnumerable.checkContext(context, ctx, op);
                IRubyObject v = block.yield(ctx, larg);
                if (this.memo == null || RubyComparable.cmpint(ctx, Helpers.invokedynamic(ctx, v, MethodNames.OP_CMP, this.memo), v, this.memo) * sortDirection > 0) {
                    this.memo = v;
                    result2[0] = larg;
                }
                return ctx.nil;
            }
        });
        return result2[0];
    }

    @JRubyMethod
    public static IRubyObject minmax(final ThreadContext context, IRubyObject self2, final Block block) {
        final Ruby runtime = context.runtime;
        final IRubyObject[] result2 = new IRubyObject[]{null, null};
        if (block.isGiven()) {
            RubyEnumerable.callEach(runtime, context, self2, block.getSignature(), new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    RubyEnumerable.checkContext(context, ctx, "minmax");
                    IRubyObject arg2 = RubyEnumerable.packEnumValues(ctx, largs);
                    if (result2[0] == null) {
                        result2[0] = result2[1] = arg2;
                    } else {
                        if (RubyComparable.cmpint(ctx, block.yield(ctx, runtime.newArray(arg2, result2[0])), arg2, result2[0]) < 0) {
                            result2[0] = arg2;
                        }
                        if (RubyComparable.cmpint(ctx, block.yield(ctx, runtime.newArray(arg2, result2[1])), arg2, result2[1]) > 0) {
                            result2[1] = arg2;
                        }
                    }
                    return ctx.nil;
                }
            });
        } else {
            RubyEnumerable.callEach(runtime, context, self2, Signature.ONE_REQUIRED, new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject arg2 = RubyEnumerable.packEnumValues(ctx, largs);
                    IRubyObject[] iRubyObjectArray = result2;
                    synchronized (result2) {
                        if (result2[0] == null) {
                            result2[0] = result2[1] = arg2;
                        } else {
                            if (RubyComparable.cmpint(ctx, Helpers.invokedynamic(ctx, arg2, MethodNames.OP_CMP, result2[0]), arg2, result2[0]) < 0) {
                                result2[0] = arg2;
                            }
                            if (RubyComparable.cmpint(ctx, Helpers.invokedynamic(ctx, arg2, MethodNames.OP_CMP, result2[1]), arg2, result2[1]) > 0) {
                                result2[1] = arg2;
                            }
                        }
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return ctx.nil;
                    }
                }
            });
        }
        if (result2[0] == null) {
            result2[0] = result2[1] = runtime.getNil();
        }
        return runtime.newArrayNoCopy(result2);
    }

    @JRubyMethod
    public static IRubyObject minmax_by(final ThreadContext context, IRubyObject self2, final Block block) {
        Ruby runtime = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, self2, "minmax_by", RubyEnumerable.enumSizeFn(context, self2));
        }
        final IRubyObject[] result2 = new IRubyObject[]{runtime.getNil(), runtime.getNil()};
        RubyEnumerable.callEach(runtime, context, self2, Signature.OPTIONAL, new BlockCallback(){
            IRubyObject minMemo = null;
            IRubyObject maxMemo = null;

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                RubyEnumerable.checkContext(context, ctx, "minmax_by");
                IRubyObject arg2 = RubyEnumerable.packEnumValues(ctx, largs);
                IRubyObject v = block.yield(ctx, arg2);
                if (this.minMemo == null) {
                    this.minMemo = this.maxMemo = v;
                    result2[0] = result2[1] = arg2;
                } else {
                    if (RubyComparable.cmpint(ctx, Helpers.invokedynamic(ctx, v, MethodNames.OP_CMP, this.minMemo), v, this.minMemo) < 0) {
                        this.minMemo = v;
                        result2[0] = arg2;
                    }
                    if (RubyComparable.cmpint(ctx, Helpers.invokedynamic(ctx, v, MethodNames.OP_CMP, this.maxMemo), v, this.maxMemo) > 0) {
                        this.maxMemo = v;
                        result2[1] = arg2;
                    }
                }
                return ctx.nil;
            }
        });
        return runtime.newArrayNoCopy(result2);
    }

    public static IRubyObject none_p(ThreadContext context, IRubyObject self2, final Block block) {
        final Ruby runtime = context.runtime;
        final ThreadContext localContext = context;
        try {
            if (block.isGiven()) {
                RubyEnumerable.callEach(runtime, context, self2, block.getSignature(), new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(localContext, ctx, "none?");
                        IRubyObject larg = RubyEnumerable.packEnumValues(runtime, largs);
                        if (block.yield(ctx, larg).isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return runtime.getNil();
                    }
                });
            } else {
                RubyEnumerable.callEach(runtime, context, self2, Signature.ONE_REQUIRED, new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(localContext, ctx, "none?");
                        IRubyObject larg = RubyEnumerable.packEnumValues(runtime, largs);
                        if (larg.isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return runtime.getNil();
                    }
                });
            }
        }
        catch (JumpException.SpecialJump sj) {
            return runtime.getFalse();
        }
        return runtime.getTrue();
    }

    @JRubyMethod(name={"none?"})
    public static IRubyObject none_p19(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.none_p(context, self2, block);
    }

    @Deprecated
    public static IRubyObject none_p(final ThreadContext context, IRubyObject self2, final Block block, Arity callbackArity) {
        Ruby runtime = context.runtime;
        try {
            if (block.isGiven()) {
                RubyEnumerable.callEach(runtime, context, self2, callbackArity, new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(context, ctx, "none?");
                        IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                        if (block.yield(ctx, larg).isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return ctx.nil;
                    }
                });
            } else {
                RubyEnumerable.callEach(runtime, context, self2, Signature.ONE_REQUIRED, new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(context, ctx, "none?");
                        IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                        if (larg.isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return ctx.nil;
                    }
                });
            }
        }
        catch (JumpException.SpecialJump sj) {
            return runtime.getFalse();
        }
        return runtime.getTrue();
    }

    public static IRubyObject one_p(ThreadContext context, IRubyObject self2, final Block block) {
        final Ruby runtime = context.runtime;
        final ThreadContext localContext = context;
        final boolean[] result2 = new boolean[]{false};
        try {
            if (block.isGiven()) {
                RubyEnumerable.callEach(runtime, context, self2, block.getSignature(), new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(localContext, ctx, "one?");
                        IRubyObject larg = RubyEnumerable.packEnumValues(runtime, largs);
                        if (block.yield(ctx, larg).isTrue()) {
                            if (result2[0]) {
                                throw JumpException.SPECIAL_JUMP;
                            }
                            result2[0] = true;
                        }
                        return runtime.getNil();
                    }
                });
            } else {
                RubyEnumerable.callEach(runtime, context, self2, Signature.ONE_REQUIRED, new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(localContext, ctx, "one?");
                        IRubyObject larg = RubyEnumerable.packEnumValues(runtime, largs);
                        if (larg.isTrue()) {
                            if (result2[0]) {
                                throw JumpException.SPECIAL_JUMP;
                            }
                            result2[0] = true;
                        }
                        return runtime.getNil();
                    }
                });
            }
        }
        catch (JumpException.SpecialJump sj) {
            return runtime.getFalse();
        }
        return result2[0] ? runtime.getTrue() : runtime.getFalse();
    }

    @JRubyMethod(name={"one?"})
    public static IRubyObject one_p19(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.one_p(context, self2, block);
    }

    @Deprecated
    public static IRubyObject one_p(final ThreadContext context, IRubyObject self2, final Block block, Arity callbackArity) {
        Ruby runtime = context.runtime;
        final boolean[] result2 = new boolean[]{false};
        try {
            if (block.isGiven()) {
                RubyEnumerable.callEach(runtime, context, self2, callbackArity, new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(context, ctx, "one?");
                        IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                        if (block.yield(ctx, larg).isTrue()) {
                            if (result2[0]) {
                                throw JumpException.SPECIAL_JUMP;
                            }
                            result2[0] = true;
                        }
                        return ctx.nil;
                    }
                });
            } else {
                RubyEnumerable.callEach(runtime, context, self2, Signature.ONE_REQUIRED, new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(context, ctx, "one?");
                        IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                        if (larg.isTrue()) {
                            if (result2[0]) {
                                throw JumpException.SPECIAL_JUMP;
                            }
                            result2[0] = true;
                        }
                        return ctx.nil;
                    }
                });
            }
        }
        catch (JumpException.SpecialJump sj) {
            return runtime.getFalse();
        }
        return result2[0] ? runtime.getTrue() : runtime.getFalse();
    }

    public static IRubyObject all_p(ThreadContext context, IRubyObject self2, final Block block) {
        final Ruby runtime = context.runtime;
        final ThreadContext localContext = context;
        try {
            if (block.isGiven()) {
                RubyEnumerable.callEach(runtime, context, self2, block.getSignature(), new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(localContext, ctx, "all?");
                        IRubyObject larg = RubyEnumerable.packEnumValues(runtime, largs);
                        if (!block.yield(ctx, larg).isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return runtime.getNil();
                    }
                });
            } else {
                RubyEnumerable.callEach(runtime, context, self2, Signature.ONE_REQUIRED, new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(localContext, ctx, "all?");
                        IRubyObject larg = RubyEnumerable.packEnumValues(runtime, largs);
                        if (!larg.isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return runtime.getNil();
                    }
                });
            }
        }
        catch (JumpException.SpecialJump sj) {
            return runtime.getFalse();
        }
        return runtime.getTrue();
    }

    @JRubyMethod(name={"all?"})
    public static IRubyObject all_p19(ThreadContext context, IRubyObject self2, Block block) {
        if (self2 instanceof RubyArray) {
            return ((RubyArray)self2).all_p(context, block);
        }
        return RubyEnumerable.all_p(context, self2, block);
    }

    @Deprecated
    public static IRubyObject all_pCommon(final ThreadContext context, IRubyObject self2, final Block block, Arity callbackArity) {
        Ruby runtime = context.runtime;
        try {
            if (block.isGiven()) {
                RubyEnumerable.callEach(runtime, context, self2, callbackArity, new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(context, ctx, "all?");
                        IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                        if (!block.yield(ctx, larg).isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return ctx.nil;
                    }
                });
            } else {
                RubyEnumerable.callEach(runtime, context, self2, Signature.ONE_REQUIRED, new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(context, ctx, "all?");
                        IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                        if (!larg.isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return ctx.nil;
                    }
                });
            }
        }
        catch (JumpException.SpecialJump sj) {
            return runtime.getFalse();
        }
        return runtime.getTrue();
    }

    @JRubyMethod(name={"any?"})
    public static IRubyObject any_p(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.any_pCommon(context, self2, block);
    }

    @Deprecated
    public static IRubyObject any_pCommon(ThreadContext context, IRubyObject self2, Block block, Arity callbackArity) {
        return RubyEnumerable.any_pCommon(context, self2, block);
    }

    public static IRubyObject any_pCommon(ThreadContext context, IRubyObject self2, final Block block) {
        final Ruby runtime = context.runtime;
        try {
            if (block.isGiven()) {
                RubyEnumerable.each(context, self2, new JavaInternalBlockBody(runtime, context, "Enumerable#any?", block.getSignature()){

                    @Override
                    public IRubyObject yield(ThreadContext context, IRubyObject[] args2) {
                        IRubyObject packedArg = RubyEnumerable.packEnumValues(context, args2);
                        if (block.yield(context, packedArg).isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return runtime.getNil();
                    }
                });
            } else {
                RubyEnumerable.each(context, self2, new JavaInternalBlockBody(runtime, context, "Enumerable#any?", Signature.ONE_REQUIRED){

                    @Override
                    public IRubyObject yield(ThreadContext context, IRubyObject[] args2) {
                        IRubyObject packedArg = RubyEnumerable.packEnumValues(context.runtime, args2);
                        if (packedArg.isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return runtime.getNil();
                    }
                });
            }
        }
        catch (JumpException.SpecialJump sj) {
            return runtime.getTrue();
        }
        return runtime.getFalse();
    }

    public static IRubyObject zip(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        return RubyEnumerable.zip19(context, self2, args2, block);
    }

    @JRubyMethod(name={"zip"}, rest=true)
    public static IRubyObject zip19(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        return RubyEnumerable.zipCommon19(context, self2, args2, block);
    }

    public static IRubyObject[] zipCommonConvert(Ruby runtime, IRubyObject[] args2) {
        return RubyEnumerable.zipCommonConvert(runtime, args2, "to_a");
    }

    public static IRubyObject[] zipCommonConvert(Ruby runtime, IRubyObject[] args2, String method) {
        RubyClass array = runtime.getArray();
        ThreadContext context = runtime.getCurrentContext();
        for (int i2 = 0; i2 < args2.length; ++i2) {
            IRubyObject result2 = TypeConverter.convertToTypeWithCheck19(args2[i2], array, method);
            if (result2.isNil()) {
                result2 = RubyEnumerable.takeItems(context, args2[i2]);
            }
            args2[i2] = result2;
        }
        return args2;
    }

    public static IRubyObject zipCommon(ThreadContext context, IRubyObject self2, IRubyObject[] aArgs, Block block) {
        Ruby runtime = context.runtime;
        IRubyObject[] args2 = RubyEnumerable.zipCommonConvert(runtime, aArgs);
        return RubyEnumerable.zipCommonAry(context, self2, args2, block);
    }

    public static IRubyObject zipCommon19(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        Ruby runtime = context.runtime;
        RubyClass array = runtime.getArray();
        IRubyObject[] newArgs = new IRubyObject[args2.length];
        boolean hasUncoercible = false;
        for (int i2 = 0; i2 < args2.length; ++i2) {
            newArgs[i2] = TypeConverter.convertToType(args2[i2], array, "to_ary", false);
            if (!newArgs[i2].isNil()) continue;
            hasUncoercible = true;
        }
        if (hasUncoercible) {
            RubySymbol each2 = runtime.newSymbol("each");
            for (int i3 = 0; i3 < args2.length; ++i3) {
                newArgs[i3] = args2[i3].callMethod(context, "to_enum", each2);
            }
        }
        if (hasUncoercible) {
            return RubyEnumerable.zipCommonEnum(context, self2, newArgs, block);
        }
        return RubyEnumerable.zipCommonAry(context, self2, newArgs, block);
    }

    public static IRubyObject zipCommonAry(ThreadContext context, IRubyObject self2, final IRubyObject[] args2, final Block block) {
        final Ruby runtime = context.runtime;
        final int len = args2.length + 1;
        if (block.isGiven()) {
            RubyEnumerable.callEach(runtime, context, self2, block.getSignature(), new BlockCallback(){
                AtomicInteger ix = new AtomicInteger(0);

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                    RubyArray array = runtime.newArray(len);
                    int myIx = this.ix.getAndIncrement();
                    array.append(larg);
                    int j = args2.length;
                    for (int i2 = 0; i2 < j; ++i2) {
                        array.append(((RubyArray)args2[i2]).entry(myIx));
                    }
                    block.yield(ctx, array);
                    return runtime.getNil();
                }
            });
            return runtime.getNil();
        }
        final RubyArray zip2 = runtime.newArray();
        RubyEnumerable.callEach(runtime, context, self2, Signature.ONE_REQUIRED, new BlockCallback(){
            AtomicInteger ix = new AtomicInteger(0);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                RubyArray array = runtime.newArray(len);
                array.append(larg);
                int myIx = this.ix.getAndIncrement();
                int j = args2.length;
                for (int i2 = 0; i2 < j; ++i2) {
                    array.append(((RubyArray)args2[i2]).entry(myIx));
                }
                RubyArray rubyArray = zip2;
                synchronized (rubyArray) {
                    zip2.append(array);
                }
                return runtime.getNil();
            }
        });
        return zip2;
    }

    public static IRubyObject zipCommonEnum(ThreadContext context, IRubyObject self2, final IRubyObject[] args2, final Block block) {
        final Ruby runtime = context.runtime;
        final int len = args2.length + 1;
        if (block.isGiven()) {
            RubyEnumerable.callEach(runtime, context, self2, block.getSignature(), new BlockCallback(){
                AtomicInteger ix = new AtomicInteger(0);

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                    RubyArray array = runtime.newArray(len);
                    int myIx = this.ix.getAndIncrement();
                    array.append(larg);
                    int j = args2.length;
                    for (int i2 = 0; i2 < j; ++i2) {
                        array.append(RubyEnumerable.zipEnumNext(ctx, args2[i2]));
                    }
                    block.yield(ctx, array);
                    return runtime.getNil();
                }
            });
            return runtime.getNil();
        }
        final RubyArray zip2 = runtime.newArray();
        RubyEnumerable.callEach(runtime, context, self2, Signature.ONE_REQUIRED, new BlockCallback(){
            AtomicInteger ix = new AtomicInteger(0);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                RubyArray array = runtime.newArray(len);
                array.append(larg);
                int myIx = this.ix.getAndIncrement();
                int j = args2.length;
                for (int i2 = 0; i2 < j; ++i2) {
                    array.append(RubyEnumerable.zipEnumNext(ctx, args2[i2]));
                }
                RubyArray rubyArray = zip2;
                synchronized (rubyArray) {
                    zip2.append(array);
                }
                return runtime.getNil();
            }
        });
        return zip2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject takeItems(ThreadContext context, IRubyObject enumerable) {
        RubyArray array;
        RubyArray rubyArray = array = context.runtime.newArray();
        synchronized (rubyArray) {
            RubyEnumerable.callEach(context.runtime, context, enumerable, Signature.ONE_ARGUMENT, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                    array.append(larg);
                    return larg;
                }
            });
        }
        return array;
    }

    public static IRubyObject zipEnumNext(ThreadContext context, IRubyObject arg2) {
        Ruby runtime = context.runtime;
        if (arg2.isNil()) {
            return context.nil;
        }
        IRubyObject oldExc = runtime.getGlobalVariables().get("$!");
        try {
            return arg2.callMethod(context, "next");
        }
        catch (RaiseException re) {
            if (re.getException().getMetaClass() == runtime.getStopIteration()) {
                runtime.getGlobalVariables().set("$!", oldExc);
                return context.nil;
            }
            throw re;
        }
    }

    @JRubyMethod
    public static IRubyObject group_by(ThreadContext context, IRubyObject self2, final Block block) {
        final Ruby runtime = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, self2, "group_by", RubyEnumerable.enumSizeFn(context, self2));
        }
        final RubyHash result2 = new RubyHash(runtime);
        RubyEnumerable.callEach(runtime, context, self2, Signature.OPTIONAL, new BlockCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                IRubyObject key2 = block.yield(ctx, larg);
                RubyHash rubyHash = result2;
                synchronized (rubyHash) {
                    RubyArray curr = (RubyArray)result2.fastARef(key2);
                    if (curr == null) {
                        curr = runtime.newArray();
                        result2.fastASet(key2, curr);
                    }
                    curr.append(larg);
                }
                return runtime.getNil();
            }
        });
        return result2;
    }

    @Deprecated
    public static IRubyObject chunk(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        switch (Arity.checkArgumentCount(context.runtime, args2, 0, 1)) {
            case 0: {
                return RubyEnumerable.chunk(context, self2, block);
            }
        }
        throw context.runtime.newArgumentError(args2.length, 0);
    }

    @JRubyMethod
    public static IRubyObject chunk(ThreadContext context, IRubyObject self2, Block block) {
        if (!block.isGiven()) {
            throw context.runtime.newArgumentError("no block given");
        }
        IRubyObject enumerator = context.runtime.getEnumerator().allocate();
        enumerator.getInternalVariables().setInternalVariable("chunk_enumerable", self2);
        enumerator.getInternalVariables().setInternalVariable("chunk_categorize", RubyProc.newProc(context.runtime, block, block.type));
        Helpers.invoke(context, enumerator, "initialize", CallBlock.newCallClosure(self2, context.runtime.getEnumerable(), Signature.ONE_ARGUMENT, (BlockCallback)new ChunkedBlockCallback(context.runtime, enumerator), context));
        return enumerator;
    }

    private static RubyEnumerator.SizeFn enumSizeFn(final ThreadContext context, final IRubyObject self2) {
        return new RubyEnumerator.SizeFn(){

            @Override
            public IRubyObject size(IRubyObject[] args2) {
                return self2.checkCallMethod(context, "size");
            }
        };
    }

    public static final class PutKeyValueCallback
    implements BlockCallback {
        private Ruby runtime;
        private RubyHash result;

        public PutKeyValueCallback(Ruby runtime, RubyHash result2) {
            this.runtime = runtime;
            this.result = result2;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject[] largs, Block blk) {
            IRubyObject value2;
            switch (largs.length) {
                case 0: {
                    value2 = context.nil;
                    break;
                }
                case 1: {
                    value2 = largs[0];
                    break;
                }
                default: {
                    value2 = RubyArray.newArrayNoCopy(this.runtime, largs);
                }
            }
            IRubyObject ary = TypeConverter.checkArrayType(this.runtime, value2);
            if (ary.isNil()) {
                throw this.runtime.newTypeError("wrong element type " + value2.getMetaClass().getName() + " (expected array)");
            }
            int size2 = ((RubyArray)ary).size();
            if (size2 != 2) {
                throw this.runtime.newArgumentError("element has wrong array length (expected 2, was " + size2 + ")");
            }
            this.result.op_aset(context, ((RubyArray)ary).eltOk(0L), ((RubyArray)ary).eltOk(1L));
            return context.nil;
        }
    }

    public static final class AppendBlockCallback
    implements BlockCallback {
        private final RubyArray result;

        public AppendBlockCallback(Ruby runtime, RubyArray result2) {
            this.result = result2;
        }

        AppendBlockCallback(RubyArray result2) {
            this.result = result2;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject[] largs, Block blk) {
            this.result.append(RubyEnumerable.packEnumValues(context, largs));
            return context.nil;
        }
    }

    public static final class ChunkedBlockCallback
    implements BlockCallback {
        private final Ruby runtime;
        private final IRubyObject enumerator;

        public ChunkedBlockCallback(Ruby runtime, IRubyObject enumerator) {
            this.runtime = runtime;
            this.enumerator = enumerator;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block block) {
            InternalVariables variables = this.enumerator.getInternalVariables();
            IRubyObject enumerable = (IRubyObject)variables.getInternalVariable("chunk_enumerable");
            final RubyProc categorize = (RubyProc)variables.getInternalVariable("chunk_categorize");
            final IRubyObject yielder = RubyEnumerable.packEnumValues(context, args2);
            final ChunkArg arg2 = new ChunkArg(context);
            final RubySymbol alone = this.runtime.newSymbol("_alone");
            final RubySymbol separator = this.runtime.newSymbol("_separator");
            RubyEnumerable.callEach(this.runtime, context, enumerable, Signature.OPTIONAL, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                    IRubyObject v = categorize.getBlock().getSignature().arityValue() == 1 ? categorize.callMethod(ctx, "call", larg) : categorize.callMethod(ctx, "call", largs);
                    if (v == alone) {
                        if (!arg2.prev_value.isNil()) {
                            yielder.callMethod(ctx, "<<", ChunkedBlockCallback.this.runtime.newArray(arg2.prev_value, arg2.prev_elts));
                            arg2.prev_value = arg2.prev_elts = ctx.nil;
                        }
                        yielder.callMethod(ctx, "<<", ChunkedBlockCallback.this.runtime.newArray(v, (IRubyObject)ChunkedBlockCallback.this.runtime.newArray(larg)));
                    } else if (v.isNil() || v == separator) {
                        if (!arg2.prev_value.isNil()) {
                            yielder.callMethod(ctx, "<<", ChunkedBlockCallback.this.runtime.newArray(arg2.prev_value, arg2.prev_elts));
                            arg2.prev_value = arg2.prev_elts = ctx.nil;
                        }
                    } else {
                        if (v instanceof RubySymbol && v.toString().charAt(0) == '_') {
                            throw ChunkedBlockCallback.this.runtime.newRuntimeError("symbol begins with an underscore is reserved");
                        }
                        if (arg2.prev_value.isNil()) {
                            arg2.prev_value = v;
                            arg2.prev_elts = ChunkedBlockCallback.this.runtime.newArray(larg);
                        } else if (arg2.prev_value.equals(v)) {
                            ((RubyArray)arg2.prev_elts).append(larg);
                        } else {
                            yielder.callMethod(ctx, "<<", ChunkedBlockCallback.this.runtime.newArray(arg2.prev_value, arg2.prev_elts));
                            arg2.prev_value = v;
                            arg2.prev_elts = ChunkedBlockCallback.this.runtime.newArray(larg);
                        }
                    }
                    return ctx.nil;
                }
            });
            if (!arg2.prev_elts.isNil()) {
                yielder.callMethod(context, "<<", this.runtime.newArray(arg2.prev_value, arg2.prev_elts));
            }
            return context.nil;
        }
    }

    private static class ChunkArg {
        IRubyObject prev_value;
        IRubyObject prev_elts;

        private ChunkArg(ThreadContext context) {
            this.prev_elts = this.prev_value = context.nil;
        }
    }

    static class EachWithIndex
    implements BlockCallback {
        private int index;
        private final Block block;

        EachWithIndex(Block block, int index2) {
            this.block = block;
            this.index = index2;
        }

        EachWithIndex(Block block) {
            this.block = block;
            this.index = 0;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject[] iargs, Block block) {
            return this.block.call(context, RubyEnumerable.packEnumValues(context, iargs), context.runtime.newFixnum(this.index++));
        }
    }
}

