/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Objects;
import org.sejda.impl.sambox.util.FontUtils;
import org.sejda.model.HorizontalAlign;
import org.sejda.model.VerticalAlign;
import org.sejda.model.exception.TaskIOException;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.PDPageContentStream;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.font.PDFont;
import org.sejda.sambox.util.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageTextWriter {
    private static final Logger LOG = LoggerFactory.getLogger(PageTextWriter.class);
    private PDDocument document;
    private static final Float DEFAULT_MARGIN = Float.valueOf(30.0f);
    private PDFont latestSuitablefont;

    public PageTextWriter(PDDocument document) {
        this.document = document;
    }

    public void write(PDPage page, HorizontalAlign hAlign, VerticalAlign vAlign, String label, PDFont font, Double fontSize, Color color) throws TaskIOException {
        try {
            this.resolveFont(label, font);
            PDRectangle pageSize = page.getCropBox().rotate(page.getRotation());
            float stringWidth = this.latestSuitablefont.getStringWidth(label) * fontSize.floatValue() / 1000.0f;
            Point2D.Float position = new Point2D.Float(hAlign.position(pageSize.getWidth(), stringWidth, DEFAULT_MARGIN.floatValue()), vAlign.position(pageSize.getHeight(), DEFAULT_MARGIN.floatValue() - fontSize.floatValue()));
            this.write(page, position, label, font, fontSize, color);
        }
        catch (IOException e) {
            throw new TaskIOException("An error occurred writing the header or footer of the page.", e);
        }
    }

    public void write(PDPage page, Point2D position, String label, PDFont font, Double fontSize, Color color) throws TaskIOException {
        this.resolveFont(label, font);
        PDRectangle pageSize = page.getCropBox().rotate(page.getRotation());
        try (PDPageContentStream contentStream = new PDPageContentStream(this.document, page, PDPageContentStream.AppendMode.APPEND, true, true);){
            contentStream.beginText();
            contentStream.setFont(this.latestSuitablefont, fontSize.floatValue());
            contentStream.setNonStrokingColor(color);
            if (page.getRotation() > 0) {
                position = this.findPositionInRotatedPage(page.getRotation(), pageSize, position);
                AffineTransform tx = AffineTransform.getTranslateInstance(position.getX(), position.getY());
                tx.rotate(Math.toRadians(page.getRotation()));
                contentStream.setTextMatrix(new Matrix(tx));
            } else {
                contentStream.setTextMatrix(new Matrix(AffineTransform.getTranslateInstance(position.getX(), position.getY())));
            }
            LOG.trace("Text position {}", (Object)position);
            contentStream.showText(label);
            contentStream.endText();
        }
        catch (IOException e) {
            throw new TaskIOException("An error occurred writing the header or footer of the page.", e);
        }
    }

    private void resolveFont(String label, PDFont font) throws TaskIOException {
        this.latestSuitablefont = FontUtils.fontOrFallback(label, font, () -> {
            if (FontUtils.canDisplay(label, this.latestSuitablefont)) {
                return this.latestSuitablefont;
            }
            return FontUtils.findFontFor(this.document, label);
        });
        if (Objects.isNull(this.latestSuitablefont)) {
            throw new TaskIOException("Unable to find suitable font for the given label \"" + label + "\"");
        }
    }

    private Point2D findPositionInRotatedPage(int rotation, PDRectangle pageSize, Point2D position) {
        LOG.debug("Found rotation {}", (Object)rotation);
        AffineTransform transform = AffineTransform.getScaleInstance(1.0, -1.0);
        if (rotation == 90) {
            transform.translate(pageSize.getHeight(), 0.0);
        }
        if (rotation == 180) {
            transform.translate(pageSize.getWidth(), -pageSize.getHeight());
        }
        if (rotation == 270) {
            transform.translate(0.0, -pageSize.getWidth());
        }
        transform.rotate(Math.toRadians(-rotation));
        transform.scale(1.0, -1.0);
        return transform.transform(position, null);
    }
}

