/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.data;

import com.ubnt.data.Sanitizable;
import com.ubnt.data.TestPattern;
import com.ubnt.data.X;
import com.ubnt.service.OoOO.N;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.log4j.Logger;

public class NetworkConf
extends X
implements Sanitizable {
    private static final Logger floatnew = N.\u00d6o0000;
    public static String[] \u00f5\u00d20000 = new String[]{"name", "enabled", "purpose", "vlan_enabled", "vlan", "ip_subnet", "dhcpd_enabled", "dhcpd_start", "dhcpd_stop", "dhcpd_dns_enabled", "dhcpd_dns_1", "dhcpd_dns_2", "dhcpd_leasetime", "dhcpd_wins_enabled", "dhcpd_wins_1", "dhcpd_wins_2", "dhcpguard_enabled", "dhcpd_ip_1", "is_nat", "nat_outbound_ip", "dpi_enabled", "igmp_snooping", "igmp_fastleave", "igmp_maxresponse", "igmp_mcrtrexpiretime", "igmp_groupmembership", "igmp_querier", "igmp_supression", "remote_vpn_subnets", "ipsec_peer_ip", "ipsec_local_ip", "x_ipsec_pre_shared_key", "ipsec_profile", "ipsec_encryption", "ipsec_hash", "ipsec_dh_group", "ipsec_key_exchange", "ipsec_pfs", "ipsec_dynamic_routing", "openvpn_remote_host", "x_openvpn_shared_secret_key", "openvpn_local_port", "openvpn_remote_port", "openvpn_local_address", "openvpn_remote_address", "pptpc_server_ip", "pptpc_username", "x_pptpc_password", "pptpc_require_mppe"};
    public static String O\u00d30000 = "LAN";
    public static String \u00f6\u00d20000 = "VOIP";
    public static TestPattern o\u00d30000 = TestPattern.getPattern(NetworkConf.class.getSimpleName());

    public static String name() {
        return "networkconf";
    }

    public static int mask() {
        return \u00d6O0000 | \u00d400000;
    }

    @Override
    public void sanitize(X x) {
        String string = x.getString("purpose");
        if (("corporate".equals(string) || "guest".equals(string)) && !x.containsField("networkgroup")) {
            x.put("networkgroup", (Object)"LAN");
        }
        o\u00d30000.matchPattern(x);
    }

    public static NetworkConf createDefaultLocalAreaNetworkConfForSite(String string) {
        NetworkConf networkConf = new NetworkConf();
        networkConf.put("attr_no_delete", (Object)true);
        networkConf.put("attr_hidden_id", (Object)O\u00d30000);
        networkConf.put("name", (Object)"LAN");
        networkConf.put("site_id", (Object)string);
        networkConf.put("vlan_enabled", (Object)false);
        networkConf.put("purpose", (Object)"corporate");
        networkConf.put("ip_subnet", (Object)"192.168.1.1/24");
        networkConf.put("is_nat", (Object)true);
        networkConf.put("dhcpd_enabled", (Object)true);
        networkConf.put("dhcpd_start", (Object)networkConf.getDefaultDHCPStartIP());
        networkConf.put("dhcpd_stop", (Object)networkConf.getDefaultDHCPStopIP());
        return networkConf;
    }

    public static NetworkConf createVoipNetworkConfForSite(String string) {
        NetworkConf networkConf = new NetworkConf();
        networkConf.put("attr_no_delete", (Object)true);
        networkConf.put("attr_hidden_id", (Object)\u00f6\u00d20000);
        networkConf.put("name", (Object)"VOIP");
        networkConf.put("site_id", (Object)string);
        networkConf.put("vlan_enabled", (Object)false);
        networkConf.put("purpose", (Object)"voip");
        networkConf.put("ip_subnet", (Object)"192.168.2.1/24");
        networkConf.put("is_nat", (Object)true);
        networkConf.put("dhcpd_enabled", (Object)true);
        networkConf.put("dhcpd_start", (Object)networkConf.getDefaultDHCPStartIP());
        networkConf.put("dhcpd_stop", (Object)networkConf.getDefaultDHCPStopIP());
        return networkConf;
    }

    public int getMaskbits() {
        SubnetUtils.SubnetInfo subnetInfo = new SubnetUtils(this.getString("ip_subnet", "192.168.1.1/24")).getInfo();
        return Integer.bitCount(subnetInfo.asInteger(subnetInfo.getNetmask()));
    }

    public String getIp() {
        String[] stringArray = this.getString("ip_subnet").split("/");
        return stringArray[0];
    }

    public String getSubnet() {
        SubnetUtils subnetUtils = new SubnetUtils(this.getString("ip_subnet", "192.168.1.1/24"));
        SubnetUtils.SubnetInfo subnetInfo = subnetUtils.getInfo();
        return String.format("%s/%d", subnetInfo.getNetworkAddress(), Integer.bitCount(subnetInfo.asInteger(subnetInfo.getNetmask())));
    }

    public boolean containsIp(String string) {
        SubnetUtils subnetUtils = new SubnetUtils(this.getString("ip_subnet", "192.168.1.1/24"));
        SubnetUtils.SubnetInfo subnetInfo = subnetUtils.getInfo();
        try {
            return subnetInfo.isInRange(string);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getDefaultDHCPStartIP() {
        SubnetUtils subnetUtils = new SubnetUtils(this.getString("ip_subnet", "192.168.1.1/24"));
        subnetUtils.setInclusiveHostCount(false);
        SubnetUtils.SubnetInfo subnetInfo = subnetUtils.getInfo();
        int n = Integer.bitCount(subnetInfo.asInteger(subnetInfo.getNetmask()));
        int n2 = n < 25 ? (25 - n) * 5 : 1;
        int n3 = subnetInfo.asInteger(subnetInfo.getLowAddress());
        int n4 = n3 + n2;
        int[] nArray = new int[4];
        for (int i = 3; i >= 0; --i) {
            int n5 = i;
            nArray[n5] = nArray[n5] | n4 >>> 8 * (3 - i) & 0xFF;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuilder.append(nArray[i]);
            if (i == nArray.length - 1) continue;
            stringBuilder.append(".");
        }
        return stringBuilder.toString();
    }

    public String getDefaultDHCPStopIP() {
        SubnetUtils subnetUtils = new SubnetUtils(this.getString("ip_subnet", "192.168.1.1/24"));
        subnetUtils.setInclusiveHostCount(false);
        return subnetUtils.getInfo().getHighAddress();
    }

    public String getDefaultGatewayIP() {
        SubnetUtils subnetUtils = new SubnetUtils(this.getString("ip_subnet", "192.168.1.1/24"));
        return subnetUtils.getInfo().getAddress();
    }

    public List<String> getDefaultNameServers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getDefaultGatewayIP());
        return arrayList;
    }

    public boolean isLocalSiteNetwork() {
        String string = this.getString("purpose");
        return "corporate".equals(string) || "guest".equals(string) || "voip".equals(string);
    }

    public boolean isCorpNetwork() {
        return "corporate".equals(this.getString("purpose"));
    }

    public boolean isGuestNetwork() {
        return "guest".equals(this.getString("purpose"));
    }

    public boolean isVoipNetwork() {
        return "voip".equals(this.getString("purpose"));
    }

    public boolean isSiteVpnNetwork() {
        return "site-vpn".equals(this.getString("purpose")) && "auto".equals(this.getString("vpn_type", "auto"));
    }

    public boolean isVpnClientNetwork() {
        return "vpn-client".equals(this.getString("purpose"));
    }

    public boolean isManualSiteVpnNetwork() {
        return "site-vpn".equals(this.getString("purpose")) && !"auto".equals(this.getString("vpn_type", "auto"));
    }

    public boolean isSiteIpsecVpnNetwork() {
        return "site-vpn".equals(this.getString("purpose")) && "ipsec-vpn".equals(this.getString("vpn_type"));
    }

    public boolean isSiteOpenvpnVpnNetwork() {
        return "site-vpn".equals(this.getString("purpose")) && "openvpn-vpn".equals(this.getString("vpn_type"));
    }

    public boolean isPptpClientNetwork() {
        return "vpn-client".equals(this.getString("purpose")) && "pptp-client".equals(this.getString("vpn_type"));
    }

    public boolean isRemoteUserVpnNetwork() {
        return "remote-user-vpn".equals(this.getString("purpose"));
    }

    public boolean isVlanOnlyNetwork() {
        return "vlan-only".equals(this.getString("purpose"));
    }

    public boolean isLocalSiteLayer2Network() {
        return this.isLocalSiteNetwork() || this.isVlanOnlyNetwork();
    }

    public static int getNetworkGroupInternalVlan(String string) {
        if (string.equals("LAN")) {
            return 1;
        }
        if (string.equals("VOIP")) {
            return 4010;
        }
        if (string.equals("LAN2")) {
            return 4012;
        }
        if (string.equals("LAN3")) {
            return 4013;
        }
        if (string.equals("LAN4")) {
            return 4014;
        }
        if (string.equals("LAN5")) {
            return 4015;
        }
        return 1;
    }

    public int getVlan() {
        int n = this.getInt("vlan", 1);
        if (n > 1 && n < 4094 && this.is("vlan_enabled", false)) {
            return n;
        }
        String string = this.getString("networkgroup", "unknown");
        return NetworkConf.getNetworkGroupInternalVlan(string);
    }
}

