/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.db.paros;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.hsqldb.Server;
import org.parosproxy.paros.db.DatabaseServer;

public class ParosDatabaseServer
implements DatabaseServer {
    public static final int DEFAULT_SERVER_PORT = 9001;
    private static final Logger logger = Logger.getLogger(DatabaseServer.class);
    String mUrl;
    String mUser = "sa";
    String mPassword = "";
    Server mServer = null;
    Connection mConn = null;

    ParosDatabaseServer(String string) throws ClassNotFoundException, Exception {
        this.start(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(String string) throws ClassNotFoundException, Exception {
        string = string.replaceAll("\\\\", "/");
        boolean bl = false;
        File file = new File(string + ".properties");
        if (file.exists()) {
            Properties properties = new Properties();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
            }
            finally {
                block12: {
                    try {
                        if (fileInputStream != null) {
                            ((InputStream)fileInputStream).close();
                        }
                    }
                    catch (IOException iOException) {
                        if (!logger.isDebugEnabled()) break block12;
                        logger.debug((Object)iOException.getMessage(), (Throwable)iOException);
                    }
                }
            }
            String string2 = (String)properties.get("version");
            if (string2.charAt(0) < '2') {
                bl = true;
            }
        }
        this.mUrl = "jdbc:hsqldb:file:" + string;
        Class.forName("org.hsqldb.jdbcDriver");
        this.mConn = DriverManager.getConnection(this.mUrl, this.mUser, this.mPassword);
        if (bl) {
            this.shutdown(true);
            this.mConn = DriverManager.getConnection(this.mUrl, this.mUser, this.mPassword);
        }
    }

    void shutdown(boolean bl) throws SQLException {
        Connection connection = this.getSingletonConnection();
        CallableStatement callableStatement = null;
        callableStatement = bl ? connection.prepareCall("SHUTDOWN COMPACT") : connection.prepareCall("SHUTDOWN");
        callableStatement.execute();
        callableStatement.close();
        this.mConn.close();
        this.mConn = null;
    }

    public Connection getNewConnection() throws SQLException {
        Connection connection = null;
        for (int i = 0; i < 5; ++i) {
            try {
                connection = DriverManager.getConnection(this.mUrl, this.mUser, this.mPassword);
                return connection;
            }
            catch (SQLException sQLException) {
                logger.warn((Object)sQLException.getMessage(), (Throwable)sQLException);
                if (i == 4) {
                    throw sQLException;
                }
                logger.warn((Object)("Recovering " + i + " times."));
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)interruptedException.getMessage(), (Throwable)interruptedException);
                }
                continue;
            }
        }
        return connection;
    }

    public Connection getSingletonConnection() throws SQLException {
        if (this.mConn == null) {
            this.mConn = this.getNewConnection();
        }
        return this.mConn;
    }
}

