/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.authentication;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import net.sf.json.JSONObject;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.ZAP;
import org.zaproxy.zap.authentication.AbstractAuthenticationMethodOptionsPanel;
import org.zaproxy.zap.authentication.AbstractCredentialsOptionsPanel;
import org.zaproxy.zap.authentication.AuthenticationCredentials;
import org.zaproxy.zap.authentication.AuthenticationHelper;
import org.zaproxy.zap.authentication.AuthenticationMethod;
import org.zaproxy.zap.authentication.AuthenticationMethodType;
import org.zaproxy.zap.authentication.GenericAuthenticationCredentials;
import org.zaproxy.zap.extension.api.ApiDynamicActionImplementor;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.script.ExtensionScript;
import org.zaproxy.zap.extension.script.ScriptType;
import org.zaproxy.zap.extension.script.ScriptWrapper;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.session.SessionManagementMethod;
import org.zaproxy.zap.session.WebSession;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.ApiUtils;
import org.zaproxy.zap.utils.EncodingUtils;
import org.zaproxy.zap.view.DynamicFieldsPanel;
import org.zaproxy.zap.view.LayoutHelper;

public class ScriptBasedAuthenticationMethodType
extends AuthenticationMethodType {
    public static final String CONTEXT_CONFIG_AUTH_SCRIPT = "context.authentication.script";
    public static final String CONTEXT_CONFIG_AUTH_SCRIPT_NAME = "context.authentication.script.name";
    public static final String CONTEXT_CONFIG_AUTH_SCRIPT_PARAMS = "context.authentication.script.params";
    public static final int METHOD_IDENTIFIER = 4;
    private static final Logger log = Logger.getLogger(ScriptBasedAuthenticationMethodType.class);
    public static final String SCRIPT_TYPE_AUTH = "authentication";
    private static final String API_METHOD_NAME = "scriptBasedAuthentication";
    private static final ImageIcon SCRIPT_ICON_AUTH = new ImageIcon(ZAP.class.getResource("/resource/icon/16/script-auth.png"));
    private static final String METHOD_NAME = Constant.messages.getString("authentication.method.script.name");
    private ExtensionScript extensionScript;
    private static final String PARAM_SCRIPT_NAME = "scriptName";
    private static final String PARAM_SCRIPT_CONFIG_PARAMS = "scriptConfigParams";

    @Override
    public void hook(ExtensionHook extensionHook) {
        if (this.getScriptsExtension() != null) {
            log.debug((Object)"Registering Script...");
            this.getScriptsExtension().registerScriptType(new ScriptType(SCRIPT_TYPE_AUTH, "authentication.method.script.type", SCRIPT_ICON_AUTH, false, new String[]{"append"}));
        }
    }

    @Override
    public ScriptBasedAuthenticationMethod createAuthenticationMethod(int n) {
        return new ScriptBasedAuthenticationMethod();
    }

    @Override
    public String getName() {
        return METHOD_NAME;
    }

    @Override
    public int getUniqueIdentifier() {
        return 4;
    }

    @Override
    public AbstractAuthenticationMethodOptionsPanel buildOptionsPanel(Context context) {
        return new ScriptBasedAuthenticationMethodOptionsPanel();
    }

    @Override
    public boolean hasOptionsPanel() {
        return true;
    }

    @Override
    public AbstractCredentialsOptionsPanel<? extends AuthenticationCredentials> buildCredentialsOptionsPanel(AuthenticationCredentials authenticationCredentials, Context context) {
        return new GenericAuthenticationCredentials.GenericAuthenticationCredentialsOptionsPanel((GenericAuthenticationCredentials)authenticationCredentials);
    }

    @Override
    public boolean hasCredentialsOptionsPanel() {
        return true;
    }

    @Override
    public boolean isTypeForMethod(AuthenticationMethod authenticationMethod) {
        return authenticationMethod instanceof ScriptBasedAuthenticationMethod;
    }

    @Override
    public ScriptBasedAuthenticationMethod loadMethodFromSession(Session session, int n) throws DatabaseException {
        ScriptBasedAuthenticationMethod scriptBasedAuthenticationMethod = this.createAuthenticationMethod(n);
        this.loadMethod(scriptBasedAuthenticationMethod, session.getContextDataStrings(n, 201), session.getContextDataStrings(n, 202));
        return scriptBasedAuthenticationMethod;
    }

    public void loadMethod(ScriptBasedAuthenticationMethod scriptBasedAuthenticationMethod, List<String> list, List<String> list2) {
        Object object;
        String string = "";
        if (list != null && list.size() > 0) {
            string = list.get(0);
            object = this.getScriptsExtension().getScript(string);
            if (object == null) {
                log.error((Object)("Unable to find script while loading Script Based Authentication Method for name: " + string));
            } else {
                log.info((Object)("Loaded script:" + ((ScriptWrapper)object).getName()));
            }
            scriptBasedAuthenticationMethod.script = (ScriptWrapper)object;
            try {
                AuthenticationScript authenticationScript = this.getScriptsExtension().getInterface((ScriptWrapper)object, AuthenticationScript.class);
                if (authenticationScript != null) {
                    ScriptBasedAuthenticationMethod.access$702(scriptBasedAuthenticationMethod, authenticationScript.getCredentialsParamsNames());
                } else {
                    log.error((Object)("Unable to load Script Based Authentication method. The script " + ((ScriptWrapper)object).getName() + " does not properly implement the Authentication Script interface."));
                }
            }
            catch (IOException | ScriptException exception) {
                log.error((Object)("Unable to load Script Based Authentication method. The script " + ((ScriptWrapper)object).getName() + " does not properly implement the Authentication Script interface."));
            }
        }
        object = null;
        if (list2 != null && list2.size() > 0) {
            object = EncodingUtils.stringToMap(list2.get(0));
            scriptBasedAuthenticationMethod.paramValues = (Map)object;
        } else {
            scriptBasedAuthenticationMethod.paramValues = new HashMap();
            log.error((Object)("Unable to load script parameter values loading Script Based Authentication Method for name: " + string));
        }
    }

    @Override
    public void persistMethodToSession(Session session, int n, AuthenticationMethod authenticationMethod) throws AuthenticationMethodType.UnsupportedAuthenticationMethodException, DatabaseException {
        if (!(authenticationMethod instanceof ScriptBasedAuthenticationMethod)) {
            throw new AuthenticationMethodType.UnsupportedAuthenticationMethodException("Script based authentication type only supports: " + ScriptBasedAuthenticationMethod.class);
        }
        ScriptBasedAuthenticationMethod scriptBasedAuthenticationMethod = (ScriptBasedAuthenticationMethod)authenticationMethod;
        session.setContextData(n, 201, scriptBasedAuthenticationMethod.script.getName());
        session.setContextData(n, 202, EncodingUtils.mapToString(scriptBasedAuthenticationMethod.paramValues));
    }

    @Override
    public AuthenticationCredentials createAuthenticationCredentials() {
        return new GenericAuthenticationCredentials(new String[0]);
    }

    private ExtensionScript getScriptsExtension() {
        if (this.extensionScript == null) {
            this.extensionScript = (ExtensionScript)Control.getSingleton().getExtensionLoader().getExtension("ExtensionScript");
        }
        return this.extensionScript;
    }

    @Override
    public ApiDynamicActionImplementor getSetMethodForContextApiAction() {
        return new ApiDynamicActionImplementor(API_METHOD_NAME, new String[]{PARAM_SCRIPT_NAME}, new String[]{PARAM_SCRIPT_CONFIG_PARAMS}){

            @Override
            public void handleAction(JSONObject jSONObject) throws ApiException {
                ScriptBasedAuthenticationMethod scriptBasedAuthenticationMethod;
                Context context;
                block9: {
                    context = ApiUtils.getContextByParamId(jSONObject, "contextId");
                    String string = ApiUtils.getNonEmptyStringParam(jSONObject, ScriptBasedAuthenticationMethodType.PARAM_SCRIPT_NAME);
                    scriptBasedAuthenticationMethod = ScriptBasedAuthenticationMethodType.this.createAuthenticationMethod(context.getIndex());
                    ScriptWrapper scriptWrapper = ScriptBasedAuthenticationMethodType.this.getScriptsExtension().getScript(string);
                    if (scriptWrapper == null) {
                        log.error((Object)("Unable to find script while loading Script Based Authentication Method for name: " + string));
                        throw new ApiException(ApiException.Type.SCRIPT_NOT_FOUND, string);
                    }
                    log.info((Object)("Loaded script for API:" + scriptWrapper.getName()));
                    scriptBasedAuthenticationMethod.script = scriptWrapper;
                    try {
                        AuthenticationScript authenticationScript = ScriptBasedAuthenticationMethodType.this.getScriptsExtension().getInterface(scriptWrapper, AuthenticationScript.class);
                        if (authenticationScript != null) {
                            ScriptBasedAuthenticationMethod.access$702(scriptBasedAuthenticationMethod, authenticationScript.getCredentialsParamsNames());
                            Object[] objectArray = authenticationScript.getRequiredParamsNames();
                            Object[] objectArray2 = authenticationScript.getOptionalParamsNames();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Loaded authentication script - required parameters: " + Arrays.toString(objectArray) + " - optional parameters: " + Arrays.toString(objectArray2)));
                            }
                            HashMap<Object, String> hashMap = new HashMap<Object, String>();
                            for (Object object : objectArray) {
                                String string2 = ApiUtils.getNonEmptyStringParam(jSONObject, (String)object);
                                hashMap.put(object, string2);
                            }
                            for (Object object : objectArray2) {
                                hashMap.put(object, ApiUtils.getOptionalStringParam(jSONObject, (String)object));
                            }
                            scriptBasedAuthenticationMethod.paramValues = hashMap;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Loaded authentication script parameters:" + hashMap));
                            }
                            break block9;
                        }
                        log.error((Object)("Unable to load Script Based Authentication method. The script " + scriptWrapper.getName() + " does not properly implement the Authentication Script interface."));
                        throw new ApiException(ApiException.Type.BAD_SCRIPT_FORMAT, "Does not follow Authentication script interface");
                    }
                    catch (IOException | ScriptException exception) {
                        log.error((Object)("Unable to load Script Based Authentication method. The script " + scriptWrapper.getName() + " does not properly implement the Authentication Script interface."));
                        throw new ApiException(ApiException.Type.BAD_SCRIPT_FORMAT, exception.getMessage());
                    }
                }
                if (!context.getAuthenticationMethod().isSameType(scriptBasedAuthenticationMethod)) {
                    AuthenticationMethodType.apiChangedAuthenticationMethodForContext(context.getIndex());
                }
                context.setAuthenticationMethod(scriptBasedAuthenticationMethod);
            }
        };
    }

    @Override
    public ApiDynamicActionImplementor getSetCredentialsForUserApiAction() {
        return GenericAuthenticationCredentials.getSetCredentialsForUserApiAction(this);
    }

    @Override
    public void exportData(Configuration configuration, AuthenticationMethod authenticationMethod) {
        if (!(authenticationMethod instanceof ScriptBasedAuthenticationMethod)) {
            throw new AuthenticationMethodType.UnsupportedAuthenticationMethodException("Script based authentication type only supports: " + ScriptBasedAuthenticationMethod.class.getName());
        }
        ScriptBasedAuthenticationMethod scriptBasedAuthenticationMethod = (ScriptBasedAuthenticationMethod)authenticationMethod;
        configuration.setProperty(CONTEXT_CONFIG_AUTH_SCRIPT_NAME, (Object)scriptBasedAuthenticationMethod.script.getName());
        configuration.setProperty(CONTEXT_CONFIG_AUTH_SCRIPT_PARAMS, (Object)EncodingUtils.mapToString(scriptBasedAuthenticationMethod.paramValues));
    }

    @Override
    public void importData(Configuration configuration, AuthenticationMethod authenticationMethod) throws ConfigurationException {
        if (!(authenticationMethod instanceof ScriptBasedAuthenticationMethod)) {
            throw new AuthenticationMethodType.UnsupportedAuthenticationMethodException("Script based authentication type only supports: " + ScriptBasedAuthenticationMethod.class.getName());
        }
        ScriptBasedAuthenticationMethod scriptBasedAuthenticationMethod = (ScriptBasedAuthenticationMethod)authenticationMethod;
        this.loadMethod(scriptBasedAuthenticationMethod, this.objListToStrList(configuration.getList(CONTEXT_CONFIG_AUTH_SCRIPT_NAME)), this.objListToStrList(configuration.getList(CONTEXT_CONFIG_AUTH_SCRIPT_PARAMS)));
    }

    private List<String> objListToStrList(List<Object> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (Object object : list) {
            arrayList.add(object.toString());
        }
        return arrayList;
    }

    public static interface AuthenticationScript {
        public String[] getRequiredParamsNames();

        public String[] getOptionalParamsNames();

        public String[] getCredentialsParamsNames();

        public HttpMessage authenticate(AuthenticationHelper var1, Map<String, String> var2, GenericAuthenticationCredentials var3) throws ScriptException;
    }

    private static class ScriptWrapperRenderer
    extends BasicComboBoxRenderer {
        private static final long serialVersionUID = 3654541772447187317L;
        private static final Border BORDER = new EmptyBorder(2, 3, 3, 3);
        private ScriptBasedAuthenticationMethodOptionsPanel panel;

        public ScriptWrapperRenderer(ScriptBasedAuthenticationMethodOptionsPanel scriptBasedAuthenticationMethodOptionsPanel) {
            this.panel = scriptBasedAuthenticationMethodOptionsPanel;
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object != null) {
                this.setBorder(BORDER);
                ScriptWrapper scriptWrapper = (ScriptWrapper)object;
                if (this.panel.loadedScript == scriptWrapper) {
                    this.setText("<html><b>" + scriptWrapper.getName() + " (loaded)</b></html>");
                } else {
                    this.setText(scriptWrapper.getName());
                }
            }
            return this;
        }
    }

    public class ScriptBasedAuthenticationMethodOptionsPanel
    extends AbstractAuthenticationMethodOptionsPanel {
        private static final long serialVersionUID = 7812841049435409987L;
        private final String SCRIPT_NAME_LABEL = Constant.messages.getString("authentication.method.script.field.label.scriptName");
        private final String LABEL_NOT_LOADED = Constant.messages.getString("authentication.method.script.field.label.notLoaded");
        private JComboBox<ScriptWrapper> scriptsComboBox;
        private JButton loadScriptButton;
        private ScriptBasedAuthenticationMethod method;
        private ScriptWrapper loadedScript;
        private JPanel dynamicContentPanel;
        private DynamicFieldsPanel dynamicFieldsPanel;
        private String[] loadedCredentialParams;

        public ScriptBasedAuthenticationMethodOptionsPanel() {
            this.initialize();
        }

        private void initialize() {
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel(this.SCRIPT_NAME_LABEL), LayoutHelper.getGBC(0, 0, 1, 0.0, 0.0));
            this.scriptsComboBox = new JComboBox();
            this.scriptsComboBox.setRenderer(new ScriptWrapperRenderer(this));
            this.add(this.scriptsComboBox, LayoutHelper.getGBC(1, 0, 1, 1.0, 0.0));
            this.loadScriptButton = new JButton("Load");
            this.add((Component)this.loadScriptButton, LayoutHelper.getGBC(2, 0, 1, 0.0, 0.0));
            this.loadScriptButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ScriptBasedAuthenticationMethodOptionsPanel.this.loadScript((ScriptWrapper)ScriptBasedAuthenticationMethodOptionsPanel.this.scriptsComboBox.getSelectedItem(), true);
                }
            });
            this.loadScriptButton.setEnabled(false);
            this.scriptsComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ScriptBasedAuthenticationMethodOptionsPanel.this.loadScriptButton.setEnabled(ScriptBasedAuthenticationMethodOptionsPanel.this.scriptsComboBox.getSelectedIndex() >= 0);
                }
            });
            this.dynamicContentPanel = new JPanel(new BorderLayout());
            this.add((Component)this.dynamicContentPanel, LayoutHelper.getGBC(0, 1, 3, 1.0, 0.0));
            this.dynamicContentPanel.add(new JLabel(this.LABEL_NOT_LOADED));
        }

        @Override
        public void validateFields() throws IllegalStateException {
            if (this.loadedScript == null) {
                this.scriptsComboBox.requestFocusInWindow();
                throw new IllegalStateException(Constant.messages.getString("authentication.method.script.dialog.error.text.notLoadedNorConfigured"));
            }
            this.dynamicFieldsPanel.validateFields();
        }

        @Override
        public void saveMethod() {
            this.method.script = (ScriptWrapper)this.scriptsComboBox.getSelectedItem();
            if (this.dynamicFieldsPanel != null) {
                this.method.paramValues = this.dynamicFieldsPanel.getFieldValues();
            } else {
                this.method.paramValues = Collections.emptyMap();
            }
            if (this.loadedScript != null) {
                ScriptBasedAuthenticationMethod.access$702(this.method, this.loadedCredentialParams);
            }
        }

        @Override
        public void bindMethod(AuthenticationMethod authenticationMethod) throws AuthenticationMethodType.UnsupportedAuthenticationMethodException {
            this.method = (ScriptBasedAuthenticationMethod)authenticationMethod;
            List<ScriptWrapper> list = ScriptBasedAuthenticationMethodType.this.getScriptsExtension().getScripts(ScriptBasedAuthenticationMethodType.SCRIPT_TYPE_AUTH);
            DefaultComboBoxModel<ScriptWrapper> defaultComboBoxModel = new DefaultComboBoxModel<ScriptWrapper>(list.toArray(new ScriptWrapper[list.size()]));
            this.scriptsComboBox.setModel(defaultComboBoxModel);
            this.scriptsComboBox.setSelectedItem(this.method.script);
            this.loadScriptButton.setEnabled(this.method.script != null);
            if (this.method.script != null) {
                this.loadScript(this.method.script, false);
                if (this.dynamicFieldsPanel != null) {
                    this.dynamicFieldsPanel.bindFieldValues(this.method.paramValues);
                }
            }
        }

        @Override
        public AuthenticationMethod getMethod() {
            return this.method;
        }

        private void loadScript(ScriptWrapper scriptWrapper, boolean bl) {
            String string;
            try {
                AuthenticationScript authenticationScript = ScriptBasedAuthenticationMethodType.this.getScriptsExtension().getInterface(scriptWrapper, AuthenticationScript.class);
                if (authenticationScript != null) {
                    Object[] objectArray = authenticationScript.getRequiredParamsNames();
                    Object[] objectArray2 = authenticationScript.getOptionalParamsNames();
                    this.loadedCredentialParams = authenticationScript.getCredentialsParamsNames();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Loaded authentication script - required parameters: " + Arrays.toString(objectArray) + " - optional parameters: " + Arrays.toString(objectArray2)));
                    }
                    Map<String, String> map = null;
                    if (bl && this.dynamicFieldsPanel != null) {
                        map = this.dynamicFieldsPanel.getFieldValues();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Trying to adapt old values: " + map));
                        }
                    }
                    this.dynamicFieldsPanel = new DynamicFieldsPanel((String[])objectArray, (String[])objectArray2);
                    this.loadedScript = scriptWrapper;
                    if (bl && map != null) {
                        this.dynamicFieldsPanel.bindFieldValues(map);
                    }
                    this.dynamicContentPanel.removeAll();
                    this.dynamicContentPanel.add((Component)this.dynamicFieldsPanel, "Center");
                    this.dynamicContentPanel.revalidate();
                    return;
                }
                log.warn((Object)("The script " + scriptWrapper.getName() + " does not properly implement the Authentication Script interface."));
                string = Constant.messages.getString("authentication.method.script.dialog.error.text.interface", scriptWrapper.getName());
            }
            catch (Exception exception) {
                log.error((Object)"Error while loading authentication script", (Throwable)exception);
                string = Constant.messages.getString("authentication.method.script.dialog.error.text.loading", exception.getMessage());
            }
            if (scriptWrapper != null) {
                ScriptBasedAuthenticationMethodType.this.getScriptsExtension().setError(scriptWrapper, string);
            }
            JOptionPane.showMessageDialog(this, string, Constant.messages.getString("authentication.method.script.dialog.error.title"), 0);
            this.loadedScript = null;
            this.scriptsComboBox.setSelectedItem(null);
            this.dynamicFieldsPanel = null;
            this.dynamicContentPanel.removeAll();
            this.dynamicContentPanel.add((Component)new JLabel(this.LABEL_NOT_LOADED), "Center");
            this.dynamicContentPanel.revalidate();
        }
    }

    public class ScriptBasedAuthenticationMethod
    extends AuthenticationMethod {
        private ScriptWrapper script;
        private String[] credentialsParamNames;
        private Map<String, String> paramValues;
        private HttpSender httpSender;

        protected HttpSender getHttpSender() {
            if (this.httpSender == null) {
                this.httpSender = new HttpSender(Model.getSingleton().getOptionsParam().getConnectionParam(), true, 5);
            }
            return this.httpSender;
        }

        public void loadScript(ScriptWrapper scriptWrapper) throws IllegalArgumentException {
            try {
                AuthenticationScript authenticationScript = ScriptBasedAuthenticationMethodType.this.getScriptsExtension().getInterface(scriptWrapper, AuthenticationScript.class);
                if (authenticationScript != null) {
                    Object[] objectArray = authenticationScript.getRequiredParamsNames();
                    Object[] objectArray2 = authenticationScript.getOptionalParamsNames();
                    this.credentialsParamNames = authenticationScript.getCredentialsParamsNames();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Loaded authentication script - required parameters: " + Arrays.toString(objectArray) + " - optional parameters: " + Arrays.toString(objectArray2)));
                    }
                    Map<Object, Object> map = this.paramValues != null ? this.paramValues : Collections.emptyMap();
                    this.paramValues = new HashMap<String, String>(objectArray.length + objectArray2.length);
                    for (Object object : objectArray) {
                        this.paramValues.put((String)object, (String)map.get(object));
                    }
                    for (Object object : objectArray2) {
                        this.paramValues.put((String)object, (String)map.get(object));
                    }
                    this.script = scriptWrapper;
                    log.info((Object)("Successfully loaded new script for ScriptBasedAuthentication: " + this));
                    return;
                }
                log.warn((Object)("The script " + scriptWrapper.getName() + " does not properly implement the Authentication Script interface."));
                throw new IllegalArgumentException(Constant.messages.getString("authentication.method.script.dialog.error.text.interface", scriptWrapper.getName()));
            }
            catch (Exception exception) {
                log.error((Object)"Error while loading authentication script", (Throwable)exception);
                throw new IllegalArgumentException(Constant.messages.getString("authentication.method.script.dialog.error.text.loading", exception.getMessage()));
            }
        }

        public String toString() {
            return "ScriptBasedAuthenticationMethod [script=" + this.script + ", paramValues=" + this.paramValues + ", credentialsParamNames=" + Arrays.toString(this.credentialsParamNames) + "]";
        }

        @Override
        public boolean isConfigured() {
            return true;
        }

        @Override
        protected AuthenticationMethod duplicate() {
            ScriptBasedAuthenticationMethod scriptBasedAuthenticationMethod = new ScriptBasedAuthenticationMethod();
            scriptBasedAuthenticationMethod.script = this.script;
            scriptBasedAuthenticationMethod.paramValues = new HashMap<String, String>(this.paramValues);
            scriptBasedAuthenticationMethod.credentialsParamNames = this.credentialsParamNames;
            return scriptBasedAuthenticationMethod;
        }

        @Override
        public boolean validateCreationOfAuthenticationCredentials() {
            if (this.credentialsParamNames != null) {
                return true;
            }
            if (View.isInitialised()) {
                View.getSingleton().showMessageDialog(Constant.messages.getString("authentication.method.script.dialog.error.text.notLoaded"));
            }
            return false;
        }

        @Override
        public AuthenticationCredentials createAuthenticationCredentials() {
            return new GenericAuthenticationCredentials(this.credentialsParamNames);
        }

        @Override
        public AuthenticationMethodType getType() {
            return new ScriptBasedAuthenticationMethodType();
        }

        @Override
        public WebSession authenticate(SessionManagementMethod sessionManagementMethod, AuthenticationCredentials authenticationCredentials, User user) throws AuthenticationMethod.UnsupportedAuthenticationCredentialsException {
            if (!(authenticationCredentials instanceof GenericAuthenticationCredentials)) {
                throw new AuthenticationMethod.UnsupportedAuthenticationCredentialsException("Script based Authentication method only supports " + GenericAuthenticationCredentials.class.getSimpleName() + ". Received: " + authenticationCredentials.getClass());
            }
            GenericAuthenticationCredentials genericAuthenticationCredentials = (GenericAuthenticationCredentials)authenticationCredentials;
            HttpMessage httpMessage = null;
            try {
                AuthenticationScript authenticationScript = ScriptBasedAuthenticationMethodType.this.getScriptsExtension().getInterface(this.script, AuthenticationScript.class);
                httpMessage = authenticationScript.authenticate(new AuthenticationHelper(this.getHttpSender(), sessionManagementMethod, user), this.paramValues, genericAuthenticationCredentials);
            }
            catch (Exception exception) {
                log.error((Object)("An error occurred while trying to authenticate using the Authentication Script: " + this.script.getName()), (Throwable)exception);
                ScriptBasedAuthenticationMethodType.this.getScriptsExtension().setError(this.script, exception);
                return null;
            }
            AuthenticationHelper.notifyOutputAuthSuccessful();
            AuthenticationHelper.addAuthMessageToHistory(httpMessage);
            return sessionManagementMethod.extractWebSession(httpMessage);
        }

        @Override
        public ApiResponse getApiResponseRepresentation() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("methodName", ScriptBasedAuthenticationMethodType.API_METHOD_NAME);
            hashMap.put(ScriptBasedAuthenticationMethodType.PARAM_SCRIPT_NAME, this.script.getName());
            hashMap.putAll(this.paramValues);
            return new ApiResponseSet("method", hashMap);
        }

        static /* synthetic */ String[] access$702(ScriptBasedAuthenticationMethod scriptBasedAuthenticationMethod, String[] stringArray) {
            scriptBasedAuthenticationMethod.credentialsParamNames = stringArray;
            return stringArray;
        }
    }
}

