/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.awt.Dialog;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.ScannerParamFilter;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.AbstractFormDialog;

class ExcludedParameterAddDialog
extends AbstractFormDialog {
    private static final String DIALOG_TITLE = Constant.messages.getString("variant.options.excludedparam.dialog.token.add.title");
    private static final String CONFIRM_BUTTON_LABEL = Constant.messages.getString("variant.options.excludedparam.dialog.token.add.button.confirm");
    private static final String NAME_FIELD_LABEL = Constant.messages.getString("variant.options.excludedparam.table.header.name");
    private static final String TYPE_FIELD_LABEL = Constant.messages.getString("variant.options.excludedparam.table.header.type");
    private static final String URL_FIELD_LABEL = Constant.messages.getString("variant.options.excludedparam.table.header.url");
    private static final String TITLE_NAME_REPEATED_DIALOG = Constant.messages.getString("variant.options.excludedparam.dialog.token.warning.name.repeated.title");
    private static final String TEXT_NAME_REPEATED_DIALOG = Constant.messages.getString("variant.options.excludedparam.dialog.token.warning.name.repeated.text");
    private static final String TITLE_WARNING_INVALID_REGEX = Constant.messages.getString("variant.options.excludedparam.dialog.token.warning.invalid.regex.title");
    private static final String MESSAGE_INVALID_NAME_REGEX = Constant.messages.getString("variant.options.excludedparam.dialog.token.warning.invalid.regex.field.name");
    private ZapTextField nameTextField;
    private ZapTextField urlTextField;
    private JComboBox<String> typeTextField;
    protected ScannerParamFilter token;
    private List<ScannerParamFilter> tokens;

    public ExcludedParameterAddDialog(Dialog dialog) {
        super(dialog, DIALOG_TITLE);
    }

    protected ExcludedParameterAddDialog(Dialog dialog, String string) {
        super(dialog, string);
    }

    @Override
    protected JPanel getFieldsPanel() {
        JPanel jPanel = new JPanel();
        GroupLayout groupLayout = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout);
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setAutoCreateContainerGaps(true);
        JLabel jLabel = new JLabel(NAME_FIELD_LABEL);
        JLabel jLabel2 = new JLabel(TYPE_FIELD_LABEL);
        JLabel jLabel3 = new JLabel(URL_FIELD_LABEL);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel).addComponent(jLabel2).addComponent(jLabel3)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getNameTextField()).addComponent(this.getWhereComboField()).addComponent(this.getUrlTextField())));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel).addComponent(this.getNameTextField())).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel2).addComponent(this.getWhereComboField())).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel3).addComponent(this.getUrlTextField())));
        return jPanel;
    }

    @Override
    protected String getConfirmButtonLabel() {
        return CONFIRM_BUTTON_LABEL;
    }

    @Override
    protected void init() {
        this.getNameTextField().setText("");
        this.getUrlTextField().setText("*");
        this.getWhereComboField().setSelectedItem(ScannerParamFilter.getStringType(-1));
        this.token = null;
    }

    @Override
    protected boolean validateFields() {
        if (!this.validateName(this.getNameTextField().getText())) {
            return false;
        }
        if (!ScannerParamFilter.isValidParamNameRegex(this.getNameTextField().getText())) {
            JOptionPane.showMessageDialog(this, MESSAGE_INVALID_NAME_REGEX, TITLE_WARNING_INVALID_REGEX, 2);
            this.getNameTextField().requestFocusInWindow();
            return false;
        }
        return true;
    }

    protected boolean validateName(String string) {
        for (ScannerParamFilter scannerParamFilter : this.tokens) {
            if (!string.equals(scannerParamFilter.getParamName())) continue;
            JOptionPane.showMessageDialog(this, TEXT_NAME_REPEATED_DIALOG, TITLE_NAME_REPEATED_DIALOG, 1);
            this.getNameTextField().requestFocusInWindow();
            return false;
        }
        return true;
    }

    @Override
    protected void performAction() {
        this.token = new ScannerParamFilter();
        this.token.setParamName(this.getNameTextField().getText());
        this.token.setWildcardedUrl(this.getUrlTextField().getText());
        this.token.setType((String)this.getWhereComboField().getSelectedItem());
    }

    @Override
    protected void clearFields() {
        this.getNameTextField().setText("");
        this.getNameTextField().discardAllEdits();
        this.getUrlTextField().setText("*");
        this.getUrlTextField().discardAllEdits();
        this.getWhereComboField().setSelectedItem(ScannerParamFilter.getStringType(-1));
    }

    public ScannerParamFilter getToken() {
        return this.token;
    }

    protected ZapTextField getNameTextField() {
        if (this.nameTextField == null) {
            this.nameTextField = new ZapTextField(25);
            this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.checkAndEnableConfirmButton();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.checkAndEnableConfirmButton();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.checkAndEnableConfirmButton();
                }

                private void checkAndEnableConfirmButton() {
                    ExcludedParameterAddDialog.this.setConfirmButtonEnabled(ExcludedParameterAddDialog.this.getNameTextField().getDocument().getLength() > 0);
                }
            });
        }
        return this.nameTextField;
    }

    protected ZapTextField getUrlTextField() {
        if (this.urlTextField == null) {
            this.urlTextField = new ZapTextField(25);
        }
        return this.urlTextField;
    }

    protected JComboBox<String> getWhereComboField() {
        if (this.typeTextField == null) {
            this.typeTextField = new JComboBox();
            for (String string : ScannerParamFilter.getListTypes()) {
                this.typeTextField.addItem(string);
            }
        }
        return this.typeTextField;
    }

    public void setTokens(List<ScannerParamFilter> list) {
        this.tokens = list;
    }

    public void clear() {
        this.tokens = null;
        this.token = null;
    }
}

