/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.renderer;

import java.text.MessageFormat;
import java.text.NumberFormat;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;
import org.parosproxy.paros.Constant;

public class SizeBytesStringValue
implements StringValue {
    private static final long serialVersionUID = 8021369832769317695L;
    private static final MessageFormat TIME_DURATION_WITH_UNIT_FORMAT = new MessageFormat(Constant.messages.getString("generic.value.size.bytes.value.unit"));
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance(Constant.getLocale());
    private static final String UNIT_BYTES;
    private static final String UNIT_KBYTES;
    private static final String UNIT_MBYTES;
    private static final String UNIT_GBYTES;
    private static final int ONE_KB_IN_BYTES = 1024;
    private static final int ONE_MB_IN_BYTES = 0x100000;
    private static final int ONE_GB_IN_BYTES = 0x40000000;

    public String getString(Object object) {
        if (object instanceof Number) {
            String string;
            double d = ((Number)object).doubleValue();
            if (d < 1024.0) {
                string = UNIT_BYTES;
            } else if (d < 1048576.0) {
                d /= 1024.0;
                string = UNIT_KBYTES;
            } else if (d < 1.073741824E9) {
                d /= 1048576.0;
                string = UNIT_MBYTES;
            } else {
                d /= 1.073741824E9;
                string = UNIT_GBYTES;
            }
            return TIME_DURATION_WITH_UNIT_FORMAT.format(new Object[]{NUMBER_FORMAT.format(d), string});
        }
        return StringValues.TO_STRING.getString(object);
    }

    public static boolean isTargetClass(Class<?> clazz) {
        return Number.class.isAssignableFrom(clazz);
    }

    static {
        NUMBER_FORMAT.setMaximumFractionDigits(2);
        UNIT_BYTES = Constant.messages.getString("generic.value.size.bytes.unit.bytes");
        UNIT_KBYTES = Constant.messages.getString("generic.value.size.bytes.unit.kibytes");
        UNIT_MBYTES = Constant.messages.getString("generic.value.size.bytes.unit.mibytes");
        UNIT_GBYTES = Constant.messages.getString("generic.value.size.bytes.unit.gibytes");
    }
}

