/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.DPIUtil;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.ImageFileNameProvider;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkImage;
import org.eclipse.swt.internal.gtk.OS;

public final class Image
extends Resource
implements Drawable {
    public int type;
    public long pixmap;
    public long mask;
    public long surface;
    int transparentPixel = -1;
    GC memGC;
    byte[] alphaData;
    int alpha = -1;
    int width = -1;
    int height = -1;
    static final int DEFAULT_SCANLINE_PAD = 4;
    ImageFileNameProvider imageFileNameProvider;
    ImageDataProvider imageDataProvider;
    int currentDeviceZoom = 100;

    Image(Device device) {
        super(device);
    }

    public Image(Device device, int n, int n2) {
        super(device);
        this.init(n, n2);
        this.init();
    }

    public Image(Device device, Image image, int n) {
        super(device);
        long l;
        long l2;
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        device = this.device;
        this.type = image.type;
        if (OS.USE_CAIRO) {
            long l3;
            if (n != 1) {
                this.transparentPixel = image.transparentPixel;
            }
            this.alpha = image.alpha;
            if (image.alphaData != null) {
                this.alphaData = new byte[image.alphaData.length];
                System.arraycopy(image.alphaData, 0, this.alphaData, 0, this.alphaData.length);
            }
            long l4 = image.surface;
            int n2 = this.width = image.width;
            int n3 = this.height = image.height;
            int n4 = Cairo.cairo_surface_get_content(l4) == 4096 ? 1 : 0;
            boolean bl = n4 == 0;
            this.surface = Cairo.cairo_image_surface_create(n4, n2, n3);
            if (this.surface == 0L) {
                SWT.error(2);
            }
            if ((l3 = Cairo.cairo_create(this.surface)) == 0L) {
                SWT.error(2);
            }
            Cairo.cairo_set_operator(l3, 1);
            Cairo.cairo_set_source_surface(l3, l4, 0.0, 0.0);
            Cairo.cairo_paint(l3);
            Cairo.cairo_destroy(l3);
            if (n != 0) {
                int n5;
                int n6;
                int n7;
                int n8;
                int n9 = Cairo.cairo_image_surface_get_stride(this.surface);
                long l5 = Cairo.cairo_image_surface_get_data(this.surface);
                if (OS.BIG_ENDIAN) {
                    n8 = 0;
                    n7 = 1;
                    n6 = 2;
                    n5 = 3;
                } else {
                    n8 = 3;
                    n7 = 2;
                    n6 = 1;
                    n5 = 0;
                }
                switch (n) {
                    case 1: {
                        Color color = device.getSystemColor(18);
                        RGB rGB = color.getRGB();
                        int n10 = rGB.red;
                        int n11 = rGB.green;
                        int n12 = rGB.blue;
                        Color color2 = device.getSystemColor(22);
                        RGB rGB2 = color2.getRGB();
                        int n13 = rGB2.red;
                        int n14 = rGB2.green;
                        int n15 = rGB2.blue;
                        byte[] byArray = new byte[n9];
                        for (int i = 0; i < n3; ++i) {
                            OS.memmove(byArray, l5 + (long)(i * n9), (long)n9);
                            int n16 = 0;
                            int n17 = 0;
                            while (n16 < n2) {
                                int n18;
                                int n19 = byArray[n17 + n8] & 0xFF;
                                int n20 = byArray[n17 + n7] & 0xFF;
                                int n21 = byArray[n17 + n6] & 0xFF;
                                int n22 = byArray[n17 + n5] & 0xFF;
                                if (bl && n19 != 0) {
                                    n20 = (n20 * 255 + n19 / 2) / n19;
                                    n21 = (n21 * 255 + n19 / 2) / n19;
                                    n22 = (n22 * 255 + n19 / 2) / n19;
                                }
                                if ((n18 = n20 * n20 + n21 * n21 + n22 * n22) < 98304) {
                                    n20 = n10;
                                    n21 = n11;
                                    n22 = n12;
                                } else {
                                    n20 = n13;
                                    n21 = n14;
                                    n22 = n15;
                                }
                                if (bl) {
                                    n20 = n20 * n19 + 128;
                                    n20 = n20 + (n20 >> 8) >> 8;
                                    n21 = n21 * n19 + 128;
                                    n21 = n21 + (n21 >> 8) >> 8;
                                    n22 = n22 * n19 + 128;
                                    n22 = n22 + (n22 >> 8) >> 8;
                                }
                                byArray[n17 + n7] = (byte)n20;
                                byArray[n17 + n6] = (byte)n21;
                                byArray[n17 + n5] = (byte)n22;
                                ++n16;
                                n17 += 4;
                            }
                            OS.memmove(l5 + (long)(i * n9), byArray, (long)n9);
                        }
                        break;
                    }
                    case 2: {
                        byte[] byArray = new byte[n9];
                        for (int i = 0; i < n3; ++i) {
                            OS.memmove(byArray, l5 + (long)(i * n9), (long)n9);
                            int n23 = 0;
                            int n24 = 0;
                            while (n23 < n2) {
                                int n25 = byArray[n24 + n8] & 0xFF;
                                int n26 = byArray[n24 + n7] & 0xFF;
                                int n27 = byArray[n24 + n6] & 0xFF;
                                int n28 = byArray[n24 + n5] & 0xFF;
                                if (bl && n25 != 0) {
                                    n26 = (n26 * 255 + n25 / 2) / n25;
                                    n27 = (n27 * 255 + n25 / 2) / n25;
                                    n28 = (n28 * 255 + n25 / 2) / n25;
                                }
                                int n29 = n26 + n26 + n27 + n27 + n27 + n27 + n27 + n28 >> 3;
                                if (bl) {
                                    n29 = n29 * n25 + 128;
                                    n29 = n29 + (n29 >> 8) >> 8;
                                }
                                byte by = (byte)n29;
                                byArray[n24 + n5] = by;
                                byArray[n24 + n6] = by;
                                byArray[n24 + n7] = by;
                                ++n23;
                                n24 += 4;
                            }
                            OS.memmove(l5 + (long)(i * n9), byArray, (long)n9);
                        }
                        break;
                    }
                }
            }
            this.init();
            return;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (OS.GTK_VERSION >= OS.VERSION(2, 24, 0)) {
            OS.gdk_pixmap_get_size(image.pixmap, nArray, nArray2);
        } else {
            OS.gdk_drawable_get_size(image.pixmap, nArray, nArray2);
        }
        int n30 = nArray[0];
        int n31 = nArray2[0];
        if (image.type == 1 && image.mask != 0L || image.transparentPixel != -1) {
            if (image.transparentPixel != -1) {
                image.createMask();
            }
            if ((l2 = OS.gdk_pixmap_new(0L, n30, n31, 1)) == 0L) {
                SWT.error(2);
            }
            if ((l = OS.gdk_gc_new(l2)) == 0L) {
                SWT.error(2);
            }
            OS.gdk_draw_drawable(l2, l, image.mask, 0, 0, 0, 0, n30, n31);
            OS.g_object_unref(l);
            this.mask = l2;
            if (image.transparentPixel != -1 && image.memGC != null) {
                image.destroyMask();
            }
        }
        if (n != 1) {
            this.transparentPixel = image.transparentPixel;
        }
        this.alpha = image.alpha;
        if (image.alphaData != null) {
            this.alphaData = new byte[image.alphaData.length];
            System.arraycopy(image.alphaData, 0, this.alphaData, 0, this.alphaData.length);
        }
        this.createAlphaMask(n30, n31);
        l2 = OS.gdk_pixmap_new(OS.gdk_get_default_root_window(), n30, n31, -1);
        if (l2 == 0L) {
            SWT.error(2);
        }
        if ((l = OS.gdk_gc_new(l2)) == 0L) {
            SWT.error(2);
        }
        this.pixmap = l2;
        if (n == 0) {
            OS.gdk_draw_drawable(l2, l, image.pixmap, 0, 0, 0, 0, n30, n31);
            OS.g_object_unref(l);
        } else {
            long l6 = OS.gdk_pixbuf_new(0, false, 8, n30, n31);
            if (l6 == 0L) {
                SWT.error(2);
            }
            long l7 = OS.gdk_colormap_get_system();
            OS.gdk_pixbuf_get_from_drawable(l6, image.pixmap, l7, 0, 0, 0, 0, n30, n31);
            int n32 = OS.gdk_pixbuf_get_rowstride(l6);
            long l8 = OS.gdk_pixbuf_get_pixels(l6);
            switch (n) {
                case 1: {
                    Color color = device.getSystemColor(18);
                    RGB rGB = color.getRGB();
                    byte by = (byte)rGB.red;
                    byte by2 = (byte)rGB.green;
                    byte by3 = (byte)rGB.blue;
                    Color color3 = device.getSystemColor(22);
                    RGB rGB3 = color3.getRGB();
                    byte by4 = (byte)rGB3.red;
                    byte by5 = (byte)rGB3.green;
                    byte by6 = (byte)rGB3.blue;
                    byte[] byArray = new byte[n32];
                    for (int i = 0; i < n31; ++i) {
                        OS.memmove(byArray, l8 + (long)(i * n32), (long)n32);
                        for (int j = 0; j < n30; ++j) {
                            int n33 = j * 3;
                            int n34 = byArray[n33] & 0xFF;
                            int n35 = byArray[n33 + 1] & 0xFF;
                            int n36 = byArray[n33 + 2] & 0xFF;
                            int n37 = n34 * n34 + n35 * n35 + n36 * n36;
                            if (n37 < 98304) {
                                byArray[n33] = by;
                                byArray[n33 + 1] = by2;
                                byArray[n33 + 2] = by3;
                                continue;
                            }
                            byArray[n33] = by4;
                            byArray[n33 + 1] = by5;
                            byArray[n33 + 2] = by6;
                        }
                        OS.memmove(l8 + (long)(i * n32), byArray, (long)n32);
                    }
                    break;
                }
                case 2: {
                    byte[] byArray = new byte[n32];
                    for (int i = 0; i < n31; ++i) {
                        OS.memmove(byArray, l8 + (long)(i * n32), (long)n32);
                        for (int j = 0; j < n30; ++j) {
                            byte by;
                            int n38 = j * 3;
                            int n39 = byArray[n38] & 0xFF;
                            int n40 = byArray[n38 + 1] & 0xFF;
                            int n41 = byArray[n38 + 2] & 0xFF;
                            byte by7 = by = (byte)(n39 + n39 + n40 + n40 + n40 + n40 + n40 + n41 >> 3);
                            byArray[n38 + 2] = by7;
                            byArray[n38 + 1] = by7;
                            byArray[n38] = by7;
                        }
                        OS.memmove(l8 + (long)(i * n32), byArray, (long)n32);
                    }
                    break;
                }
            }
            OS.gdk_pixbuf_render_to_drawable(l6, l2, l, 0, 0, 0, 0, n30, n31, 1, 0, 0);
            OS.g_object_unref(l6);
            OS.g_object_unref(l);
        }
        this.init();
    }

    public Image(Device device, Rectangle rectangle) {
        super(device);
        if (rectangle == null) {
            SWT.error(4);
        }
        this.init(rectangle.width, rectangle.height);
        this.init();
    }

    public Image(Device device, ImageData imageData) {
        super(device);
        this.init(imageData);
        this.init();
    }

    public Image(Device device, ImageData imageData, ImageData imageData2) {
        super(device);
        if (imageData == null) {
            SWT.error(4);
        }
        if (imageData2 == null) {
            SWT.error(4);
        }
        if (imageData.width != imageData2.width || imageData.height != imageData2.height) {
            SWT.error(5);
        }
        imageData2 = ImageData.convertMask(imageData2);
        ImageData imageData3 = new ImageData(imageData.width, imageData.height, imageData.depth, imageData.palette, imageData.scanlinePad, imageData.data);
        imageData3.maskPad = imageData2.scanlinePad;
        imageData3.maskData = imageData2.data;
        this.init(imageData3);
        this.init();
    }

    public Image(Device device, InputStream inputStream) {
        super(device);
        this.init(new ImageData(inputStream));
        this.init();
    }

    public Image(Device device, String string) {
        super(device);
        if (string == null) {
            SWT.error(4);
        }
        this.initNative(string);
        if (this.pixmap == 0L && this.surface == 0L) {
            this.init(new ImageData(string));
        }
        this.init();
    }

    public Image(Device device, ImageFileNameProvider imageFileNameProvider) {
        super(device);
        this.imageFileNameProvider = imageFileNameProvider;
        this.currentDeviceZoom = this.getDeviceZoom();
        String string = DPIUtil.validateAndGetImagePathAtZoom(imageFileNameProvider, this.currentDeviceZoom, new boolean[1]);
        this.initNative(string);
        if (this.pixmap == 0L && this.surface == 0L) {
            this.init(new ImageData(string));
        }
        this.init();
    }

    public Image(Device device, ImageDataProvider imageDataProvider) {
        super(device);
        this.imageDataProvider = imageDataProvider;
        this.currentDeviceZoom = this.getDeviceZoom();
        ImageData imageData = DPIUtil.validateAndGetImageDataAtZoom(imageDataProvider, this.currentDeviceZoom, new boolean[1]);
        this.init(imageData);
        this.init();
    }

    int getDeviceZoom() {
        return DPIUtil.mapDPIToZoom(this.device._getDPIx());
    }

    boolean refreshImageForZoom() {
        int n;
        boolean bl = false;
        if (this.imageFileNameProvider != null) {
            int n2 = this.getDeviceZoom();
            if (n2 != this.currentDeviceZoom) {
                boolean[] blArray = new boolean[1];
                String string = DPIUtil.validateAndGetImagePathAtZoom(this.imageFileNameProvider, n2, blArray);
                if (blArray[0] || this.currentDeviceZoom != 100) {
                    this.destroy();
                    this.initNative(string);
                    if (this.pixmap == 0L && this.surface == 0L) {
                        this.init(new ImageData(string));
                    }
                    this.init();
                    bl = true;
                }
                this.currentDeviceZoom = n2;
            }
        } else if (this.imageDataProvider != null && (n = this.getDeviceZoom()) != this.currentDeviceZoom) {
            boolean[] blArray = new boolean[1];
            ImageData imageData = DPIUtil.validateAndGetImageDataAtZoom(this.imageDataProvider, n, blArray);
            if (blArray[0] || this.currentDeviceZoom != 100) {
                this.destroy();
                this.init(imageData);
                this.init();
                bl = true;
            }
            this.currentDeviceZoom = n;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initNative(String string) {
        block6: {
            try {
                int n = string.length();
                char[] cArray = new char[n];
                string.getChars(0, n, cArray, 0);
                byte[] byArray = Converter.wcsToMbcs(null, cArray, true);
                long l = OS.gdk_pixbuf_new_from_file(byArray, null);
                if (l == 0L) break block6;
                try {
                    this.createFromPixbuf(0, l);
                }
                finally {
                    if (l != 0L) {
                        OS.g_object_unref(l);
                    }
                }
            }
            catch (SWTException sWTException) {
                // empty catch block
            }
        }
    }

    void createAlphaMask(int n, int n2) {
        if (this.device.useXRender && (this.alpha != -1 || this.alphaData != null)) {
            this.mask = OS.gdk_pixmap_new(0L, this.alpha != -1 ? 1 : n, this.alpha != -1 ? 1 : n2, 8);
            if (this.mask == 0L) {
                SWT.error(2);
            }
            long l = OS.gdk_gc_new(this.mask);
            if (this.alpha != -1) {
                GdkColor gdkColor = new GdkColor();
                gdkColor.pixel = (this.alpha & 0xFF) << 8 | this.alpha & 0xFF;
                OS.gdk_gc_set_foreground(l, gdkColor);
                OS.gdk_draw_rectangle(this.mask, l, 1, 0, 0, 1, 1);
            } else {
                long l2 = OS.gdk_drawable_get_image(this.mask, 0, 0, n, n2);
                if (l2 == 0L) {
                    SWT.error(2);
                }
                GdkImage gdkImage = new GdkImage();
                OS.memmove(gdkImage, l2);
                if (gdkImage.bpl == n) {
                    OS.memmove(gdkImage.mem, this.alphaData, (long)this.alphaData.length);
                } else {
                    byte[] byArray = new byte[gdkImage.bpl];
                    for (int i = 0; i < n2; ++i) {
                        System.arraycopy(this.alphaData, n * i, byArray, 0, n);
                        OS.memmove(gdkImage.mem + (long)(gdkImage.bpl * i), byArray, (long)gdkImage.bpl);
                    }
                }
                OS.gdk_draw_image(this.mask, l, l2, 0, 0, 0, 0, n, n2);
                OS.g_object_unref(l2);
            }
            OS.g_object_unref(l);
        }
    }

    void createFromPixbuf(int n, long l) {
        this.type = n;
        boolean bl = OS.gdk_pixbuf_get_has_alpha(l);
        if (OS.USE_CAIRO) {
            int n2 = this.width = OS.gdk_pixbuf_get_width(l);
            int n3 = this.height = OS.gdk_pixbuf_get_height(l);
            int n4 = OS.gdk_pixbuf_get_rowstride(l);
            long l2 = OS.gdk_pixbuf_get_pixels(l);
            int n5 = bl ? 0 : 1;
            this.surface = Cairo.cairo_image_surface_create(n5, n2, n3);
            if (this.surface == 0L) {
                SWT.error(2);
            }
            long l3 = Cairo.cairo_image_surface_get_data(this.surface);
            int n6 = Cairo.cairo_image_surface_get_stride(this.surface);
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            if (OS.BIG_ENDIAN) {
                n7 = 0;
                n8 = 1;
                n9 = 2;
                n10 = 3;
            } else {
                n7 = 3;
                n8 = 2;
                n9 = 1;
                n10 = 0;
            }
            byte[] byArray = new byte[n4];
            if (bl) {
                this.alphaData = new byte[n2 * n3];
                int n11 = 0;
                for (int i = 0; i < n3; ++i) {
                    OS.memmove(byArray, l2 + (long)(i * n4), (long)n4);
                    int n12 = 0;
                    int n13 = 0;
                    while (n12 < n2) {
                        int n14 = byArray[n13 + 3] & 0xFF;
                        int n15 = (byArray[n13 + 0] & 0xFF) * n14 + 128;
                        n15 = n15 + (n15 >> 8) >> 8;
                        int n16 = (byArray[n13 + 1] & 0xFF) * n14 + 128;
                        n16 = n16 + (n16 >> 8) >> 8;
                        int n17 = (byArray[n13 + 2] & 0xFF) * n14 + 128;
                        n17 = n17 + (n17 >> 8) >> 8;
                        byArray[n13 + n7] = (byte)n14;
                        byArray[n13 + n8] = (byte)n15;
                        byArray[n13 + n9] = (byte)n16;
                        byArray[n13 + n10] = (byte)n17;
                        this.alphaData[n11++] = (byte)n14;
                        ++n12;
                        n13 += 4;
                    }
                    OS.memmove(l3 + (long)(i * n4), byArray, (long)n4);
                }
            } else {
                byte[] byArray2 = new byte[n6];
                for (int i = 0; i < n3; ++i) {
                    OS.memmove(byArray, l2 + (long)(i * n4), (long)n4);
                    int n18 = 0;
                    int n19 = 0;
                    int n20 = 0;
                    while (n18 < n2) {
                        int n21 = byArray[n19 + 0] & 0xFF;
                        int n22 = byArray[n19 + 1] & 0xFF;
                        int n23 = byArray[n19 + 2] & 0xFF;
                        byArray2[n20 + n8] = (byte)n21;
                        byArray2[n20 + n9] = (byte)n22;
                        byArray2[n20 + n10] = (byte)n23;
                        ++n18;
                        n19 += 3;
                        n20 += 4;
                    }
                    OS.memmove(l3 + (long)(i * n6), byArray2, (long)n6);
                }
            }
            Cairo.cairo_surface_mark_dirty(this.surface);
        } else {
            if (bl) {
                int n24 = OS.gdk_pixbuf_get_width(l);
                int n25 = OS.gdk_pixbuf_get_height(l);
                int n26 = OS.gdk_pixbuf_get_rowstride(l);
                long l4 = OS.gdk_pixbuf_get_pixels(l);
                byte[] byArray = new byte[n26];
                this.alphaData = new byte[n24 * n25];
                for (int i = 0; i < n25; ++i) {
                    OS.memmove(byArray, l4 + (long)(i * n26), (long)n26);
                    for (int j = 0; j < n24; ++j) {
                        this.alphaData[i * n24 + j] = byArray[j * 4 + 3];
                        byArray[j * 4 + 3] = -1;
                    }
                    OS.memmove(l4 + (long)(i * n26), byArray, (long)n26);
                }
                this.createAlphaMask(n24, n25);
            }
            long[] lArray = new long[1];
            OS.gdk_pixbuf_render_pixmap_and_mask(l, lArray, null, 0);
            this.pixmap = lArray[0];
            if (this.pixmap == 0L) {
                SWT.error(2);
            }
        }
    }

    void createMask() {
        if (OS.USE_CAIRO) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8 = this.width;
            int n9 = this.height;
            int n10 = Cairo.cairo_image_surface_get_stride(this.surface);
            long l = Cairo.cairo_image_surface_get_data(this.surface);
            if (OS.BIG_ENDIAN) {
                n7 = 0;
                n6 = 1;
                n5 = 2;
                n4 = 3;
                n3 = this.transparentPixel >> 24 & 0xFF;
                n2 = this.transparentPixel >> 16 & 0xFF;
                n = this.transparentPixel >> 8 & 0xFF;
            } else {
                n7 = 3;
                n6 = 2;
                n5 = 1;
                n4 = 0;
                n3 = this.transparentPixel >> 16 & 0xFF;
                n2 = this.transparentPixel >> 8 & 0xFF;
                n = this.transparentPixel >> 0 & 0xFF;
            }
            byte[] byArray = new byte[n10 * n9];
            OS.memmove(byArray, l, (long)byArray.length);
            int n11 = 0;
            for (int i = 0; i < n9; ++i) {
                int n12 = 0;
                while (n12 < n8) {
                    int n13 = byArray[n11 + n7] & 0xFF;
                    int n14 = byArray[n11 + n6] & 0xFF;
                    int n15 = byArray[n11 + n5] & 0xFF;
                    int n16 = byArray[n11 + n4] & 0xFF;
                    if (n14 == n3 && n15 == n2 && n16 == n) {
                        n16 = 0;
                        n15 = 0;
                        n14 = 0;
                        n13 = 0;
                    } else {
                        n13 = 255;
                    }
                    byArray[n11 + n7] = (byte)n13;
                    byArray[n11 + n6] = (byte)n14;
                    byArray[n11 + n5] = (byte)n15;
                    byArray[n11 + n4] = (byte)n16;
                    ++n12;
                    n11 += 4;
                }
            }
            OS.memmove(l, byArray, (long)byArray.length);
            return;
        }
        if (this.mask != 0L) {
            return;
        }
        this.mask = this.createMask(this.getImageData(), false);
        if (this.mask == 0L) {
            SWT.error(2);
        }
    }

    long createMask(ImageData imageData, boolean bl) {
        ImageData imageData2 = imageData.getTransparencyMask();
        byte[] byArray = imageData2.data;
        byte[] byArray2 = bl ? new byte[byArray.length] : byArray;
        for (int i = 0; i < byArray2.length; ++i) {
            byte by = byArray[i];
            byArray2[i] = (byte)((by & 0x80) >> 7 | (by & 0x40) >> 5 | (by & 0x20) >> 3 | (by & 0x10) >> 1 | (by & 8) << 1 | (by & 4) << 3 | (by & 2) << 5 | (by & 1) << 7);
        }
        byArray2 = ImageData.convertPad(byArray2, imageData2.width, imageData2.height, imageData2.depth, imageData2.scanlinePad, 1);
        return OS.gdk_bitmap_create_from_data(0L, byArray2, imageData2.width, imageData2.height);
    }

    void createSurface() {
        if (this.surface != 0L) {
            return;
        }
        if (OS.GTK3) {
            return;
        }
        if (this.transparentPixel != -1) {
            this.createMask();
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (OS.GTK_VERSION >= OS.VERSION(2, 24, 0)) {
            OS.gdk_pixmap_get_size(this.pixmap, nArray, nArray2);
        } else {
            OS.gdk_drawable_get_size(this.pixmap, nArray, nArray2);
        }
        int n = nArray[0];
        int n2 = nArray2[0];
        this.width = n;
        this.height = n2;
        if (this.mask != 0L || this.alpha != -1 || this.alphaData != null) {
            long l;
            int n3;
            int n4;
            int n5;
            int n6;
            long l2 = OS.gdk_pixbuf_new(0, true, 8, n, n2);
            if (l2 == 0L) {
                SWT.error(2);
            }
            long l3 = OS.gdk_colormap_get_system();
            OS.gdk_pixbuf_get_from_drawable(l2, this.pixmap, l3, 0, 0, 0, 0, n, n2);
            int n7 = OS.gdk_pixbuf_get_rowstride(l2);
            long l4 = OS.gdk_pixbuf_get_pixels(l2);
            byte[] byArray = new byte[n7];
            if (OS.BIG_ENDIAN) {
                n6 = 0;
                n5 = 1;
                n4 = 2;
                n3 = 3;
            } else {
                n6 = 3;
                n5 = 2;
                n4 = 1;
                n3 = 0;
            }
            if (this.mask != 0L && OS.gdk_drawable_get_depth(this.mask) == 1) {
                l = OS.gdk_pixbuf_new(0, false, 8, n, n2);
                if (l == 0L) {
                    SWT.error(2);
                }
                OS.gdk_pixbuf_get_from_drawable(l, this.mask, 0L, 0, 0, 0, 0, n, n2);
                int n8 = OS.gdk_pixbuf_get_rowstride(l);
                long l5 = OS.gdk_pixbuf_get_pixels(l);
                byte[] byArray2 = new byte[n8];
                long l6 = l4;
                long l7 = l5;
                for (int i = 0; i < n2; ++i) {
                    OS.memmove(byArray, l6, (long)n7);
                    OS.memmove(byArray2, l7, (long)n8);
                    int n9 = 0;
                    int n10 = 0;
                    while (n9 < n) {
                        if (byArray2[n9 * 3] == 0) {
                            byArray[n10 + 3] = 0;
                            byArray[n10 + 2] = 0;
                            byArray[n10 + 1] = 0;
                            byArray[n10 + 0] = 0;
                        } else {
                            byte by = byArray[n10 + 0];
                            byte by2 = byArray[n10 + 1];
                            byte by3 = byArray[n10 + 2];
                            byArray[n10 + n6] = -1;
                            byArray[n10 + n5] = by;
                            byArray[n10 + n4] = by2;
                            byArray[n10 + n3] = by3;
                        }
                        ++n9;
                        n10 += 4;
                    }
                    OS.memmove(l6, byArray, (long)n7);
                    l6 += (long)n7;
                    l7 += (long)n8;
                }
                OS.g_object_unref(l);
            } else if (this.alpha != -1) {
                l = l4;
                for (int i = 0; i < n2; ++i) {
                    OS.memmove(byArray, l, (long)n7);
                    int n11 = 0;
                    int n12 = 0;
                    while (n11 < n) {
                        int n13 = (byArray[n12 + 0] & 0xFF) * this.alpha + 128;
                        n13 = n13 + (n13 >> 8) >> 8;
                        int n14 = (byArray[n12 + 1] & 0xFF) * this.alpha + 128;
                        n14 = n14 + (n14 >> 8) >> 8;
                        int n15 = (byArray[n12 + 2] & 0xFF) * this.alpha + 128;
                        n15 = n15 + (n15 >> 8) >> 8;
                        byArray[n12 + n6] = (byte)this.alpha;
                        byArray[n12 + n5] = (byte)n13;
                        byArray[n12 + n4] = (byte)n14;
                        byArray[n12 + n3] = (byte)n15;
                        ++n11;
                        n12 += 4;
                    }
                    OS.memmove(l, byArray, (long)n7);
                    l += (long)n7;
                }
            } else if (this.alphaData != null) {
                l = l4;
                for (int i = 0; i < nArray2[0]; ++i) {
                    OS.memmove(byArray, l, (long)n7);
                    int n16 = 0;
                    int n17 = 0;
                    while (n16 < n) {
                        int n18 = this.alphaData[i * nArray[0] + n16] & 0xFF;
                        int n19 = (byArray[n17 + 0] & 0xFF) * n18 + 128;
                        n19 = n19 + (n19 >> 8) >> 8;
                        int n20 = (byArray[n17 + 1] & 0xFF) * n18 + 128;
                        n20 = n20 + (n20 >> 8) >> 8;
                        int n21 = (byArray[n17 + 2] & 0xFF) * n18 + 128;
                        n21 = n21 + (n21 >> 8) >> 8;
                        byArray[n17 + n6] = (byte)n18;
                        byArray[n17 + n5] = (byte)n19;
                        byArray[n17 + n4] = (byte)n20;
                        byArray[n17 + n3] = (byte)n21;
                        ++n16;
                        n17 += 4;
                    }
                    OS.memmove(l, byArray, (long)n7);
                    l += (long)n7;
                }
            } else {
                l = l4;
                for (int i = 0; i < nArray2[0]; ++i) {
                    OS.memmove(byArray, l, (long)n7);
                    int n22 = 0;
                    int n23 = 0;
                    while (n22 < n) {
                        byte by = byArray[n23 + 0];
                        byte by4 = byArray[n23 + 1];
                        byte by5 = byArray[n23 + 2];
                        byArray[n23 + n6] = -1;
                        byArray[n23 + n5] = by;
                        byArray[n23 + n4] = by4;
                        byArray[n23 + n3] = by5;
                        ++n22;
                        n23 += 4;
                    }
                    OS.memmove(l, byArray, (long)n7);
                    l += (long)n7;
                }
            }
            this.surface = Cairo.cairo_image_surface_create(0, n, n2);
            l = Cairo.cairo_image_surface_get_data(this.surface);
            OS.memmove(l, l4, (long)(n7 * n2));
            Cairo.cairo_surface_mark_dirty(this.surface);
            OS.g_object_unref(l2);
        } else {
            long l = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
            long l8 = OS.GDK_PIXMAP_XID(this.pixmap);
            long l9 = OS.gdk_x11_visual_get_xvisual(OS.gdk_visual_get_system());
            this.surface = Cairo.cairo_xlib_surface_create(l, l8, l9, n, n2);
        }
        if (this.transparentPixel != -1 && this.memGC != null) {
            this.destroyMask();
        }
    }

    void destroyMask() {
        if (this.mask == 0L) {
            return;
        }
        OS.g_object_unref(this.mask);
        this.mask = 0L;
    }

    @Override
    void destroy() {
        if (this.memGC != null) {
            this.memGC.dispose();
        }
        if (this.pixmap != 0L) {
            OS.g_object_unref(this.pixmap);
        }
        if (this.mask != 0L) {
            OS.g_object_unref(this.mask);
        }
        if (this.surface != 0L) {
            Cairo.cairo_surface_destroy(this.surface);
        }
        this.mask = 0L;
        this.pixmap = 0L;
        this.surface = 0L;
        this.memGC = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        if (this.device != image.device || this.transparentPixel != image.transparentPixel) {
            return false;
        }
        if (this.imageDataProvider != null && image.imageDataProvider != null) {
            return this.imageDataProvider.equals(image.imageDataProvider);
        }
        if (this.imageFileNameProvider != null && image.imageFileNameProvider != null) {
            return this.imageFileNameProvider.equals(image.imageFileNameProvider);
        }
        if (OS.USE_CAIRO) {
            return this.surface == image.surface;
        }
        return this.pixmap == image.pixmap;
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.transparentPixel == -1) {
            return null;
        }
        return null;
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.width != -1 && this.height != -1) {
            return new Rectangle(0, 0, this.width, this.height);
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (OS.GTK_VERSION >= OS.VERSION(2, 24, 0)) {
            OS.gdk_pixmap_get_size(this.pixmap, nArray, nArray2);
        } else {
            OS.gdk_drawable_get_size(this.pixmap, nArray, nArray2);
        }
        this.width = nArray[0];
        this.height = nArray2[0];
        return new Rectangle(0, 0, this.width, this.height);
    }

    public ImageData getImageData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (OS.USE_CAIRO) {
            int n;
            int n2;
            int n3;
            int n4;
            boolean bl;
            long l = ImageList.convertSurface(this);
            int n5 = Cairo.cairo_image_surface_get_format(l);
            int n6 = Cairo.cairo_image_surface_get_width(l);
            int n7 = Cairo.cairo_image_surface_get_height(l);
            int n8 = Cairo.cairo_image_surface_get_stride(l);
            long l2 = Cairo.cairo_image_surface_get_data(l);
            boolean bl2 = bl = n5 == 0;
            if (OS.BIG_ENDIAN) {
                n4 = 0;
                n3 = 1;
                n2 = 2;
                n = 3;
            } else {
                n4 = 3;
                n3 = 2;
                n2 = 1;
                n = 0;
            }
            byte[] byArray = new byte[n8 * n7];
            OS.memmove(byArray, l2, (long)byArray.length);
            PaletteData paletteData = new PaletteData(0xFF0000, 65280, 255);
            ImageData imageData = new ImageData(n6, n7, 32, paletteData, 4, byArray);
            if (bl) {
                imageData.alphaData = new byte[n6 * n7];
                byte[] byArray2 = imageData.alphaData;
                int n9 = 0;
                int n10 = 0;
                for (int i = 0; i < n7; ++i) {
                    int n11 = 0;
                    while (n11 < n6) {
                        int n12 = byArray[n9 + n4] & 0xFF;
                        int n13 = byArray[n9 + n3] & 0xFF;
                        int n14 = byArray[n9 + n2] & 0xFF;
                        int n15 = byArray[n9 + n] & 0xFF;
                        byArray[n9 + 0] = 0;
                        byArray2[n10++] = (byte)n12;
                        if (n12 != 0) {
                            byArray[n9 + 1] = (byte)((n13 * 255 + n12 / 2) / n12);
                            byArray[n9 + 2] = (byte)((n14 * 255 + n12 / 2) / n12);
                            byArray[n9 + 3] = (byte)((n15 * 255 + n12 / 2) / n12);
                        }
                        ++n11;
                        n9 += 4;
                    }
                }
            } else {
                int n16 = 0;
                for (int i = 0; i < n7; ++i) {
                    int n17 = 0;
                    while (n17 < n6) {
                        byte by = byArray[n16 + n3];
                        byte by2 = byArray[n16 + n2];
                        byte by3 = byArray[n16 + n];
                        byArray[n16 + 0] = 0;
                        byArray[n16 + 1] = by;
                        byArray[n16 + 2] = by2;
                        byArray[n16 + 3] = by3;
                        ++n17;
                        n16 += 4;
                    }
                }
            }
            Cairo.cairo_surface_destroy(l);
            return imageData;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (OS.GTK_VERSION >= OS.VERSION(2, 24, 0)) {
            OS.gdk_pixmap_get_size(this.pixmap, nArray, nArray2);
        } else {
            OS.gdk_drawable_get_size(this.pixmap, nArray, nArray2);
        }
        int n = nArray[0];
        int n18 = nArray2[0];
        long l = OS.gdk_pixbuf_new(0, false, 8, n, n18);
        if (l == 0L) {
            SWT.error(2);
        }
        long l3 = OS.gdk_colormap_get_system();
        OS.gdk_pixbuf_get_from_drawable(l, this.pixmap, l3, 0, 0, 0, 0, n, n18);
        int n19 = OS.gdk_pixbuf_get_rowstride(l);
        long l4 = OS.gdk_pixbuf_get_pixels(l);
        byte[] byArray = new byte[n19 * n18];
        OS.memmove(byArray, l4, (long)byArray.length);
        OS.g_object_unref(l);
        PaletteData paletteData = new PaletteData(0xFF0000, 65280, 255);
        ImageData imageData = new ImageData(n, n18, 24, paletteData, 4, byArray);
        imageData.bytesPerLine = n19;
        if (this.transparentPixel == -1 && this.type == 1 && this.mask != 0L) {
            int n20;
            int n21;
            long l5 = OS.gdk_drawable_get_image(this.mask, 0, 0, n, n18);
            if (l5 == 0L) {
                SWT.error(2);
            }
            GdkImage gdkImage = new GdkImage();
            OS.memmove(gdkImage, l5);
            byte[] byArray3 = new byte[gdkImage.bpl * gdkImage.height];
            OS.memmove(byArray3, gdkImage.mem, (long)byArray3.length);
            OS.g_object_unref(l5);
            for (n21 = 1; n21 < 128 && gdkImage.bpl != (n20 = ((n + 7) / 8 + (n21 - 1)) / n21 * n21); ++n21) {
            }
            imageData.maskPad = 2;
            byArray3 = ImageData.convertPad(byArray3, n, n18, 1, n21, imageData.maskPad);
            if (gdkImage.byte_order == 0) {
                for (n20 = 0; n20 < byArray3.length; ++n20) {
                    byte by = byArray3[n20];
                    byArray3[n20] = (byte)((by & 1) << 7 | (by & 2) << 5 | (by & 4) << 3 | (by & 8) << 1 | (by & 0x10) >> 1 | (by & 0x20) >> 3 | (by & 0x40) >> 5 | (by & 0x80) >> 7);
                }
            }
            imageData.maskData = byArray3;
        }
        imageData.transparentPixel = this.transparentPixel;
        imageData.alpha = this.alpha;
        if (this.alpha == -1 && this.alphaData != null) {
            imageData.alphaData = new byte[this.alphaData.length];
            System.arraycopy(this.alphaData, 0, imageData.alphaData, 0, this.alphaData.length);
        }
        return imageData;
    }

    public static Image gtk_new(Device device, int n, long l, long l2) {
        Image image = new Image(device);
        image.type = n;
        if (OS.GTK3) {
            image.surface = l;
        } else {
            image.pixmap = l;
            if (OS.USE_CAIRO) {
                image.createSurface();
            }
        }
        image.mask = l2;
        return image;
    }

    public static Image gtk_new_from_pixbuf(Device device, int n, long l) {
        Image image = new Image(device);
        image.createFromPixbuf(n, l);
        image.type = n;
        return image;
    }

    public int hashCode() {
        if (this.imageDataProvider != null) {
            return this.imageDataProvider.hashCode();
        }
        if (this.imageFileNameProvider != null) {
            return this.imageFileNameProvider.hashCode();
        }
        if (OS.USE_CAIRO) {
            return (int)this.surface;
        }
        return (int)this.pixmap;
    }

    void init(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            SWT.error(5);
        }
        this.type = 0;
        if (OS.USE_CAIRO) {
            long l;
            if (OS.GTK_VERSION >= OS.VERSION(2, 22, 0)) {
                this.surface = OS.gdk_window_create_similar_surface(OS.gdk_get_default_root_window(), 4096, n, n2);
            } else {
                long l2;
                long l3;
                l = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
                long l4 = Cairo.cairo_xlib_surface_create(l, l3 = OS.gdk_x11_drawable_get_xid(OS.gdk_get_default_root_window()), l2 = OS.gdk_x11_visual_get_xvisual(OS.gdk_visual_get_system()), 1, 1);
                if (l4 == 0L) {
                    SWT.error(2);
                }
                this.surface = Cairo.cairo_surface_create_similar(l4, 4096, n, n2);
                Cairo.cairo_surface_destroy(l4);
            }
            if (this.surface == 0L) {
                SWT.error(2);
            }
            if ((l = Cairo.cairo_create(this.surface)) == 0L) {
                SWT.error(2);
            }
            Cairo.cairo_set_source_rgb(l, 1.0, 1.0, 1.0);
            Cairo.cairo_rectangle(l, 0.0, 0.0, n, n2);
            Cairo.cairo_fill(l);
            Cairo.cairo_destroy(l);
            this.width = n;
            this.height = n2;
            return;
        }
        this.pixmap = OS.gdk_pixmap_new(OS.gdk_get_default_root_window(), n, n2, -1);
        if (this.pixmap == 0L) {
            SWT.error(2);
        }
        GdkColor gdkColor = new GdkColor();
        gdkColor.red = (short)-1;
        gdkColor.green = (short)-1;
        gdkColor.blue = (short)-1;
        long l = OS.gdk_colormap_get_system();
        OS.gdk_colormap_alloc_color(l, gdkColor, true, true);
        long l5 = OS.gdk_gc_new(this.pixmap);
        OS.gdk_gc_set_foreground(l5, gdkColor);
        OS.gdk_draw_rectangle(this.pixmap, l5, 1, 0, 0, n, n2);
        OS.g_object_unref(l5);
        OS.gdk_colormap_free_colors(l, gdkColor, 1);
    }

    void init(ImageData imageData) {
        boolean bl;
        long l;
        if (imageData == null) {
            SWT.error(4);
        }
        int n = this.width = imageData.width;
        int n2 = this.height = imageData.height;
        PaletteData paletteData = imageData.palette;
        if ((imageData.depth != 1 && imageData.depth != 2 && imageData.depth != 4 && imageData.depth != 8 || paletteData.isDirect) && imageData.depth != 8 && (imageData.depth != 16 && imageData.depth != 24 && imageData.depth != 32 || !paletteData.isDirect)) {
            SWT.error(38);
        }
        if (OS.USE_CAIRO) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            boolean bl2 = imageData.transparentPixel != -1 || imageData.alpha != -1 || imageData.maskData != null || imageData.alphaData != null;
            int n9 = bl2 ? 0 : 1;
            this.surface = Cairo.cairo_image_surface_create(n9, n, n2);
            if (this.surface == 0L) {
                SWT.error(2);
            }
            int n10 = Cairo.cairo_image_surface_get_stride(this.surface);
            long l2 = Cairo.cairo_image_surface_get_data(this.surface);
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            int n14 = 0;
            int n15 = 32;
            if (OS.BIG_ENDIAN) {
                n11 = 0;
                n12 = 1;
                n13 = 2;
                n14 = 3;
                n8 = 65280;
                n7 = 0xFF0000;
                n6 = -16777216;
                n5 = 1;
            } else {
                n11 = 3;
                n12 = 2;
                n13 = 1;
                n14 = 0;
                n8 = 0xFF0000;
                n7 = 65280;
                n6 = 255;
                n5 = 0;
            }
            byte[] byArray = imageData.data;
            if (!paletteData.isDirect || imageData.depth != n15 || n10 != imageData.bytesPerLine || paletteData.redMask != n8 || paletteData.greenMask != n7 || paletteData.blueMask != n6 || n5 != imageData.getByteOrder()) {
                byArray = new byte[n10 * n2];
                if (paletteData.isDirect) {
                    ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, n, n2, paletteData.redMask, paletteData.greenMask, paletteData.blueMask, 255, null, 0, 0, 0, byArray, n15, n10, n5, 0, 0, n, n2, n8, n7, n6, false, false);
                } else {
                    RGB[] rGBArray = paletteData.getRGBs();
                    n4 = rGBArray.length;
                    byte[] byArray2 = new byte[n4];
                    byte[] byArray3 = new byte[n4];
                    byte[] byArray4 = new byte[n4];
                    for (n3 = 0; n3 < rGBArray.length; ++n3) {
                        RGB rGB = rGBArray[n3];
                        if (rGB == null) continue;
                        byArray2[n3] = (byte)rGB.red;
                        byArray3[n3] = (byte)rGB.green;
                        byArray4[n3] = (byte)rGB.blue;
                    }
                    ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, n, n2, byArray2, byArray3, byArray4, 255, null, 0, 0, 0, byArray, n15, n10, n5, 0, 0, n, n2, n8, n7, n6, false, false);
                }
            }
            boolean bl3 = imageData.getTransparencyType() == 2;
            int n16 = this.type = bl3 ? 1 : 0;
            if (bl3 || imageData.transparentPixel != -1) {
                if (imageData.transparentPixel != -1) {
                    RGB rGB = null;
                    if (paletteData.isDirect) {
                        rGB = paletteData.getRGB(imageData.transparentPixel);
                    } else if (imageData.transparentPixel < paletteData.colors.length) {
                        rGB = paletteData.getRGB(imageData.transparentPixel);
                    }
                    if (rGB != null) {
                        this.transparentPixel = rGB.red << 16 | rGB.green << 8 | rGB.blue;
                    }
                }
                ImageData imageData2 = imageData.getTransparencyMask();
                int n17 = 0;
                for (int i = 0; i < n2; ++i) {
                    int n18 = 0;
                    while (n18 < n) {
                        n3 = imageData2.getPixel(n18, i) == 0 ? 0 : 255;
                        int n19 = (byArray[n17 + n12] & 0xFF) * n3 + 128;
                        n19 = n19 + (n19 >> 8) >> 8;
                        int n20 = (byArray[n17 + n13] & 0xFF) * n3 + 128;
                        n20 = n20 + (n20 >> 8) >> 8;
                        int n21 = (byArray[n17 + n14] & 0xFF) * n3 + 128;
                        n21 = n21 + (n21 >> 8) >> 8;
                        byArray[n17 + n11] = (byte)n3;
                        byArray[n17 + n12] = (byte)n19;
                        byArray[n17 + n13] = (byte)n20;
                        byArray[n17 + n14] = (byte)n21;
                        ++n18;
                        n17 += 4;
                    }
                }
            } else {
                this.alpha = imageData.alpha;
                if (imageData.alpha == -1 && imageData.alphaData != null) {
                    this.alphaData = new byte[imageData.alphaData.length];
                    System.arraycopy(imageData.alphaData, 0, this.alphaData, 0, this.alphaData.length);
                }
                if (this.alpha != -1) {
                    int n22 = 0;
                    for (n4 = 0; n4 < n2; ++n4) {
                        int n23 = 0;
                        while (n23 < n) {
                            int n24 = this.alpha;
                            n3 = (byArray[n22 + n12] & 0xFF) * n24 + 128;
                            n3 = n3 + (n3 >> 8) >> 8;
                            int n25 = (byArray[n22 + n13] & 0xFF) * n24 + 128;
                            n25 = n25 + (n25 >> 8) >> 8;
                            int n26 = (byArray[n22 + n14] & 0xFF) * n24 + 128;
                            n26 = n26 + (n26 >> 8) >> 8;
                            byArray[n22 + n11] = (byte)n24;
                            byArray[n22 + n12] = (byte)n3;
                            byArray[n22 + n13] = (byte)n25;
                            byArray[n22 + n14] = (byte)n26;
                            ++n23;
                            n22 += 4;
                        }
                    }
                } else if (this.alphaData != null) {
                    int n27 = 0;
                    for (n4 = 0; n4 < n2; ++n4) {
                        int n28 = 0;
                        while (n28 < n) {
                            int n29 = this.alphaData[n4 * n + n28] & 0xFF;
                            n3 = (byArray[n27 + n12] & 0xFF) * n29 + 128;
                            n3 = n3 + (n3 >> 8) >> 8;
                            int n30 = (byArray[n27 + n13] & 0xFF) * n29 + 128;
                            n30 = n30 + (n30 >> 8) >> 8;
                            int n31 = (byArray[n27 + n14] & 0xFF) * n29 + 128;
                            n31 = n31 + (n31 >> 8) >> 8;
                            byArray[n27 + n11] = (byte)n29;
                            byArray[n27 + n12] = (byte)n3;
                            byArray[n27 + n13] = (byte)n30;
                            byArray[n27 + n14] = (byte)n31;
                            ++n28;
                            n27 += 4;
                        }
                    }
                }
            }
            OS.memmove(l2, byArray, (long)(n10 * n2));
            Cairo.cairo_surface_mark_dirty(this.surface);
            return;
        }
        long l3 = OS.gdk_pixbuf_new(0, false, 8, n, n2);
        if (l3 == 0L) {
            SWT.error(2);
        }
        int n32 = OS.gdk_pixbuf_get_rowstride(l3);
        long l4 = OS.gdk_pixbuf_get_pixels(l3);
        byte[] byArray = imageData.data;
        if (!paletteData.isDirect || imageData.depth != 24 || n32 != imageData.bytesPerLine || paletteData.redMask != 0xFF0000 || paletteData.greenMask != 65280 || paletteData.blueMask != 255) {
            byArray = new byte[n32 * n2];
            if (paletteData.isDirect) {
                ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, n, n2, paletteData.redMask, paletteData.greenMask, paletteData.blueMask, 255, null, 0, 0, 0, byArray, 24, n32, 1, 0, 0, n, n2, 0xFF0000, 65280, 255, false, false);
            } else {
                RGB[] rGBArray = paletteData.getRGBs();
                int n33 = rGBArray.length;
                byte[] byArray5 = new byte[n33];
                byte[] byArray6 = new byte[n33];
                byte[] byArray7 = new byte[n33];
                for (int i = 0; i < rGBArray.length; ++i) {
                    RGB rGB = rGBArray[i];
                    if (rGB == null) continue;
                    byArray5[i] = (byte)rGB.red;
                    byArray6[i] = (byte)rGB.green;
                    byArray7[i] = (byte)rGB.blue;
                }
                ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, n, n2, byArray5, byArray6, byArray7, 255, null, 0, 0, 0, byArray, 24, n32, 1, 0, 0, n, n2, 0xFF0000, 65280, 255, false, false);
            }
        }
        OS.memmove(l4, byArray, (long)(n32 * n2));
        long l5 = OS.gdk_pixmap_new(OS.gdk_get_default_root_window(), n, n2, -1);
        if (l5 == 0L) {
            SWT.error(2);
        }
        if ((l = OS.gdk_gc_new(l5)) == 0L) {
            SWT.error(2);
        }
        OS.gdk_pixbuf_render_to_drawable(l3, l5, l, 0, 0, 0, 0, n, n2, 1, 0, 0);
        OS.g_object_unref(l);
        OS.g_object_unref(l3);
        boolean bl4 = bl = imageData.getTransparencyType() == 2;
        if (bl || imageData.transparentPixel != -1) {
            long l6;
            if (imageData.transparentPixel != -1) {
                RGB rGB = null;
                if (paletteData.isDirect) {
                    rGB = paletteData.getRGB(imageData.transparentPixel);
                } else if (imageData.transparentPixel < paletteData.colors.length) {
                    rGB = paletteData.getRGB(imageData.transparentPixel);
                }
                if (rGB != null) {
                    this.transparentPixel = rGB.red << 16 | rGB.green << 8 | rGB.blue;
                }
            }
            if ((l6 = this.createMask(imageData, bl)) == 0L) {
                SWT.error(2);
            }
            this.mask = l6;
            this.type = bl ? 1 : 0;
        } else {
            this.type = 0;
            this.mask = 0L;
            this.alpha = imageData.alpha;
            if (imageData.alpha == -1 && imageData.alphaData != null) {
                this.alphaData = new byte[imageData.alphaData.length];
                System.arraycopy(imageData.alphaData, 0, this.alphaData, 0, this.alphaData.length);
            }
            this.createAlphaMask(n, n2);
        }
        this.pixmap = l5;
    }

    @Override
    public long internal_new_GC(GCData gCData) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.type != 0 || this.memGC != null) {
            SWT.error(5);
        }
        long l = OS.USE_CAIRO ? Cairo.cairo_create(this.surface) : OS.gdk_gc_new(this.pixmap);
        if (gCData != null) {
            int n = 0x6000000;
            if ((gCData.style & n) == 0) {
                gCData.style |= 0x2000000;
            } else if ((gCData.style & 0x4000000) != 0) {
                gCData.style |= 0x8000000;
            }
            gCData.device = this.device;
            gCData.drawable = this.pixmap;
            gCData.background = this.device.COLOR_WHITE.handle;
            gCData.foreground = this.device.COLOR_BLACK.handle;
            gCData.font = this.device.systemFont;
            gCData.image = this;
        }
        return l;
    }

    @Override
    public void internal_dispose_GC(long l, GCData gCData) {
        long l2 = l;
        if (OS.USE_CAIRO) {
            Cairo.cairo_destroy(l2);
        } else {
            OS.g_object_unref(l2);
        }
    }

    @Override
    public boolean isDisposed() {
        if (OS.USE_CAIRO) {
            return this.surface == 0L;
        }
        return this.pixmap == 0L;
    }

    public void setBackground(Color color) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.transparentPixel == -1) {
            return;
        }
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        if (OS.USE_CAIRO) {
            return "Image {" + this.surface + "}";
        }
        return "Image {" + this.pixmap + "}";
    }
}

