/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrument;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrument.EventHandlerNode;
import com.oracle.truffle.api.instrument.KillException;
import com.oracle.truffle.api.instrument.Probe;
import com.oracle.truffle.api.instrument.ProbeInstrument;
import com.oracle.truffle.api.instrument.QuitException;
import com.oracle.truffle.api.instrument.TagInstrument;
import com.oracle.truffle.api.instrument.WrapperNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;

@NodeInfo(cost=NodeCost.NONE)
@Deprecated
final class ProbeNode
extends EventHandlerNode {
    @CompilerDirectives.CompilationFinal
    Probe probe = null;
    @Node.Child
    protected ProbeInstrument.AbstractInstrumentNode firstInstrumentNode;

    ProbeNode() {
    }

    @Override
    public Node copy() {
        Node node = super.copy();
        this.probe.registerProbeNodeClone((ProbeNode)node);
        return node;
    }

    @Override
    public Probe getProbe() {
        return this.probe;
    }

    @Override
    public void enter(Node node, VirtualFrame frame) {
        this.probe.checkProbeUnchanged();
        TagInstrument.BeforeTagInstrument beforeTagInstrument = this.probe.getBeforeTagInstrument();
        if (beforeTagInstrument != null) {
            beforeTagInstrument.getListener().onEnter(this.probe, ((WrapperNode)((Object)this.getParent())).getChild(), frame);
        }
        if (this.firstInstrumentNode != null) {
            this.firstInstrumentNode.enter(node, frame);
        }
    }

    @Override
    public void returnVoid(Node node, VirtualFrame frame) {
        TagInstrument.AfterTagInstrument afterTagInstrument;
        this.probe.checkProbeUnchanged();
        if (this.firstInstrumentNode != null) {
            this.firstInstrumentNode.returnVoid(node, frame);
        }
        if ((afterTagInstrument = this.probe.getAfterTagInstrument()) != null) {
            afterTagInstrument.getListener().onReturnVoid(this.probe, ((WrapperNode)((Object)this.getParent())).getChild(), frame);
        }
    }

    @Override
    public void returnValue(Node node, VirtualFrame frame, Object result) {
        TagInstrument.AfterTagInstrument afterTagInstrument;
        this.probe.checkProbeUnchanged();
        if (this.firstInstrumentNode != null) {
            this.firstInstrumentNode.returnValue(node, frame, result);
        }
        if ((afterTagInstrument = this.probe.getAfterTagInstrument()) != null) {
            afterTagInstrument.getListener().onReturnValue(this.probe, ((WrapperNode)((Object)this.getParent())).getChild(), frame, result);
        }
    }

    @Override
    public void returnExceptional(Node node, VirtualFrame frame, Throwable exception) {
        TagInstrument.AfterTagInstrument afterTagInstrument;
        if (exception instanceof KillException) {
            throw (KillException)exception;
        }
        if (exception instanceof QuitException) {
            throw (QuitException)exception;
        }
        this.probe.checkProbeUnchanged();
        if (this.firstInstrumentNode != null) {
            this.firstInstrumentNode.returnExceptional(node, frame, exception);
        }
        if ((afterTagInstrument = this.probe.getAfterTagInstrument()) != null) {
            afterTagInstrument.getListener().onReturnExceptional(this.probe, ((WrapperNode)((Object)this.getParent())).getChild(), frame, exception);
        }
    }

    @Override
    public String instrumentationInfo() {
        return "Standard probe";
    }

    Node getProbedNode() {
        return ((WrapperNode)((Object)this.getParent())).getChild();
    }

    @CompilerDirectives.TruffleBoundary
    void addInstrument(ProbeInstrument instrument) {
        assert (instrument.getProbe() == this.probe);
        this.firstInstrumentNode = this.insert(instrument.addToChain(this.firstInstrumentNode));
    }

    @CompilerDirectives.TruffleBoundary
    void removeInstrument(ProbeInstrument instrument) {
        assert (instrument.getProbe() == this.probe);
        ProbeInstrument.AbstractInstrumentNode modifiedChain = instrument.removeFromChain(this.firstInstrumentNode);
        this.firstInstrumentNode = modifiedChain == null ? null : this.insert(modifiedChain);
    }
}

