/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.utilities;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class CyclicAssumption {
    private final String name;
    private volatile Assumption assumption;
    private static final AtomicReferenceFieldUpdater<CyclicAssumption, Assumption> ASSUMPTION_UPDATER = AtomicReferenceFieldUpdater.newUpdater(CyclicAssumption.class, Assumption.class, "assumption");

    public CyclicAssumption(String name) {
        this.name = name;
        this.assumption = Truffle.getRuntime().createAssumption(name);
    }

    @CompilerDirectives.TruffleBoundary
    public void invalidate() {
        Assumption newAssumption = Truffle.getRuntime().createAssumption(this.name);
        Assumption oldAssumption = ASSUMPTION_UPDATER.getAndSet(this, newAssumption);
        oldAssumption.invalidate();
    }

    public Assumption getAssumption() {
        return this.assumption;
    }
}

