/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.impl.FindContextNode;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.java.JavaInterop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.vm.ComputeInExecutor;
import com.oracle.truffle.api.vm.ContextStore;
import com.oracle.truffle.api.vm.EngineTruffleObject;
import com.oracle.truffle.api.vm.EventConsumer;
import com.oracle.truffle.api.vm.ExecutionImpl;
import com.oracle.truffle.api.vm.FindContextNodeImpl;
import com.oracle.truffle.api.vm.InstrumentCache;
import com.oracle.truffle.api.vm.LanguageCache;
import com.oracle.truffle.api.vm.SymbolInvokerImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PolyglotEngine {
    static final boolean JAVA_INTEROP_ENABLED = !TruffleOptions.AOT;
    static final Logger LOG = Logger.getLogger(PolyglotEngine.class.getName());
    private static final SPIAccessor SPI = new SPIAccessor();
    private final Thread initThread;
    private final Executor executor;
    private final Map<String, Language> langs;
    private final InputStream in;
    private final OutputStream err;
    private final OutputStream out;
    private final EventConsumer<?>[] handlers;
    private final Map<String, Object> globals;
    private final Object instrumenter;
    private final Object instrumentationHandler;
    private final Map<String, Instrument> instruments;
    private final List<Object[]> config;
    private final Object[] debugger = new Object[]{null};
    private final ContextStore context;
    private boolean disposed;

    PolyglotEngine() {
        PolyglotEngine.assertNoTruffle();
        this.initThread = null;
        this.in = null;
        this.err = null;
        this.out = null;
        this.langs = null;
        this.handlers = null;
        this.globals = null;
        this.executor = null;
        this.instrumenter = null;
        this.instrumentationHandler = null;
        this.instruments = null;
        this.config = null;
        this.context = null;
    }

    PolyglotEngine(Executor executor, Map<String, Object> globals, OutputStream out, OutputStream err, InputStream in, EventConsumer<?>[] handlers, List<Object[]> config) {
        PolyglotEngine.assertNoTruffle();
        this.executor = executor;
        this.out = out;
        this.err = err;
        this.in = in;
        this.handlers = handlers;
        this.initThread = Thread.currentThread();
        this.globals = new HashMap<String, Object>(globals);
        this.instrumenter = null;
        this.config = config;
        this.instrumentationHandler = Access.INSTRUMENT.createInstrumentationHandler(this, out, err, in);
        HashMap<String, Language> map = new HashMap<String, Language>();
        HashSet<LanguageCache> uniqueCaches = new HashSet<LanguageCache>(LanguageCache.languages().values());
        for (LanguageCache languageCache : uniqueCaches) {
            Language newLanguage = new Language(languageCache);
            for (String mimeType : newLanguage.getMimeTypes()) {
                map.put(mimeType, newLanguage);
            }
        }
        this.langs = map;
        this.instruments = this.createAndAutostartDescriptors(InstrumentCache.load(this.getClass().getClassLoader()));
        this.context = ExecutionImpl.createStore(this);
    }

    private Map<String, Instrument> createAndAutostartDescriptors(List<InstrumentCache> instrumentCaches) {
        LinkedHashMap<String, Instrument> instr = new LinkedHashMap<String, Instrument>();
        for (InstrumentCache cache : instrumentCaches) {
            Instrument instrument = new Instrument(cache);
            instr.put(cache.getId(), instrument);
        }
        return Collections.unmodifiableMap(instr);
    }

    public static Builder newBuilder() {
        PolyglotEngine vm = new PolyglotEngine();
        return vm.new Builder();
    }

    @Deprecated
    public static Builder buildNew() {
        return PolyglotEngine.newBuilder();
    }

    public Map<String, ? extends Language> getLanguages() {
        return Collections.unmodifiableMap(this.langs);
    }

    public Map<String, Instrument> getInstruments() {
        return this.instruments;
    }

    public Value eval(Source source) throws IOException {
        PolyglotEngine.assertNoTruffle();
        String mimeType = source.getMimeType();
        assert (this.checkThread());
        Language l = this.langs.get(mimeType);
        if (l == null) {
            throw new IOException("No language for MIME type " + mimeType + " found. Supported types: " + this.langs.keySet());
        }
        return this.eval(l, source);
    }

    public void dispose() {
        assert (this.checkThread());
        PolyglotEngine.assertNoTruffle();
        this.disposed = true;
        ComputeInExecutor<Void> compute = new ComputeInExecutor<Void>(this.executor){

            @Override
            protected Void compute() throws IOException {
                for (Language language : PolyglotEngine.this.getLanguages().values()) {
                    TruffleLanguage<?> impl = language.getImpl(false);
                    if (impl == null) continue;
                    try {
                        Access.LANGS.dispose(impl, language.getEnv(true));
                    }
                    catch (Error | Exception ex) {
                        LOG.log(Level.SEVERE, "Error disposing " + impl, ex);
                    }
                }
                for (Instrument instrument : PolyglotEngine.this.instruments.values()) {
                    try {
                        instrument.setEnabledImpl(false, false);
                    }
                    catch (Error | Exception ex) {
                        LOG.log(Level.SEVERE, "Error disposing " + instrument, ex);
                    }
                }
                return null;
            }
        };
        try {
            compute.perform();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private Value eval(final Language l, final Source s) throws IOException {
        final TruffleLanguage[] lang = new TruffleLanguage[]{null};
        if (this.executor == null) {
            Object value = this.evalImpl(lang, s, l);
            return new DirectValue(lang, value);
        }
        ComputeInExecutor<Object> compute = new ComputeInExecutor<Object>(this.executor){

            @Override
            protected Object compute() throws IOException {
                return PolyglotEngine.this.evalImpl(lang, s, l);
            }
        };
        compute.perform();
        return new ExecutorValue(lang, compute);
    }

    Language createLanguage(Map.Entry<String, LanguageCache> en) {
        return new Language(en.getValue());
    }

    ContextStore context() {
        return this.context;
    }

    Object[] debugger() {
        return this.debugger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object evalImpl(TruffleLanguage<?>[] fillLang, Source s, Language l) throws IOException {
        ContextStore prev = ExecutionImpl.executionStarted(this.context);
        try {
            Access.DEBUG.executionStarted(this, -1, this.debugger, s);
            TruffleLanguage<?> langImpl = l.getImpl(true);
            fillLang[0] = langImpl;
            Object object = Access.LANGS.eval(langImpl, s, l.cache);
            return object;
        }
        finally {
            ExecutionImpl.executionEnded(prev);
            Access.DEBUG.executionEnded(this, this.debugger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Object invokeForeign(Node foreignNode, VirtualFrame frame, TruffleObject receiver) throws IOException {
        Object res;
        PolyglotEngine.assertNoTruffle();
        CompilerAsserts.neverPartOfCompilation();
        if (this.executor == null) {
            ContextStore prev = ExecutionImpl.executionStarted(this.context);
            try {
                Access.DEBUG.executionStarted(this, -1, this.debugger, null);
                Object[] args = ForeignAccess.getArguments(frame).toArray();
                res = ForeignAccess.execute(foreignNode, frame, receiver, args);
            }
            finally {
                ExecutionImpl.executionEnded(prev);
                Access.DEBUG.executionEnded(this, this.debugger);
            }
        } else {
            res = this.invokeForeignOnExecutor(foreignNode, frame, receiver);
        }
        if (res instanceof TruffleObject) {
            return new EngineTruffleObject(this, (TruffleObject)res);
        }
        return res;
    }

    static void assertNoTruffle() {
        CompilerAsserts.neverPartOfCompilation("Methods of PolyglotEngine must not be compiled by Truffle. Use Truffle interoperability or a @TruffleBoundary instead.");
    }

    @CompilerDirectives.TruffleBoundary
    private Object invokeForeignOnExecutor(final Node foreignNode, VirtualFrame frame, final TruffleObject receiver) throws IOException {
        final MaterializedFrame materialized = frame.materialize();
        ComputeInExecutor<Object> compute = new ComputeInExecutor<Object>(this.executor){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Object compute() throws IOException {
                ContextStore prev = ExecutionImpl.executionStarted(PolyglotEngine.this.context);
                try {
                    Access.DEBUG.executionStarted(PolyglotEngine.this, -1, PolyglotEngine.this.debugger, null);
                    Object[] args = ForeignAccess.getArguments(materialized).toArray();
                    RootNode node = SymbolInvokerImpl.createTemporaryRoot(TruffleLanguage.class, foreignNode, receiver);
                    RootCallTarget target = Truffle.getRuntime().createCallTarget(node);
                    Object object = target.call(args);
                    return object;
                }
                finally {
                    ExecutionImpl.executionEnded(prev);
                    Access.DEBUG.executionEnded(PolyglotEngine.this, PolyglotEngine.this.debugger);
                }
            }
        };
        return compute.get();
    }

    public Value findGlobalSymbol(final String globalName) {
        assert (this.checkThread());
        PolyglotEngine.assertNoTruffle();
        final TruffleLanguage[] lang = new TruffleLanguage[]{null};
        ComputeInExecutor<Object> compute = new ComputeInExecutor<Object>(this.executor){

            @Override
            protected Object compute() throws IOException {
                TruffleLanguage.Env env;
                Object obj = PolyglotEngine.this.globals.get(globalName);
                if (obj == null) {
                    for (Language dl : PolyglotEngine.this.langs.values()) {
                        env = dl.getEnv(false);
                        if (env == null || (obj = Access.LANGS.findExportedSymbol(env, globalName, true)) == null) continue;
                        lang[0] = dl.getImpl(true);
                        break;
                    }
                }
                if (obj == null) {
                    for (Language dl : PolyglotEngine.this.langs.values()) {
                        env = dl.getEnv(false);
                        if (env == null || (obj = Access.LANGS.findExportedSymbol(env, globalName, true)) == null) continue;
                        lang[0] = dl.getImpl(true);
                        break;
                    }
                }
                return obj;
            }
        };
        try {
            compute.perform();
            if (compute.get() == null) {
                return null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new ExecutorValue(lang, compute);
    }

    private boolean checkThread() {
        if (this.initThread != Thread.currentThread()) {
            throw new IllegalStateException("PolyglotEngine created on " + this.initThread.getName() + " but used on " + Thread.currentThread().getName());
        }
        if (this.disposed) {
            throw new IllegalStateException("Engine has already been disposed");
        }
        return true;
    }

    void dispatch(Object ev, int type) {
        if (type == 1) {
            this.dispatchExecutionEvent(ev);
        }
        if (type == 2) {
            this.dispatchSuspendedEvent(ev);
        }
        Class<?> clazz = ev.getClass();
        this.dispatch(clazz, ev);
    }

    void dispatchSuspendedEvent(Object event) {
    }

    void dispatchExecutionEvent(Object event) {
    }

    <Event> void dispatch(Class<Event> type, Event event) {
        for (EventConsumer<?> handler : this.handlers) {
            if (handler.type != type) continue;
            handler.on(event);
        }
    }

    TruffleLanguage<?> findLanguage(Class<? extends TruffleLanguage> languageClazz) {
        for (Map.Entry<String, Language> entrySet : this.langs.entrySet()) {
            Language languageDescription = entrySet.getValue();
            TruffleLanguage<?> impl = languageDescription.getImpl(false);
            if (!languageClazz.isInstance(impl)) continue;
            return impl;
        }
        return null;
    }

    TruffleLanguage<?> findLanguage(String mimeType) {
        Language languageDescription = this.langs.get(mimeType);
        if (languageDescription != null) {
            return languageDescription.getImpl(true);
        }
        return null;
    }

    TruffleLanguage.Env findEnv(Class<? extends TruffleLanguage> languageClazz) {
        for (Map.Entry<String, Language> entrySet : this.langs.entrySet()) {
            Language languageDescription = entrySet.getValue();
            TruffleLanguage.Env env = languageDescription.getEnv(false);
            if (env == null || !languageClazz.isInstance(languageDescription.getImpl(false))) continue;
            return env;
        }
        throw new IllegalStateException("Cannot find language " + languageClazz + " among " + this.langs);
    }

    static {
        try {
            Class.forName(TruffleInstrument.class.getName(), true, TruffleInstrument.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private static class SPIAccessor
    extends Accessor {
        private SPIAccessor() {
        }

        static Accessor.LanguageSupport langs() {
            return SPI.languageSupport();
        }

        static Accessor.InstrumentSupport instrumentAccess() {
            return SPI.instrumentSupport();
        }

        static Accessor.DebugSupport debugAccess() {
            return SPI.debugSupport();
        }

        @Override
        protected Accessor.EngineSupport engineSupport() {
            return new EngineImpl();
        }

        static final class EngineImpl
        extends Accessor.EngineSupport {
            EngineImpl() {
            }

            @Override
            public boolean isMimeTypeSupported(Object obj, String mimeType) {
                PolyglotEngine vm = (PolyglotEngine)obj;
                return vm.findLanguage(mimeType) != null;
            }

            @Override
            public TruffleLanguage.Env findEnv(Object obj, Class<? extends TruffleLanguage> languageClass) {
                PolyglotEngine vm = (PolyglotEngine)obj;
                return vm.findEnv(languageClass);
            }

            @Override
            public void dispatchEvent(Object obj, Object event, int type) {
                PolyglotEngine vm = (PolyglotEngine)obj;
                vm.dispatch(event, type);
            }

            @Override
            public TruffleLanguage<?> findLanguageImpl(Object obj, Class<? extends TruffleLanguage> languageClazz, String mimeType) {
                PolyglotEngine vm = (PolyglotEngine)(obj == null ? ExecutionImpl.findVM() : obj);
                if (vm == null) {
                    throw new IllegalStateException("Accessor.findLanguageImpl access to vm");
                }
                TruffleLanguage<?> language = null;
                if (languageClazz != null) {
                    language = vm.findLanguage(languageClazz);
                }
                if (language == null && mimeType != null) {
                    language = vm.findLanguage(mimeType);
                }
                if (language == null) {
                    throw new IllegalStateException("Cannot find language " + languageClazz + " with mimeType" + mimeType + " among " + vm.langs);
                }
                return language;
            }

            @Override
            public Object getInstrumenter(Object obj) {
                PolyglotEngine vm = (PolyglotEngine)(obj == null ? ExecutionImpl.findVM() : obj);
                return vm == null ? null : vm.instrumenter;
            }

            @Override
            public Object getInstrumentationHandler(Object obj) {
                PolyglotEngine vm = (PolyglotEngine)(obj == null ? ExecutionImpl.findVM() : obj);
                return vm == null ? null : vm.instrumentationHandler;
            }

            @Override
            public Object importSymbol(Object vmObj, TruffleLanguage<?> ownLang, String globalName) {
                Object obj;
                TruffleLanguage.Env env;
                TruffleLanguage<?> l;
                PolyglotEngine vm = (PolyglotEngine)vmObj;
                Object g = vm.globals.get(globalName);
                if (g != null) {
                    return g;
                }
                LinkedHashSet uniqueLang = new LinkedHashSet(vm.langs.values());
                for (Language dl : uniqueLang) {
                    l = dl.getImpl(false);
                    env = dl.getEnv(false);
                    if (l == ownLang || l == null || env == null || (obj = Access.LANGS.findExportedSymbol(env, globalName, true)) == null) continue;
                    return obj;
                }
                for (Language dl : uniqueLang) {
                    l = dl.getImpl(false);
                    env = dl.getEnv(false);
                    if (l == ownLang || l == null || env == null || (obj = Access.LANGS.findExportedSymbol(env, globalName, false)) == null) continue;
                    return obj;
                }
                return null;
            }

            @Override
            public <C> FindContextNode<C> createFindContextNode(TruffleLanguage<C> lang) {
                return new FindContextNodeImpl<C>(lang);
            }
        }
    }

    static class Access {
        static final Accessor.LanguageSupport LANGS = SPIAccessor.langs();
        static final Accessor.InstrumentSupport INSTRUMENT = SPIAccessor.instrumentAccess();
        static final Accessor.DebugSupport DEBUG = SPIAccessor.debugAccess();

        Access() {
        }
    }

    public class Language {
        private final Map<Source, CallTarget> cache = new WeakHashMap<Source, CallTarget>();
        private final LanguageCache info;
        private TruffleLanguage.Env env;

        Language(LanguageCache info) {
            this.info = info;
        }

        public Set<String> getMimeTypes() {
            return this.info.getMimeTypes();
        }

        public String getName() {
            return this.info.getName();
        }

        public String getVersion() {
            return this.info.getVersion();
        }

        public Value eval(Source source) throws IOException {
            PolyglotEngine.assertNoTruffle();
            assert (PolyglotEngine.this.checkThread());
            return PolyglotEngine.this.eval(this, source);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Value getGlobalObject() {
            assert (PolyglotEngine.this.checkThread());
            ContextStore prev = ExecutionImpl.executionStarted(PolyglotEngine.this.context);
            try {
                Object res = Access.LANGS.languageGlobal(this.getEnv(true));
                if (res == null) {
                    Value value = null;
                    return value;
                }
                DirectValue directValue = new DirectValue(new TruffleLanguage[]{this.info.getImpl(true)}, res);
                return directValue;
            }
            finally {
                ExecutionImpl.executionEnded(prev);
            }
        }

        TruffleLanguage<?> getImpl(boolean create) {
            this.getEnv(create);
            TruffleLanguage<?> impl = this.info.getImpl(false);
            return impl;
        }

        private Map<String, Object> getArgumentsForLanguage() {
            if (PolyglotEngine.this.config == null) {
                return Collections.emptyMap();
            }
            HashMap<String, Object> forLanguage = new HashMap<String, Object>();
            for (Object[] mimeKeyValue : PolyglotEngine.this.config) {
                if (!this.getMimeTypes().contains(mimeKeyValue[0])) continue;
                forLanguage.put((String)mimeKeyValue[1], mimeKeyValue[2]);
            }
            return Collections.unmodifiableMap(forLanguage);
        }

        TruffleLanguage.Env getEnv(boolean create) {
            if (this.env == null && create) {
                this.env = Access.LANGS.attachEnv(PolyglotEngine.this, this.info.getImpl(true), PolyglotEngine.this.out, PolyglotEngine.this.err, PolyglotEngine.this.in, PolyglotEngine.this.instrumenter, this.getArgumentsForLanguage());
            }
            return this.env;
        }

        public String toString() {
            return "[" + this.getName() + "@ " + this.getVersion() + " for " + this.getMimeTypes() + "]";
        }
    }

    public final class Instrument {
        private final InstrumentCache info;
        private boolean enabled;

        Instrument(InstrumentCache cache) {
            this.info = cache;
        }

        public String getId() {
            return this.info.getId();
        }

        public String getName() {
            return this.info.getName();
        }

        public String getVersion() {
            return this.info.getVersion();
        }

        InstrumentCache getCache() {
            return this.info;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public <T> T lookup(Class<T> type) {
            return Access.INSTRUMENT.getInstrumentationHandlerService(PolyglotEngine.this.instrumentationHandler, this, type);
        }

        public void setEnabled(final boolean enabled) {
            assert (PolyglotEngine.this.checkThread());
            if (this.enabled != enabled) {
                ComputeInExecutor<Void> compute = new ComputeInExecutor<Void>(PolyglotEngine.this.executor){

                    @Override
                    protected Void compute() throws IOException {
                        Instrument.this.setEnabledImpl(enabled, true);
                        return null;
                    }
                };
                try {
                    compute.perform();
                }
                catch (IOException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }

        void setEnabledImpl(boolean enabled, boolean cleanup) {
            if (this.enabled != enabled) {
                if (enabled) {
                    Access.INSTRUMENT.addInstrument(PolyglotEngine.this.instrumentationHandler, this, this.getCache().getInstrumentationClass());
                } else {
                    Access.INSTRUMENT.disposeInstrument(PolyglotEngine.this.instrumentationHandler, this, cleanup);
                }
                this.enabled = enabled;
            }
        }

        public String toString() {
            return "Instrument [id=" + this.getId() + ", name=" + this.getName() + ", version=" + this.getVersion() + ", enabled=" + this.enabled + "]";
        }
    }

    private class ExecutorValue
    extends Value {
        private final ComputeInExecutor<Object> compute;

        ExecutorValue(TruffleLanguage<?>[] language, ComputeInExecutor<Object> compute) {
            super(language);
            this.compute = compute;
        }

        @Override
        boolean isDirect() {
            return false;
        }

        @Override
        Object value() throws IOException {
            return this.compute.get();
        }

        public String toString() {
            return "PolyglotEngine.Value[" + this.compute + "]";
        }
    }

    private class DirectValue
    extends Value {
        private final Object value;

        DirectValue(TruffleLanguage<?>[] language, Object value) {
            super(language);
            this.value = value;
        }

        @Override
        boolean isDirect() {
            return true;
        }

        @Override
        Object value() {
            return this.value;
        }

        public String toString() {
            return "PolyglotEngine.Value[value=" + this.value + ",computed=true,exception=null]";
        }
    }

    public abstract class Value {
        private final TruffleLanguage<?>[] language;
        private CallTarget target;

        Value(TruffleLanguage<?>[] language) {
            this.language = language;
        }

        abstract boolean isDirect();

        abstract Object value() throws IOException;

        public Object get() throws IOException {
            PolyglotEngine.assertNoTruffle();
            Object result = this.waitForSymbol();
            if (PolyglotEngine.this.executor != null && result instanceof TruffleObject) {
                return new EngineTruffleObject(PolyglotEngine.this, (TruffleObject)result);
            }
            return result;
        }

        public <T> T as(Class<T> representation) throws IOException {
            EngineTruffleObject eto;
            PolyglotEngine.assertNoTruffle();
            Object obj = this.get();
            if (obj instanceof EngineTruffleObject && representation.isInstance((eto = (EngineTruffleObject)obj).getDelegate())) {
                return representation.cast(eto.getDelegate());
            }
            if (representation == String.class) {
                Class<?> clazz = this.language[0].getClass();
                Object unwrapped = obj;
                while (unwrapped instanceof EngineTruffleObject) {
                    unwrapped = ((EngineTruffleObject)obj).getDelegate();
                }
                return representation.cast(Access.LANGS.toString(this.language[0], PolyglotEngine.this.findEnv(clazz), unwrapped));
            }
            if (representation.isInstance(obj)) {
                return representation.cast(obj);
            }
            if (JAVA_INTEROP_ENABLED) {
                return JavaInterop.asJavaObject(representation, (TruffleObject)obj);
            }
            throw new ClassCastException("Value cannot be represented as " + representation.getName());
        }

        @Deprecated
        public Value invoke(Object thiz, Object ... args) throws IOException {
            return this.execute(args);
        }

        public Value execute(final Object ... args) throws IOException {
            if (this.isDirect()) {
                Object ret = this.executeDirect(args);
                return new DirectValue(this.language, ret);
            }
            PolyglotEngine.assertNoTruffle();
            this.get();
            ComputeInExecutor<Object> invokeCompute = new ComputeInExecutor<Object>(PolyglotEngine.this.executor){

                @Override
                protected Object compute() throws IOException {
                    return Value.this.executeDirect(args);
                }
            };
            invokeCompute.perform();
            return new ExecutorValue(this.language, invokeCompute);
        }

        private Object executeDirect(Object[] args) throws IOException {
            if (this.target == null) {
                this.target = SymbolInvokerImpl.createCallTarget(this.language[0], PolyglotEngine.this, this.value());
            }
            return this.target.call(args);
        }

        private Object waitForSymbol() throws IOException {
            PolyglotEngine.assertNoTruffle();
            assert (PolyglotEngine.this.checkThread());
            return this.value();
        }
    }

    public class Builder {
        private OutputStream out;
        private OutputStream err;
        private InputStream in;
        private final List<EventConsumer<?>> handlers = new ArrayList();
        private final Map<String, Object> globals = new HashMap<String, Object>();
        private Executor executor;
        private List<Object[]> arguments;

        Builder() {
        }

        public Builder setOut(OutputStream os) {
            this.out = os;
            return this;
        }

        public Builder setErr(OutputStream os) {
            this.err = os;
            return this;
        }

        public Builder setIn(InputStream is) {
            this.in = is;
            return this;
        }

        public Builder onEvent(EventConsumer<?> handler) {
            Objects.requireNonNull(handler);
            this.handlers.add(handler);
            return this;
        }

        public Builder config(String mimeType, String key, Object value) {
            if (this.arguments == null) {
                this.arguments = new ArrayList<Object[]>();
            }
            this.arguments.add(new Object[]{mimeType, key, value});
            return this;
        }

        public Builder globalSymbol(String name, Object obj) {
            Object truffleReady;
            if (obj instanceof TruffleObject || obj instanceof Number || obj instanceof String || obj instanceof Character || obj instanceof Boolean) {
                truffleReady = obj;
            } else if (JAVA_INTEROP_ENABLED) {
                truffleReady = JavaInterop.asTruffleObject(obj);
            } else {
                throw new IllegalArgumentException();
            }
            this.globals.put(name, truffleReady);
            return this;
        }

        public Builder executor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public PolyglotEngine build() {
            PolyglotEngine.assertNoTruffle();
            if (this.out == null) {
                this.out = System.out;
            }
            if (this.err == null) {
                this.err = System.err;
            }
            if (this.in == null) {
                this.in = System.in;
            }
            return new PolyglotEngine(this.executor, this.globals, this.out, this.err, this.in, this.handlers.toArray(new EventConsumer[0]), this.arguments);
        }
    }
}

