/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.CoreClass;
import org.jruby.truffle.core.CoreMethod;
import org.jruby.truffle.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.CoreMethodNode;
import org.jruby.truffle.core.CoreSourceSection;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.YieldingCoreMethodNode;
import org.jruby.truffle.core.array.ArrayAppendManyNode;
import org.jruby.truffle.core.array.ArrayAppendManyNodeGen;
import org.jruby.truffle.core.array.ArrayAppendOneNode;
import org.jruby.truffle.core.array.ArrayAppendOneNodeGen;
import org.jruby.truffle.core.array.ArrayBuilderNode;
import org.jruby.truffle.core.array.ArrayCoreMethodNode;
import org.jruby.truffle.core.array.ArrayGuards;
import org.jruby.truffle.core.array.ArrayHelpers;
import org.jruby.truffle.core.array.ArrayMirror;
import org.jruby.truffle.core.array.ArrayNodesFactory;
import org.jruby.truffle.core.array.ArrayOperations;
import org.jruby.truffle.core.array.ArrayPopOneNode;
import org.jruby.truffle.core.array.ArrayPopOneNodeGen;
import org.jruby.truffle.core.array.ArrayReadDenormalizedNode;
import org.jruby.truffle.core.array.ArrayReadDenormalizedNodeGen;
import org.jruby.truffle.core.array.ArrayReadNormalizedNode;
import org.jruby.truffle.core.array.ArrayReadNormalizedNodeGen;
import org.jruby.truffle.core.array.ArrayReadSliceDenormalizedNode;
import org.jruby.truffle.core.array.ArrayReadSliceDenormalizedNodeGen;
import org.jruby.truffle.core.array.ArrayReadSliceNormalizedNode;
import org.jruby.truffle.core.array.ArrayReadSliceNormalizedNodeGen;
import org.jruby.truffle.core.array.ArrayStrategy;
import org.jruby.truffle.core.array.ArrayWriteNormalizedNode;
import org.jruby.truffle.core.array.ArrayWriteNormalizedNodeGen;
import org.jruby.truffle.core.cast.ToAryNodeGen;
import org.jruby.truffle.core.cast.ToIntNode;
import org.jruby.truffle.core.cast.ToIntNodeGen;
import org.jruby.truffle.core.format.BytesResult;
import org.jruby.truffle.core.format.FormatExceptionTranslator;
import org.jruby.truffle.core.format.exceptions.FormatException;
import org.jruby.truffle.core.format.pack.PackCompiler;
import org.jruby.truffle.core.kernel.KernelNodes;
import org.jruby.truffle.core.kernel.KernelNodesFactory;
import org.jruby.truffle.core.numeric.FixnumLowerNodeGen;
import org.jruby.truffle.core.proc.ProcOperations;
import org.jruby.truffle.core.proc.ProcType;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeNodes;
import org.jruby.truffle.core.rope.RopeNodesFactory;
import org.jruby.truffle.core.string.StringCachingGuards;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyRootNode;
import org.jruby.truffle.language.SnippetNode;
import org.jruby.truffle.language.arguments.MissingArgumentBehavior;
import org.jruby.truffle.language.arguments.ReadPreArgumentNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.dispatch.MissingBehavior;
import org.jruby.truffle.language.locals.LocalVariableType;
import org.jruby.truffle.language.locals.ReadDeclarationVariableNode;
import org.jruby.truffle.language.methods.Arity;
import org.jruby.truffle.language.methods.DeclarationContext;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.language.methods.SharedMethodInfo;
import org.jruby.truffle.language.objects.AllocateObjectNode;
import org.jruby.truffle.language.objects.AllocateObjectNodeGen;
import org.jruby.truffle.language.objects.IsFrozenNode;
import org.jruby.truffle.language.objects.IsFrozenNodeGen;
import org.jruby.truffle.language.objects.TaintNode;
import org.jruby.truffle.language.objects.TaintNodeGen;
import org.jruby.truffle.language.yield.YieldNode;
import org.jruby.util.Memo;

@CoreClass(name="Array")
public abstract class ArrayNodes {

    @CoreMethod(names={"zip"}, rest=true, required=1, needsBlock=true)
    public static abstract class ZipNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode zipInternalCall;

        @Specialization(guards={"isRubyArray(other)", "aStrategy.matches(array)", "bStrategy.matches(other)", "others.length == 0"}, limit="ARRAY_STRATEGIES")
        public DynamicObject zipObjectIntegerFixnum(DynamicObject array, DynamicObject other, Object[] others, NotProvided block, @Cached(value="of(array)") ArrayStrategy aStrategy, @Cached(value="of(other)") ArrayStrategy bStrategy, @Cached(value="aStrategy.generalize(bStrategy)") ArrayStrategy generalized, @Cached(value="createBinaryProfile()") ConditionProfile bNotSmallerProfile) {
            ArrayMirror a = aStrategy.newMirror(array);
            ArrayMirror b = bStrategy.newMirror(other);
            int bSize = ArrayHelpers.getSize(other);
            int zippedLength = ArrayHelpers.getSize(array);
            Object[] zipped = new Object[zippedLength];
            for (int n = 0; n < zippedLength; ++n) {
                if (bNotSmallerProfile.profile(n < bSize)) {
                    ArrayMirror pair = generalized.newArray(2);
                    pair.set(0, a.get(n));
                    pair.set(1, b.get(n));
                    zipped[n] = ArrayHelpers.createArray(this.getContext(), pair.getArray(), 2);
                    continue;
                }
                zipped[n] = ArrayHelpers.createArray(this.getContext(), new Object[]{a.get(n), this.nil()}, 2);
            }
            return ArrayHelpers.createArray(this.getContext(), zipped, zippedLength);
        }

        @Specialization(guards={"isRubyArray(other)", "fallback(array, other, others)"})
        public Object zipObjectObjectNotSingleObject(VirtualFrame frame, DynamicObject array, DynamicObject other, Object[] others, NotProvided block) {
            return this.zipRuby(frame, array, null);
        }

        @Specialization(guards={"!isRubyArray(other)"})
        public Object zipObjectObjectNotArray(VirtualFrame frame, DynamicObject array, DynamicObject other, Object[] others, NotProvided block) {
            return this.zipRuby(frame, array, null);
        }

        @Specialization
        public Object zipBlock(VirtualFrame frame, DynamicObject array, DynamicObject other, Object[] others, DynamicObject block) {
            return this.zipRuby(frame, array, block);
        }

        private Object zipRuby(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            if (this.zipInternalCall == null) {
                CompilerDirectives.transferToInterpreter();
                this.zipInternalCall = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            Object[] others = RubyArguments.getArguments(frame);
            return this.zipInternalCall.call(frame, array, "zip_internal", block, others);
        }

        protected static boolean fallback(DynamicObject array, DynamicObject other, Object[] others) {
            return ArrayGuards.isNullArray(array) || ArrayGuards.isNullArray(other) || others.length > 0;
        }
    }

    @CoreMethod(names={"sort"}, needsBlock=true)
    public static abstract class SortNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode compareDispatchNode;
        @Node.Child
        private YieldNode yieldNode;

        public SortNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.compareDispatchNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.yieldNode = new YieldNode(context);
        }

        @Specialization(guards={"isNullArray(array)"})
        public DynamicObject sortNull(DynamicObject array, Object unusedBlock) {
            return ArrayHelpers.createArray(this.getContext(), null, 0);
        }

        @ExplodeLoop
        @Specialization(guards={"!isNullArray(array)", "isSmall(array)", "strategy.matches(array)"}, limit="ARRAY_STRATEGIES")
        public DynamicObject sortVeryShort(VirtualFrame frame, DynamicObject array, NotProvided block, @Cached(value="of(array)") ArrayStrategy strategy) {
            int i;
            ArrayMirror originalStore = strategy.newMirror(array);
            ArrayMirror store = strategy.newArray(this.getContext().getOptions().ARRAY_SMALL);
            int size = ArrayHelpers.getSize(array);
            for (i = 0; i < this.getContext().getOptions().ARRAY_SMALL; ++i) {
                if (i >= size) continue;
                store.set(i, originalStore.get(i));
            }
            for (i = 0; i < this.getContext().getOptions().ARRAY_SMALL; ++i) {
                if (i >= size) continue;
                for (int j = i + 1; j < this.getContext().getOptions().ARRAY_SMALL; ++j) {
                    if (j >= size) continue;
                    Object a = store.get(i);
                    Object b = store.get(j);
                    if (this.castSortValue(this.compareDispatchNode.call(frame, b, "<=>", null, a)) >= 0) continue;
                    store.set(j, a);
                    store.set(i, b);
                }
            }
            return ArrayHelpers.createArray(this.getContext(), store.getArray(), size);
        }

        @Specialization(guards={"!isNullArray(array)", "!isSmall(array)"})
        public Object sortLargeArray(VirtualFrame frame, DynamicObject array, NotProvided block, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "sorted = dup; Rubinius.privately { sorted.isort!(0, right) }; sorted", "right", ArrayHelpers.getSize(array));
        }

        @Specialization(guards={"!isNullArray(array)"})
        public Object sortWithBlock(VirtualFrame frame, DynamicObject array, DynamicObject block, @Cached(value="new()") SnippetNode snippet) {
            return snippet.execute(frame, "sorted = dup; Rubinius.privately { sorted.isort_block!(0, right, block) }; sorted", "right", ArrayHelpers.getSize(array), "block", block);
        }

        private int castSortValue(Object value) {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.coreExceptions().argumentError("expecting a Fixnum to sort", this));
        }

        protected boolean isSmall(DynamicObject array) {
            return ArrayHelpers.getSize(array) <= this.getContext().getOptions().ARRAY_SMALL;
        }
    }

    @CoreMethod(names={"size", "length"})
    public static abstract class SizeNode
    extends ArrayCoreMethodNode {
        @Specialization
        public int size(DynamicObject array) {
            return ArrayHelpers.getSize(array);
        }
    }

    @CoreMethod(names={"shift"}, raiseIfFrozenSelf=true, optional=1)
    @ImportStatic(value={ArrayGuards.class})
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="array"), @NodeChild(type=RubyNode.class, value="n")})
    public static abstract class ShiftNode
    extends CoreMethodNode {
        @Node.Child
        private ToIntNode toIntNode;

        public abstract Object executeShift(VirtualFrame var1, DynamicObject var2, Object var3);

        @Specialization(guards={"isEmptyArray(array)"})
        public Object shiftEmpty(DynamicObject array, NotProvided n) {
            return this.nil();
        }

        @Specialization(guards={"strategy.matches(array)", "!isEmptyArray(array)"}, limit="ARRAY_STRATEGIES")
        public Object shiftOther(DynamicObject array, NotProvided n, @Cached(value="of(array)") ArrayStrategy strategy) {
            ArrayMirror store = strategy.newMirror(array);
            int size = ArrayHelpers.getSize(array);
            Object value = store.get(0);
            store.copyTo(store, 1, 0, size - 1);
            ArrayMirror filler = strategy.newArray(1);
            filler.copyTo(store, 0, size - 1, 1);
            Layouts.ARRAY.setSize(array, size - 1);
            return value;
        }

        @Specialization(guards={"n < 0"})
        public Object shiftNegative(DynamicObject array, int n) {
            throw new RaiseException(this.coreExceptions().argumentErrorNegativeArraySize(this));
        }

        @Specialization(guards={"n == 0"})
        public Object shiftZero(DynamicObject array, int n) {
            return ArrayHelpers.createArray(this.getContext(), null, 0);
        }

        @Specialization(guards={"n > 0", "isEmptyArray(array)"})
        public Object shiftManyEmpty(DynamicObject array, int n) {
            return ArrayHelpers.createArray(this.getContext(), null, 0);
        }

        @Specialization(guards={"n > 0", "strategy.matches(array)", "!isEmptyArray(array)"}, limit="ARRAY_STRATEGIES")
        public Object shiftMany(DynamicObject array, int n, @Cached(value="of(array)") ArrayStrategy strategy, @Cached(value="createBinaryProfile()") ConditionProfile minProfile) {
            int size = ArrayHelpers.getSize(array);
            int numShift = minProfile.profile(size < n) ? size : n;
            ArrayMirror store = strategy.newMirror(array);
            ArrayMirror result = store.extractRange(0, numShift);
            store.copyTo(store, numShift, 0, size - numShift);
            ArrayMirror filler = strategy.newArray(numShift);
            filler.copyTo(store, 0, size - numShift, numShift);
            Layouts.ARRAY.setSize(array, size - numShift);
            return ArrayHelpers.createArray(this.getContext(), result.getArray(), numShift);
        }

        @Specialization(guards={"wasProvided(n)", "!isInteger(n)", "!isLong(n)"})
        public Object shiftNToInt(VirtualFrame frame, DynamicObject array, Object n) {
            return this.executeShift(frame, array, this.toInt(frame, n));
        }

        private int toInt(VirtualFrame frame, Object indexObject) {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = this.insert(ToIntNode.create());
            }
            return this.toIntNode.doInt(frame, indexObject);
        }
    }

    @CoreMethod(names={"select"}, needsBlock=true, returnsEnumeratorIfNoBlock=true)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class SelectNode
    extends YieldingCoreMethodNode {
        @Specialization(guards={"isNullArray(array)"})
        public Object selectNull(DynamicObject array, DynamicObject block) {
            return ArrayHelpers.createArray(this.getContext(), null, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"strategy.matches(array)"}, limit="ARRAY_STRATEGIES")
        public Object selectOther(VirtualFrame frame, DynamicObject array, DynamicObject block, @Cached(value="of(array)") ArrayStrategy strategy, @Cached(value="create(getContext())") ArrayBuilderNode arrayBuilder) {
            int n;
            ArrayMirror store = strategy.newMirror(array);
            Object selectedStore = arrayBuilder.start(ArrayHelpers.getSize(array));
            int selectedSize = 0;
            try {
                for (n = 0; n < ArrayHelpers.getSize(array); ++n) {
                    Object value = store.get(n);
                    if (!this.yieldIsTruthy(frame, block, value)) continue;
                    selectedStore = arrayBuilder.appendValue(selectedStore, selectedSize, value);
                    ++selectedSize;
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    LoopNode.reportLoopCount(this, n);
                }
            }
            return ArrayHelpers.createArray(this.getContext(), arrayBuilder.finish(selectedStore, selectedSize), selectedSize);
        }
    }

    @CoreMethod(names={"replace"}, required=1, raiseIfFrozenSelf=true)
    @ImportStatic(value={ArrayGuards.class})
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="array"), @NodeChild(type=RubyNode.class, value="other")})
    public static abstract class ReplaceNode
    extends CoreMethodNode {
        public abstract DynamicObject executeReplace(DynamicObject var1, DynamicObject var2);

        @CreateCast(value={"other"})
        public RubyNode coerceOtherToAry(RubyNode index) {
            return ToAryNodeGen.create(null, null, index);
        }

        @Specialization(guards={"isNullArray(other)"})
        public DynamicObject replace(DynamicObject array, DynamicObject other) {
            ArrayHelpers.setStoreAndSize(array, null, 0);
            return array;
        }

        @Specialization(guards={"strategy.matches(other)"}, limit="ARRAY_STRATEGIES")
        public DynamicObject replace(DynamicObject array, DynamicObject other, @Cached(value="of(other)") ArrayStrategy strategy) {
            int size = ArrayHelpers.getSize(other);
            ArrayMirror copy = strategy.newMirror(other).copyArrayAndMirror();
            ArrayHelpers.setStoreAndSize(array, copy.getArray(), size);
            return array;
        }
    }

    @CoreMethod(names={"reject!"}, needsBlock=true, returnsEnumeratorIfNoBlock=true, raiseIfFrozenSelf=true)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class RejectInPlaceNode
    extends YieldingCoreMethodNode {
        public abstract Object executeRejectInPlace(VirtualFrame var1, DynamicObject var2, DynamicObject var3);

        @Specialization(guards={"isNullArray(array)"})
        public Object rejectInPlaceNull(DynamicObject array, DynamicObject block) {
            return this.nil();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"strategy.matches(array)"}, limit="ARRAY_STRATEGIES")
        public Object rejectInPlaceOther(VirtualFrame frame, DynamicObject array, DynamicObject block, @Cached(value="of(array)") ArrayStrategy strategy) {
            int n;
            ArrayMirror store = strategy.newMirror(array);
            int i = 0;
            try {
                for (n = 0; n < ArrayHelpers.getSize(array); ++n) {
                    Object value = store.get(n);
                    if (this.yieldIsTruthy(frame, block, value)) continue;
                    if (i != n) {
                        store.set(i, store.get(n));
                    }
                    ++i;
                }
            }
            finally {
                ArrayMirror filler = strategy.newArray(n - i);
                filler.copyTo(store, 0, i, n - i);
                Layouts.ARRAY.setSize(array, i);
                if (CompilerDirectives.inInterpreter()) {
                    LoopNode.reportLoopCount(this, n);
                }
            }
            if (i != n) {
                return array;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"delete_if"}, needsBlock=true, returnsEnumeratorIfNoBlock=true, raiseIfFrozenSelf=true)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class DeleteIfNode
    extends YieldingCoreMethodNode {
        @Specialization
        public Object deleteIf(VirtualFrame frame, DynamicObject array, DynamicObject block, @Cached(value="createRejectInPlaceNode()") RejectInPlaceNode rejectInPlaceNode) {
            rejectInPlaceNode.executeRejectInPlace(frame, array, block);
            return array;
        }

        protected RejectInPlaceNode createRejectInPlaceNode() {
            return ArrayNodesFactory.RejectInPlaceNodeFactory.create(null);
        }
    }

    @CoreMethod(names={"reject"}, needsBlock=true, returnsEnumeratorIfNoBlock=true)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class RejectNode
    extends YieldingCoreMethodNode {
        @Specialization(guards={"isNullArray(array)"})
        public Object rejectNull(DynamicObject array, DynamicObject block) {
            return ArrayHelpers.createArray(this.getContext(), null, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"strategy.matches(array)"}, limit="ARRAY_STRATEGIES")
        public Object rejectOther(VirtualFrame frame, DynamicObject array, DynamicObject block, @Cached(value="of(array)") ArrayStrategy strategy, @Cached(value="create(getContext())") ArrayBuilderNode arrayBuilder) {
            int n;
            ArrayMirror store = strategy.newMirror(array);
            Object selectedStore = arrayBuilder.start(ArrayHelpers.getSize(array));
            int selectedSize = 0;
            try {
                for (n = 0; n < ArrayHelpers.getSize(array); ++n) {
                    Object value = store.get(n);
                    if (this.yieldIsTruthy(frame, block, value)) continue;
                    selectedStore = arrayBuilder.appendValue(selectedStore, selectedSize, value);
                    ++selectedSize;
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    LoopNode.reportLoopCount(this, n);
                }
            }
            return ArrayHelpers.createArray(this.getContext(), arrayBuilder.finish(selectedStore, selectedSize), selectedSize);
        }
    }

    @CoreMethod(names={"push", "__append__"}, rest=true, optional=1, raiseIfFrozenSelf=true)
    public static abstract class PushNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private ArrayAppendOneNode appendOneNode;

        public PushNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.appendOneNode = ArrayAppendOneNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization(guards={"rest.length == 0"})
        public DynamicObject pushZero(DynamicObject array, NotProvided unusedValue, Object[] rest) {
            return array;
        }

        @Specialization(guards={"rest.length == 0", "wasProvided(value)"})
        public DynamicObject pushOne(DynamicObject array, Object value, Object[] rest) {
            return this.appendOneNode.executeAppendOne(array, value);
        }

        @Specialization(guards={"rest.length > 0", "wasProvided(value)"})
        public DynamicObject pushMany(VirtualFrame frame, DynamicObject array, Object value, Object[] rest) {
            this.appendOneNode.executeAppendOne(array, value);
            for (int i = 0; i < rest.length; ++i) {
                this.appendOneNode.executeAppendOne(array, rest[i]);
            }
            return array;
        }
    }

    @CoreMethod(names={"<<"}, raiseIfFrozenSelf=true, required=1)
    public static abstract class LeftShiftNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private ArrayAppendOneNode appendOneNode;

        public LeftShiftNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.appendOneNode = ArrayAppendOneNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public DynamicObject leftShift(DynamicObject array, Object value) {
            return this.appendOneNode.executeAppendOne(array, value);
        }
    }

    @CoreMethod(names={"pop"}, raiseIfFrozenSelf=true, optional=1)
    public static abstract class PopNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private ToIntNode toIntNode;
        @Node.Child
        private ArrayPopOneNode popOneNode;

        public abstract Object executePop(VirtualFrame var1, DynamicObject var2, Object var3);

        @Specialization
        public Object pop(DynamicObject array, NotProvided n) {
            if (this.popOneNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.popOneNode = this.insert(ArrayPopOneNodeGen.create(this.getContext(), this.getEncapsulatingSourceSection(), null));
            }
            return this.popOneNode.executePopOne(array);
        }

        @Specialization(guards={"n < 0"})
        public Object popNNegative(VirtualFrame frame, DynamicObject array, int n) {
            throw new RaiseException(this.coreExceptions().argumentErrorNegativeArraySize(this));
        }

        @Specialization(guards={"n >= 0", "isEmptyArray(array)"})
        public Object popEmpty(VirtualFrame frame, DynamicObject array, int n) {
            return ArrayHelpers.createArray(this.getContext(), null, 0);
        }

        @Specialization(guards={"n == 0", "!isEmptyArray(array)"})
        public Object popZeroNotEmpty(DynamicObject array, int n) {
            return ArrayHelpers.createArray(this.getContext(), null, 0);
        }

        @Specialization(guards={"n > 0", "!isEmptyArray(array)", "strategy.matches(array)"}, limit="ARRAY_STRATEGIES")
        public Object popNotEmpty(DynamicObject array, int n, @Cached(value="of(array)") ArrayStrategy strategy, @Cached(value="createBinaryProfile()") ConditionProfile minProfile) {
            int size = ArrayHelpers.getSize(array);
            int numPop = minProfile.profile(size < n) ? size : n;
            ArrayMirror store = strategy.newMirror(array);
            ArrayMirror popped = store.extractRange(size - numPop, size);
            ArrayMirror filler = strategy.newArray(numPop);
            filler.copyTo(store, 0, size - numPop, numPop);
            Layouts.ARRAY.setSize(array, size - numPop);
            return ArrayHelpers.createArray(this.getContext(), popped.getArray(), numPop);
        }

        @Specialization(guards={"wasProvided(n)", "!isInteger(n)", "!isLong(n)"})
        public Object popNToInt(VirtualFrame frame, DynamicObject array, Object n) {
            return this.executePop(frame, array, this.toInt(frame, n));
        }

        private int toInt(VirtualFrame frame, Object indexObject) {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = this.insert(ToIntNode.create());
            }
            return this.toIntNode.doInt(frame, indexObject);
        }
    }

    @CoreMethod(names={"pack"}, required=1, taintFromParameter=0)
    @ImportStatic(value={StringCachingGuards.class})
    public static abstract class PackNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private RopeNodes.MakeLeafRopeNode makeLeafRopeNode;
        @Node.Child
        private TaintNode taintNode;
        private final BranchProfile exceptionProfile = BranchProfile.create();
        private final ConditionProfile resizeProfile = ConditionProfile.createBinaryProfile();

        @Specialization(guards={"isRubyString(format)", "ropesEqual(format, cachedFormat)"}, limit="getCacheLimit()")
        public DynamicObject packCached(VirtualFrame frame, DynamicObject array, DynamicObject format, @Cached(value="privatizeRope(format)") Rope cachedFormat, @Cached(value="ropeLength(cachedFormat)") int cachedFormatLength, @Cached(value="create(compileFormat(format))") DirectCallNode callPackNode) {
            BytesResult result;
            try {
                result = (BytesResult)callPackNode.call(frame, new Object[]{ArrayHelpers.getStore(array), ArrayHelpers.getSize(array)});
            }
            catch (FormatException e) {
                this.exceptionProfile.enter();
                throw FormatExceptionTranslator.translate(this, e);
            }
            return this.finishPack(cachedFormatLength, result);
        }

        @Specialization(contains={"packCached"}, guards={"isRubyString(format)"})
        public DynamicObject packUncached(VirtualFrame frame, DynamicObject array, DynamicObject format, @Cached(value="create()") IndirectCallNode callPackNode) {
            BytesResult result;
            try {
                result = (BytesResult)callPackNode.call(frame, this.compileFormat(format), new Object[]{ArrayHelpers.getStore(array), ArrayHelpers.getSize(array)});
            }
            catch (FormatException e) {
                this.exceptionProfile.enter();
                throw FormatExceptionTranslator.translate(this, e);
            }
            return this.finishPack(Layouts.STRING.getRope(format).byteLength(), result);
        }

        private DynamicObject finishPack(int formatLength, BytesResult result) {
            byte[] bytes = result.getOutput();
            if (this.resizeProfile.profile(bytes.length != result.getOutputLength())) {
                bytes = Arrays.copyOf(bytes, result.getOutputLength());
            }
            if (this.makeLeafRopeNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.makeLeafRopeNode = this.insert(RopeNodesFactory.MakeLeafRopeNodeGen.create(null, null, null, null));
            }
            DynamicObject string = this.createString(this.makeLeafRopeNode.executeMake(bytes, result.getEncoding().getEncodingForLength(formatLength), result.getStringCodeRange(), result.getStringLength()));
            if (result.isTainted()) {
                if (this.taintNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.taintNode = this.insert(TaintNodeGen.create(this.getContext(), this.getEncapsulatingSourceSection(), null));
                }
                this.taintNode.executeTaint(string);
            }
            return string;
        }

        @Specialization(guards={"!isRubyString(format)", "!isBoolean(format)", "!isInteger(format)", "!isLong(format)", "!isNil(format)"})
        public Object pack(VirtualFrame frame, DynamicObject array, Object format, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "pack(format.to_str)", "format", format);
        }

        @CompilerDirectives.TruffleBoundary
        protected CallTarget compileFormat(DynamicObject format) {
            return new PackCompiler(this.getContext(), this).compile(format.toString());
        }

        protected int getCacheLimit() {
            return this.getContext().getOptions().PACK_CACHE;
        }
    }

    public static class MinBlock {
        private final FrameDescriptor frameDescriptor;
        private final FrameSlot frameSlot;
        private final SharedMethodInfo sharedMethodInfo;
        private final CallTarget callTarget;

        public MinBlock(RubyContext context) {
            SourceSection sourceSection = CoreSourceSection.createCoreSourceSection("Array", "min");
            this.frameDescriptor = new FrameDescriptor(context.getCoreLibrary().getNilObject());
            this.frameSlot = this.frameDescriptor.addFrameSlot("minimum_memo");
            this.sharedMethodInfo = new SharedMethodInfo(sourceSection, null, Arity.NO_ARGUMENTS, "min", false, null, false, false, false);
            this.callTarget = Truffle.getRuntime().createCallTarget(new RubyRootNode(context, sourceSection, null, this.sharedMethodInfo, ArrayNodesFactory.MinBlockNodeFactory.create(context, sourceSection, new RubyNode[]{new ReadDeclarationVariableNode(context, sourceSection, LocalVariableType.FRAME_LOCAL, 1, this.frameSlot), new ReadPreArgumentNode(0, MissingArgumentBehavior.RUNTIME_ERROR)}), false));
        }

        public FrameDescriptor getFrameDescriptor() {
            return this.frameDescriptor;
        }

        public FrameSlot getFrameSlot() {
            return this.frameSlot;
        }

        public SharedMethodInfo getSharedMethodInfo() {
            return this.sharedMethodInfo;
        }

        public CallTarget getCallTarget() {
            return this.callTarget;
        }
    }

    public static abstract class MinBlockNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode compareNode;

        public MinBlockNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.compareNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public DynamicObject min(VirtualFrame frame, Object minimumObject, Object value) {
            Memo minimum = (Memo)minimumObject;
            Object current = minimum.get();
            if (current == null) {
                minimum.set(value);
            } else {
                Object compared = this.compareNode.call(frame, value, "<=>", null, current);
                if (compared instanceof Integer) {
                    if ((Integer)compared < 0) {
                        minimum.set(value);
                    }
                } else {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.coreExceptions().argumentError("comparison of X with Y failed", this));
                }
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"min"}, needsBlock=true)
    public static abstract class MinNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode eachNode;
        private final MinBlock minBlock;

        public MinNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.eachNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.minBlock = context.getCoreLibrary().getArrayMinBlock();
        }

        @Specialization
        public Object min(VirtualFrame frame, DynamicObject array, NotProvided blockNotProvided) {
            Memo minimum = new Memo();
            InternalMethod method = RubyArguments.getMethod(frame);
            VirtualFrame minimumClosureFrame = Truffle.getRuntime().createVirtualFrame(RubyArguments.pack(null, null, method, DeclarationContext.BLOCK, null, array, null, new Object[0]), this.minBlock.getFrameDescriptor());
            minimumClosureFrame.setObject(this.minBlock.getFrameSlot(), minimum);
            DynamicObject block = ProcOperations.createRubyProc(this.coreLibrary().getProcFactory(), ProcType.PROC, this.minBlock.getSharedMethodInfo(), this.minBlock.getCallTarget(), this.minBlock.getCallTarget(), minimumClosureFrame.materialize(), method, array, null);
            this.eachNode.call(frame, array, "each", block, new Object[0]);
            if (minimum.get() == null) {
                return this.nil();
            }
            return minimum.get();
        }

        @Specialization
        public Object min(VirtualFrame frame, DynamicObject array, DynamicObject block, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "array.min_internal(&block)", "array", array, "block", block);
        }
    }

    public static class MaxBlock {
        private final FrameDescriptor frameDescriptor;
        private final FrameSlot frameSlot;
        private final SharedMethodInfo sharedMethodInfo;
        private final CallTarget callTarget;

        public MaxBlock(RubyContext context) {
            SourceSection sourceSection = CoreSourceSection.createCoreSourceSection("Array", "max");
            this.frameDescriptor = new FrameDescriptor(context.getCoreLibrary().getNilObject());
            this.frameSlot = this.frameDescriptor.addFrameSlot("maximum_memo");
            this.sharedMethodInfo = new SharedMethodInfo(sourceSection, null, Arity.NO_ARGUMENTS, "max", false, null, false, false, false);
            this.callTarget = Truffle.getRuntime().createCallTarget(new RubyRootNode(context, sourceSection, null, this.sharedMethodInfo, ArrayNodesFactory.MaxBlockNodeFactory.create(context, sourceSection, new RubyNode[]{new ReadDeclarationVariableNode(context, sourceSection, LocalVariableType.FRAME_LOCAL, 1, this.frameSlot), new ReadPreArgumentNode(0, MissingArgumentBehavior.RUNTIME_ERROR)}), false));
        }

        public FrameDescriptor getFrameDescriptor() {
            return this.frameDescriptor;
        }

        public FrameSlot getFrameSlot() {
            return this.frameSlot;
        }

        public SharedMethodInfo getSharedMethodInfo() {
            return this.sharedMethodInfo;
        }

        public CallTarget getCallTarget() {
            return this.callTarget;
        }
    }

    public static abstract class MaxBlockNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode compareNode;

        public MaxBlockNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.compareNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public DynamicObject max(VirtualFrame frame, Object maximumObject, Object value) {
            Memo maximum = (Memo)maximumObject;
            Object current = maximum.get();
            if (current == null) {
                maximum.set(value);
            } else {
                Object compared = this.compareNode.call(frame, value, "<=>", null, current);
                if (compared instanceof Integer) {
                    if ((Integer)compared > 0) {
                        maximum.set(value);
                    }
                } else {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.coreExceptions().argumentError("comparison of X with Y failed", this));
                }
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"max"}, needsBlock=true)
    public static abstract class MaxNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode eachNode;
        private final MaxBlock maxBlock;

        public MaxNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.eachNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.maxBlock = context.getCoreLibrary().getArrayMaxBlock();
        }

        @Specialization
        public Object max(VirtualFrame frame, DynamicObject array, NotProvided blockNotProvided) {
            Memo maximum = new Memo();
            InternalMethod method = RubyArguments.getMethod(frame);
            VirtualFrame maximumClosureFrame = Truffle.getRuntime().createVirtualFrame(RubyArguments.pack(null, null, method, DeclarationContext.BLOCK, null, array, null, new Object[0]), this.maxBlock.getFrameDescriptor());
            maximumClosureFrame.setObject(this.maxBlock.getFrameSlot(), maximum);
            DynamicObject block = ProcOperations.createRubyProc(this.coreLibrary().getProcFactory(), ProcType.PROC, this.maxBlock.getSharedMethodInfo(), this.maxBlock.getCallTarget(), this.maxBlock.getCallTarget(), maximumClosureFrame.materialize(), method, array, null);
            this.eachNode.call(frame, array, "each", block, new Object[0]);
            if (maximum.get() == null) {
                return this.nil();
            }
            return maximum.get();
        }

        @Specialization
        public Object max(VirtualFrame frame, DynamicObject array, DynamicObject block, @Cached(value="createMethodCall()") CallDispatchHeadNode callNode) {
            return callNode.call(frame, array, "max_internal", block, new Object[0]);
        }
    }

    @CoreMethod(names={"map!", "collect!"}, needsBlock=true, returnsEnumeratorIfNoBlock=true, raiseIfFrozenSelf=true)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class MapInPlaceNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private ArrayWriteNormalizedNode writeNode;

        @Specialization(guards={"isNullArray(array)"})
        public DynamicObject mapInPlaceNull(DynamicObject array, DynamicObject block) {
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"strategy.matches(array)"}, limit="ARRAY_STRATEGIES")
        public Object map(VirtualFrame frame, DynamicObject array, DynamicObject block, @Cached(value="of(array)") ArrayStrategy strategy, @Cached(value="createWriteNode()") ArrayWriteNormalizedNode writeNode) {
            int n;
            ArrayMirror store = strategy.newMirror(array);
            try {
                for (n = 0; n < ArrayHelpers.getSize(array); ++n) {
                    writeNode.executeWrite(array, n, this.yield(frame, block, store.get(n)));
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    LoopNode.reportLoopCount(this, n);
                }
            }
            return array;
        }

        protected ArrayWriteNormalizedNode createWriteNode() {
            return ArrayWriteNormalizedNodeGen.create(this.getContext(), this.getSourceSection(), null, null, null);
        }
    }

    @CoreMethod(names={"map", "collect"}, needsBlock=true, returnsEnumeratorIfNoBlock=true)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class MapNode
    extends YieldingCoreMethodNode {
        @Specialization(guards={"isNullArray(array)"})
        public DynamicObject mapNull(DynamicObject array, DynamicObject block) {
            return ArrayHelpers.createArray(this.getContext(), null, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"strategy.matches(array)"}, limit="ARRAY_STRATEGIES")
        public Object map(VirtualFrame frame, DynamicObject array, DynamicObject block, @Cached(value="of(array)") ArrayStrategy strategy, @Cached(value="create(getContext())") ArrayBuilderNode arrayBuilder) {
            int n;
            ArrayMirror store = strategy.newMirror(array);
            int size = ArrayHelpers.getSize(array);
            Object mappedStore = arrayBuilder.start(size);
            try {
                for (n = 0; n < ArrayHelpers.getSize(array); ++n) {
                    Object mappedValue = this.yield(frame, block, store.get(n));
                    mappedStore = arrayBuilder.appendValue(mappedStore, n, mappedValue);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    LoopNode.reportLoopCount(this, n);
                }
            }
            return ArrayHelpers.createArray(this.getContext(), arrayBuilder.finish(mappedStore, size), size);
        }
    }

    @CoreMethod(names={"inject", "reduce"}, needsBlock=true, optional=2)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class InjectNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode dispatch;

        public InjectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.dispatch = DispatchHeadNodeFactory.createMethodCall(context, MissingBehavior.CALL_METHOD_MISSING);
        }

        @Specialization(guards={"isEmptyArray(array)", "wasProvided(initial)"})
        public Object injectEmptyArray(VirtualFrame frame, DynamicObject array, Object initial, NotProvided unused, DynamicObject block) {
            return initial;
        }

        @Specialization(guards={"isEmptyArray(array)"})
        public Object injectEmptyArrayNoInitial(VirtualFrame frame, DynamicObject array, NotProvided initial, NotProvided unused, DynamicObject block) {
            return this.nil();
        }

        @Specialization(guards={"strategy.matches(array)", "!isEmptyArray(array)", "wasProvided(initial)"}, limit="ARRAY_STRATEGIES")
        public Object injectWithInitial(VirtualFrame frame, DynamicObject array, Object initial, NotProvided unused, DynamicObject block, @Cached(value="of(array)") ArrayStrategy strategy) {
            ArrayMirror store = strategy.newMirror(array);
            return this.injectBlockHelper(frame, array, block, store, initial, 0);
        }

        @Specialization(guards={"strategy.matches(array)", "!isEmptyArray(array)"}, limit="ARRAY_STRATEGIES")
        public Object injectNoInitial(VirtualFrame frame, DynamicObject array, NotProvided initial, NotProvided unused, DynamicObject block, @Cached(value="of(array)") ArrayStrategy strategy) {
            ArrayMirror store = strategy.newMirror(array);
            return this.injectBlockHelper(frame, array, block, store, store.get(0), 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object injectBlockHelper(VirtualFrame frame, DynamicObject array, DynamicObject block, ArrayMirror store, Object initial, int start) {
            int n;
            Object accumulator = initial;
            try {
                for (n = start; n < ArrayHelpers.getSize(array); ++n) {
                    accumulator = this.yield(frame, block, accumulator, store.get(n));
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    LoopNode.reportLoopCount(this, n);
                }
            }
            return accumulator;
        }

        @Specialization(guards={"isRubySymbol(symbol)", "isEmptyArray(array)", "wasProvided(initial)"})
        public Object injectSymbolEmptyArray(VirtualFrame frame, DynamicObject array, Object initial, DynamicObject symbol, NotProvided block) {
            return initial;
        }

        @Specialization(guards={"isRubySymbol(symbol)", "isEmptyArray(array)"})
        public Object injectSymbolEmptyArrayNoInitial(VirtualFrame frame, DynamicObject array, DynamicObject symbol, NotProvided unused, NotProvided block) {
            return this.nil();
        }

        @Specialization(guards={"isRubySymbol(symbol)", "strategy.matches(array)", "!isEmptyArray(array)", "wasProvided(initial)"}, limit="ARRAY_STRATEGIES")
        public Object injectSymbolWithInitial(VirtualFrame frame, DynamicObject array, Object initial, DynamicObject symbol, NotProvided block, @Cached(value="of(array)") ArrayStrategy strategy) {
            ArrayMirror store = strategy.newMirror(array);
            return this.injectSymbolHelper(frame, array, symbol, store, initial, 0);
        }

        @Specialization(guards={"isRubySymbol(symbol)", "strategy.matches(array)", "!isEmptyArray(array)"}, limit="ARRAY_STRATEGIES")
        public Object injectSymbolNoInitial(VirtualFrame frame, DynamicObject array, DynamicObject symbol, NotProvided unused, NotProvided block, @Cached(value="of(array)") ArrayStrategy strategy) {
            ArrayMirror store = strategy.newMirror(array);
            return this.injectSymbolHelper(frame, array, symbol, store, store.get(0), 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object injectSymbolHelper(VirtualFrame frame, DynamicObject array, DynamicObject symbol, ArrayMirror store, Object initial, int start) {
            int n;
            Object accumulator = initial;
            try {
                for (n = start; n < ArrayHelpers.getSize(array); ++n) {
                    accumulator = this.dispatch.call(frame, accumulator, symbol, null, store.get(n));
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    LoopNode.reportLoopCount(this, n);
                }
            }
            return accumulator;
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1, raiseIfFrozenSelf=true)
    @ImportStatic(value={ArrayGuards.class})
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="self"), @NodeChild(type=RubyNode.class, value="from")})
    public static abstract class InitializeCopyNode
    extends CoreMethodNode {
        @CreateCast(value={"from"})
        public RubyNode coerceOtherToAry(RubyNode other) {
            return ToAryNodeGen.create(null, null, other);
        }

        @Specialization
        public DynamicObject initializeCopy(DynamicObject self, DynamicObject from, @Cached(value="createReplaceNode()") ReplaceNode replaceNode) {
            if (self == from) {
                return self;
            }
            replaceNode.executeReplace(self, from);
            return self;
        }

        protected ReplaceNode createReplaceNode() {
            return ArrayNodesFactory.ReplaceNodeFactory.create(null, null);
        }
    }

    @CoreMethod(names={"initialize"}, needsBlock=true, optional=2, raiseIfFrozenSelf=true, lowerFixnumParameters={0})
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class InitializeNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private ToIntNode toIntNode;
        @Node.Child
        private CallDispatchHeadNode toAryNode;
        @Node.Child
        private KernelNodes.RespondToNode respondToToAryNode;
        protected static final long MAX_INT = Integer.MAX_VALUE;

        public abstract DynamicObject executeInitialize(VirtualFrame var1, DynamicObject var2, Object var3, Object var4, Object var5);

        @Specialization
        public DynamicObject initializeNoArgs(DynamicObject array, NotProvided size, NotProvided unusedValue, NotProvided block) {
            ArrayHelpers.setStoreAndSize(array, null, 0);
            return array;
        }

        @Specialization
        public DynamicObject initializeOnlyBlock(DynamicObject array, NotProvided size, NotProvided unusedValue, DynamicObject block) {
            ArrayHelpers.setStoreAndSize(array, null, 0);
            return array;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"size < 0"})
        public DynamicObject initializeNegativeIntSize(DynamicObject array, int size, Object unusedValue, Object maybeBlock) {
            throw new RaiseException(this.coreExceptions().argumentError("negative array size", this));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"size < 0"})
        public DynamicObject initializeNegativeLongSize(DynamicObject array, long size, Object unusedValue, Object maybeBlock) {
            throw new RaiseException(this.coreExceptions().argumentError("negative array size", this));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"size >= MAX_INT"})
        public DynamicObject initializeSizeTooBig(DynamicObject array, long size, NotProvided unusedValue, NotProvided block) {
            throw new RaiseException(this.coreExceptions().argumentError("array size too big", this));
        }

        @Specialization(guards={"size >= 0"})
        public DynamicObject initializeWithSizeNoValue(DynamicObject array, int size, NotProvided unusedValue, NotProvided block) {
            Object[] store = new Object[size];
            Arrays.fill(store, this.nil());
            ArrayHelpers.setStoreAndSize(array, store, size);
            return array;
        }

        @Specialization(guards={"size >= 0", "wasProvided(value)", "strategy.specializesFor(value)"}, limit="ARRAY_STRATEGIES")
        public DynamicObject initializeWithSizeAndValue(DynamicObject array, int size, Object value, NotProvided block, @Cached(value="forValue(value)") ArrayStrategy strategy, @Cached(value="createBinaryProfile()") ConditionProfile needsFill) {
            ArrayMirror store = strategy.newArray(size);
            if (needsFill.profile(size > 0 && store.get(0) != value)) {
                for (int i = 0; i < size; ++i) {
                    store.set(i, value);
                }
            }
            ArrayHelpers.setStoreAndSize(array, store.getArray(), size);
            return array;
        }

        @Specialization(guards={"wasProvided(sizeObject)", "!isInteger(sizeObject)", "!isLong(sizeObject)", "wasProvided(value)"})
        public DynamicObject initializeSizeOther(VirtualFrame frame, DynamicObject array, Object sizeObject, Object value, NotProvided block) {
            int size = this.toInt(frame, sizeObject);
            return this.executeInitialize(frame, array, size, value, block);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"size >= 0"})
        public Object initializeBlock(VirtualFrame frame, DynamicObject array, int size, Object unusedValue, DynamicObject block, @Cached(value="create(getContext())") ArrayBuilderNode arrayBuilder) {
            int n;
            Object store = arrayBuilder.start(size);
            try {
                for (n = 0; n < size; ++n) {
                    store = arrayBuilder.appendValue(store, n, this.yield(frame, block, n));
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    LoopNode.reportLoopCount(this, n);
                }
                ArrayHelpers.setStoreAndSize(array, arrayBuilder.finish(store, n), n);
            }
            return array;
        }

        @Specialization(guards={"isRubyArray(copy)"})
        public DynamicObject initializeFromArray(DynamicObject array, DynamicObject copy, NotProvided unusedValue, Object maybeBlock, @Cached(value="createReplaceNode()") ReplaceNode replaceNode) {
            replaceNode.executeReplace(array, copy);
            return array;
        }

        @Specialization(guards={"!isInteger(object)", "!isLong(object)", "wasProvided(object)", "!isRubyArray(object)"})
        public DynamicObject initialize(VirtualFrame frame, DynamicObject array, Object object, NotProvided unusedValue, NotProvided block) {
            Object toAryResult;
            DynamicObject copy = null;
            if (this.respondToToAry(frame, object) && RubyGuards.isRubyArray(toAryResult = this.callToAry(frame, object))) {
                copy = (DynamicObject)toAryResult;
            }
            if (copy != null) {
                return this.executeInitialize(frame, array, copy, NotProvided.INSTANCE, NotProvided.INSTANCE);
            }
            int size = this.toInt(frame, object);
            return this.executeInitialize(frame, array, size, NotProvided.INSTANCE, NotProvided.INSTANCE);
        }

        public boolean respondToToAry(VirtualFrame frame, Object object) {
            if (this.respondToToAryNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.respondToToAryNode = this.insert(KernelNodesFactory.RespondToNodeFactory.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            return this.respondToToAryNode.doesRespondToString(frame, object, this.create7BitString("to_ary", (Encoding)UTF8Encoding.INSTANCE), true);
        }

        protected Object callToAry(VirtualFrame frame, Object object) {
            if (this.toAryNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toAryNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true));
            }
            return this.toAryNode.call(frame, object, "to_ary", null, new Object[0]);
        }

        protected int toInt(VirtualFrame frame, Object value) {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = this.insert(ToIntNode.create());
            }
            return this.toIntNode.doInt(frame, value);
        }

        protected ReplaceNode createReplaceNode() {
            return ArrayNodesFactory.ReplaceNodeFactory.create(null, null);
        }
    }

    @CoreMethod(names={"include?"}, required=1)
    public static abstract class IncludeNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private KernelNodes.SameOrEqualNode equalNode = KernelNodesFactory.SameOrEqualNodeFactory.create(new RubyNode[]{null, null});

        public IncludeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNullArray(array)"})
        public boolean includeNull(VirtualFrame frame, DynamicObject array, Object value) {
            return false;
        }

        @Specialization(guards={"strategy.matches(array)"}, limit="ARRAY_STRATEGIES")
        public boolean include(VirtualFrame frame, DynamicObject array, Object value, @Cached(value="of(array)") ArrayStrategy strategy) {
            ArrayMirror store = strategy.newMirror(array);
            for (int n = 0; n < ArrayHelpers.getSize(array); ++n) {
                Object stored = store.get(n);
                if (!this.equalNode.executeSameOrEqual(frame, stored, value)) continue;
                return true;
            }
            return false;
        }
    }

    @CoreMethod(names={"fill"}, rest=true, needsBlock=true, raiseIfFrozenSelf=true)
    public static abstract class FillNode
    extends ArrayCoreMethodNode {
        @Specialization(guards={"args.length == 1", "strategy.matches(array)", "strategy.accepts(value(args))"}, limit="ARRAY_STRATEGIES")
        protected DynamicObject fill(DynamicObject array, Object[] args, NotProvided block, @Cached(value="of(array, value(args))") ArrayStrategy strategy) {
            Object value = args[0];
            ArrayMirror store = strategy.newMirror(array);
            int size = ArrayHelpers.getSize(array);
            for (int i = 0; i < size; ++i) {
                store.set(i, value);
            }
            return array;
        }

        protected Object value(Object[] args) {
            return args[0];
        }

        @Specialization
        protected Object fillFallback(VirtualFrame frame, DynamicObject array, Object[] args, NotProvided block, @Cached(value="createMethodCall()") CallDispatchHeadNode callFillInternal) {
            return callFillInternal.call(frame, array, "fill_internal", null, args);
        }

        @Specialization
        protected Object fillFallback(VirtualFrame frame, DynamicObject array, Object[] args, DynamicObject block, @Cached(value="createMethodCall()") CallDispatchHeadNode callFillInternal) {
            return callFillInternal.call(frame, array, "fill_internal", block, args);
        }
    }

    @CoreMethod(names={"each_with_index"}, needsBlock=true, returnsEnumeratorIfNoBlock=true)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class EachWithIndexNode
    extends YieldingCoreMethodNode {
        @Specialization(guards={"isNullArray(array)"})
        public DynamicObject eachWithIndexNull(DynamicObject array, DynamicObject block) {
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"strategy.matches(array)"}, limit="ARRAY_STRATEGIES")
        public Object eachWithIndexOther(VirtualFrame frame, DynamicObject array, DynamicObject block, @Cached(value="of(array)") ArrayStrategy strategy) {
            int n;
            ArrayMirror store = strategy.newMirror(array);
            try {
                for (n = 0; n < ArrayHelpers.getSize(array); ++n) {
                    this.yield(frame, block, store.get(n), n);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    LoopNode.reportLoopCount(this, n);
                }
            }
            return array;
        }
    }

    @CoreMethod(names={"each"}, needsBlock=true, returnsEnumeratorIfNoBlock=true)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class EachNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode toEnumNode;

        public EachNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNullArray(array)"})
        public Object eachNull(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"strategy.matches(array)"}, limit="ARRAY_STRATEGIES")
        public Object eachOther(VirtualFrame frame, DynamicObject array, DynamicObject block, @Cached(value="of(array)") ArrayStrategy strategy) {
            int n;
            ArrayMirror store = strategy.newMirror(array);
            try {
                for (n = 0; n < ArrayHelpers.getSize(array); ++n) {
                    this.yield(frame, block, store.get(n));
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    LoopNode.reportLoopCount(this, n);
                }
            }
            return array;
        }
    }

    @CoreMethod(names={"delete_at"}, required=1, raiseIfFrozenSelf=true, lowerFixnumParameters={0})
    @ImportStatic(value={ArrayGuards.class})
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="array"), @NodeChild(type=RubyNode.class, value="index")})
    public static abstract class DeleteAtNode
    extends CoreMethodNode {
        @CreateCast(value={"index"})
        public RubyNode coerceOtherToInt(RubyNode index) {
            return ToIntNodeGen.create(index);
        }

        @Specialization(guards={"isEmptyArray(array)"})
        public Object deleteAtNullOrEmpty(DynamicObject array, int index) {
            return this.nil();
        }

        @Specialization(guards={"strategy.matches(array)"}, limit="ARRAY_STRATEGIES")
        public Object deleteAt(DynamicObject array, int index, @Cached(value="of(array)") ArrayStrategy strategy, @Cached(value="createBinaryProfile()") ConditionProfile negativeIndexProfile, @Cached(value="create()") BranchProfile notInBoundsProfile) {
            int size = ArrayHelpers.getSize(array);
            int i = ArrayOperations.normalizeIndex(size, index, negativeIndexProfile);
            if (i < 0 || i >= size) {
                notInBoundsProfile.enter();
                return this.nil();
            }
            ArrayMirror store = strategy.newMirror(array);
            Object value = store.get(i);
            store.copyTo(store, i + 1, i, size - i - 1);
            ArrayHelpers.setStoreAndSize(array, store.getArray(), size - 1);
            return value;
        }
    }

    @CoreMethod(names={"delete"}, required=1)
    public static abstract class DeleteNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private KernelNodes.SameOrEqualNode equalNode = KernelNodesFactory.SameOrEqualNodeFactory.create(new RubyNode[]{null, null});
        @Node.Child
        private IsFrozenNode isFrozenNode;

        public DeleteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNullArray(array)"})
        public Object deleteNull(VirtualFrame frame, DynamicObject array, Object value) {
            return this.nil();
        }

        @Specialization(guards={"strategy.matches(array)"}, limit="ARRAY_STRATEGIES")
        public Object delete(VirtualFrame frame, DynamicObject array, Object value, @Cached(value="of(array)") ArrayStrategy strategy) {
            int n;
            ArrayMirror store = strategy.newMirror(array);
            Object found = this.nil();
            int i = 0;
            for (n = 0; n < ArrayHelpers.getSize(array); ++n) {
                Object stored = store.get(n);
                if (this.equalNode.executeSameOrEqual(frame, stored, value)) {
                    this.checkFrozen(array);
                    found = stored;
                    continue;
                }
                if (i != n) {
                    store.set(i, store.get(n));
                }
                ++i;
            }
            if (i != n) {
                ArrayHelpers.setStoreAndSize(array, store.getArray(), i);
            }
            return found;
        }

        public void checkFrozen(Object object) {
            if (this.isFrozenNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.isFrozenNode = this.insert(IsFrozenNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            this.isFrozenNode.raiseIfFrozen(object);
        }
    }

    @CoreMethod(names={"concat"}, required=1, raiseIfFrozenSelf=true)
    @ImportStatic(value={ArrayGuards.class})
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="array"), @NodeChild(type=RubyNode.class, value="other")})
    public static abstract class ConcatNode
    extends CoreMethodNode {
        @Node.Child
        private ArrayAppendManyNode appendManyNode;

        public ConcatNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.appendManyNode = ArrayAppendManyNodeGen.create(context, sourceSection, null, null);
        }

        @CreateCast(value={"other"})
        public RubyNode coerceOtherToAry(RubyNode other) {
            return ToAryNodeGen.create(null, null, other);
        }

        @Specialization
        public DynamicObject concat(DynamicObject array, DynamicObject other) {
            this.appendManyNode.executeAppendMany(array, other);
            return array;
        }
    }

    @CoreMethod(names={"compact!"}, raiseIfFrozenSelf=true)
    public static abstract class CompactBangNode
    extends ArrayCoreMethodNode {
        @Specialization(guards={"!isObjectArray(array)"})
        public DynamicObject compactNotObjects(DynamicObject array) {
            return this.nil();
        }

        @Specialization(guards={"isObjectArray(array)"})
        public Object compactObjects(DynamicObject array) {
            Object[] store = (Object[])ArrayHelpers.getStore(array);
            int size = ArrayHelpers.getSize(array);
            int m = 0;
            for (int n = 0; n < size; ++n) {
                if (store[n] == this.nil()) continue;
                store[m] = store[n];
                ++m;
            }
            ArrayHelpers.setStoreAndSize(array, store, m);
            if (m == size) {
                return this.nil();
            }
            return array;
        }
    }

    @CoreMethod(names={"compact"})
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class CompactNode
    extends ArrayCoreMethodNode {
        @Specialization(guards={"isNullArray(array)"})
        public Object compactNull(DynamicObject array) {
            return ArrayHelpers.createArray(this.getContext(), null, 0);
        }

        @Specialization(guards={"!isObjectArray(array)", "strategy.matches(array)"}, limit="ARRAY_STRATEGIES")
        public DynamicObject compactPrimitive(DynamicObject array, @Cached(value="of(array)") ArrayStrategy strategy) {
            int size = ArrayHelpers.getSize(array);
            Object store = strategy.newMirror(array).extractRange(0, size).getArray();
            return ArrayHelpers.createArray(this.getContext(), store, size);
        }

        @Specialization(guards={"isObjectArray(array)"})
        public Object compactObjects(DynamicObject array) {
            Object[] store = (Object[])ArrayHelpers.getStore(array);
            Object[] newStore = new Object[store.length];
            int size = ArrayHelpers.getSize(array);
            int m = 0;
            for (int n = 0; n < size; ++n) {
                if (store[n] == this.nil()) continue;
                newStore[m] = store[n];
                ++m;
            }
            return ArrayHelpers.createArray(this.getContext(), newStore, m);
        }
    }

    @CoreMethod(names={"clear"}, raiseIfFrozenSelf=true)
    public static abstract class ClearNode
    extends ArrayCoreMethodNode {
        @Specialization(guards={"isRubyArray(array)"})
        public DynamicObject clear(DynamicObject array) {
            ArrayHelpers.setStoreAndSize(array, null, 0);
            return array;
        }
    }

    @CoreMethod(names={"at"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="array"), @NodeChild(type=RubyNode.class, value="index")})
    public static abstract class AtNode
    extends CoreMethodNode {
        @Node.Child
        private ArrayReadDenormalizedNode readNode;

        @CreateCast(value={"index"})
        public RubyNode coerceOtherToInt(RubyNode index) {
            return FixnumLowerNodeGen.create(null, null, ToIntNodeGen.create(index));
        }

        @Specialization
        public Object at(DynamicObject array, int index) {
            if (this.readNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.readNode = this.insert(ArrayReadDenormalizedNodeGen.create(this.getContext(), this.getSourceSection(), null, null));
            }
            return this.readNode.executeRead(array, index);
        }
    }

    @CoreMethod(names={"[]="}, required=2, optional=1, lowerFixnumParameters={0}, raiseIfFrozenSelf=true)
    public static abstract class IndexSetNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private ArrayReadNormalizedNode readNode;
        @Node.Child
        private ArrayWriteNormalizedNode writeNode;
        @Node.Child
        protected ArrayReadSliceNormalizedNode readSliceNode;
        @Node.Child
        private ToIntNode toIntNode;

        public abstract Object executeSet(VirtualFrame var1, DynamicObject var2, Object var3, Object var4, Object var5);

        @Specialization
        public Object set(DynamicObject array, int index, Object value, NotProvided unused, @Cached(value="createBinaryProfile()") ConditionProfile negativeIndexProfile) {
            int normalizedIndex = ArrayOperations.normalizeIndex(ArrayHelpers.getSize(array), index, negativeIndexProfile);
            this.checkIndex(array, index, normalizedIndex);
            return this.write(array, normalizedIndex, value);
        }

        @Specialization(guards={"!isInteger(indexObject)", "!isIntegerFixnumRange(indexObject)"})
        public Object set(VirtualFrame frame, DynamicObject array, Object indexObject, Object value, NotProvided unused) {
            int index = this.toInt(frame, indexObject);
            return this.executeSet(frame, array, index, value, unused);
        }

        @Specialization(guards={"!isRubyArray(value)", "wasProvided(value)", "strategy.specializesFor(value)"}, limit="ARRAY_STRATEGIES")
        public Object setObject(VirtualFrame frame, DynamicObject array, int start, int length, Object value, @Cached(value="forValue(value)") ArrayStrategy strategy, @Cached(value="createBinaryProfile()") ConditionProfile negativeIndexProfile) {
            this.checkLengthPositive(length);
            int size = ArrayHelpers.getSize(array);
            int begin = ArrayOperations.normalizeIndex(size, start, negativeIndexProfile);
            this.checkIndex(array, start, begin);
            ArrayMirror mirror = strategy.newArray(1);
            mirror.set(0, value);
            DynamicObject ary = ArrayHelpers.createArray(this.getContext(), mirror.getArray(), 1);
            return this.executeSet(frame, array, start, length, ary);
        }

        @Specialization(guards={"isRubyArray(replacement)", "length == getArraySize(replacement)"})
        public Object setOtherIntArraySameLength(DynamicObject array, int start, int length, DynamicObject replacement, @Cached(value="createBinaryProfile()") ConditionProfile negativeIndexProfile) {
            int normalizedIndex = ArrayOperations.normalizeIndex(ArrayHelpers.getSize(array), start, negativeIndexProfile);
            this.checkIndex(array, start, normalizedIndex);
            for (int i = 0; i < length; ++i) {
                this.write(array, normalizedIndex + i, this.read(replacement, i));
            }
            return replacement;
        }

        @Specialization(guards={"isRubyArray(replacement)", "length != getArraySize(replacement)"})
        public Object setOtherArray(VirtualFrame frame, DynamicObject array, int rawStart, int length, DynamicObject replacement, @Cached(value="createBinaryProfile()") ConditionProfile negativeIndexProfile, @Cached(value="createBinaryProfile()") ConditionProfile needCopy, @Cached(value="createBinaryProfile()") ConditionProfile recursive) {
            int i;
            this.checkLengthPositive(length);
            int start = ArrayOperations.normalizeIndex(ArrayHelpers.getSize(array), rawStart, negativeIndexProfile);
            this.checkIndex(array, rawStart, start);
            int end = start + length;
            int arraySize = ArrayHelpers.getSize(array);
            int replacementSize = ArrayHelpers.getSize(replacement);
            int endOfReplacementInArray = start + replacementSize;
            if (recursive.profile(array == replacement)) {
                DynamicObject copy = this.readSlice(array, 0, arraySize);
                return this.executeSet(frame, array, start, length, copy);
            }
            int tailSize = arraySize - end;
            DynamicObject tailCopy = null;
            boolean needsTail = needCopy.profile(tailSize > 0);
            if (needsTail) {
                tailCopy = this.readSlice(array, end, tailSize);
            }
            for (i = 0; i < replacementSize; ++i) {
                this.write(array, start + i, this.read(replacement, i));
            }
            if (needsTail) {
                for (i = 0; i < tailSize; ++i) {
                    this.write(array, endOfReplacementInArray + i, this.read(tailCopy, i));
                }
            }
            if (needsTail) {
                Layouts.ARRAY.setSize(array, endOfReplacementInArray + tailSize);
            } else {
                Layouts.ARRAY.setSize(array, endOfReplacementInArray);
            }
            return replacement;
        }

        @Specialization(guards={"!isInteger(startObject) || !isInteger(lengthObject)", "wasProvided(value)"})
        public Object setStartLengthNotInt(VirtualFrame frame, DynamicObject array, Object startObject, Object lengthObject, Object value, @Cached(value="createBinaryProfile()") ConditionProfile negativeIndexProfile) {
            int start = this.toInt(frame, startObject);
            int length = this.toInt(frame, lengthObject);
            return this.executeSet(frame, array, start, length, value);
        }

        @Specialization(guards={"isIntegerFixnumRange(range)"})
        public Object setRange(VirtualFrame frame, DynamicObject array, DynamicObject range, Object value, NotProvided unused, @Cached(value="createBinaryProfile()") ConditionProfile negativeBeginProfile, @Cached(value="createBinaryProfile()") ConditionProfile negativeEndProfile) {
            int inclusiveEnd;
            int begin;
            int size = ArrayHelpers.getSize(array);
            int start = ArrayOperations.normalizeIndex(size, begin = Layouts.INTEGER_FIXNUM_RANGE.getBegin(range), negativeBeginProfile);
            if (start < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().rangeError(range, (Node)this));
            }
            int end = ArrayOperations.normalizeIndex(size, Layouts.INTEGER_FIXNUM_RANGE.getEnd(range), negativeEndProfile);
            int n = inclusiveEnd = Layouts.INTEGER_FIXNUM_RANGE.getExcludedEnd(range) ? end - 1 : end;
            if (inclusiveEnd < 0) {
                inclusiveEnd = -1;
            }
            int length = inclusiveEnd - start + 1;
            return this.executeSet(frame, array, start, length, value);
        }

        private void checkIndex(DynamicObject array, int index, int normalizedIndex) {
            if (normalizedIndex < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().indexTooSmallError("array", index, ArrayHelpers.getSize(array), this));
            }
        }

        public void checkLengthPositive(int length) {
            if (length < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().negativeLengthError(length, this));
            }
        }

        protected int getArraySize(DynamicObject array) {
            return ArrayHelpers.getSize(array);
        }

        private Object read(DynamicObject array, int index) {
            if (this.readNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.readNode = this.insert(ArrayReadNormalizedNodeGen.create(this.getContext(), this.getSourceSection(), null, null));
            }
            return this.readNode.executeRead(array, index);
        }

        private Object write(DynamicObject array, int index, Object value) {
            if (this.writeNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.writeNode = this.insert(ArrayWriteNormalizedNodeGen.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            return this.writeNode.executeWrite(array, index, value);
        }

        private DynamicObject readSlice(DynamicObject array, int start, int length) {
            if (this.readSliceNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.readSliceNode = this.insert(ArrayReadSliceNormalizedNodeGen.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            return this.readSliceNode.executeReadSlice(array, start, length);
        }

        private int toInt(VirtualFrame frame, Object indexObject) {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = this.insert(ToIntNode.create());
            }
            return this.toIntNode.doInt(frame, indexObject);
        }
    }

    @CoreMethod(names={"[]", "slice"}, required=1, optional=1, lowerFixnumParameters={0, 1})
    public static abstract class IndexNode
    extends ArrayCoreMethodNode {
        @Node.Child
        protected ArrayReadDenormalizedNode readNode;
        @Node.Child
        protected ArrayReadSliceDenormalizedNode readSliceNode;
        @Node.Child
        protected ArrayReadSliceNormalizedNode readNormalizedSliceNode;
        @Node.Child
        protected CallDispatchHeadNode fallbackNode;
        @Node.Child
        protected AllocateObjectNode allocateObjectNode;

        public IndexNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public Object index(DynamicObject array, int index, NotProvided length) {
            if (this.readNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.readNode = this.insert(ArrayReadDenormalizedNodeGen.create(this.getContext(), this.getSourceSection(), null, null));
            }
            return this.readNode.executeRead(array, index);
        }

        @Specialization
        public DynamicObject slice(VirtualFrame frame, DynamicObject array, int start, int length) {
            if (length < 0) {
                return this.nil();
            }
            if (this.readSliceNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.readSliceNode = this.insert(ArrayReadSliceDenormalizedNodeGen.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            return this.readSliceNode.executeReadSlice(array, start, length);
        }

        @Specialization(guards={"isIntegerFixnumRange(range)"})
        public DynamicObject slice(VirtualFrame frame, DynamicObject array, DynamicObject range, NotProvided len, @Cached(value="createBinaryProfile()") ConditionProfile negativeBeginProfile, @Cached(value="createBinaryProfile()") ConditionProfile negativeEndProfile) {
            int size = ArrayHelpers.getSize(array);
            int normalizedIndex = ArrayOperations.normalizeIndex(size, Layouts.INTEGER_FIXNUM_RANGE.getBegin(range), negativeBeginProfile);
            if (normalizedIndex < 0 || normalizedIndex > size) {
                return this.nil();
            }
            int end = ArrayOperations.normalizeIndex(size, Layouts.INTEGER_FIXNUM_RANGE.getEnd(range), negativeEndProfile);
            int exclusiveEnd = ArrayOperations.clampExclusiveIndex(size, Layouts.INTEGER_FIXNUM_RANGE.getExcludedEnd(range) ? end : end + 1);
            if (exclusiveEnd <= normalizedIndex) {
                return this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(array), null, 0);
            }
            int length = exclusiveEnd - normalizedIndex;
            if (this.readNormalizedSliceNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.readNormalizedSliceNode = this.insert(ArrayReadSliceNormalizedNodeGen.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            return this.readNormalizedSliceNode.executeReadSlice(array, normalizedIndex, length);
        }

        @Specialization(guards={"!isInteger(a)", "!isIntegerFixnumRange(a)"})
        public Object fallbackIndex(VirtualFrame frame, DynamicObject array, Object a, NotProvided length) {
            Object[] objects = new Object[]{a};
            return this.fallback(frame, array, ArrayHelpers.createArray(this.getContext(), objects, objects.length));
        }

        @Specialization(guards={"!isIntegerFixnumRange(a)", "wasProvided(b)"})
        public Object fallbackSlice(VirtualFrame frame, DynamicObject array, Object a, Object b) {
            Object[] objects = new Object[]{a, b};
            return this.fallback(frame, array, ArrayHelpers.createArray(this.getContext(), objects, objects.length));
        }

        public Object fallback(VirtualFrame frame, DynamicObject array, DynamicObject args) {
            if (this.fallbackNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.fallbackNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            InternalMethod method = RubyArguments.getMethod(frame);
            return this.fallbackNode.call(frame, array, "element_reference_fallback", null, this.createString(StringOperations.encodeRope(method.getName(), (Encoding)UTF8Encoding.INSTANCE)), args);
        }
    }

    @CoreMethod(names={"*"}, required=1, lowerFixnumParameters={0}, taintFromSelf=true)
    public static abstract class MulNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private KernelNodes.RespondToNode respondToToStrNode;
        @Node.Child
        private ToIntNode toIntNode;
        @Node.Child
        private AllocateObjectNode allocateObjectNode;

        public MulNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        protected abstract Object executeMul(VirtualFrame var1, DynamicObject var2, int var3);

        @Specialization(guards={"isNullArray(array)"})
        public DynamicObject mulEmpty(DynamicObject array, int count) {
            if (count < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().argumentError("negative argument", this));
            }
            return this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(array), null, 0);
        }

        @Specialization(guards={"strategy.matches(array)", "!isNullArray(array)"}, limit="ARRAY_STRATEGIES")
        public DynamicObject mulIntegerFixnum(DynamicObject array, int count, @Cached(value="of(array)") ArrayStrategy strategy) {
            if (count < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().argumentError("negative argument", this));
            }
            int size = ArrayHelpers.getSize(array);
            int newSize = size * count;
            ArrayMirror store = strategy.newMirror(array);
            ArrayMirror newStore = strategy.newArray(newSize);
            for (int n = 0; n < count; ++n) {
                store.copyTo(newStore, 0, n * size, size);
            }
            return this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(array), newStore.getArray(), newSize);
        }

        @Specialization(guards={"isRubyString(string)"})
        public Object mulObject(VirtualFrame frame, DynamicObject array, DynamicObject string, @Cached(value="createMethodCall()") CallDispatchHeadNode callNode) {
            return callNode.call(frame, array, "join", null, string);
        }

        @Specialization(guards={"!isInteger(object)", "!isRubyString(object)"})
        public Object mulObjectCount(VirtualFrame frame, DynamicObject array, Object object, @Cached(value="new()") SnippetNode snippetNode) {
            if (this.respondToToStr(frame, object)) {
                return snippetNode.execute(frame, "join(sep.to_str)", "sep", object);
            }
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = this.insert(ToIntNode.create());
            }
            int count = this.toIntNode.doInt(frame, object);
            return this.executeMul(frame, array, count);
        }

        public boolean respondToToStr(VirtualFrame frame, Object object) {
            if (this.respondToToStrNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.respondToToStrNode = this.insert(KernelNodesFactory.RespondToNodeFactory.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            return this.respondToToStrNode.doesRespondToString(frame, object, this.create7BitString("to_str", (Encoding)UTF8Encoding.INSTANCE), false);
        }
    }

    @CoreMethod(names={"+"}, required=1)
    @ImportStatic(value={ArrayGuards.class})
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="a"), @NodeChild(type=RubyNode.class, value="b")})
    public static abstract class AddNode
    extends CoreMethodNode {
        @CreateCast(value={"b"})
        public RubyNode coerceOtherToAry(RubyNode other) {
            return ToAryNodeGen.create(null, null, other);
        }

        @Specialization(guards={"isNullArray(a)", "isNullArray(b)"})
        public DynamicObject addNullNull(DynamicObject a, DynamicObject b) {
            return ArrayHelpers.createArray(this.getContext(), null, 0);
        }

        @Specialization(guards={"isNullArray(a)", "!isNullArray(b)", "strategy.matches(b)"}, limit="ARRAY_STRATEGIES")
        public DynamicObject addNullOther(DynamicObject a, DynamicObject b, @Cached(value="of(b)") ArrayStrategy strategy) {
            int size = ArrayHelpers.getSize(b);
            ArrayMirror mirror = strategy.newMirror(b).extractRange(0, size);
            return ArrayHelpers.createArray(this.getContext(), mirror.getArray(), size);
        }

        @Specialization(guards={"!isNullArray(a)", "isNullArray(b)", "strategy.matches(a)"}, limit="ARRAY_STRATEGIES")
        public DynamicObject addOtherNull(DynamicObject a, DynamicObject b, @Cached(value="of(a)") ArrayStrategy strategy) {
            int size = ArrayHelpers.getSize(a);
            ArrayMirror mirror = strategy.newMirror(a).extractRange(0, size);
            return ArrayHelpers.createArray(this.getContext(), mirror.getArray(), size);
        }

        @Specialization(guards={"strategy.matches(a)", "strategy.matches(b)"}, limit="ARRAY_STRATEGIES")
        public DynamicObject addSameType(DynamicObject a, DynamicObject b, @Cached(value="of(a)") ArrayStrategy strategy) {
            int aSize = ArrayHelpers.getSize(a);
            int bSize = ArrayHelpers.getSize(b);
            int combinedSize = aSize + bSize;
            ArrayMirror mirror = strategy.newArray(combinedSize);
            strategy.newMirror(a).copyTo(mirror, 0, 0, aSize);
            strategy.newMirror(b).copyTo(mirror, 0, aSize, bSize);
            return ArrayHelpers.createArray(this.getContext(), mirror.getArray(), combinedSize);
        }

        @Specialization(guards={"aStrategy.matches(a)", "bStrategy.matches(b)", "aStrategy != bStrategy"}, limit="ARRAY_STRATEGIES")
        public DynamicObject addGeneralize(DynamicObject a, DynamicObject b, @Cached(value="of(a)") ArrayStrategy aStrategy, @Cached(value="of(b)") ArrayStrategy bStrategy, @Cached(value="aStrategy.generalize(bStrategy)") ArrayStrategy generalized) {
            int aSize = ArrayHelpers.getSize(a);
            int bSize = ArrayHelpers.getSize(b);
            int combinedSize = aSize + bSize;
            ArrayMirror mirror = generalized.newArray(combinedSize);
            aStrategy.newMirror(a).copyTo(mirror, 0, 0, aSize);
            bStrategy.newMirror(b).copyTo(mirror, 0, aSize, bSize);
            return ArrayHelpers.createArray(this.getContext(), mirror.getArray(), combinedSize);
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateNode;

        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return this.allocateNode.allocate(rubyClass, null, 0);
        }
    }
}

