/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.bool;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.core.CoreMethodNode;
import org.jruby.truffle.core.bool.TrueClassNodes;
import org.jruby.truffle.language.RubyNode;

@GeneratedBy(value=TrueClassNodes.class)
public final class TrueClassNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(AndNodeFactory.getInstance(), OrNodeFactory.getInstance(), XorNodeFactory.getInstance());
    }

    @GeneratedBy(value=TrueClassNodes.XorNode.class)
    public static final class XorNodeFactory
    extends NodeFactoryBase<TrueClassNodes.XorNode> {
        private static XorNodeFactory xorNodeFactoryInstance;

        private XorNodeFactory() {
            super(TrueClassNodes.XorNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode.class}});
        }

        @Override
        public TrueClassNodes.XorNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode)) {
                return XorNodeFactory.create((RubyNode)arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrueClassNodes.XorNode> getInstance() {
            if (xorNodeFactoryInstance == null) {
                xorNodeFactoryInstance = new XorNodeFactory();
            }
            return xorNodeFactoryInstance;
        }

        public static TrueClassNodes.XorNode create(RubyNode operand) {
            return new XorNodeGen(operand);
        }

        @GeneratedBy(value=TrueClassNodes.XorNode.class)
        public static final class XorNodeGen
        extends TrueClassNodes.XorNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private XorNodeGen(RubyNode operand) {
                this.operand_ = this.createCast(operand);
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                boolean operandValue_;
                try {
                    operandValue_ = this.operand_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.xor(operandValue_);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.operand_}, operandValue);
            }
        }
    }

    @GeneratedBy(value=TrueClassNodes.OrNode.class)
    public static final class OrNodeFactory
    extends NodeFactoryBase<TrueClassNodes.OrNode> {
        private static OrNodeFactory orNodeFactoryInstance;

        private OrNodeFactory() {
            super(TrueClassNodes.OrNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public TrueClassNodes.OrNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return OrNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrueClassNodes.OrNode> getInstance() {
            if (orNodeFactoryInstance == null) {
                orNodeFactoryInstance = new OrNodeFactory();
            }
            return orNodeFactoryInstance;
        }

        public static TrueClassNodes.OrNode create(RubyNode[] arguments) {
            return new OrNodeGen(arguments);
        }

        @GeneratedBy(value=TrueClassNodes.OrNode.class)
        public static final class OrNodeGen
        extends TrueClassNodes.OrNode {
            @Node.Child
            private RubyNode arguments0_;

            private OrNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                return this.or(arguments0Value_);
            }
        }
    }

    @GeneratedBy(value=TrueClassNodes.AndNode.class)
    public static final class AndNodeFactory
    extends NodeFactoryBase<TrueClassNodes.AndNode> {
        private static AndNodeFactory andNodeFactoryInstance;

        private AndNodeFactory() {
            super(TrueClassNodes.AndNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode.class}});
        }

        @Override
        public TrueClassNodes.AndNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode)) {
                return AndNodeFactory.create((RubyNode)arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrueClassNodes.AndNode> getInstance() {
            if (andNodeFactoryInstance == null) {
                andNodeFactoryInstance = new AndNodeFactory();
            }
            return andNodeFactoryInstance;
        }

        public static TrueClassNodes.AndNode create(RubyNode operand) {
            return new AndNodeGen(operand);
        }

        @GeneratedBy(value=TrueClassNodes.AndNode.class)
        public static final class AndNodeGen
        extends TrueClassNodes.AndNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AndNodeGen(RubyNode operand) {
                this.operand_ = this.createCast(operand);
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                boolean operandValue_;
                try {
                    operandValue_ = this.operand_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.and(operandValue_);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.operand_}, operandValue);
            }
        }
    }
}

