/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.cast.NumericToFloatNode;
import org.jruby.truffle.language.RubyNode;

@GeneratedBy(value=NumericToFloatNode.class)
public final class NumericToFloatNodeGen
extends NumericToFloatNode
implements SpecializedNode {
    @Node.Child
    private RubyNode value_;
    @Node.Child
    private BaseNode_ specialization_;

    private NumericToFloatNodeGen(RubyContext context, SourceSection sourceSection, String method, RubyNode value) {
        super(context, sourceSection, method);
        this.value_ = value;
        this.specialization_ = UninitializedNode_.create(this);
    }

    @Override
    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public double executeDouble(VirtualFrame frameValue, DynamicObject valueValue) {
        return this.specialization_.executeDouble1(frameValue, valueValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public double executeDouble(VirtualFrame frameValue) {
        return this.specialization_.executeDouble0(frameValue);
    }

    @Override
    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    @Override
    public Node deepCopy() {
        return SpecializationNode.updateRoot(super.deepCopy());
    }

    public static NumericToFloatNode create(RubyContext context, SourceSection sourceSection, String method, RubyNode value) {
        return new NumericToFloatNodeGen(context, sourceSection, method, value);
    }

    @GeneratedBy(methodName="fallback(Object)", value=NumericToFloatNode.class)
    private static final class FallbackNode_
    extends BaseNode_ {
        FallbackNode_(NumericToFloatNodeGen root) {
            super(root, 0x7FFFFFFE);
        }

        private boolean guardFallback(Frame frameValue, Object valueValue) {
            return this.createNext(frameValue, valueValue) == null;
        }

        @Override
        public double executeDouble0(VirtualFrame frameValue) {
            Object valueValue_ = this.root.value_.execute(frameValue);
            if (this.guardFallback(frameValue, valueValue_)) {
                return this.root.fallback(valueValue_);
            }
            return this.getNext().executeDouble_(frameValue, valueValue_);
        }

        @Override
        public double executeDouble1(VirtualFrame frameValue, DynamicObject valueValue) {
            if (this.guardFallback(frameValue, valueValue)) {
                return this.root.fallback(valueValue);
            }
            return this.getNext().executeDouble1(frameValue, valueValue);
        }

        @Override
        public double executeDouble_(VirtualFrame frameValue, Object valueValue) {
            if (this.guardFallback(frameValue, valueValue)) {
                return this.root.fallback(valueValue);
            }
            return this.getNext().executeDouble_(frameValue, valueValue);
        }

        static BaseNode_ create(NumericToFloatNodeGen root) {
            return new FallbackNode_(root);
        }
    }

    @GeneratedBy(methodName="castNumeric(VirtualFrame, DynamicObject)", value=NumericToFloatNode.class)
    private static final class CastNumericNode_
    extends BaseNode_ {
        CastNumericNode_(NumericToFloatNodeGen root) {
            super(root, 1);
        }

        @Override
        public double executeDouble0(VirtualFrame frameValue) {
            DynamicObject valueValue_;
            try {
                valueValue_ = this.root.value_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDouble_(frameValue, ex.getResult());
            }
            if (this.root.isNumeric(frameValue, valueValue_)) {
                return this.root.castNumeric(frameValue, valueValue_);
            }
            return this.getNext().executeDouble_(frameValue, valueValue_);
        }

        @Override
        public double executeDouble1(VirtualFrame frameValue, DynamicObject valueValue) {
            if (this.root.isNumeric(frameValue, valueValue)) {
                return this.root.castNumeric(frameValue, valueValue);
            }
            return this.getNext().executeDouble1(frameValue, valueValue);
        }

        @Override
        public double executeDouble_(VirtualFrame frameValue, Object valueValue) {
            DynamicObject valueValue_;
            if (valueValue instanceof DynamicObject && this.root.isNumeric(frameValue, valueValue_ = (DynamicObject)valueValue)) {
                return this.root.castNumeric(frameValue, valueValue_);
            }
            return this.getNext().executeDouble_(frameValue, valueValue);
        }

        static BaseNode_ create(NumericToFloatNodeGen root) {
            return new CastNumericNode_(root);
        }
    }

    @GeneratedBy(value=NumericToFloatNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(NumericToFloatNodeGen root) {
            super(root, 0);
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object valueValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, valueValue));
        }

        @Override
        public double executeDouble0(VirtualFrame frameValue) {
            Object valueValue_ = this.root.value_.execute(frameValue);
            return this.getNext().executeDouble_(frameValue, valueValue_);
        }

        @Override
        public double executeDouble1(VirtualFrame frameValue, DynamicObject valueValue) {
            return this.getNext().executeDouble1(frameValue, valueValue);
        }

        @Override
        public double executeDouble_(VirtualFrame frameValue, Object valueValue) {
            return this.getNext().executeDouble_(frameValue, valueValue);
        }

        static BaseNode_ create(NumericToFloatNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=NumericToFloatNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(NumericToFloatNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public double executeDouble0(VirtualFrame frameValue) {
            Object valueValue_ = this.root.value_.execute(frameValue);
            return (Double)this.uninitialized((Frame)frameValue, valueValue_);
        }

        @Override
        public double executeDouble1(VirtualFrame frameValue, DynamicObject valueValue) {
            return (Double)this.uninitialized((Frame)frameValue, (Object)valueValue);
        }

        @Override
        public double executeDouble_(VirtualFrame frameValue, Object valueValue) {
            return (Double)this.uninitialized((Frame)frameValue, valueValue);
        }

        static BaseNode_ create(NumericToFloatNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=NumericToFloatNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected NumericToFloatNodeGen root;

        BaseNode_(NumericToFloatNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        @Override
        protected final void setRoot(Node root) {
            this.root = (NumericToFloatNodeGen)root;
        }

        @Override
        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.value_};
        }

        @Override
        public final Object acceptAndExecute(Frame frameValue, Object valueValue) {
            return this.executeDouble_((VirtualFrame)frameValue, valueValue);
        }

        public abstract double executeDouble_(VirtualFrame var1, Object var2);

        public double executeDouble1(VirtualFrame frameValue, DynamicObject valueValue) {
            return this.executeDouble_(frameValue, valueValue);
        }

        public Object execute(VirtualFrame frameValue) {
            Object valueValue_ = this.root.value_.execute(frameValue);
            return this.executeDouble_(frameValue, valueValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public double executeDouble0(VirtualFrame frameValue) {
            return (Double)this.execute(frameValue);
        }

        @Override
        protected final SpecializationNode createNext(Frame frameValue, Object valueValue) {
            DynamicObject valueValue_;
            if (valueValue instanceof DynamicObject && this.root.isNumeric((VirtualFrame)frameValue, valueValue_ = (DynamicObject)valueValue)) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return CastNumericNode_.create(this.root);
            }
            return null;
        }

        @Override
        protected final SpecializationNode createFallback() {
            return FallbackNode_.create(this.root);
        }

        @Override
        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }
    }
}

