/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.encoding;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jcodings.util.CaseInsensitiveBytesHash;
import org.jruby.RubyEncoding;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.CoreClass;
import org.jruby.truffle.core.CoreMethod;
import org.jruby.truffle.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.UnaryCoreMethodNode;
import org.jruby.truffle.core.cast.ToStrNode;
import org.jruby.truffle.core.cast.ToStrNodeGen;
import org.jruby.truffle.core.encoding.EncodingOperations;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.util.ByteList;

@CoreClass(name="Encoding")
public abstract class EncodingNodes {
    private static final DynamicObject[] ENCODING_LIST = new DynamicObject[EncodingDB.getEncodings().size()];
    private static final Map<String, DynamicObject> LOOKUP = new HashMap<String, DynamicObject>();

    @CompilerDirectives.TruffleBoundary
    public static synchronized DynamicObject getEncoding(Encoding encoding) {
        return LOOKUP.get(new String(encoding.getName(), StandardCharsets.UTF_8).toLowerCase(Locale.ENGLISH));
    }

    @CompilerDirectives.TruffleBoundary
    public static DynamicObject getEncoding(String name) {
        return LOOKUP.get(name.toLowerCase(Locale.ENGLISH));
    }

    public static DynamicObject getEncoding(int index) {
        return ENCODING_LIST[index];
    }

    @CompilerDirectives.TruffleBoundary
    public static void storeEncoding(int encodingListIndex, DynamicObject encoding) {
        assert (RubyGuards.isRubyEncoding(encoding));
        EncodingNodes.ENCODING_LIST[encodingListIndex] = encoding;
        LOOKUP.put(Layouts.ENCODING.getName(encoding).toString().toLowerCase(Locale.ENGLISH), encoding);
    }

    @CompilerDirectives.TruffleBoundary
    public static void storeAlias(String aliasName, DynamicObject encoding) {
        assert (RubyGuards.isRubyEncoding(encoding));
        LOOKUP.put(aliasName.toLowerCase(Locale.ENGLISH), encoding);
    }

    public static DynamicObject newEncoding(DynamicObject encodingClass, Encoding encoding, byte[] name, int p, int end, boolean dummy) {
        return EncodingNodes.createRubyEncoding(encodingClass, encoding, new ByteList(name, p, end), dummy);
    }

    public static Object[] cloneEncodingList() {
        Object[] clone = new Object[ENCODING_LIST.length];
        System.arraycopy(ENCODING_LIST, 0, clone, 0, ENCODING_LIST.length);
        return clone;
    }

    public static DynamicObject createRubyEncoding(DynamicObject encodingClass, Encoding encoding, ByteList name, boolean dummy) {
        return Layouts.ENCODING.createEncoding(Layouts.CLASS.getInstanceFactory(encodingClass), encoding, name, dummy);
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends UnaryCoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            throw new RaiseException(this.coreExceptions().typeErrorAllocatorUndefinedFor(rubyClass, this));
        }
    }

    @CoreMethod(names={"name", "to_s"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject toS(DynamicObject encoding) {
            ByteList name = Layouts.ENCODING.getName(encoding).dup();
            name.setEncoding((Encoding)ASCIIEncoding.INSTANCE);
            return this.createString(name);
        }
    }

    @CoreMethod(names={"encoding_map"}, onSingleton=true)
    public static abstract class EncodingMapNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode upcaseNode;
        @Node.Child
        private CallDispatchHeadNode toSymNode;
        @Node.Child
        private CallDispatchHeadNode newLookupTableNode;
        @Node.Child
        private CallDispatchHeadNode lookupTableWriteNode;
        @Node.Child
        private CallDispatchHeadNode newTupleNode;

        public EncodingMapNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.upcaseNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.toSymNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.newLookupTableNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.lookupTableWriteNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.newTupleNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public Object encodingMap(VirtualFrame frame) {
            Object ret = this.newLookupTableNode.call(frame, this.coreLibrary().getLookupTableClass(), "new", null, new Object[0]);
            DynamicObject[] encodings = ENCODING_LIST;
            for (int i = 0; i < encodings.length; ++i) {
                Object upcased = this.upcaseNode.call(frame, this.createString(Layouts.ENCODING.getName(encodings[i])), "upcase", null, new Object[0]);
                Object key = this.toSymNode.call(frame, upcased, "to_sym", null, new Object[0]);
                Object value = this.newTupleNode.call(frame, this.coreLibrary().getTupleClass(), "create", null, this.nil(), i);
                this.lookupTableWriteNode.call(frame, ret, "[]=", null, key, value);
            }
            CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntryIterator i = EncodingDB.getAliases().entryIterator();
            while (i.hasNext()) {
                CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry e = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)i.next();
                Object upcased = this.upcaseNode.call(frame, this.createString(new ByteList(e.bytes, e.p, e.end - e.p)), "upcase", null, new Object[0]);
                Object key = this.toSymNode.call(frame, upcased, "to_sym", null, new Object[0]);
                DynamicObject alias = this.createString(new ByteList(e.bytes, e.p, e.end - e.p));
                int index = ((EncodingDB.Entry)e.value).getIndex();
                Object value = this.newTupleNode.call(frame, this.coreLibrary().getTupleClass(), "create", null, alias, index);
                this.lookupTableWriteNode.call(frame, ret, "[]=", null, key, value);
            }
            Encoding defaultInternalEncoding = this.getContext().getJRubyRuntime().getDefaultInternalEncoding();
            Object internalTuple = this.makeTuple(frame, this.newTupleNode, this.create7BitString("internal", (Encoding)UTF8Encoding.INSTANCE), this.indexLookup(encodings, defaultInternalEncoding));
            this.lookupTableWriteNode.call(frame, ret, "[]=", null, this.getSymbol("INTERNAL"), internalTuple);
            Encoding defaultExternalEncoding = this.getContext().getJRubyRuntime().getDefaultExternalEncoding();
            Object externalTuple = this.makeTuple(frame, this.newTupleNode, this.create7BitString("external", (Encoding)UTF8Encoding.INSTANCE), this.indexLookup(encodings, defaultExternalEncoding));
            this.lookupTableWriteNode.call(frame, ret, "[]=", null, this.getSymbol("EXTERNAL"), externalTuple);
            Encoding localeEncoding = this.getLocaleEncoding();
            Object localeTuple = this.makeTuple(frame, this.newTupleNode, this.create7BitString("locale", (Encoding)UTF8Encoding.INSTANCE), this.indexLookup(encodings, localeEncoding));
            this.lookupTableWriteNode.call(frame, ret, "[]=", null, this.getSymbol("LOCALE"), localeTuple);
            Encoding filesystemEncoding = this.getLocaleEncoding();
            Object filesystemTuple = this.makeTuple(frame, this.newTupleNode, this.create7BitString("filesystem", (Encoding)UTF8Encoding.INSTANCE), this.indexLookup(encodings, filesystemEncoding));
            this.lookupTableWriteNode.call(frame, ret, "[]=", null, this.getSymbol("FILESYSTEM"), filesystemTuple);
            return ret;
        }

        private Object makeTuple(VirtualFrame frame, CallDispatchHeadNode newTupleNode, Object ... values) {
            return newTupleNode.call(frame, this.coreLibrary().getTupleClass(), "create", null, values);
        }

        @CompilerDirectives.TruffleBoundary
        private Encoding getLocaleEncoding() {
            return this.getContext().getJRubyRuntime().getEncodingService().getLocaleEncoding();
        }

        @CompilerDirectives.TruffleBoundary
        public Object indexLookup(DynamicObject[] encodings, Encoding encoding) {
            if (encoding == null) {
                return this.nil();
            }
            ByteList encodingName = new ByteList(encoding.getName());
            for (int i = 0; i < encodings.length; ++i) {
                if (!Layouts.ENCODING.getName(encodings[i]).equals((Object)encodingName)) continue;
                return i;
            }
            throw new UnsupportedOperationException(String.format("Could not find encoding %s in the registered encoding list", encoding.toString()));
        }
    }

    @CoreMethod(names={"dummy?"})
    public static abstract class DummyNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public boolean isDummy(DynamicObject encoding) {
            return Layouts.ENCODING.getDummy(encoding);
        }
    }

    @CoreMethod(names={"locale_charmap"}, onSingleton=true)
    public static abstract class LocaleCharacterMapNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject localeCharacterMap() {
            ByteList name = new ByteList(this.getContext().getJRubyRuntime().getEncodingService().getLocaleEncoding().getName());
            return this.createString(name);
        }
    }

    @CoreMethod(names={"list"}, onSingleton=true)
    public static abstract class ListNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject list() {
            Object[] encodings = EncodingNodes.cloneEncodingList();
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), encodings, encodings.length);
        }
    }

    @CoreMethod(names={"default_internal_jruby="}, onSingleton=true, required=1)
    public static abstract class SetDefaultInternalNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ToStrNode toStrNode;

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyEncoding(encoding)"})
        public DynamicObject defaultInternal(DynamicObject encoding) {
            this.getContext().getJRubyRuntime().setDefaultInternalEncoding(EncodingOperations.getEncoding(encoding));
            return encoding;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isNil(encoding)"})
        public DynamicObject defaultInternal(Object encoding) {
            this.getContext().getJRubyRuntime().setDefaultInternalEncoding(null);
            return this.nil();
        }

        @Specialization(guards={"!isRubyEncoding(encoding)", "!isNil(encoding)"})
        public DynamicObject defaultInternal(VirtualFrame frame, Object encoding) {
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toStrNode = this.insert(ToStrNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            DynamicObject encodingName = this.toStrNode.executeToStr(frame, encoding);
            this.getContext().getJRubyRuntime().setDefaultInternalEncoding(EncodingOperations.getEncoding(EncodingNodes.getEncoding(encodingName.toString())));
            return encodingName;
        }
    }

    @CoreMethod(names={"default_external_jruby="}, onSingleton=true, required=1)
    public static abstract class SetDefaultExternalNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ToStrNode toStrNode;

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyEncoding(encoding)"})
        public DynamicObject defaultExternalEncoding(DynamicObject encoding) {
            this.getContext().getJRubyRuntime().setDefaultExternalEncoding(EncodingOperations.getEncoding(encoding));
            return encoding;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(encodingString)"})
        public DynamicObject defaultExternal(DynamicObject encodingString) {
            DynamicObject rubyEncoding = EncodingNodes.getEncoding(encodingString.toString());
            this.getContext().getJRubyRuntime().setDefaultExternalEncoding(EncodingOperations.getEncoding(rubyEncoding));
            return rubyEncoding;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isNil(nil)"})
        public DynamicObject defaultExternal(Object nil) {
            throw new RaiseException(this.coreExceptions().argumentError("default external can not be nil", this));
        }

        @Specialization(guards={"!isRubyEncoding(encoding)", "!isRubyString(encoding)", "!isNil(encoding)"})
        public DynamicObject defaultExternal(VirtualFrame frame, Object encoding) {
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toStrNode = this.insert(ToStrNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.defaultExternal(this.toStrNode.executeToStr(frame, encoding));
        }
    }

    @CoreMethod(names={"compatible?"}, needsSelf=false, onSingleton=true, required=2)
    public static abstract class CompatibleQueryNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isRubyString(first)", "isRubyString(second)", "firstEncoding == secondEncoding", "extractEncoding(first) == firstEncoding", "extractEncoding(second) == secondEncoding"}, limit="getCacheLimit()")
        public DynamicObject isCompatibleStringStringCached(DynamicObject first, DynamicObject second, @Cached(value="extractEncoding(first)") Encoding firstEncoding, @Cached(value="extractEncoding(second)") Encoding secondEncoding, @Cached(value="isCompatibleStringStringUncached(first, second)") DynamicObject rubyEncoding) {
            return rubyEncoding;
        }

        @Specialization(guards={"isRubyString(first)", "isRubyString(second)"}, contains={"isCompatibleStringStringCached"})
        public DynamicObject isCompatibleStringStringUncached(DynamicObject first, DynamicObject second) {
            Encoding compatibleEncoding = CompatibleQueryNode.compatibleEncodingForStrings(first, second);
            if (compatibleEncoding != null) {
                return EncodingNodes.getEncoding(compatibleEncoding);
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyEncoding(first)", "isRubyEncoding(second)"})
        public Object isCompatibleEncodingEncoding(DynamicObject first, DynamicObject second) {
            Encoding secondEncoding;
            Encoding firstEncoding = EncodingOperations.getEncoding(first);
            Encoding compatibleEncoding = RubyEncoding.areCompatible((Encoding)firstEncoding, (Encoding)(secondEncoding = EncodingOperations.getEncoding(second)));
            if (compatibleEncoding != null) {
                return EncodingNodes.getEncoding(compatibleEncoding);
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(first)", "isRubyRegexp(second)"})
        public Object isCompatibleStringRegexp(DynamicObject first, DynamicObject second) {
            Encoding compatibleEncoding = RubyEncoding.areCompatible((Encoding)Layouts.STRING.getRope(first).getEncoding(), (Encoding)Layouts.REGEXP.getRegex(second).getEncoding());
            if (compatibleEncoding != null) {
                return EncodingNodes.getEncoding(compatibleEncoding);
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyRegexp(first)", "isRubyString(second)"})
        public Object isCompatibleRegexpString(DynamicObject first, DynamicObject second) {
            Encoding compatibleEncoding = RubyEncoding.areCompatible((Encoding)Layouts.REGEXP.getRegex(first).getEncoding(), (Encoding)Layouts.STRING.getRope(second).getEncoding());
            if (compatibleEncoding != null) {
                return EncodingNodes.getEncoding(compatibleEncoding);
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyRegexp(first)", "isRubyRegexp(second)"})
        public Object isCompatibleRegexpRegexp(DynamicObject first, DynamicObject second) {
            Encoding compatibleEncoding = RubyEncoding.areCompatible((Encoding)Layouts.REGEXP.getRegex(first).getEncoding(), (Encoding)Layouts.REGEXP.getRegex(second).getEncoding());
            if (compatibleEncoding != null) {
                return EncodingNodes.getEncoding(compatibleEncoding);
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyRegexp(first)", "isRubySymbol(second)"})
        public Object isCompatibleRegexpSymbol(DynamicObject first, DynamicObject second) {
            Encoding compatibleEncoding = RubyEncoding.areCompatible((Encoding)Layouts.REGEXP.getRegex(first).getEncoding(), (Encoding)Layouts.SYMBOL.getRope(second).getEncoding());
            if (compatibleEncoding != null) {
                return EncodingNodes.getEncoding(compatibleEncoding);
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubySymbol(first)", "isRubyRegexp(second)"})
        public Object isCompatibleSymbolRegexp(DynamicObject first, DynamicObject second) {
            Encoding compatibleEncoding = RubyEncoding.areCompatible((Encoding)Layouts.SYMBOL.getRope(first).getEncoding(), (Encoding)Layouts.REGEXP.getRegex(second).getEncoding());
            if (compatibleEncoding != null) {
                return EncodingNodes.getEncoding(compatibleEncoding);
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(first)", "isRubySymbol(second)"})
        public Object isCompatibleStringSymbol(DynamicObject first, DynamicObject second) {
            Encoding compatibleEncoding = CompatibleQueryNode.compatibleEncodingForRopes(StringOperations.rope(first), Layouts.SYMBOL.getRope(second));
            if (compatibleEncoding != null) {
                return EncodingNodes.getEncoding(compatibleEncoding);
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubySymbol(first)", "isRubySymbol(second)"})
        public Object isCompatibleSymbolSymbol(DynamicObject first, DynamicObject second) {
            Encoding compatibleEncoding = CompatibleQueryNode.compatibleEncodingForRopes(Layouts.SYMBOL.getRope(first), Layouts.SYMBOL.getRope(second));
            if (compatibleEncoding != null) {
                return EncodingNodes.getEncoding(compatibleEncoding);
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(first)", "isRubyEncoding(second)"})
        public Object isCompatibleStringEncoding(DynamicObject first, DynamicObject second) {
            Encoding compatibleEncoding = RubyEncoding.areCompatible((Encoding)Layouts.STRING.getRope(first).getEncoding(), (Encoding)EncodingOperations.getEncoding(second));
            if (compatibleEncoding != null) {
                return EncodingNodes.getEncoding(compatibleEncoding);
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        public static Encoding compatibleEncodingForStrings(DynamicObject first, DynamicObject second) {
            assert (RubyGuards.isRubyString(first));
            assert (RubyGuards.isRubyString(second));
            Rope firstRope = StringOperations.rope(first);
            Rope secondRope = StringOperations.rope(second);
            return CompatibleQueryNode.compatibleEncodingForRopes(firstRope, secondRope);
        }

        @CompilerDirectives.TruffleBoundary
        public static Encoding compatibleEncodingForRopes(Rope firstRope, Rope secondRope) {
            Encoding firstEncoding = firstRope.getEncoding();
            Encoding secondEncoding = secondRope.getEncoding();
            if (firstEncoding == null || secondEncoding == null) {
                return null;
            }
            if (firstEncoding == secondEncoding) {
                return firstEncoding;
            }
            if (secondRope.isEmpty()) {
                return firstEncoding;
            }
            if (firstRope.isEmpty()) {
                return firstEncoding.isAsciiCompatible() && CompatibleQueryNode.isAsciiOnly(secondRope) ? firstEncoding : secondEncoding;
            }
            if (!firstEncoding.isAsciiCompatible() || !secondEncoding.isAsciiCompatible()) {
                return null;
            }
            if (firstRope.getCodeRange() != secondRope.getCodeRange()) {
                if (firstRope.getCodeRange() == CodeRange.CR_7BIT) {
                    return secondEncoding;
                }
                if (secondRope.getCodeRange() == CodeRange.CR_7BIT) {
                    return firstEncoding;
                }
            }
            if (secondRope.getCodeRange() == CodeRange.CR_7BIT) {
                return firstEncoding;
            }
            if (firstRope.getCodeRange() == CodeRange.CR_7BIT) {
                return secondEncoding;
            }
            return null;
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean isAsciiOnly(Rope rope) {
            return rope.getEncoding().isAsciiCompatible() && rope.getCodeRange() == CodeRange.CR_7BIT;
        }

        protected Encoding extractEncoding(DynamicObject string) {
            if (RubyGuards.isRubyString(string)) {
                return Layouts.STRING.getRope(string).getEncoding();
            }
            return null;
        }

        protected int getCacheLimit() {
            return this.getContext().getOptions().ENCODING_COMPATIBILE_QUERY_CACHE;
        }
    }

    @CoreMethod(names={"ascii_compatible?"})
    public static abstract class AsciiCompatibleNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public Object isCompatible(DynamicObject encoding) {
            return EncodingOperations.getEncoding(encoding).isAsciiCompatible();
        }
    }
}

