/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.nio.charset.StandardCharsets;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.exceptions.NoImplicitConversionException;
import org.jruby.truffle.core.kernel.KernelNodes;
import org.jruby.truffle.core.kernel.KernelNodesFactory;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.dispatch.MissingBehavior;
import org.jruby.truffle.language.objects.IsTaintedNode;
import org.jruby.truffle.language.objects.IsTaintedNodeGen;

@NodeChildren(value={@NodeChild(value="value", type=FormatNode.class)})
public abstract class ToStringNode
extends FormatNode {
    protected final boolean convertNumbersToStrings;
    private final String conversionMethod;
    private final boolean inspectOnConversionFailure;
    private final Object valueOnNil;
    @Node.Child
    private CallDispatchHeadNode toStrNode;
    @Node.Child
    private CallDispatchHeadNode toSNode;
    @Node.Child
    private KernelNodes.ToSNode inspectNode;
    @Node.Child
    private IsTaintedNode isTaintedNode;
    private final ConditionProfile taintedProfile = ConditionProfile.createBinaryProfile();

    public ToStringNode(RubyContext context, boolean convertNumbersToStrings, String conversionMethod, boolean inspectOnConversionFailure, Object valueOnNil) {
        super(context);
        this.convertNumbersToStrings = convertNumbersToStrings;
        this.conversionMethod = conversionMethod;
        this.inspectOnConversionFailure = inspectOnConversionFailure;
        this.valueOnNil = valueOnNil;
        this.isTaintedNode = IsTaintedNodeGen.create(context, null, null);
    }

    public abstract Object executeToString(VirtualFrame var1, Object var2);

    @Specialization(guards={"isNil(nil)"})
    public Object toStringNil(Object nil) {
        return this.valueOnNil;
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"convertNumbersToStrings"})
    public byte[] toString(int value) {
        return Integer.toString(value).getBytes(StandardCharsets.US_ASCII);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"convertNumbersToStrings"})
    public byte[] toString(long value) {
        return Long.toString(value).getBytes(StandardCharsets.US_ASCII);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"convertNumbersToStrings"})
    public byte[] toString(double value) {
        return Double.toString(value).getBytes(StandardCharsets.US_ASCII);
    }

    @Specialization(guards={"isRubyString(string)"})
    public byte[] toStringString(VirtualFrame frame, DynamicObject string) {
        if (this.taintedProfile.profile(this.isTaintedNode.executeIsTainted(string))) {
            this.setTainted(frame);
        }
        return Layouts.STRING.getRope(string).getBytes();
    }

    @Specialization(guards={"isRubyArray(array)"})
    public byte[] toString(VirtualFrame frame, DynamicObject array) {
        Object value;
        if (this.toSNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.toSNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true, MissingBehavior.RETURN_MISSING));
        }
        if (RubyGuards.isRubyString(value = this.toSNode.call(frame, array, "to_s", null, new Object[0]))) {
            if (this.taintedProfile.profile(this.isTaintedNode.executeIsTainted(value))) {
                this.setTainted(frame);
            }
            return Layouts.STRING.getRope((DynamicObject)value).getBytes();
        }
        throw new NoImplicitConversionException(array, "String");
    }

    @Specialization(guards={"!isRubyString(object)", "!isRubyArray(object)"})
    public byte[] toString(VirtualFrame frame, Object object) {
        Object value;
        if (this.toStrNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.toStrNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true, MissingBehavior.RETURN_MISSING));
        }
        if (RubyGuards.isRubyString(value = this.toStrNode.call(frame, object, this.conversionMethod, null, new Object[0]))) {
            if (this.taintedProfile.profile(this.isTaintedNode.executeIsTainted(value))) {
                this.setTainted(frame);
            }
            return Layouts.STRING.getRope((DynamicObject)value).getBytes();
        }
        if (this.inspectOnConversionFailure) {
            if (this.inspectNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.inspectNode = this.insert(KernelNodesFactory.ToSNodeFactory.create(this.getContext(), this.getEncapsulatingSourceSection(), new RubyNode[]{null}));
            }
            return Layouts.STRING.getRope(this.inspectNode.toS(frame, object)).getBytes();
        }
        throw new NoImplicitConversionException(object, "String");
    }
}

