/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.format;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.format.FormatNode;

@NodeChildren(value={@NodeChild(value="spacePadding", type=FormatNode.class), @NodeChild(value="zeroPadding", type=FormatNode.class), @NodeChild(value="value", type=FormatNode.class)})
public abstract class FormatIntegerNode
extends FormatNode {
    private final char format;

    public FormatIntegerNode(RubyContext context, char format) {
        super(context);
        this.format = format;
    }

    @Specialization(guards={"!isRubyBignum(value)", "spacePadding == cachedSpacePadding", "zeroPadding == cachedZeroPadding"}, limit="getLimit()")
    public byte[] formatCached(int spacePadding, int zeroPadding, Object value, @Cached(value="spacePadding") int cachedSpacePadding, @Cached(value="zeroPadding") int cachedZeroPadding, @Cached(value="makeFormatString(spacePadding, zeroPadding)") String cachedFormatString) {
        return this.doFormat(value, cachedFormatString);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"!isRubyBignum(value)"}, contains={"formatCached"})
    public byte[] formatUncached(int spacePadding, int zeroPadding, Object value) {
        return this.doFormat(value, this.makeFormatString(spacePadding, zeroPadding));
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isRubyBignum(value)"})
    public byte[] format(int spacePadding, int zeroPadding, DynamicObject value) {
        String formatted;
        BigInteger bigInteger = Layouts.BIGNUM.getValue(value);
        switch (this.format) {
            case 'd': 
            case 'i': 
            case 'u': {
                formatted = bigInteger.toString();
                break;
            }
            case 'o': {
                formatted = bigInteger.toString(8).toLowerCase(Locale.ENGLISH);
                break;
            }
            case 'x': {
                formatted = bigInteger.toString(16).toLowerCase(Locale.ENGLISH);
                break;
            }
            case 'X': {
                formatted = bigInteger.toString(16).toUpperCase(Locale.ENGLISH);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        while (formatted.length() < spacePadding) {
            formatted = " " + formatted;
        }
        while (formatted.length() < zeroPadding) {
            formatted = "0" + formatted;
        }
        return formatted.getBytes(StandardCharsets.US_ASCII);
    }

    @CompilerDirectives.TruffleBoundary
    protected byte[] doFormat(Object value, String formatString) {
        return String.format(formatString, value).getBytes(StandardCharsets.US_ASCII);
    }

    protected String makeFormatString(int spacePadding, int zeroPadding) {
        StringBuilder builder = new StringBuilder();
        builder.append("%");
        if (spacePadding != -1) {
            builder.append(" ");
            builder.append(spacePadding);
            if (zeroPadding != -1) {
                builder.append(".");
                builder.append(zeroPadding);
            }
        } else if (zeroPadding != -1) {
            builder.append("0");
            builder.append(zeroPadding);
        }
        builder.append(this.format);
        return builder.toString();
    }

    protected int getLimit() {
        return this.getContext().getOptions().PACK_CACHE;
    }
}

