/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.read.bytes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.Arrays;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.read.SourceNode;
import org.jruby.truffle.core.rope.AsciiOnlyLeafRope;

@NodeChildren(value={@NodeChild(value="source", type=SourceNode.class)})
public abstract class ReadBinaryStringNode
extends FormatNode {
    final boolean readToEnd;
    final boolean readToNull;
    final int count;
    final boolean trimTrailingSpaces;
    final boolean trimTrailingNulls;
    final boolean trimToFirstNull;

    public ReadBinaryStringNode(RubyContext context, boolean readToEnd, boolean readToNull, int count, boolean trimTrailingSpaces, boolean trimTrailingNulls, boolean trimToFirstNull) {
        super(context);
        this.readToEnd = readToEnd;
        this.readToNull = readToNull;
        this.count = count;
        this.trimTrailingSpaces = trimTrailingSpaces;
        this.trimTrailingNulls = trimTrailingNulls;
        this.trimToFirstNull = trimToFirstNull;
    }

    @Specialization(guards={"isNull(source)"})
    public void read(VirtualFrame frame, Object source) {
        CompilerDirectives.transferToInterpreter();
        this.advanceSourcePosition(frame, this.count);
        throw new IllegalStateException();
    }

    @Specialization
    public DynamicObject read(VirtualFrame frame, byte[] source) {
        int firstNull;
        int usedLength;
        int length;
        int start = this.getSourcePosition(frame);
        if (this.readToEnd) {
            length = 0;
            while (start + length < this.getSourceLength(frame) && (!this.readToNull || start + length < this.getSourceLength(frame) && source[start + length] != 0)) {
                ++length;
            }
            if (start + length < this.getSourceLength(frame) && source[start + length] == 0) {
                ++length;
            }
        } else if (this.readToNull) {
            for (length = 0; start + length < this.getSourceLength(frame) && length < this.count && (!this.readToNull || start + length < this.getSourceLength(frame) && source[start + length] != 0); ++length) {
            }
            if (start + length < this.getSourceLength(frame) && source[start + length] == 0) {
                ++length;
            }
        } else {
            length = this.count;
            if (start + length >= this.getSourceLength(frame)) {
                length = this.getSourceLength(frame) - start;
            }
        }
        for (usedLength = length; usedLength > 0 && (this.trimTrailingSpaces && source[start + usedLength - 1] == 32 || this.trimTrailingNulls && source[start + usedLength - 1] == 0); --usedLength) {
        }
        if (this.trimToFirstNull && (firstNull = this.indexOfFirstNull(source, start, usedLength)) != -1 && this.trimTrailingNulls) {
            usedLength = firstNull;
        }
        this.setSourcePosition(frame, start + length);
        return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), new AsciiOnlyLeafRope(Arrays.copyOfRange(source, start, start + usedLength), (Encoding)ASCIIEncoding.INSTANCE));
    }

    private int indexOfFirstNull(byte[] bytes, int start, int length) {
        for (int n = 0; n < length; ++n) {
            if (bytes[start + n] != 0) continue;
            return n;
        }
        return -1;
    }
}

