/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.numeric;

import com.oracle.truffle.api.dsl.Specialization;
import org.jruby.truffle.core.CoreClass;
import org.jruby.truffle.core.CoreLibrary;
import org.jruby.truffle.core.CoreMethod;
import org.jruby.truffle.core.UnaryCoreMethodNode;

@CoreClass(name="Truffle::Fixnum")
public abstract class TruffleFixnumNodes {

    @CoreMethod(names={"lower"}, isModuleFunction=true, required=1)
    public static abstract class LowerPrimitiveNode
    extends UnaryCoreMethodNode {
        @Specialization
        public int lower(int value) {
            return value;
        }

        @Specialization(guards={"canLower(value)"})
        public int lower(long value) {
            return (int)value;
        }

        @Specialization(guards={"!canLower(value)"})
        public long lowerFails(long value) {
            return value;
        }

        protected static boolean canLower(long value) {
            return CoreLibrary.fitsIntoInteger(value);
        }
    }
}

