/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.proc;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.truffle.core.CoreClass;
import org.jruby.truffle.core.CoreMethod;
import org.jruby.truffle.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.UnaryCoreMethodNode;
import org.jruby.truffle.core.YieldingCoreMethodNode;
import org.jruby.truffle.core.binding.BindingNodes;
import org.jruby.truffle.core.proc.ProcType;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.arguments.ArgumentDescriptorUtils;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.objects.AllocateObjectNode;
import org.jruby.truffle.language.objects.AllocateObjectNodeGen;

@CoreClass(name="Proc")
public abstract class ProcNodes {

    @CoreMethod(names={"source_location"})
    public static abstract class SourceLocationNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object sourceLocation(DynamicObject proc) {
            SourceSection sourceSection = Layouts.PROC.getSharedMethodInfo(proc).getSourceSection();
            if (sourceSection.getSource() == null) {
                return this.nil();
            }
            DynamicObject file = this.createString(StringOperations.encodeRope(sourceSection.getSource().getName(), (Encoding)UTF8Encoding.INSTANCE));
            Object[] objects = new Object[]{file, sourceSection.getStartLine()};
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), objects, objects.length);
        }
    }

    @CoreMethod(names={"parameters"})
    public static abstract class ParametersNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject parameters(DynamicObject proc) {
            ArgumentDescriptor[] argsDesc = Layouts.PROC.getSharedMethodInfo(proc).getArgumentDescriptors();
            boolean isLambda = Layouts.PROC.getType(proc) == ProcType.LAMBDA;
            return ArgumentDescriptorUtils.argumentDescriptorsToParameters(this.getContext(), argsDesc, isLambda);
        }
    }

    @CoreMethod(names={"lambda?"})
    public static abstract class LambdaNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public boolean lambda(DynamicObject proc) {
            return Layouts.PROC.getType(proc) == ProcType.LAMBDA;
        }
    }

    @CoreMethod(names={"call", "[]", "yield"}, rest=true, needsBlock=true)
    public static abstract class CallNode
    extends YieldingCoreMethodNode {
        @Specialization
        public Object call(VirtualFrame frame, DynamicObject proc, Object[] args, NotProvided block) {
            return this.yield(frame, proc, args);
        }

        @Specialization
        public Object call(VirtualFrame frame, DynamicObject proc, Object[] args, DynamicObject block) {
            return this.yieldWithModifiedBlock(frame, proc, block, args);
        }
    }

    @CoreMethod(names={"binding"})
    public static abstract class BindingNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject binding(DynamicObject proc) {
            MaterializedFrame frame = Layouts.PROC.getDeclarationFrame(proc);
            return BindingNodes.createBinding(this.getContext(), frame);
        }
    }

    @CoreMethod(names={"arity"})
    public static abstract class ArityNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int arity(DynamicObject proc) {
            return Layouts.PROC.getSharedMethodInfo(proc).getArity().getArityNumber();
        }
    }

    @CoreMethod(names={"dup", "clone"})
    public static abstract class DupNode
    extends UnaryCoreMethodNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode;

        @Specialization
        public DynamicObject dup(DynamicObject proc) {
            DynamicObject copy = this.getAllocateObjectNode().allocate(Layouts.BASIC_OBJECT.getLogicalClass(proc), new Object[]{Layouts.PROC.getType(proc), Layouts.PROC.getSharedMethodInfo(proc), Layouts.PROC.getCallTargetForType(proc), Layouts.PROC.getCallTargetForLambdas(proc), Layouts.PROC.getDeclarationFrame(proc), Layouts.PROC.getMethod(proc), Layouts.PROC.getSelf(proc), Layouts.PROC.getBlock(proc), Layouts.PROC.getFrameOnStackMarker(proc)});
            return copy;
        }

        private AllocateObjectNode getAllocateObjectNode() {
            if (this.allocateObjectNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.allocateObjectNode = this.insert(AllocateObjectNodeGen.create(this.getContext(), null, null, null));
            }
            return this.allocateObjectNode;
        }
    }

    @CoreMethod(names={"new"}, constructor=true, needsBlock=true, rest=true)
    public static abstract class ProcNewNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode initializeNode;
        @Node.Child
        private AllocateObjectNode allocateObjectNode;

        public abstract DynamicObject executeProcNew(VirtualFrame var1, DynamicObject var2, Object[] var3, Object var4);

        @Specialization
        public DynamicObject proc(VirtualFrame frame, DynamicObject procClass, Object[] args, NotProvided block) {
            Frame parentFrame = this.getContext().getCallStack().getCallerFrameIgnoringSend().getFrame(FrameInstance.FrameAccess.READ_ONLY, true);
            DynamicObject parentBlock = RubyArguments.getBlock(parentFrame.getArguments());
            if (parentBlock == null) {
                throw new RaiseException(this.coreExceptions().argumentErrorProcWithoutBlock(this));
            }
            return this.executeProcNew(frame, procClass, args, parentBlock);
        }

        @Specialization(guards={"procClass == getProcClass()", "block.getShape() == getProcShape()"})
        public DynamicObject procNormalOptimized(DynamicObject procClass, Object[] args, DynamicObject block) {
            return block;
        }

        protected DynamicObject getProcClass() {
            return this.coreLibrary().getProcClass();
        }

        protected Shape getProcShape() {
            return this.coreLibrary().getProcFactory().getShape();
        }

        @Specialization(guards={"procClass == metaClass(block)"})
        public DynamicObject procNormal(DynamicObject procClass, Object[] args, DynamicObject block) {
            return block;
        }

        @Specialization(guards={"procClass != metaClass(block)"})
        public DynamicObject procSpecial(VirtualFrame frame, DynamicObject procClass, Object[] args, DynamicObject block) {
            DynamicObject proc = this.getAllocateObjectNode().allocate(procClass, new Object[]{Layouts.PROC.getType(block), Layouts.PROC.getSharedMethodInfo(block), Layouts.PROC.getCallTargetForType(block), Layouts.PROC.getCallTargetForLambdas(block), Layouts.PROC.getDeclarationFrame(block), Layouts.PROC.getMethod(block), Layouts.PROC.getSelf(block), Layouts.PROC.getBlock(block), Layouts.PROC.getFrameOnStackMarker(block)});
            this.getInitializeNode().call(frame, proc, "initialize", block, args);
            return proc;
        }

        protected DynamicObject metaClass(DynamicObject object) {
            return Layouts.BASIC_OBJECT.getMetaClass(object);
        }

        private AllocateObjectNode getAllocateObjectNode() {
            if (this.allocateObjectNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.allocateObjectNode = this.insert(AllocateObjectNodeGen.create(this.getContext(), null, null, null));
            }
            return this.allocateObjectNode;
        }

        private CallDispatchHeadNode getInitializeNode() {
            if (this.initializeNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.initializeNode = this.insert(DispatchHeadNodeFactory.createMethodCallOnSelf(this.getContext()));
            }
            return this.initializeNode;
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends UnaryCoreMethodNode {
        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            throw new RaiseException(this.coreExceptions().typeErrorAllocatorUndefinedFor(rubyClass, this));
        }
    }
}

