/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.proc;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.proc.ProcOperations;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.SafepointAction;
import org.jruby.truffle.platform.signal.Signal;
import org.jruby.truffle.platform.signal.SignalHandler;

public class ProcSignalHandler
implements SignalHandler {
    private final RubyContext context;
    private final DynamicObject proc;

    public ProcSignalHandler(RubyContext context, DynamicObject proc) {
        assert (RubyGuards.isRubyProc(proc));
        this.context = context;
        this.proc = proc;
    }

    @Override
    public void handle(Signal signal) {
        Thread mainThread = Layouts.FIBER.getThread(Layouts.THREAD.getFiberManager(this.context.getThreadManager().getRootThread()).getCurrentFiber());
        this.context.getSafepointManager().pauseThreadAndExecuteLaterFromNonRubyThread(mainThread, new SafepointAction(){

            @Override
            public void run(DynamicObject thread, Node currentNode) {
                ProcOperations.rootCall(ProcSignalHandler.this.proc, new Object[0]);
            }
        });
    }
}

